/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.porez;

import com.cloudgarden.layout.AnchorConstraint;
import com.cloudgarden.layout.AnchorLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import org.jdesktop.application.Application;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.reports.PzReportManager;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.fields.PzDateField;

public class PzDialogEPP
extends PzDialog {
    private static final long serialVersionUID = -2842904921637076753L;
    private JLabel lblPocetniDatum;
    private JLabel jLabel1;
    private PzDateField dfPocetniDatum;
    private JLabel lblKrajnjiDatum;
    private PzButton btnPrikazi;
    private PzDateField dfKrajnjiDatum;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogEPP inst = new PzDialogEPP(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogEPP(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    private void initGUI() {
        try {
            AnchorLayout thisLayout = new AnchorLayout();
            this.getContentPane().setLayout(thisLayout);
            this.btnPrikazi = new PzButton("Prika\u017ei");
            this.btnPrikazi.addActionListener((ActionListener)((Object)this));
            this.getContentPane().add((Component)this.btnPrikazi, new AnchorConstraint(348, 981, 690, 802, 1, 1, 1, 1));
            this.btnPrikazi.setPreferredSize(new Dimension(103, 26));
            this.dfKrajnjiDatum = new PzDateField();
            this.getContentPane().add((Component)this.dfKrajnjiDatum, new AnchorConstraint(322, 781, 690, 600, 1, 1, 1, 1));
            this.dfKrajnjiDatum.setPreferredSize(new Dimension(104, 28));
            this.dfPocetniDatum = new PzDateField();
            this.getContentPane().add((Component)this.dfPocetniDatum, new AnchorConstraint(309, 411, 690, 221, 1, 1, 1, 1));
            this.dfPocetniDatum.setPreferredSize(new Dimension(109, 29));
            this.lblPocetniDatum = new JLabel("Po\u010detni datum:");
            this.getContentPane().add((Component)this.lblPocetniDatum, new AnchorConstraint(414, 221, 572, 20, 1, 1, 1, 1));
            this.lblPocetniDatum.setPreferredSize(new Dimension(116, 12));
            this.lblKrajnjiDatum = new JLabel("Krajnji datum:");
            this.getContentPane().add((Component)this.lblKrajnjiDatum, new AnchorConstraint(427, 600, 585, 426, 1, 1, 1, 1));
            this.lblKrajnjiDatum.setPreferredSize(new Dimension(100, 12));
            this.setSize(591, 115);
            this.setRestorable(false);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        String que = "select     d.datDPO,     (case when d.storno = 0 then d.ozndokumenta else d.ozndokumenta || ' ' || ' (Storno)' end),     k.sfrkomitent,     k.naziv,     d.kategorija,     t.oznTarGr,     (case when d.storno = 0 then t.osnovica else -t.osnovica end),     (case when d.storno = 0 then t.iznos else -t.iznos end)from     kalkulacija d,     komitent k,     taksakalkulacija t where     d.arhiviran = 1 and     d.sfrkomitent = k.sfrkomitent and     d.iddok = t.iddok and     d.datDPO >= ':datOd' and     d.datDPO <= ':datDo' and     d.tip in ('KALKULACIJA', 'TROSAK', 'RACUN_DOBAVLJACA', 'ZAPISNIK_OTPREMNICE', 'PRIJEMNICA_REPRO') and     t.tip = 'U' order by     d.kategorija ASC,     d.datDPO ASC";
        que = que.replace(":datOd", this.dfPocetniDatum.getVal().toString());
        que = que.replace(":datDo", this.dfKrajnjiDatum.getVal().toString());
        EntityManager em = PzEntityManager.getEm();
        Query q = em.createNativeQuery(que);
        List result = q.getResultList();
        ArrayList<Data> beans = new ArrayList<Data>();
        for (Object[] objects : result) {
            Data d = new Data();
            d.setDatum((Date)objects[0]);
            d.setOznDokumenta((String)objects[1]);
            d.setSfrKomitent((String)objects[2]);
            d.setNazivKomitenta((String)objects[3]);
            d.setKategorija((String)objects[4]);
            d.setOznTarGr((String)objects[5]);
            d.setOsnovica((BigDecimal)objects[6]);
            d.setPorez((BigDecimal)objects[7]);
            beans.add(d);
        }
        JRBeanCollectionDataSource ds = new JRBeanCollectionDataSource(beans);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("OD_DATUMA", this.dfPocetniDatum.getText());
        params.put("DO_DATUMA", this.dfKrajnjiDatum.getText());
        try {
            params.put("FIRMA", PzFirma.getFirma().getNaziv());
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        String izvestaj = "rs/pezar/reports/compiled/pregled.pdv.epp.jasper";
        try {
            PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)ds, (String)izvestaj, params, (String)"pregled_pdv_epp", (int)PzReportManager.REPORT_TYPE_JASPER);
        }
        catch (JRException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public static class Data {
        private Date datum;
        private String oznDokumenta;
        private String sfrKomitent;
        private String nazivKomitenta;
        private String kategorija;
        private String oznTarGr;
        private BigDecimal osnovica;
        private BigDecimal porez;

        public Date getDatum() {
            return this.datum;
        }

        public void setDatum(Date datum) {
            this.datum = datum;
        }

        public String getOznDokumenta() {
            return this.oznDokumenta;
        }

        public void setOznDokumenta(String oznDokumenta) {
            this.oznDokumenta = oznDokumenta;
        }

        public String getSfrKomitent() {
            return this.sfrKomitent;
        }

        public void setSfrKomitent(String sfrKomitent) {
            this.sfrKomitent = sfrKomitent;
        }

        public String getNazivKomitenta() {
            return this.nazivKomitenta;
        }

        public void setNazivKomitenta(String nazivKomitenta) {
            this.nazivKomitenta = nazivKomitenta;
        }

        public String getKategorija() {
            return this.kategorija == null ? "NEPOZNATO" : this.kategorija.toUpperCase();
        }

        public void setKategorija(String kategorija) {
            this.kategorija = kategorija;
        }

        public String getOznTarGr() {
            return this.oznTarGr;
        }

        public void setOznTarGr(String oznTarGr) {
            this.oznTarGr = oznTarGr;
        }

        public BigDecimal getOsnovica() {
            return this.osnovica;
        }

        public void setOsnovica(BigDecimal osnovica) {
            this.osnovica = osnovica;
        }

        public BigDecimal getPorez() {
            return this.porez;
        }

        public void setPorez(BigDecimal porez) {
            this.porez = porez;
        }
    }
}

