/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.komitenti;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.border.Border;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.jdesktop.application.Application;
import rs.pezar.analitike.gui.komitenti.ukupnoDugovanje.UkupnoDugovanjeUtil;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Firma;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.PzTableDataSource;
import rs.pezar.swing.PzAbstractTable;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzScrollableTable;
import rs.pezar.swing.data.models.PzTableModelPregledDugovanja;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;

public class PzDialogUkupnoDugovanje
extends PzDialog {
    private static final long serialVersionUID = 1L;
    private PzPanel panel;
    private PzPanelHeader header;
    private PzButton btnOk;
    private PzDateField dateZakljucnoSa;
    private JComboBox cbSort;
    private PzPanel pzPanel2;
    private PzPanel pzPanel1;
    private JComboBox cbKupacDobavljac;
    private PzPanel panel1;
    private JComboBox cbKomitenti;
    private ScrollableCursor cursor;
    private JCheckBox cbAvans;
    private JCheckBox chkKompenzacija;
    private PzScrollableTable table;
    private EntityManager em;
    private int tip;
    private int komitent;
    private int sort;
    private String naslov;
    private String period;
    private String report;
    private byte tipKartice;
    private JComboBox cbRj;
    private int tipRj;

    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.btnOk) {
                this.onBtnOkPressed();
            }
        }
        catch (Exception e1) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogUkupnoDugovanje(Boolean.FALSE);
    }

    public PzDialogUkupnoDugovanje(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public PzDialogUkupnoDugovanje(PzDialog dialog) {
        super(dialog);
        this.initGUI();
    }

    public PzDialogUkupnoDugovanje(Boolean initGUI) {
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setPreferredSize(new Dimension(868, 219));
            this.setTitle("Pregled ukupnog dugovanja");
            this.setResizable(false);
            this.setRestorable(false);
            this.panel = new PzPanel();
            this.getContentPane().add((Component)this.panel, "Center");
            this.panel.setPaintGradient(true);
            GridBagLayout panelLayout = new GridBagLayout();
            panelLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            panelLayout.rowHeights = new int[]{-22, 7, 61, 60, 23, 8, 19};
            panelLayout.columnWeights = new double[]{0.0, 0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            panelLayout.columnWidths = new int[]{7, 7, 235, 7, 181, 7, 187, 7};
            this.panel.setLayout((LayoutManager)panelLayout);
            this.panel.setPreferredSize(new Dimension(670, 182));
            this.header = new PzPanelHeader();
            this.panel.add((Component)this.header, (Object)new GridBagConstraints(0, 2, 8, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.header.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/chart.png")));
            this.header.setTitle("Pregled ukupnog dugovanja");
            this.panel1 = new PzPanel();
            this.panel.add((Component)this.panel1, (Object)new GridBagConstraints(1, 3, 2, 4, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panel1.setBorder((Border)BorderFactory.createTitledBorder("Komitenti"));
            this.panel1.setLayout(null);
            DefaultComboBoxModel<String> cbKomitentiModel = new DefaultComboBoxModel<String>(new String[]{"Doma\u0107i komitenti", "Ino komitenti", "Svi Komitenti"});
            this.cbKomitenti = new JComboBox();
            this.panel1.add((Component)this.cbKomitenti);
            this.cbKomitenti.setModel(cbKomitentiModel);
            this.cbKomitenti.setBounds(17, 24, 119, 21);
            DefaultComboBoxModel<String> jComboBox1Model = new DefaultComboBoxModel<String>(new String[]{"Kupac->Dobavlja\u010d", "Samo kupci", "Samo dobavlja\u010di"});
            this.cbKupacDobavljac = new JComboBox();
            this.cbKupacDobavljac.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent arg0) {
                    if (arg0.getStateChange() == 1) {
                        if (arg0.getItem().equals("Kupac->Dobavlja\u010d")) {
                            PzDialogUkupnoDugovanje.this.chkKompenzacija.setVisible(true);
                        } else {
                            PzDialogUkupnoDugovanje.this.chkKompenzacija.setVisible(false);
                        }
                    }
                }
            });
            this.panel1.add((Component)this.cbKupacDobavljac);
            this.cbKupacDobavljac.setModel(jComboBox1Model);
            this.cbKupacDobavljac.setBounds(166, 24, 133, 21);
            DefaultComboBoxModel<String> cbmRj = new DefaultComboBoxModel<String>(new String[]{"Sve fakture", "Bez maloprodaje"});
            this.cbRj = new JComboBox();
            this.panel1.add((Component)this.cbRj);
            this.cbRj.setBounds(328, 24, 117, 21);
            this.cbRj.setModel(cbmRj);
            this.chkKompenzacija = new JCheckBox("Filter: mogu\u0107a kompenzacija");
            this.chkKompenzacija.setOpaque(false);
            this.panel1.add((Component)this.chkKompenzacija);
            this.chkKompenzacija.setBounds(166, 51, 279, 17);
            this.cbAvans = new JCheckBox("Bez avansa");
            this.panel1.add((Component)this.cbAvans);
            this.cbAvans.setBounds(166, 71, 162, 17);
            this.cbAvans.setName("cbAvans");
            this.pzPanel1 = new PzPanel();
            this.panel.add((Component)this.pzPanel1, (Object)new GridBagConstraints(4, 3, 1, 4, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pzPanel1.setBorder((Border)BorderFactory.createTitledBorder("Sort"));
            this.pzPanel1.setLayout(null);
            DefaultComboBoxModel<String> cbSortModel = new DefaultComboBoxModel<String>(new String[]{"Sort: \u0161ifra", "Sort: naziv"});
            this.cbSort = new JComboBox();
            this.pzPanel1.add((Component)this.cbSort);
            this.cbSort.setModel(cbSortModel);
            this.cbSort.setBounds(30, 24, 100, 21);
            this.pzPanel2 = new PzPanel();
            this.panel.add((Component)this.pzPanel2, (Object)new GridBagConstraints(6, 3, 1, 2, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pzPanel2.setBorder((Border)BorderFactory.createTitledBorder("Krajnji datum"));
            this.pzPanel2.setLayout(null);
            this.dateZakljucnoSa = new PzDateField();
            this.pzPanel2.add((Component)this.dateZakljucnoSa);
            this.dateZakljucnoSa.setBounds(45, 19, 78, 24);
            this.btnOk = new PzButton();
            this.panel.add((Component)this.btnOk, (Object)new GridBagConstraints(6, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.btnOk.setText("OK");
            this.btnOk.addActionListener((ActionListener)((Object)this));
            this.pack();
            this.setSize(868, 219);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void onBtnOkPressed() {
        this.fillInTheInfo();
        this.showReport();
    }

    private boolean fillInTheInfo() {
        this.tip = this.cbKomitenti.getSelectedIndex();
        this.komitent = this.cbKupacDobavljac.getSelectedIndex();
        this.tipRj = this.cbRj.getSelectedIndex();
        this.sort = this.cbSort.getSelectedIndex();
        if (this.komitent == 1) {
            this.naslov = "Pregled potra\u017eivanja od kupaca";
        } else if (this.komitent == 2) {
            this.naslov = "Pregled dugovanja prema dobavlja\u010dima";
        } else if (this.komitent == 0) {
            this.naslov = null;
        }
        if (this.komitent == 0) {
            this.tipKartice = 1;
            this.report = "rs/pezar/reports/compiled/pregledPotrazivanjaIObaveza.jasper";
        } else {
            this.tipKartice = 0;
            this.report = "rs/pezar/reports/compiled/pregledDugovanja.jasper";
        }
        this.period = "U periodu do datuma - " + this.dateZakljucnoSa.getText();
        String baseQuery = UkupnoDugovanjeUtil.createDependentQuery(this.tip, this.komitent, this.tipRj, this.sort, this.dateZakljucnoSa.getVal(), this.chkKompenzacija.isSelected(), !this.cbAvans.isSelected());
        this.em = PzEntityManager.getEm();
        Query q = this.em.createNativeQuery(baseQuery);
        q.setHint("eclipselink.cursor.scrollable", (Object)"True");
        if (this.cursor != null) {
            this.cursor.close();
        }
        this.cursor = (ScrollableCursor)q.getSingleResult();
        return true;
    }

    public void setEntity(PzEntity entity, Component component) {
    }

    protected void setHeaderOnInsert() {
    }

    private void showReport() {
        HashMap<String, String> params = new HashMap<String, String>();
        Firma firma = null;
        try {
            firma = PzFirma.getFirma();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        Vector<Firma> v = new Vector<Firma>();
        v.add(firma);
        params.put("naslov", this.naslov);
        params.put("period", this.period);
        params.put("tipKomitenta", this.cbKomitenti.getSelectedItem().toString());
        PzTableModelPregledDugovanja model = new PzTableModelPregledDugovanja(this.cursor, this.tipKartice);
        this.table = new PzScrollableTable();
        this.table.setModel((TableModel)model);
        PzTableDataSource ds = new PzTableDataSource((PzAbstractTable)this.table, v);
        try {
            PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)ds, (String)this.report, params, (String)"PregledDugovanja");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void thisWindowClosing(WindowEvent evt) {
        super.thisWindowClosing(evt);
        if (this.cursor != null) {
            this.cursor.close();
        }
        if (this.em != null) {
            this.em.close();
        }
        super.thisWindowClosing(evt);
    }
}

