/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.kepu.kontrola;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.sql.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import rs.pezar.analitike.gui.kepu.kontrola.KepuEntry;
import rs.pezar.analitike.gui.kepu.kontrola.KontrolaUtil;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Konto;
import rs.pezar.db.entity.KontoPK;
import rs.pezar.sifarnici.gui.PzDialogKontniPlan;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzGenericTableDialog;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.event.PzEntityChecker;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzTextField;

public class KontrolaKonto
extends PzDialog {
    private final JPanel kontoPanel = new JPanel();
    private PzTextField kontoField;
    private PzTextField jLabelAnalitika;
    private JPanel tablePanel;
    private PzTable table;
    private Konto konto;
    private List<KepuEntry> list;
    private Date datOd;
    private Date datDo;

    public static void main(String[] args) {
        try {
            KontrolaKonto dialog = new KontrolaKonto();
            dialog.setDefaultCloseOperation(2);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public KontrolaKonto() {
        this.initGUI();
    }

    public KontrolaKonto(PzDialog parent) {
        super(parent);
        this.initGUI();
        this.list = (List)this.getSession().popParameter("KE_LIST");
        this.datOd = (Date)this.getSession().popParameter("KE_DATOD");
        this.datDo = (Date)this.getSession().popParameter("KE_DATDO");
    }

    private void initGUI() {
        this.setBounds(100, 100, 535, 539);
        this.getContentPane().setLayout(new BorderLayout());
        this.kontoPanel.setLayout(new FlowLayout());
        this.kontoPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.kontoPanel, "North");
        JLabel lblNewLabel = new JLabel("Konto:");
        this.kontoPanel.add(lblNewLabel);
        this.kontoField = new PzTextField();
        this.kontoField.setColumns(6);
        this.kontoPanel.add((Component)this.kontoField);
        this.kontoField.setMaxLength(6);
        this.kontoField.setFKField(Konto.class, PzDialogKontniPlan.class, true, null);
        this.kontoField.setEntityChecker(new PzEntityChecker(){
            boolean ponovo = true;

            public PzEntity getEntity() {
                try {
                    Konto kon = (Konto)PzEntityManager.find(Konto.class, (Object)new KontoPK(KontrolaKonto.this.kontoField.getVal(), KontrolaKonto.this.jLabelAnalitika.getText()));
                    if (kon != null && !kon.getTipAnalitike().equals("") && this.ponovo) {
                        this.ponovo = false;
                        EntityManager em1 = PzEntityManager.getEm();
                        Query q = em1.createQuery("SELECT k FROM Konto k WHERE  k.id.oznKonto=:oznkonta ORDER BY k.id.analitika");
                        q.setParameter("oznkonta", (Object)KontrolaKonto.this.kontoField.getVal());
                        PzEntityFilter filter = new PzEntityFilter(){

                            public Object[] getValues(PzEntity entity) {
                                Konto k = (Konto)entity;
                                return new Object[]{k.getId().getAnalitika().equals("") ? "Sve analitike" : k.getId().getAnalitika()};
                            }

                            public String[] getColumnNames() {
                                return new String[]{"Analitika"};
                            }
                        };
                        return PzGenericTableDialog.showDialog((PzDialog)KontrolaKonto.this, Konto.class, (List)q.getResultList(), (String)"Izbor analitike", (String)"", (PzEntityFilter)filter);
                    }
                    return PzEntityManager.find(Konto.class, (Object)new KontoPK(KontrolaKonto.this.kontoField.getVal(), KontrolaKonto.this.jLabelAnalitika.getText()));
                }
                catch (Exception e) {
                    PzMysqlExceptionHandler.handle((Component)KontrolaKonto.this.kontoField, (Throwable)e);
                    return null;
                }
            }
        });
        this.kontoField.requestFocus();
        this.kontoField.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (String.valueOf(e.getKeyChar()).matches("\\d")) {
                    KontrolaKonto.this.jLabelAnalitika.setText("");
                }
            }
        });
        this.jLabelAnalitika = new PzTextField();
        this.jLabelAnalitika.setColumns(3);
        this.kontoPanel.add((Component)this.jLabelAnalitika);
        this.jLabelAnalitika.setText("");
        JButton okButton = new JButton("OK");
        this.kontoPanel.add(okButton);
        okButton.setActionCommand("OK");
        okButton.addActionListener((ActionListener)((Object)this));
        this.getRootPane().setDefaultButton(okButton);
        this.tablePanel = new JPanel();
        this.getContentPane().add((Component)this.tablePanel, "Center");
        this.tablePanel.setLayout(new BorderLayout(0, 0));
        JScrollPane sp = new JScrollPane();
        this.table = new PzTable();
        sp.setViewportView((Component)this.table);
        this.tablePanel.add((Component)sp, "Center");
    }

    public void setEntity(PzEntity entity, Component component) {
        this.konto = (Konto)entity;
        this.kontoField.setVal((Object)this.konto.getId().getOznKonto());
        this.jLabelAnalitika.setVal((Object)this.konto.getId().getAnalitika());
    }

    public void actionPerformed(ActionEvent e) {
        List<KepuEntry> problems = KontrolaUtil.traziGresku(this.list, this.datOd, this.datDo, this.konto);
        this.table.setData(problems, KepuEntry.class);
    }
}

