/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.artikli.otpis;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.eclipse.persistence.indirection.IndirectList;
import rs.pezar.analitike.gui.artikli.otpis.Arhiviranje;
import rs.pezar.analitike.gui.artikli.otpis.Dodavanje;
import rs.pezar.analitike.gui.artikli.otpis.PzDialogDokumenti;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.entity.Artikalopstidokument;
import rs.pezar.db.entity.Brojacrj;
import rs.pezar.db.entity.Opstidokument;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Stanje;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogInsert;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzMathUtility;

public class PzDialogOtpis
extends PzDialogInsert {
    private PzPanel pzPanelN;
    private JScrollPane jScrollPane;
    private PzToolBarIcon icnArhiva;
    private PzToolBarIcon icnDodavanje;
    private PzToolBarIcon icnIzmena;
    private PzDoubleField vrednostSaPorezom;
    private JLabel jLabel2;
    private PzDoubleField vrednostBezPoreza;
    private JLabel jLabel1;
    private PzPanel pzPanelC;
    private JToolBar jToolBar;
    private PzTable tableInterni;
    private Opstidokument otpis;
    private boolean izmena;
    private PzToolBarIcon icnBrisanje;
    private Radnajedinica ulaznaRJ;
    private PzTable table;
    private Stanje stanjeIzlaz;
    private List<Artikalopstidokument> artotpiss;
    private PzPanel mainPanel;
    private PzDialogDokumenti parent;
    private Brojacrj brojac;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brDok = new JLabel();

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogOtpis inst = new PzDialogOtpis(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogOtpis(JFrame frame) {
        super(frame);
        this.otpis = new Opstidokument();
    }

    public PzDialogOtpis(PzDialog parent, boolean izmena, Object data1, Object data2) {
        super(parent);
        this.parent = (PzDialogDokumenti)parent;
        this.tableInterni = (PzTable)data1;
        this.otpis = izmena ? (Opstidokument)this.tableInterni.getSelectedEntity() : new Opstidokument();
        this.izmena = izmena;
        PzEntityUtil.currentType = "OTPIS";
        this.initGUI();
    }

    private void refresh() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PzDialogOtpis.this.brDok.setText(String.valueOf(PzDialogOtpis.this.table.getRowCount()));
            }
        });
    }

    protected void initGUI() {
        try {
            if (this.izmena) {
                this.setTitle("OTPIS ROBE U: " + this.otpis.getRadnajedinica().getId().getOznRj() + "(" + this.otpis.getRadnajedinica().getgTip() + ") " + this.otpis.getRadnajedinica().getNaziv());
            }
            this.mainPanel = new PzPanel();
            this.mainPanel.setPaintGradient(true);
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            mainPanelLayout.rowWeights = new double[]{0.0, 0.0, 0.1, 0.1};
            mainPanelLayout.rowHeights = new int[]{96, 46, 7, 7};
            mainPanelLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            mainPanelLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.pzPanelN = new PzPanel();
            this.mainPanel.add((Component)this.pzPanelN, (Object)new GridBagConstraints(0, 1, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            GridBagLayout pzPanelNLayout = new GridBagLayout();
            pzPanelNLayout.rowWeights = new double[]{14.0, 14.0, 14.0};
            pzPanelNLayout.rowHeights = new int[]{7, 7, 7};
            pzPanelNLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.1, 0.1};
            pzPanelNLayout.columnWidths = new int[]{108, 120, 10, 107, 120, 20, 34};
            this.pzPanelN.setLayout((LayoutManager)pzPanelNLayout);
            this.pzPanelN.setOpaque(false);
            this.jLabel1 = new JLabel();
            this.pzPanelN.add((Component)this.jLabel1, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.jLabel1.setText("Iznos bez poreza");
            this.vrednostBezPoreza = new PzDoubleField();
            this.pzPanelN.add((Component)this.vrednostBezPoreza, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.vrednostBezPoreza.setEditable(false);
            this.vrednostBezPoreza.setVal((Object)this.otpis.getIznosBezPoreza());
            this.vrednostBezPoreza.setFocusable(false);
            this.jLabel2 = new JLabel();
            this.pzPanelN.add((Component)this.jLabel2, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.jLabel2.setText("Iznos sa porezom");
            this.vrednostSaPorezom = new PzDoubleField();
            this.pzPanelN.add((Component)this.vrednostSaPorezom, (Object)new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.vrednostSaPorezom.setEditable(false);
            this.vrednostSaPorezom.setVal((Object)this.otpis.getIznosSaPorezom());
            this.vrednostSaPorezom.setFocusable(false);
            this.jToolBar = new JToolBar();
            this.mainPanel.add((Component)this.jToolBar, (Object)new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            this.jToolBar.setLayout(toolbarLayout);
            toolbarLayout.setAlignment(0);
            this.jToolBar.setOpaque(false);
            this.icnDodavanje = new PzToolBarIcon();
            this.jToolBar.add((Component)this.icnDodavanje);
            this.icnDodavanje.setText("Dodavanje|(ins)");
            this.icnDodavanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/product_add.png")));
            this.icnDodavanje.setActionCommand("Dodavanje");
            this.icnDodavanje.addActionListener((ActionListener)((Object)this));
            this.icnDodavanje.setShortcut("insert");
            this.icnIzmena = new PzToolBarIcon();
            this.jToolBar.add((Component)this.icnIzmena);
            this.icnIzmena.setText("Izmena|(F3)");
            this.icnIzmena.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/product_edit.png")));
            this.icnIzmena.setActionCommand("Izmena");
            this.icnIzmena.addActionListener((ActionListener)((Object)this));
            this.icnIzmena.setShortcut("f3");
            this.icnBrisanje = new PzToolBarIcon();
            this.jToolBar.add((Component)this.icnBrisanje);
            this.icnBrisanje.setText("Brisanje|(del)");
            this.icnBrisanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/box_delete.png")));
            this.icnBrisanje.setActionCommand("Brisanje");
            this.icnBrisanje.addActionListener((ActionListener)((Object)this));
            this.icnBrisanje.setShortcut("delete");
            this.icnArhiva = new PzToolBarIcon();
            this.jToolBar.add((Component)this.icnArhiva);
            this.icnArhiva.setText("Arhiva|(ctrl+W)");
            this.icnArhiva.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/address_book.png")));
            this.icnArhiva.setActionCommand("Arhiviranje");
            this.icnArhiva.addActionListener((ActionListener)((Object)this));
            this.icnArhiva.setShortcut("ctrl+w");
            this.pzPanelC = new PzPanel();
            GridBagLayout pzPanelCLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.pzPanelC, (Object)new GridBagConstraints(0, 2, 4, 2, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pzPanelC.setLayout((LayoutManager)pzPanelCLayout);
            pzPanelCLayout.rowWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            pzPanelCLayout.rowHeights = new int[]{7, 7, 7, 7};
            pzPanelCLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            pzPanelCLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.pzPanelC.setOpaque(false);
            this.jScrollPane = new JScrollPane();
            this.pzPanelC.add((Component)this.jScrollPane, (Object)new GridBagConstraints(0, 0, 4, 4, 0.0, 0.0, 10, 1, new Insets(0, 10, 10, 10), 0, 0));
            this.jScrollPane.setBounds(12, 0, 984, 592);
            if (this.otpis.getArtikalopstidokuments() == null) {
                this.otpis.setArtikalopstidokuments((List)new IndirectList());
            }
            this.table = new PzTable(this.otpis.getArtikalopstidokuments(), Artikalopstidokument.class);
            this.table.setEnterAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PzDialogOtpis.this.icnDodavanje.doClick();
                }
            });
            this.jScrollPane.setViewportView((Component)this.table);
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText("  Broj stavki na popisu: ");
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.pack();
            this.setSize(989, 666);
            this.setMinimumSize(new Dimension(989, 666));
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void actionPerformed(ActionEvent e) {
        EntityManager em = PzEntityManager.getEm();
        try {
            boolean izmena1 = false;
            String actionCommand = ((PzButton)e.getSource()).getActionCommand();
            if (actionCommand.equals("Brisanje")) {
                if (this.table.getSelectedEntity() == null) {
                    JOptionPane.showMessageDialog(SwingUtilities.getRoot((Component)((Object)this)), "Niste odabrali stavku za brisanje.", "Obavestenje", 1);
                    return;
                }
                int rez = PzSwingUtility.daNeDijalog((Component)((Object)this), (Object)"Da li ste sigurni?", (String)"Brisanje", null, (boolean)true);
                if (rez != 0) {
                    return;
                }
                Artikalopstidokument artopsti = (Artikalopstidokument)this.table.getSelectedEntity();
                this.otpis.setIznosBezPoreza(this.otpis.getIznosBezPoreza().subtract(PzMathUtility.roundToBigDecimal((double)(artopsti.getCenaBezPoreza() * artopsti.getKolicina()))));
                this.otpis.setIznosSaPorezom(this.otpis.getIznosSaPorezom().subtract(PzMathUtility.roundToBigDecimal((double)(artopsti.getCenaSaPorezom() * artopsti.getKolicina()))));
                this.otpis.setPdvIznos(this.otpis.getIznosSaPorezom().subtract(this.otpis.getIznosBezPoreza()));
                this.artotpiss = this.otpis.getArtikalopstidokuments();
                this.artotpiss.remove(artopsti);
                this.otpis.setArtikalopstidokuments(this.artotpiss);
                this.vrednostBezPoreza.setVal((Object)this.otpis.getIznosBezPoreza());
                this.vrednostSaPorezom.setVal((Object)this.otpis.getIznosSaPorezom());
                em.getTransaction().begin();
                em.remove(em.find(Artikalopstidokument.class, (Object)artopsti.getId()));
                em.merge((Object)this.otpis);
                em.getTransaction().commit();
                this.table.refreshData();
                this.refresh();
                return;
            }
            this.getSession().putParameter("table", (Object)this.table);
            this.getSession().putParameter("otpis", (Object)this.otpis);
            if (actionCommand.equals("Izmena")) {
                if (this.table.getRowCount() == 0) {
                    return;
                }
                izmena1 = true;
                actionCommand = "Dodavanje";
            } else if (actionCommand.equals("Arhiviranje")) {
                if (this.table.getRowCount() == 0) {
                    JOptionPane.showMessageDialog(SwingUtilities.getRoot((Component)((Object)this)), "Nije uneta nijedna stavka na otpisu.", "Obavestenje", 1);
                    return;
                }
                this.showDialog(Arhiviranje.class);
                return;
            }
            this.getSession().putParameter("update", (Object)izmena1);
            this.showDialog(Dodavanje.class);
            this.vrednostBezPoreza.setVal((Object)this.otpis.getIznosBezPoreza());
            this.vrednostSaPorezom.setVal((Object)this.otpis.getIznosSaPorezom());
            this.refresh();
            return;
        }
        catch (Exception e1) {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
            return;
        }
        finally {
            em.close();
        }
    }

    protected void onInsert() {
    }

    protected void onUpdate() {
    }

    public boolean shouldBeShown() {
        if (this.izmena) {
            return true;
        }
        boolean result = false;
        this.ulaznaRJ = PzDialogRJ.getRJ((PzDialog)this);
        if (this.ulaznaRJ != null) {
            result = true;
            this.setTitle("OTPIS ROBE U: " + this.ulaznaRJ.getId().getOznRj() + "(" + this.ulaznaRJ.getgTip() + ") " + this.ulaznaRJ.getNaziv());
            EntityManager em = PzEntityManager.getEm();
            try {
                try {
                    if (this.otpis == null) {
                        this.otpis = new Opstidokument();
                    }
                    this.otpis.setStorno(0);
                    this.otpis.setArhiviran((short)0);
                    this.otpis.setTip("OTPIS");
                    em.getTransaction().begin();
                    this.otpis.setRadnajedinica(this.ulaznaRJ);
                    this.otpis.setDatum(new Date(new java.util.Date().getTime()));
                    this.otpis.setProknjizen((short)0);
                    this.otpis.setProcRabata(0.0);
                    this.otpis.setIznosBezPoreza(new BigDecimal(0));
                    this.otpis.setIznosSaPorezom(new BigDecimal(0));
                    this.otpis.setPdvIznos(new BigDecimal(0));
                    this.otpis.setRjUlaz(this.ulaznaRJ.getPunNaziv());
                    PzDokumentManager.getInstance().snimiDokument((PzDokument)this.otpis, true, null, em);
                    em.getTransaction().commit();
                    this.tableInterni.insert((PzEntity)this.otpis, false);
                }
                catch (Exception e) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
                    em.close();
                }
            }
            finally {
                em.close();
            }
        }
        return result;
    }

    public void setEntity(PzEntity entity, Component component) {
    }

    protected void setHeaderOnInsert() {
    }

    protected void setHeaderOnUpdate() {
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogOtpis(Boolean.FALSE);
    }

    public PzDialogOtpis(Boolean initGUI) {
    }

    public void finish() {
        this.parent.finish();
        this.dispose();
    }

    protected void thisWindowClosing(WindowEvent evt) {
        super.thisWindowClosing(evt);
        PzEntityUtil.currentType = null;
    }
}

