/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.artikli.nivelacije;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import javax.persistence.EntityManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.entity.Nivelacija;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Taksanivelacija;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.custom.PzDialogPorezIznos;
import rs.pezar.swing.custom.PzTablePorez;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.util.PzSwingUtility;

public class PzDialogVrednosnaNivelacija
extends PzDialog {
    private static final long serialVersionUID = 6418074900050518935L;
    private PzPanel pnlContent;
    private PzPanelHeader pnlHeader;
    private JLabel lblRazlika;
    private JScrollPane scp;
    private PzDoubleField dblObracun;
    private JLabel lblObracunato;
    private PzButton btnOk;
    private PzDateField datum;
    private JLabel lblDatum;
    private PzDoubleField dblRazlika;
    private Radnajedinica rj;
    private PzTablePorez tblPorez;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogVrednosnaNivelacija inst = new PzDialogVrednosnaNivelacija(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogVrednosnaNivelacija(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.pnlContent = new PzPanel();
            GridBagLayout pnlContentLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlContent, "Center");
            pnlContentLayout.rowHeights = new int[]{7, 20, 7, 7, 20, 7};
            pnlContentLayout.columnWeights = new double[]{0.0, 0.0};
            pnlContentLayout.columnWidths = new int[]{103, 176};
            pnlContentLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.1, 0.0, 0.0};
            this.pnlContent.setLayout((LayoutManager)pnlContentLayout);
            this.pnlContent.setPreferredSize(new Dimension(602, 220));
            this.pnlHeader = new PzPanelHeader();
            new GridBagLayout();
            this.pnlHeader.setTitle("Unos vrednosne nivelacije");
            this.pnlHeader.setText("Unesite iznos za koji se nivelise vrednost magacina");
            this.pnlContent.add((Component)this.pnlHeader, (Object)new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 20, 0), 0, 0));
            this.dblRazlika = new PzDoubleField();
            this.dblRazlika.setColumns(10);
            this.pnlContent.add((Component)this.dblRazlika, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 10), 0, 0));
            this.lblRazlika = new JLabel("Razlika:");
            this.pnlContent.add((Component)this.lblRazlika, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 10), 0, 0));
            this.lblDatum = new JLabel("Datum izrade:");
            this.pnlContent.add((Component)this.lblDatum, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 10), 0, 0));
            this.datum = new PzDateField();
            this.pnlContent.add((Component)this.datum, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 10), 0, 0));
            this.btnOk = new PzButton("Unos");
            this.pnlContent.add((Component)this.btnOk, (Object)new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 15, 10), 0, 0));
            this.btnOk.setName("btnOk");
            this.btnOk.setIcon((Icon)new ImageIcon(PzDialogVrednosnaNivelacija.class.getResource("/rs/pezar/analitike/resource/img/check.png")));
            this.btnOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PzDialogVrednosnaNivelacija.this.btnOkActionPerformed(evt);
                }
            });
            this.scp = new JScrollPane();
            this.tblPorez = this.createTablePorez();
            this.scp.setViewportView((Component)this.tblPorez);
            this.pnlContent.add((Component)this.scp, (Object)new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
            this.lblObracunato = new JLabel("Obra\u010dunato:");
            this.pnlContent.add((Component)this.lblObracunato, (Object)new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
            this.dblObracun = this.tblPorez.createExpresionField("$2$+$3$");
            this.dblObracun.setEditable(false);
            this.dblObracun.setFocusable(false);
            this.pnlContent.add((Component)this.dblObracun, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 10), 0, 0));
            this.setSize(350, 500);
            this.setRestorable(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        if (BDConverter.getIznos((BigDecimal)this.dblRazlika.getBigDecimal()).equals(BDConverter.getIznos((BigDecimal)new BigDecimal(0)))) {
            PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Vrednost razlike ne mo\u017ee biti 0");
            this.dblRazlika.requestFocusInWindow();
            return;
        }
        if (this.rj.getgTip().equals("E") && !BDConverter.getIznos((double)this.dblObracun.getVal()).equals(BDConverter.getIznos((double)this.dblRazlika.getVal()))) {
            PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Obra\u010dunata i uneta vrednost se ne sla\u017eu");
            this.dblRazlika.requestFocusInWindow();
            return;
        }
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        try {
            em.getTransaction().begin();
            Nivelacija n = new Nivelacija();
            n.setRadnajedinica(this.rj);
            n.setTip(TipDokumentConfig.get().NIVELACIJA);
            n.setPodTip(TipDokumentConfig.get().PODTIP_NIVELACIJA_VREDNOSNA);
            n.setDatum(this.datum.getVal());
            n.setStaraVrednost(new BigDecimal(0));
            n.setNovaVrednost(this.dblRazlika.getBigDecimal());
            n.setVrednostRobe(this.dblRazlika.getBigDecimal());
            n.setOpis("VREDNOSNA NIVELACIJA");
            if (this.rj.getgTip().equals("E")) {
                n.setTaksanivelacijas(this.tblPorez.getPorezi());
                for (Taksanivelacija t : n.getTaksanivelacijas()) {
                    t.setTip("UK");
                    t.setOsnovica(t.getOsnovica().add(t.getIznos()));
                }
            }
            PzDokumentManager.getInstance().arhivirajDokument((PzDokument)n, true, null, em);
            em.getTransaction().commit();
            PzSwingUtility.showInformationMessage((Component)((Object)this), (String)"Nivelacija uspe\u0161no uneta u sistem.");
            this.dispose();
        }
        catch (Exception e) {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            PzMysqlExceptionHandler.handle((Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
    }

    public boolean shouldBeShown() {
        this.rj = PzDialogRJ.getRJ((PzDialog)this);
        if (!this.rj.getgTip().equals("E")) {
            this.tblPorez.setEnabled(false);
            this.dblObracun.setEnabled(false);
        }
        return this.rj != null;
    }

    private PzTablePorez createTablePorez() {
        PzTablePorez pzTablePorez = new PzTablePorez(Taksanivelacija.class, PzDialogPorezIznos.class, true);
        pzTablePorez.setColumnControlVisible(false);
        pzTablePorez.setAutoResizeMode(4);
        pzTablePorez.packAll();
        return pzTablePorez;
    }
}

