/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.artikli.nivelacije;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import javax.persistence.EntityManager;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import jxl.Cell;
import jxl.CellType;
import jxl.Sheet;
import jxl.Workbook;
import jxl.read.biff.BiffException;
import org.apache.poi.ss.util.CellRangeAddress;
import org.eclipse.persistence.indirection.IndirectList;
import org.jdesktop.application.Application;
import rs.pezar.analitike.PzExtensionLoader;
import rs.pezar.analitike.gui.artikli.nivelacije.uvozCenovnika.UnosPutanje;
import rs.pezar.core.transformation.TransformationException;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.entity.Aftaksa;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Artikalfaktura;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Nivelacija;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzDateUtility;

public class PzDialogUvozCenovnika
extends PzDialog {
    private static int PARAMETER_OD = -1;
    private static int PARAMETER_DO = -1;
    private static int PARAMETER_STR = -1;
    private PzPanel pnlGlavni;
    private JPanel pnlUputstvo;
    private PzTextField tfCena;
    private JLabel lblCena;
    private PzTextField tfSifra;
    private JComboBox cbSifra;
    private JLabel lblUputstvo;
    private PzPanel pnlPlan;
    private PzPanel pnlPlanImporta;
    private JPanel pnlRang;
    private JLabel lblOd;
    private PzNumericOnlyTextField tfOd;
    private JLabel lblDo;
    private PzNumericOnlyTextField tfDo;
    private JLabel lblStranica;
    private JComboBox cbStranica;
    private JPanel pnlButton;
    private PzButton btnPotvrdi;
    private Workbook workBook;
    private Radnajedinica rj;
    private File file;
    private int value = -1;
    private int valueC = -1;
    private Artikalfaktura al;
    private final List<String> listaSifara = new ArrayList<String>();
    private static Object[][] niz;

    public PzDialogUvozCenovnika(JFrame frame) {
        super(frame);
        this.initGUI();
        niz = this.createCriteriasOpsti();
    }

    private void postInit() {
        try {
            this.initParameters();
            this.workBook = Workbook.getWorkbook((File)this.file);
            int i = 0;
            while (i <= this.workBook.getNumberOfSheets()) {
                if (i == 0) {
                    this.cbStranica.addItem(new PzChoice("", (Object)i));
                } else {
                    this.cbStranica.addItem(new PzChoice(Integer.toString(i), (Object)i));
                }
                ++i;
            }
            if (this.workBook.getNumberOfSheets() == 1) {
                this.cbStranica.setSelectedIndex(1);
            }
            i = 0;
            while (i < niz.length) {
                this.cbSifra.addItem(this.getCriteriaOpsti(0)[i]);
                ++i;
            }
        }
        catch (IOException e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
        catch (BiffException e1) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("Plan importa");
            this.pnlGlavni = new PzPanel();
            this.pnlGlavni.setPaintGradient(true);
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            GridBagLayout pnlGlavniLayout1 = new GridBagLayout();
            pnlGlavniLayout1.rowWeights = new double[]{0.0, 0.0, 0.1};
            pnlGlavniLayout1.rowHeights = new int[]{74, 7, 20};
            pnlGlavniLayout1.columnWeights = new double[]{0.1};
            pnlGlavniLayout1.columnWidths = new int[]{7};
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout1);
            this.pnlGlavni.setPreferredSize(new Dimension(681, 295));
            this.pnlUputstvo = new JPanel();
            GridBagLayout pnlUputstvoLayout = new GridBagLayout();
            pnlUputstvoLayout.rowWeights = new double[]{0.1};
            pnlUputstvoLayout.rowHeights = new int[]{7};
            pnlUputstvoLayout.columnWeights = new double[]{0.1};
            pnlUputstvoLayout.columnWidths = new int[]{7};
            this.pnlGlavni.add((Component)this.pnlUputstvo, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
            TitledBorder border = BorderFactory.createTitledBorder("Uputstvo:");
            border.setTitleFont(new Font("Tahoma", 0, 12));
            this.pnlUputstvo.setBorder(border);
            this.pnlUputstvo.setLayout(pnlUputstvoLayout);
            this.pnlUputstvo.setOpaque(false);
            this.lblUputstvo = new JLabel();
            this.pnlUputstvo.add((Component)this.lblUputstvo, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.lblUputstvo.setText("<Html>Dijalog slu\u017ei za definisanje uvoza cenovnika iz excela.<br>Korisnik iz padaju\u0107e liste bira polje a zatim unosi slovo ili broj kolone u kojoj se podaci za izabrano polje nalaze.<br>Korisnik tako\u0111e bira list i red od kog \u0107e po\u010deti \u010ditanje podataka. Red do kog se podaci \u010ditaju je opcioni.</html>");
            this.lblUputstvo.setForeground(new Color(0, 0, 255));
            this.lblUputstvo.setFont(new Font("Tahoma", 0, 12));
            this.pnlPlan = new PzPanel();
            GridBagLayout pnlPlanLayout = new GridBagLayout();
            pnlPlanLayout.rowWeights = new double[]{0.0, 0.0};
            pnlPlanLayout.rowHeights = new int[]{82, 31};
            pnlPlanLayout.columnWeights = new double[]{0.1, 0.0};
            pnlPlanLayout.columnWidths = new int[]{397, 212};
            this.pnlGlavni.add((Component)this.pnlPlan, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.pnlPlan.setLayout((LayoutManager)pnlPlanLayout);
            this.pnlPlan.setOpaque(false);
            this.pnlPlanImporta = new PzPanel();
            GridBagLayout pnlPlanImportaLayout = new GridBagLayout();
            this.pnlPlan.add((Component)this.pnlPlanImporta, (Object)new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
            TitledBorder border2 = BorderFactory.createTitledBorder("Izbor polja i kolona");
            border2.setTitleFont(new Font("Tahoma", 0, 12));
            this.pnlPlanImporta.setBorder((Border)border2);
            this.pnlPlanImporta.setOpaque(false);
            this.pnlPlanImporta.setBackground(Color.WHITE);
            pnlPlanImportaLayout.rowWeights = new double[]{0.1, 0.0, 0.0, 0.1};
            pnlPlanImportaLayout.rowHeights = new int[]{7, 7, 7, 7};
            pnlPlanImportaLayout.columnWeights = new double[]{0.1, 0.0, 0.1};
            pnlPlanImportaLayout.columnWidths = new int[]{7, 124, 7};
            this.pnlPlanImporta.setLayout((LayoutManager)pnlPlanImportaLayout);
            this.cbSifra = new JComboBox();
            this.pnlPlanImporta.add((Component)this.cbSifra, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 10), 0, 0));
            this.tfSifra = new PzTextField();
            this.pnlPlanImporta.add((Component)this.tfSifra, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tfSifra.setToUpperCase(true);
            this.tfSifra.setMaxLength(2);
            this.tfSifra.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    if (!PzDialogUvozCenovnika.this.tfSifra.getVal().equals("")) {
                        if (PzDialogUvozCenovnika.this.getInteger(PzDialogUvozCenovnika.this.tfSifra.getVal()) == -1) {
                            PzDialogUvozCenovnika.this.value = CellRangeAddress.valueOf((String)(String.valueOf(PzDialogUvozCenovnika.this.tfSifra.getVal()) + "1")).getFirstColumn();
                        } else {
                            PzDialogUvozCenovnika pzDialogUvozCenovnika = PzDialogUvozCenovnika.this;
                            pzDialogUvozCenovnika.value = pzDialogUvozCenovnika.value + PzDialogUvozCenovnika.this.getInteger(PzDialogUvozCenovnika.this.tfSifra.getVal());
                        }
                    }
                    return true;
                }
            });
            this.lblCena = new JLabel();
            this.pnlPlanImporta.add((Component)this.lblCena, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.lblCena.setName("lblCena");
            this.tfCena = new PzTextField();
            this.pnlPlanImporta.add((Component)this.tfCena, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tfCena.setToUpperCase(true);
            this.tfCena.setMaxLength(2);
            this.tfCena.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    if (!PzDialogUvozCenovnika.this.tfCena.getVal().equals("")) {
                        if (PzDialogUvozCenovnika.this.getInteger(PzDialogUvozCenovnika.this.tfCena.getVal()) == -1) {
                            PzDialogUvozCenovnika.this.valueC = CellRangeAddress.valueOf((String)(String.valueOf(PzDialogUvozCenovnika.this.tfCena.getVal()) + "1")).getFirstColumn();
                        } else {
                            PzDialogUvozCenovnika pzDialogUvozCenovnika = PzDialogUvozCenovnika.this;
                            pzDialogUvozCenovnika.valueC = pzDialogUvozCenovnika.valueC + PzDialogUvozCenovnika.this.getInteger(PzDialogUvozCenovnika.this.tfCena.getVal());
                        }
                    }
                    return true;
                }
            });
            this.pnlRang = new JPanel();
            GridBagLayout pnlRangLayout = new GridBagLayout();
            this.pnlPlan.add((Component)this.pnlRang, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
            pnlRangLayout.rowWeights = new double[]{0.0, 0.0, 0.0};
            pnlRangLayout.rowHeights = new int[]{25, 25, 10};
            pnlRangLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0};
            pnlRangLayout.columnWidths = new int[]{58, 40, 55, 45};
            this.pnlRang.setLayout(pnlRangLayout);
            border2 = BorderFactory.createTitledBorder("Izbor lista i rang redova");
            border2.setTitleFont(new Font("Tahoma", 0, 12));
            this.pnlRang.setBorder(border2);
            this.pnlRang.setOpaque(false);
            this.lblOd = new JLabel();
            this.pnlRang.add((Component)this.lblOd, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 2, 0), 0, 0));
            this.lblOd.setText("Od reda");
            this.tfOd = new PzNumericOnlyTextField();
            this.pnlRang.add((Component)this.tfOd, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.tfOd.setVerifyInput(true);
            this.tfOd.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    if (PzDialogUvozCenovnika.this.tfOd.getIntVal() == 0) {
                        JOptionPane.showMessageDialog((Component)((Object)PzDialogUvozCenovnika.this), "Niste unijeli po\u010detni red podataka", "Informacija", 1);
                        return false;
                    }
                    return true;
                }
            });
            this.lblDo = new JLabel();
            this.pnlRang.add((Component)this.lblDo, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 2, 0), 0, 0));
            this.lblDo.setText("Do reda");
            this.tfDo = new PzNumericOnlyTextField();
            this.pnlRang.add((Component)this.tfDo, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 5), 0, 0));
            this.tfDo.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    return true;
                }
            });
            this.lblStranica = new JLabel();
            this.pnlRang.add((Component)this.lblStranica, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 2, 0), 0, 0));
            this.lblStranica.setText("List");
            this.cbStranica = new JComboBox();
            this.pnlRang.add((Component)this.cbStranica, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.cbStranica.setVerifyInputWhenFocusTarget(true);
            this.cbStranica.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    if (PzDialogUvozCenovnika.this.cbStranica.getSelectedItem().toString().equals("")) {
                        JOptionPane.showMessageDialog((Component)((Object)PzDialogUvozCenovnika.this), "Molim izaberite stranicu!", "Informacija", 1);
                        return false;
                    }
                    PzDialogUvozCenovnika.this.cbItemStateChanged();
                    return true;
                }
            });
            this.pnlButton = new JPanel();
            BorderLayout pnlButtonLayout = new BorderLayout();
            this.pnlButton.setLayout(pnlButtonLayout);
            this.pnlPlan.add((Component)this.pnlButton, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 2, 0, 0), 0, 0));
            this.pnlButton.setOpaque(false);
            this.btnPotvrdi = new PzButton();
            this.pnlButton.add((Component)this.btnPotvrdi, "Center");
            this.btnPotvrdi.setBounds(195, 12, 133, 30);
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setFont(new Font("Tahoma", 1, 12));
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/check.png")));
            this.btnPotvrdi.setPreferredSize(new Dimension(128, 33));
            this.btnPotvrdi.setActionCommand("potvrdi");
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.pack();
            this.setSize(647, 289);
            this.setResizable(false);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        final EntityManager em = PzEntityManager.getEm();
        if (actionCommand.equals("potvrdi") && this.checkAllFields()) {
            this.setColumnValue(2);
            PzWorkerDialog.showStatus((String)"Uvoz cenovnika je u toku. Molim sa\u010dekajte.", (PzDialog)this);
            SwingWorker<Object, Integer> sw = new SwingWorker<Object, Integer>(){

                @Override
                protected Object doInBackground() throws Exception {
                    int i = 0;
                    try {
                        Faktura f = null;
                        f = new Faktura();
                        f.setTip("FAKTURA");
                        f.setArtikalfakturas((List)new IndirectList());
                        f.setRadnajedinica(PzDialogUvozCenovnika.this.rj);
                        f.setArtikalfakturas(new ArrayList());
                        f.setUserPoc(PzExtensionLoader.getLoggedUser());
                        f.setUserKraj(PzExtensionLoader.getLoggedUser());
                        em.getTransaction().begin();
                        Sheet sheet = PzDialogUvozCenovnika.this.workBook.getSheet(PARAMETER_STR);
                        if (sheet.getRows() != 0) {
                            if (PARAMETER_DO == -1) {
                                PARAMETER_DO = sheet.getRows();
                            }
                            System.out.println("Parametar do je:" + PARAMETER_DO);
                            int j = PARAMETER_OD;
                            while (j <= PARAMETER_DO) {
                                if (j != sheet.getRows()) {
                                    Cell[] row = sheet.getRow(j);
                                    if (row.length != 0) {
                                        PzDialogUvozCenovnika.this.createAndGetArtikalFaktura(row, f, em);
                                        ++i;
                                    } else {
                                        int red = j + 1;
                                        throw new TransformationException("Informacija! Red " + red + " je prazan");
                                    }
                                    ++j;
                                    continue;
                                }
                                break;
                            }
                        } else {
                            throw new TransformationException("Informacija! List je prazan!");
                        }
                        Nivelacija nivelacija = PzEntityUtil.createNivelacija((PzDokument)f, (boolean)true, (boolean)true, (EntityManager)em);
                        PzDialogUvozCenovnika.this.arhiviraj(f, em);
                        if (nivelacija != null) {
                            nivelacija.setDatum(PzDateUtility.getCurrentDate());
                            PzDokumentManager.getInstance().arhivirajDokument((PzDokument)nivelacija, true, null, em);
                        }
                        em.getTransaction().commit();
                    }
                    catch (Exception e1) {
                        if (em.getTransaction().isActive()) {
                            em.getTransaction().rollback();
                        }
                        throw e1;
                    }
                    return null;
                }

                @Override
                protected void done() {
                    try {
                        try {
                            this.get();
                            PzDialogUvozCenovnika.this.dispose();
                        }
                        catch (InterruptedException e) {
                            PzMysqlExceptionHandler.handle((Component)((Object)PzDialogUvozCenovnika.this), (Throwable)e);
                            em.close();
                            PzDialogUvozCenovnika.this.initParameters();
                            PzWorkerDialog.hideStatus();
                        }
                        catch (ExecutionException e) {
                            block9: {
                                if (e.getCause() instanceof TransformationException) {
                                    PzSwingUtility.showErrorMessage((Component)((Object)PzDialogUvozCenovnika.this), (String)e.getMessage());
                                    break block9;
                                }
                                PzMysqlExceptionHandler.handle((Component)((Object)PzDialogUvozCenovnika.this), (Throwable)e);
                            }
                            em.close();
                            PzDialogUvozCenovnika.this.initParameters();
                            PzWorkerDialog.hideStatus();
                        }
                    }
                    finally {
                        em.close();
                        PzDialogUvozCenovnika.this.initParameters();
                        PzWorkerDialog.hideStatus();
                    }
                }
            };
            sw.execute();
        }
    }

    private void arhiviraj(Faktura fak, EntityManager em) throws Exception {
        if (fak == null) {
            return;
        }
        for (Artikalfaktura arfak : fak.getArtikalfakturas()) {
            StanjePK stanjePk = new StanjePK(arfak.getId().getSfrProizvod(), fak.getRadnajedinica());
            Stanje s = (Stanje)em.find(Stanje.class, (Object)stanjePk);
            s.setProdCena(arfak.getProdCena().doubleValue());
            em.merge((Object)s);
        }
    }

    private void createAndGetArtikalFaktura(Cell[] row, Faktura f, EntityManager em) throws TransformationException, IllegalAccessException, InvocationTargetException {
        this.al = new Artikalfaktura();
        this.al.setAftaksas(new Vector());
        Stanje s = null;
        Artikal a = null;
        int i = 0;
        int redP = 1;
        int j = 0;
        while (j < niz.length) {
            if (this.getCriteriaOpstiInt(2)[j] >= row.length) {
                throw new TransformationException("Gre\u0161ka! Kolona za polje " + this.getCriteriaOpsti(0)[j] + " u redu " + redP + " nije dobro definisana! ");
            }
            if (this.getCriteriaOpstiInt(2)[j] != -1) {
                int red;
                i = j;
                redP = red = row[this.getCriteriaOpstiInt(2)[j]].getRow() + 1;
                if (row[this.getCriteriaOpstiInt(2)[j]].getType() == CellType.EMPTY) {
                    throw new TransformationException("Gre\u0161ka! Kolona za polje " + this.getCriteriaOpsti(0)[j] + " je prazna. Red " + red + ".");
                }
            }
            ++j;
        }
        int red = row[this.getCriteriaOpstiInt(2)[2]].getRow() + 1;
        if (this.getCriteriaOpsti(3)[i].equals("STRING") && row[this.getCriteriaOpstiInt(2)[i]].getContents().length() > this.getCriteriaOpstiInt(4)[i]) {
            throw new TransformationException("Gre\u0161ka! Vrednost kolone za polje " + this.getCriteriaOpsti(0)[i] + " u " + red + ". redu je preduga\u010dka. Polje " + this.getCriteriaOpsti(0)[i] + " ima " + this.getCriteriaOpstiInt(4)[i] + " karaktera");
        }
        String sifra = this.getCriteriaOpstiInt(2)[0] != -1 ? row[this.getCriteriaOpstiInt(2)[0]].getContents() : row[this.getCriteriaOpstiInt(2)[1]].getContents();
        String upit = "Select a from Artikal a where %krit%='" + sifra + "'";
        upit = this.getCriteriaOpstiInt(2)[0] != -1 ? upit.replace("%krit%", "a.sfrProizvod") : upit.replace("%krit%", "a.dobSifra");
        List lista = em.createQuery(upit).getResultList();
        if (lista.size() != 0) {
            a = (Artikal)lista.get(0);
            this.al.getAftaksas().add(new Aftaksa(f.getIdDok(), a.getSfrProizvod(), a.getTarifnaGrupa("PDV").getOznTarGr(), 0, a.getTarifnaGrupa("PDV").getStopa(), a.getTarifnaGrupa("PDV").getVrstatg().getOznVrstaTG(), ""));
        }
        if (a == null) {
            this.listaSifara.add(sifra);
        } else {
            s = (Stanje)em.find(Stanje.class, (Object)new StanjePK(a.getSfrProizvod(), this.rj));
            if (s == null) {
                s = new Stanje();
                s.setId(new StanjePK(a.getSfrProizvod(), this.rj));
                s.setProdCena(0.0);
                em.persist((Object)s);
            }
            double broj = 0.0;
            if ((this.getCriteriaOpsti(3)[2].equals("DOUBLE") || this.getCriteriaOpsti(3)[3].equals("BIG_DECIMAL")) && (broj = this.getDouble(row[this.getCriteriaOpstiInt(2)[2]].getContents())) == -1.0) {
                throw new TransformationException("Gre\u0161ka! Vrednost kolone za polje " + this.getCriteriaOpsti(0)[2] + " u " + red + ". redu nije broj. ");
            }
            this.al.setArtikal(a);
            this.al.setId(1, a.getSfrProizvod(), 1);
            this.al.setCena(broj);
            f.getArtikalfakturas().add(this.al);
        }
    }

    private void AzurirajStanje(Cell[] row, EntityManager em) throws TransformationException, IllegalAccessException, InvocationTargetException {
        Stanje s = null;
        int i = 0;
        int j = 1;
        while (j < niz.length) {
            if (this.getCriteriaOpstiInt(2)[j] > row.length) {
                throw new TransformationException("Gre\u0161ka! Kolona za polje " + this.getCriteriaOpsti(0)[j] + " nije dobro definisana! ");
            }
            if (this.getCriteriaOpstiInt(2)[j] != -1) {
                i = j;
                int red = row[this.getCriteriaOpstiInt(2)[j]].getRow() + 1;
                if (row[this.getCriteriaOpstiInt(2)[j]].getType() == CellType.EMPTY) {
                    throw new TransformationException("Gre\u0161ka! Kolona za polje " + this.getCriteriaOpsti(0)[j] + " je prazna. Red " + red + ".");
                }
            }
            ++j;
        }
        int red = row[this.getCriteriaOpstiInt(2)[2]].getRow() + 1;
        if (this.getCriteriaOpsti(3)[i].equals("STRING") && row[this.getCriteriaOpstiInt(2)[i]].getContents().length() > this.getCriteriaOpstiInt(4)[i]) {
            throw new TransformationException("Gre\u0161ka! Vrednost kolone za polje " + this.getCriteriaOpsti(0)[i] + " u " + red + ". redu je preduga\u010dka. Polje " + this.getCriteriaOpsti(0)[i] + " ima " + this.getCriteriaOpstiInt(4)[i] + " karaktera");
        }
        String sifra = row[this.getCriteriaOpstiInt(2)[i]].getContents();
        s = i == 1 ? (Stanje)em.find(Stanje.class, (Object)new StanjePK(sifra, this.rj)) : (Stanje)em.createQuery("Select s from Stanje s where s.dobSifra='" + sifra + "'").getResultList().get(1);
        if (s == null) {
            throw new TransformationException("Gre\u0161ka! Ne postoji stanje za artikal u redu " + red + ".");
        }
        double broj = 0.0;
        if ((this.getCriteriaOpsti(3)[3].equals("DOUBLE") || this.getCriteriaOpsti(3)[3].equals("BIG_DECIMAL")) && (broj = this.getDouble(row[this.getCriteriaOpstiInt(2)[3]].getContents())) == -1.0) {
            throw new TransformationException("Gre\u0161ka! Vrednost kolone za polje " + this.getCriteriaOpsti(0)[3] + " u " + red + ". redu nije broj. ");
        }
        s.setProdCena(broj);
    }

    private Object[][] createCriteriasOpsti() {
        return new Object[][]{{"\u0160ifra", "sfrProizvod", -1, "STRING", 30}, {"Karaloski broj", "dobSifra", -1, "STRING", 255}, {"Cena", "cena", -1, "DOUBLE", 0}};
    }

    public double getDouble(String input) {
        try {
            double broj = new DecimalFormat("###,###.##").parse(input).doubleValue();
            return broj;
        }
        catch (Exception exception) {
            return -1.0;
        }
    }

    private boolean checkAllFields() {
        boolean rez = true;
        if (this.tfSifra.getVal().equals("") || this.tfCena.getVal().equals("")) {
            rez = false;
            JOptionPane.showMessageDialog((Component)((Object)this), "Niste uneli sva polja", "Informacija", 1);
        }
        if (rez && this.tfOd.getIntVal() == 0) {
            rez = false;
            JOptionPane.showMessageDialog((Component)((Object)this), "Niste uneli po\u010detni red podataka", "Informacija", 1);
        }
        return rez;
    }

    private void setColumnValue(int kolona) {
        this.cbItemStateChanged();
        PARAMETER_DO += this.tfDo.getIntVal();
        PARAMETER_OD += this.tfOd.getIntVal();
        PzDialogUvozCenovnika.niz[this.cbSifra.getSelectedIndex()][kolona] = this.value;
        PzDialogUvozCenovnika.niz[2][kolona] = this.valueC;
    }

    public static void setChoice(int index, int kolona, int val) {
        PzDialogUvozCenovnika.niz[index][kolona] = val;
    }

    private void initParameters() {
        PARAMETER_OD = -1;
        PARAMETER_DO = -1;
        PARAMETER_STR = -1;
        int i = 0;
        while (i < niz.length) {
            PzDialogUvozCenovnika.setChoice(i, 2, -1);
            ++i;
        }
    }

    private void cbItemStateChanged() {
        PARAMETER_STR = -1;
        PARAMETER_STR += Integer.parseInt(this.cbStranica.getSelectedItem().toString());
    }

    public String[] getCriteriaOpsti(int x) {
        int len = niz.length;
        Object[][] array = niz;
        String[] criterias = new String[len];
        int i = 0;
        while (i < len) {
            criterias[i] = (String)array[i][x];
            ++i;
        }
        return criterias;
    }

    public int[] getCriteriaOpstiInt(int x) {
        int len = niz.length;
        Object[][] array = niz;
        int[] criterias = new int[len];
        int i = 0;
        while (i < len) {
            criterias[i] = (Integer)array[i][x];
            ++i;
        }
        return criterias;
    }

    public boolean shouldBeShown() {
        this.rj = PzDialogRJ.getRJ((PzDialog)this);
        if (this.rj == null) {
            return false;
        }
        this.showDialog(UnosPutanje.class);
        this.file = (File)this.getSession().getParameter("file");
        if (this.file == null) {
            return false;
        }
        this.postInit();
        return true;
    }

    public int getInteger(String input) {
        try {
            int broj = Integer.parseInt(input);
            return broj;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static class Type {
        public static final String T_DOUBLE = "DOUBLE";
        public static final String T_BIG_DECIMAL = "BIG_DECIMAL";
        public static final String T_STRING = "STRING";
        public static final String T_DATE = "DATE";
        public static final String T_INTEGER = "INTEGER";
        public static final String T_BOOLEAN = "BOOLEAN";
    }
}

