/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.artikli.garniture.SastavGarniture;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.persistence.EntityManager;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import rs.pezar.analitike.gui.artikli.garniture.SastavGarniture.DodavanjeKomponente;
import rs.pezar.core.format.PzFormatFactory;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Artikalgarnitura;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.renderers.PzDoubleCellRenderer;

public class SastavGarniture
extends PzDialog {
    private static final long serialVersionUID = 2020718806330562548L;
    private JToolBar toolbar;
    private PzToolBarIcon icnDodavanje;
    private PzTable tabelaArtikli;
    private JScrollPane scrollPane;
    private PzPanel pnlGlavni;
    private PzToolBarIcon icnBrisiGarnituru;
    private Artikal garnitura;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brDok = new JLabel();

    public SastavGarniture(PzDialog dialog) {
        super(dialog);
        this.garnitura = (Artikal)this.getSession().getParameter("artikal");
        this.initGUI();
        this.refresh();
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("SASTAV GARNITURE: [ " + this.garnitura.getSfrProizvod() + " ] " + this.garnitura.getNaziv());
            this.pnlGlavni = new PzPanel();
            this.pnlGlavni.setPaintGradient(true);
            GridBagLayout pnlGlavniLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            pnlGlavniLayout.rowWeights = new double[]{0.0, 0.1, 0.1, 0.1};
            pnlGlavniLayout.rowHeights = new int[]{100, 7, 7, 7};
            pnlGlavniLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            pnlGlavniLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout);
            this.scrollPane = new JScrollPane();
            this.pnlGlavni.add((Component)this.scrollPane, (Object)new GridBagConstraints(0, 1, 4, 3, 0.0, 0.0, 10, 1, new Insets(0, 10, 10, 10), 0, 0));
            this.tabelaArtikli = new PzTable(this.garnitura.getDeloviGarniture(), Artikalgarnitura.class);
            this.scrollPane.setViewportView((Component)this.tabelaArtikli);
            this.tabelaArtikli.setEnterAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SastavGarniture.this.icnDodavanje.doClick();
                }
            });
            if (this.tabelaArtikli.getColumnCount() > 0) {
                this.tabelaArtikli.getColumn(2).setCellRenderer((TableCellRenderer)new PzDoubleCellRenderer(PzFormatFactory.getGarKoefUgradnjeFormat()));
            }
            this.toolbar = new JToolBar();
            this.pnlGlavni.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.toolbar.setLayout(toolbarLayout);
            this.toolbar.setOpaque(false);
            this.icnDodavanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnDodavanje);
            this.icnDodavanje.setText("Dodavanje|(INS)");
            this.icnDodavanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/product_add.png")));
            this.icnDodavanje.setActionCommand("dodavanje");
            this.icnDodavanje.addActionListener((ActionListener)((Object)this));
            this.icnDodavanje.setShortcut("INSERT");
            this.icnBrisiGarnituru = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnBrisiGarnituru);
            this.icnBrisiGarnituru.setText("Brisanje|(Del)");
            this.icnBrisiGarnituru.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/product_delete.png")));
            this.icnBrisiGarnituru.setActionCommand("brisanje");
            this.icnBrisiGarnituru.addActionListener((ActionListener)((Object)this));
            this.icnBrisiGarnituru.setShortcut("Delete");
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText("  Broj artikala");
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.pack();
            this.setSize(688, 557);
            this.setMinimumSize(new Dimension(688, 557));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        EntityManager em = PzEntityManager.getEm();
        try {
            try {
                if (actionCommand.equals("dodavanje")) {
                    this.getSession().putParameter("tabela", (Object)this.tabelaArtikli);
                    this.getSession().putParameter("artikal", (Object)this.garnitura);
                    this.showDialog(DodavanjeKomponente.class);
                    this.refresh();
                } else if (actionCommand.equals("brisanje") && this.tabelaArtikli.getRowCount() != 0) {
                    em.getTransaction().begin();
                    this.tabelaArtikli.removeSelectedEntity(true, em);
                    em.getTransaction().commit();
                    this.tabelaArtikli.commitRemove();
                    this.refresh();
                }
            }
            catch (Exception e1) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                em.close();
            }
        }
        finally {
            em.close();
        }
    }

    private void refresh() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SastavGarniture.this.tabelaArtikli.getColumnCount() > 0) {
                    SastavGarniture.this.tabelaArtikli.getColumn(2).setCellRenderer((TableCellRenderer)new PzDoubleCellRenderer(PzFormatFactory.getGarKoefUgradnjeFormat()));
                }
                SastavGarniture.this.brDok.setText(String.valueOf(SastavGarniture.this.tabelaArtikli.getRowCount()));
            }
        });
    }

    public static Object getGUIBuilderInstance() {
        return new SastavGarniture(Boolean.FALSE);
    }

    public SastavGarniture(Boolean initGUI) {
    }
}

