/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.artikli.garniture;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.persistence.EntityManager;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import rs.pezar.analitike.gui.artikli.garniture.SastavGarniture.OtvaranjeGarniture;
import rs.pezar.analitike.gui.artikli.garniture.SastavGarniture.SastavGarniture;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Artikal;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.util.PzSwingUtility;

public class PzDialogSastavGarniture
extends PzDialog {
    private static final long serialVersionUID = 1L;
    private JToolBar toolbar;
    private PzToolBarIcon icnDodavanje;
    private PzTable tabelaGarnitura;
    private JScrollPane scrollPane;
    private PzPanel pnlGlavni;
    private PzToolBarIcon icnGarnitura;
    private PzToolBarIcon icnBrisiGarnituru;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brDok = new JLabel();

    public PzDialogSastavGarniture(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("Garniture");
            this.pnlGlavni = new PzPanel();
            this.pnlGlavni.setPaintGradient(true);
            GridBagLayout pnlGlavniLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            pnlGlavniLayout.rowWeights = new double[]{0.0, 0.1, 0.1, 0.1};
            pnlGlavniLayout.rowHeights = new int[]{110, 200, 200, 90};
            pnlGlavniLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            pnlGlavniLayout.columnWidths = new int[]{200, 200, 200, 200};
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout);
            this.scrollPane = new JScrollPane();
            this.pnlGlavni.add((Component)this.scrollPane, (Object)new GridBagConstraints(0, 1, 4, 3, 0.0, 0.0, 10, 1, new Insets(0, 7, 7, 7), 0, 0));
            this.tabelaGarnitura = new PzTable();
            this.scrollPane.setViewportView((Component)this.tabelaGarnitura);
            this.tabelaGarnitura.setEnterAction(new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (PzDialogSastavGarniture.this.tabelaGarnitura.getSelectedRow() == -1) {
                        return;
                    }
                    PzDialogSastavGarniture.this.getSession().putParameter("artikal", (Object)PzDialogSastavGarniture.this.tabelaGarnitura.getSelectedEntity());
                    PzDialogSastavGarniture.this.showDialog(SastavGarniture.class);
                }
            });
            this.tabelaGarnitura.setFilter(new PzEntityFilter(){

                public Object[] getValues(PzEntity entity) {
                    Artikal dok = (Artikal)entity;
                    return new Object[]{dok.getSfrProizvod(), dok.getNaziv()};
                }

                public String[] getColumnNames() {
                    return new String[]{"\u0160ifra", "Naziv"};
                }
            });
            this.initializeTable();
            this.toolbar = new JToolBar();
            this.pnlGlavni.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.toolbar.setLayout(toolbarLayout);
            this.toolbar.setOpaque(false);
            this.icnDodavanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnDodavanje);
            this.icnDodavanje.setText("Dodavanje|(INS)");
            this.icnDodavanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/product_add.png")));
            this.icnDodavanje.setActionCommand("dodavanje");
            this.icnDodavanje.addActionListener((ActionListener)((Object)this));
            this.icnDodavanje.setShortcut("INSERT");
            this.icnGarnitura = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnGarnitura);
            this.icnGarnitura.setText("Ulaz u garnituru|(Enter)");
            this.icnGarnitura.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/product_view.png")));
            this.icnGarnitura.setActionCommand("ulaz");
            this.icnGarnitura.addActionListener((ActionListener)((Object)this));
            this.icnGarnitura.setShortcut("ENTER");
            this.icnGarnitura.setPreferredSize(new Dimension(76, 80));
            this.icnBrisiGarnituru = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnBrisiGarnituru);
            this.icnBrisiGarnituru.setText("Brisanje|(Del)");
            this.icnBrisiGarnituru.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/product_delete.png")));
            this.icnBrisiGarnituru.setActionCommand("brisanje");
            this.icnBrisiGarnituru.addActionListener((ActionListener)((Object)this));
            this.icnBrisiGarnituru.setShortcut("Delete");
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText("Broj garnitura");
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.pack();
            this.setSize(800, 5600);
            this.setMinimumSize(new Dimension(800, 600));
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        EntityManager em = PzEntityManager.getEm();
        try {
            try {
                if (actionCommand.equals("dodavanje")) {
                    this.getSession().putParameter("tabela", (Object)this.tabelaGarnitura);
                    this.showDialog(OtvaranjeGarniture.class);
                    this.refresh();
                } else if (actionCommand.equals("ulaz")) {
                    if (this.tabelaGarnitura.getRowCount() != 0) {
                        this.getSession().putParameter("artikal", (Object)this.tabelaGarnitura.getSelectedEntity());
                        this.showDialog(SastavGarniture.class);
                    }
                } else if (actionCommand.equals("brisanje") && this.tabelaGarnitura.getRowCount() != 0) {
                    Artikal gar = (Artikal)this.tabelaGarnitura.getSelectedEntity();
                    if (gar.getDeloviGarniture().size() != 0) {
                        PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Garnitura ima definisanu strukturu. BRISANJE NEMOGU\u010aE");
                    } else {
                        int rez = PzSwingUtility.daNeDijalog((Component)((Object)this), (Object)"Da li ste sigurni?!", (String)"Brisanje", null, (boolean)false);
                        if (rez == 0) {
                            em.getTransaction().begin();
                            gar.setGarnitura((short)0);
                            em.merge((Object)gar);
                            em.getTransaction().commit();
                            this.tabelaGarnitura.removeGUI(this.tabelaGarnitura.getSelectedRow());
                        }
                    }
                }
            }
            catch (Exception e1) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                em.close();
            }
        }
        finally {
            em.close();
        }
    }

    private void refresh() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PzDialogSastavGarniture.this.brDok.setText(String.valueOf(PzDialogSastavGarniture.this.tabelaGarnitura.getRowCount()));
            }
        });
    }

    private void initializeTable() throws Exception {
        List data = PzEntityManager.getList((String)"SELECT a FROM Artikal a where a.garnitura=1");
        this.tabelaGarnitura.setData(data, Artikal.class);
        this.brDok.setText(String.valueOf(data.size()));
    }
}

