/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.jdesktop.application.Application;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.LayerUI;
import rs.pezar.analitike.gui.kepu.Dodavanje;
import rs.pezar.analitike.gui.kepu.PzTableModelKep;
import rs.pezar.analitike.gui.kepu.RbrKepuSkoci;
import rs.pezar.analitike.gui.kepu.kontrola.KepuEntry;
import rs.pezar.analitike.gui.kepu.kontrola.KontrolaKonto;
import rs.pezar.core.RuleKep;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Dokument;
import rs.pezar.db.entity.Firma;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.RadnajedinicaPK;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.PzTableDataSource;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzAbstractTable;
import rs.pezar.swing.PzBusyPainterUI;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzCheckbox;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogChoice;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzDateUtility;

public class PzDialogKEPKnjiga
extends PzDialog {
    private PzPanel plDugmici;
    private JLabel lblRazduzenje;
    private JLabel lblOpcioniOpisRJ;
    private PzNumericOnlyTextField nfRJ;
    private JLabel lblRadnaJedinica;
    private PzPanel plLabele;
    private PzToolBarIcon btnStampa;
    private PzToolBarIcon btnSelStampa;
    private PzToolBarIcon btnBrisanje;
    private PzToolBarIcon btnIzmena;
    private PzToolBarIcon btnDodavanje;
    private PzToolBarIcon btnPrikaziDokument;
    private JToolBar toolbar;
    private JLabel lblRalikaRazduzUplata;
    private JLabel lblrazlzaduzrazduz;
    private JLabel lblNazivRadneJedinice;
    private JLabel lblUplata;
    private PzTable tblKepu;
    private JScrollPane spKepu;
    private PzPanel plTabela;
    private JLabel lblZaduzenje;
    private PzDoubleField dfMedjuracunica2;
    private PzDoubleField dfMedjuracunica1;
    private PzDoubleField dfUplata;
    private PzDoubleField dfZaduzenje;
    private PzDoubleField dfRazduzenje;
    private Radnajedinica radnaJedinica;
    private ScrollableCursor cursor;
    private JLabel lblbrDok;
    private JLabel lblbrojdokumenata;
    private EntityManager em;
    private RuleKep ruleK;
    private JLabel lblPrikazKepu;
    private JLabel lblPrikaz;
    private List<Radnajedinica> radnejedinice;
    private PzBusyPainterUI layerUI;
    private JXLayer<PzPanel> layer;
    private SwingWorker<ScrollableCursor, Object> worker;
    private PzTableModelKep tableModel;
    private PzToolBarIcon btnFilter;
    private byte optionTemp;
    private PzButton pzButton1;
    private PzCheckbox chckGenerisiRedne;
    private PzButton btnOsvezi;
    private JLabel lblDo;
    private JLabel lblOd;
    private PzCheckbox chkDatum;
    private PzDateField pzDateField1;
    private JLabel lblFilterIkona;
    private JLabel jLabel1;
    private String dokTemp;
    private String sviDok;
    private boolean filtrirano = false;
    private PzToolBarIcon btnSkoci;
    private PzDateField dateOd;
    private PzDateField dateDo;
    private String orderBy;
    private PzToolBarIcon btnKontrola;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogKEPKnjiga inst = new PzDialogKEPKnjiga(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogKEPKnjiga(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public void setLocked(boolean locked) {
        if (this.layerUI != null) {
            this.layerUI.setLocked(locked);
        }
    }

    private void initGUI() {
        try {
            this.setTitle("Izbor RJ za \"KEP\" knjigu");
            this.plDugmici = new PzPanel();
            GridBagLayout plDugmiciLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.plDugmici, "South");
            this.plDugmici.setPreferredSize(new Dimension(1012, 94));
            plDugmiciLayout.rowWeights = new double[]{0.1};
            plDugmiciLayout.rowHeights = new int[]{7};
            plDugmiciLayout.columnWeights = new double[]{0.1};
            plDugmiciLayout.columnWidths = new int[]{7};
            this.plDugmici.setLayout((LayoutManager)plDugmiciLayout);
            this.toolbar = new JToolBar();
            this.plDugmici.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 16, 2, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.toolbar.setLayout(toolbarLayout);
            this.btnDodavanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnDodavanje);
            this.btnDodavanje.setText("Dodavanje|(Ins)");
            this.btnDodavanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/book_blue_add.png")));
            this.btnDodavanje.addActionListener((ActionListener)((Object)this));
            this.btnDodavanje.setShortcut("insert");
            this.btnIzmena = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnIzmena);
            this.btnIzmena.setText("Izmena|(F3)");
            this.btnIzmena.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/book_blue_new.png")));
            this.btnIzmena.addActionListener((ActionListener)((Object)this));
            this.btnIzmena.setShortcut("f3");
            this.btnBrisanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnBrisanje);
            this.btnBrisanje.setText("Brisanje|(Del)");
            this.btnBrisanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/book_blue_delete.png")));
            this.btnBrisanje.addActionListener((ActionListener)((Object)this));
            this.btnBrisanje.setShortcut("delete");
            this.btnSelStampa = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnSelStampa);
            this.btnSelStampa.setText("Sel. za \u0161tampu|(F2)");
            this.btnSelStampa.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/printer_preferences.png")));
            this.btnSelStampa.addActionListener((ActionListener)((Object)this));
            this.btnSelStampa.setShortcut("f2");
            this.btnSelStampa.setEnabled(false);
            this.btnSelStampa.setVisible(false);
            this.btnStampa = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnStampa);
            this.btnStampa.setText("\u0160tampa |(Alt+S)");
            this.btnStampa.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/printer_preferences.png")));
            this.btnStampa.addActionListener((ActionListener)((Object)this));
            this.btnStampa.setShortcut("alt+s");
            this.btnPrikaziDokument = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnPrikaziDokument);
            this.btnPrikaziDokument.setText("Prikaz dokumenta|(f2)");
            this.btnPrikaziDokument.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/printer_preferences.png")));
            this.btnPrikaziDokument.addActionListener((ActionListener)((Object)this));
            this.btnPrikaziDokument.setShortcut("f2");
            this.btnFilter = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnFilter);
            this.btnFilter.setText("Filter|(f4)");
            this.btnFilter.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/funnel.png")));
            this.btnFilter.addActionListener((ActionListener)((Object)this));
            this.btnFilter.setShortcut("f4");
            this.btnSkoci = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnSkoci);
            this.btnSkoci.setText("Sko\u010di na|rbr (ctrl+g)");
            this.btnSkoci.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/find_456.png")));
            this.btnSkoci.addActionListener((ActionListener)((Object)this));
            this.btnSkoci.setShortcut("ctrl+g");
            this.btnKontrola = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnKontrola);
            this.btnKontrola.setText("Kontrola|(ctrl+K)");
            this.btnKontrola.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/find_456.png")));
            this.btnKontrola.addActionListener((ActionListener)((Object)this));
            this.btnKontrola.setShortcut("ctrl+k");
            this.plLabele = new PzPanel();
            GridBagLayout plLabeleLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.plLabele, "North");
            this.plLabele.setPreferredSize(new Dimension(1012, 137));
            plLabeleLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.1, 0.0};
            plLabeleLayout.rowHeights = new int[]{37, 27, 7, 25, 20, 7};
            plLabeleLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1, 0.0};
            plLabeleLayout.columnWidths = new int[]{121, 157, 171, 151, 158, 159, 7, 7, 7};
            this.plLabele.setLayout((LayoutManager)plLabeleLayout);
            this.lblRadnaJedinica = new JLabel();
            this.plLabele.add((Component)this.lblRadnaJedinica, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 15, 5, 5), 0, 0));
            this.lblRadnaJedinica.setText("Radna jedinica");
            this.lblRadnaJedinica.setFont(new Font("Tahoma", 0, 14));
            this.nfRJ = new PzNumericOnlyTextField();
            this.plLabele.add((Component)this.nfRJ, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.nfRJ.setFont(new Font("Tahoma", 0, 14));
            this.nfRJ.setPreferredSize(new Dimension(68, 24));
            this.nfRJ.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                }

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        PzDialogKEPKnjiga.this.btnOKactionPerformed(null);
                    }
                }
            });
            this.lblOpcioniOpisRJ = new JLabel();
            this.plLabele.add((Component)this.lblOpcioniOpisRJ, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.lblOpcioniOpisRJ.setText("Opcioni opis RJ");
            this.lblOpcioniOpisRJ.setFont(new Font("Tahoma", 0, 14));
            this.lblOpcioniOpisRJ.setVisible(false);
            this.lblRazduzenje = new JLabel();
            this.plLabele.add((Component)this.lblRazduzenje, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.lblRazduzenje.setText("Razdu\u017eenje:  ");
            this.lblRazduzenje.setFont(new Font("Tahoma", 0, 14));
            this.lblUplata = new JLabel();
            this.plLabele.add((Component)this.lblUplata, (Object)new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.lblUplata.setText("Uplata:  ");
            this.lblUplata.setFont(new Font("Tahoma", 0, 14));
            this.lblUplata.setVisible(false);
            this.dfRazduzenje = new PzDoubleField();
            this.plLabele.add((Component)this.dfRazduzenje, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.dfRazduzenje.setFont(new Font("Tahoma", 1, 14));
            this.dfRazduzenje.setFocusable(false);
            this.dfRazduzenje.setEditable(false);
            this.dfRazduzenje.setBackground(new Color(174, 174, 174));
            this.dfRazduzenje.setBorder((Border)BorderFactory.createCompoundBorder(new LineBorder(new Color(0, 0, 0), 1, false), null));
            this.dfZaduzenje = new PzDoubleField();
            this.plLabele.add((Component)this.dfZaduzenje, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.dfZaduzenje.setFont(new Font("Tahoma", 1, 14));
            this.dfZaduzenje.setFocusable(false);
            this.dfZaduzenje.setEditable(false);
            this.dfZaduzenje.setBackground(new Color(174, 174, 174));
            this.dfZaduzenje.setBorder((Border)BorderFactory.createCompoundBorder(new LineBorder(new Color(0, 0, 0), 1, false), null));
            this.dfZaduzenje.setToolTipText("Zadu\u017eenje");
            this.dfUplata = new PzDoubleField();
            this.plLabele.add((Component)this.dfUplata, (Object)new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.dfUplata.setFont(new Font("Tahoma", 1, 14));
            this.dfUplata.setFocusable(false);
            this.dfUplata.setEditable(false);
            this.dfUplata.setBackground(new Color(174, 174, 174));
            this.dfUplata.setBorder((Border)BorderFactory.createCompoundBorder(new LineBorder(new Color(0, 0, 0), 1, false), null));
            this.dfUplata.setVisible(false);
            this.dfMedjuracunica1 = new PzDoubleField();
            this.plLabele.add((Component)this.dfMedjuracunica1, (Object)new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.dfMedjuracunica1.setFont(new Font("Tahoma", 0, 14));
            this.dfMedjuracunica1.setFocusable(false);
            this.dfMedjuracunica1.setEditable(false);
            this.dfMedjuracunica1.setBackground(new Color(192, 192, 192));
            this.dfMedjuracunica1.setBorder((Border)BorderFactory.createCompoundBorder(new LineBorder(new Color(0, 0, 0), 1, false), null));
            this.dateOd = new PzDateField();
            this.dateOd.setVal((Object)PzDateUtility.getFirstDayOfCurrentYear());
            this.plLabele.add((Component)this.dateOd, (Object)new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.dateOd.setFont(new Font("Tahoma", 0, 14));
            this.dateOd.setBorder((Border)new LineBorder(new Color(0, 0, 0), 1, false));
            this.dfMedjuracunica2 = new PzDoubleField();
            this.plLabele.add((Component)this.dfMedjuracunica2, (Object)new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.dfMedjuracunica2.setFont(new Font("Tahoma", 0, 14));
            this.dfMedjuracunica2.setFocusable(false);
            this.dfMedjuracunica2.setEditable(false);
            this.dfMedjuracunica2.setBackground(new Color(192, 192, 192));
            this.dfMedjuracunica2.setBorder((Border)BorderFactory.createCompoundBorder(new LineBorder(new Color(0, 0, 0), 1, false), null));
            this.lblZaduzenje = new JLabel();
            this.plLabele.add((Component)this.lblZaduzenje, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 15, 5, 5), 0, 0));
            this.lblZaduzenje.setText("Zadu\u017eenje:  ");
            this.lblZaduzenje.setFont(new Font("Tahoma", 0, 14));
            this.lblNazivRadneJedinice = new JLabel();
            this.plLabele.add((Component)this.lblNazivRadneJedinice, (Object)new GridBagConstraints(2, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.lblNazivRadneJedinice.setPreferredSize(new Dimension(316, 27));
            this.lblNazivRadneJedinice.setBackground(new Color(172, 234, 175));
            this.lblNazivRadneJedinice.setOpaque(true);
            this.lblNazivRadneJedinice.setBorder(new LineBorder(new Color(0, 0, 0), 1, false));
            this.lblrazlzaduzrazduz = new JLabel();
            this.plLabele.add((Component)this.lblrazlzaduzrazduz, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.lblrazlzaduzrazduz.setName("lblrazlzaduzrazduz");
            this.lblRalikaRazduzUplata = new JLabel();
            this.plLabele.add((Component)this.lblRalikaRazduzUplata, (Object)new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.lblRalikaRazduzUplata.setName("lblRalikaRazduzUplata");
            this.lblbrojdokumenata = new JLabel();
            this.lblbrojdokumenata.setText("Broj dokumenata:");
            this.plLabele.add((Component)this.lblbrojdokumenata, (Object)new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
            this.lblbrojdokumenata.setName("lblbrojdokumenata");
            this.lblbrDok = new JLabel();
            this.plLabele.add((Component)this.lblbrDok, (Object)new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 0, 0), 0, 0));
            this.lblbrDok.setName("lblbrDok");
            this.lblPrikazKepu = new JLabel();
            this.plLabele.add((Component)this.lblPrikazKepu, (Object)new GridBagConstraints(7, 1, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
            this.lblPrikazKepu.setText("Prikaz kepu:");
            this.lblPrikazKepu.setName("lblPrikazKepu");
            this.lblPrikaz = new JLabel();
            this.plLabele.add((Component)this.lblPrikaz, (Object)new GridBagConstraints(7, 1, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 0, 0), 0, 0));
            this.plLabele.add((Component)this.getJLabel1(), (Object)new GridBagConstraints(7, 3, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
            this.plLabele.add((Component)this.getLblFilterIkona(), (Object)new GridBagConstraints(7, 3, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 0, 0), 0, 0));
            this.dateDo = new PzDateField();
            this.plLabele.add((Component)this.dateDo, (Object)new GridBagConstraints(4, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.dateDo.setBorder((Border)new LineBorder(new Color(0, 0, 0), 1, false));
            this.chkDatum = new PzCheckbox();
            this.plLabele.add((Component)this.chkDatum, (Object)new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 15, 5, 5), 0, 0));
            this.chkDatum.setName("chkDatum");
            this.chkDatum.addActionListener((ActionListener)((Object)this));
            this.lblOd = new JLabel();
            this.plLabele.add((Component)this.lblOd, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 13, 3, new Insets(5, 5, 5, 5), 0, 0));
            this.lblOd.setName("lblOd");
            this.lblDo = new JLabel();
            this.plLabele.add((Component)this.lblDo, (Object)new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 13, 3, new Insets(5, 5, 5, 5), 0, 0));
            this.lblDo.setName("lblDo");
            this.btnOsvezi = new PzButton();
            this.plLabele.add((Component)this.btnOsvezi, (Object)new GridBagConstraints(5, 4, 1, 1, 0.0, 0.0, 13, 3, new Insets(5, 5, 5, 5), 0, 0));
            this.btnOsvezi.setName("btnOsvezi");
            this.btnOsvezi.addActionListener((ActionListener)((Object)this));
            this.chckGenerisiRedne = new PzCheckbox();
            this.plLabele.add((Component)this.chckGenerisiRedne, (Object)new GridBagConstraints(7, 4, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
            this.chckGenerisiRedne.setName("chckGenerisiRedne");
            this.pzButton1 = new PzButton();
            this.plLabele.add((Component)this.pzButton1, (Object)new GridBagConstraints(7, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.pzButton1.setName("pzButton1");
            this.pzButton1.addActionListener((ActionListener)((Object)this));
            this.pzButton1.addActionListener((ActionListener)((Object)this));
            this.lblPrikaz.setName("lblPrikaz");
            this.plTabela = new PzPanel();
            GridBagLayout plTabelaLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.plTabela, "Center");
            plTabelaLayout.rowWeights = new double[]{0.1};
            plTabelaLayout.rowHeights = new int[]{7};
            plTabelaLayout.columnWeights = new double[]{0.1};
            plTabelaLayout.columnWidths = new int[]{7};
            this.plTabela.setLayout((LayoutManager)plTabelaLayout);
            this.spKepu = new JScrollPane();
            this.plTabela.add((Component)this.spKepu, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tblKepu = new PzTable();
            this.spKepu.setViewportView((Component)this.tblKepu);
            this.btnBrisanje.setEnabled(false);
            this.btnDodavanje.setEnabled(false);
            this.btnIzmena.setEnabled(false);
            this.btnStampa.setEnabled(false);
            this.btnPrikaziDokument.setEnabled(false);
            this.btnFilter.setEnabled(false);
            this.btnSkoci.setEnabled(false);
            this.setDateSelected(false);
            this.layerUI = new PzBusyPainterUI();
            this.layer = new JXLayer((Component)this.plTabela, (LayerUI)this.layerUI);
            this.getContentPane().add((Component)this.layer, "Center");
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
            this.pack();
            this.setSize(1360, 759);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.btnBrisanje)) {
            this.onBrisanjePressed();
        } else if (e.getSource().equals(this.btnDodavanje)) {
            this.onDodavanjePressed();
        } else if (e.getSource().equals(this.btnIzmena)) {
            this.onIzmenaPressed();
        } else if (e.getSource().equals(this.btnSelStampa)) {
            this.onSelStampaPressed();
        } else if (e.getSource().equals(this.btnStampa)) {
            this.onStampaPressed();
        } else if (e.getSource().equals(this.btnPrikaziDokument)) {
            this.onSlikaDokumentaPressed();
        } else if (e.getSource().equals(this.nfRJ)) {
            this.btnOKactionPerformed(e);
        } else if (e.getSource().equals(this.btnFilter)) {
            this.onFilterPressed();
        } else if (e.getSource().equals(this.btnSkoci)) {
            this.onSkociPressed();
        } else if (e.getSource().equals(this.chkDatum)) {
            this.onDateChecked();
        } else if (e.getSource().equals(this.btnKontrola)) {
            this.onKontrolaPressed();
        } else if (e.getSource().equals(this.btnOsvezi) || e.getSource().equals(this.pzButton1)) {
            if (this.radnaJedinica != null) {
                this.fillInTheInfo();
            } else {
                JOptionPane.showMessageDialog((Component)((Object)this), "Prvo morate odabrati radnu jedinicu!", "Gre\u0161ka!", 0);
            }
        }
    }

    private void onKontrolaPressed() {
        Vector<KepuEntry> list = new Vector<KepuEntry>();
        int i = 0;
        while (i < this.tblKepu.getRowCount()) {
            KepuEntry ke = new KepuEntry();
            ke.setIdDok((Integer)this.tblKepu.getValueAt(i, 6));
            ke.setDatum((Date)this.tblKepu.getValueAt(i, 1));
            ke.setOpis((String)this.tblKepu.getValueAt(i, 2));
            ke.setZaduzenje((BigDecimal)this.tblKepu.getValueAt(i, 3));
            ke.setRazduzenje((BigDecimal)this.tblKepu.getValueAt(i, 4));
            list.add(ke);
            ++i;
        }
        this.getSession().putParameter("KE_LIST", list);
        this.getSession().putParameter("KE_DATOD", (Object)this.dateOd.getVal());
        this.getSession().putParameter("KE_DATDO", (Object)this.dateDo.getVal());
        this.showDialog(KontrolaKonto.class);
    }

    private void onDateChecked() {
        if (this.chkDatum.isSelected()) {
            this.setDateSelected(true);
        } else {
            this.setDateSelected(false);
        }
    }

    private void setDateSelected(boolean selected) {
        this.dateOd.setEnabled(selected);
        this.lblOd.setEnabled(selected);
        this.dateDo.setEnabled(selected);
        this.lblDo.setEnabled(selected);
        this.btnOsvezi.setEnabled(selected);
    }

    private void onSkociPressed() {
        String rbr = RbrKepuSkoci.getRbr(this);
        if (rbr != null) {
            int j = 0;
            while (j < this.tblKepu.getModel().getRowCount()) {
                if (this.tblKepu.getStringAt(j, 0).equals(rbr)) {
                    this.tblKepu.changeSelection(j, 0, false, false);
                    break;
                }
                ++j;
            }
        }
    }

    private void onDodavanjePressed() {
        Dokument d = Dodavanje.getNewData(this, this.radnaJedinica, null);
        if (d != null) {
            try {
                PzDokumentManager.getInstance().arhivirajDokument((PzDokument)d, false, null);
            }
            catch (Exception e) {
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            }
        }
        this.doFunc();
    }

    private void onStampaPressed() {
        this.showReport();
    }

    private void onSelStampaPressed() {
    }

    private void onFilterPressed() {
        String[] temp1 = this.sviDok.split(",");
        Vector<String> temp2 = new Vector<String>();
        int i = 0;
        while (i < temp1.length) {
            temp2.add(temp1[i]);
            ++i;
        }
        String temp3 = PzDialogChoice.showPzDialogChoice((PzDialog)this, temp2, (String)"Izbor dokumenata", (Byte)PzDialogChoice.TYPE_CHECKBOX);
        if (temp3 != null) {
            this.dokTemp = temp3;
        }
        if (this.dokTemp.equals(this.sviDok)) {
            this.filtrirano = false;
            this.lblFilterIkona.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/forbidden.png")));
        } else {
            this.filtrirano = true;
            this.lblFilterIkona.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/check.png")));
        }
        if (temp3 != null) {
            this.doFunc();
        }
    }

    private void onIzmenaPressed() {
        try {
            if (this.tblKepu.getSelectedRow() != -1) {
                Dokument d = (Dokument)PzEntityManager.find(Dokument.class, (Object)((PzTableModelKep)((Object)this.tblKepu.getModel())).getKey(this.tblKepu.getSelectedRow()));
                if (!this.ruleK.isKepuDocumentChangeable(d.getTip())) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Dokument ima analiticke podatke i ne moze biti menjak kroz kepu knjigu.\n Kroz Kepu mozete menjati dokumente koji su uneti kroz Kepu.", "Greska", 0);
                    return;
                }
                Dodavanje.getNewData(this, this.radnaJedinica, d);
                PzEntityManager.update((Object)d);
            }
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
        this.doFunc();
    }

    private void onBrisanjePressed() {
        Dokument d = null;
        try {
            if (this.tblKepu.getSelectedRow() != -1) {
                d = (Dokument)PzEntityManager.find(Dokument.class, (Object)((PzTableModelKep)((Object)this.tblKepu.getModel())).getKey(this.tblKepu.getSelectedRow()));
                if (!this.ruleK.isKepuDocumentChangeable(d.getTip())) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Dokument ima analiticke podatke i ne moze biti brisan kroz kepu knjigu.\n Kroz Kepu mozete brisati ili menjati dokumente koji su uneti kroz Kepu.", "Greska", 0);
                    return;
                }
                if (JOptionPane.showConfirmDialog((Component)((Object)this), "Potvrdite brisanje sa 'yes'", "Brisanje", 0) == 0) {
                    PzDokumentManager.getInstance().deleteDokument((PzDokument)d, null);
                }
            }
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
        this.doFunc();
    }

    private void btnOKactionPerformed(ActionEvent arg0) {
        this.doFunc();
    }

    private void doFunc() {
        if (this.nfRJ.getText().equals("")) {
            this.radnaJedinica = PzDialogRJ.getRj((PzDialog)this, this.radnejedinice);
            this.nfRJ.setText(this.radnaJedinica.getId().getOznRj());
            this.lblNazivRadneJedinice.setText(this.radnaJedinica.getPunNaziv());
            if (this.cursor != null) {
                this.cursor.close();
            }
            this.fillInTheInfo();
            this.btnBrisanje.setEnabled(true);
            this.btnDodavanje.setEnabled(true);
            this.btnIzmena.setEnabled(true);
            this.btnStampa.setEnabled(true);
            this.btnPrikaziDokument.setEnabled(true);
        } else {
            this.em = PzEntityManager.getEm();
            RadnajedinicaPK pk = new RadnajedinicaPK();
            pk.setOznRj(this.nfRJ.getText());
            pk.setOznOgranak("1");
            this.radnaJedinica = (Radnajedinica)this.em.find(Radnajedinica.class, (Object)pk);
            if (this.radnaJedinica == null) {
                PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Oznaka radne jedinice nije pronadjena medju dozvoljenim oznakama. Ukoliko niste sigurni, obrisite sadr\u017eaj polja i pritisnite enter.");
                return;
            }
            this.lblNazivRadneJedinice.setText(this.radnaJedinica.getPunNaziv());
            if (this.cursor != null) {
                this.cursor.close();
            }
            this.fillInTheInfo();
        }
    }

    private ScrollableCursor fillInTheInfo() {
        if (this.cursor != null) {
            this.cursor.close();
        }
        if (this.em != null) {
            this.em.close();
        }
        this.em = PzEntityManager.getEm();
        String option = "";
        this.optionTemp = (byte)-1;
        try {
            option = PzParameter.getParameterValue((String)"KEPU_FORMA");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (option.equals("raz_bez_pdv")) {
            this.optionTemp = 0;
            this.lblPrikaz.setText("Razduzenje bez poreza");
        } else if (option.equals("raz_bez_pdv_rabat")) {
            this.optionTemp = 1;
            this.lblPrikaz.setText("Razduzenje bez poreza i rabata");
        } else if (option.equals("raz_sa_pdv_rabat")) {
            this.optionTemp = (byte)2;
            this.lblPrikaz.setText("Razduzenje sa porezom i rabatom");
        }
        this.ruleK = new RuleKep(this.radnaJedinica, this.optionTemp);
        this.sviDok = this.ruleK.getKepuDocumentTypes();
        if (!this.filtrirano) {
            this.dokTemp = this.sviDok;
        }
        final String dokumenta = this.dokTemp;
        final String oznrj = "'" + this.radnaJedinica.getId().getOznRj() + "'";
        final String ogranak = "'" + this.radnaJedinica.getId().getOznOgranak() + "'";
        this.orderBy = this.chckGenerisiRedne.isSelected() ? "3" : "rbrkepu";
        this.layerUI.setLocked(true);
        this.worker = new SwingWorker<ScrollableCursor, Object>(){

            @Override
            protected ScrollableCursor doInBackground() throws Exception {
                String que = String.format("SELECT * FROM((SELECT a.tip, a.rbroj, CASE \t\tWHEN a.tip = '" + TipDokumentConfig.get().KALKULACIJA + "' THEN a.datum " + "\t\tWHEN a.tip = '" + TipDokumentConfig.get().TROSAK + "' THEN a.datum " + "\t\tWHEN a.tip = '" + TipDokumentConfig.get().RACUN_DOBAVLJACA + "' THEN a.datum " + "\t\tWHEN a.tip = '" + TipDokumentConfig.get().ZAPISNIK_OTPREMNICE + "' THEN a.datum " + "\t\tWHEN a.tip = '" + TipDokumentConfig.get().FAKTURA + "' THEN a.datprometa " + "\t\tWHEN a.tip = '" + TipDokumentConfig.get().FAKTURA_INTERNI_RACUN + "' THEN a.datprometa " + "\t\tWHEN a.datprometa is NULL THEN a.datum " + "\t\tELSE a.datum " + "\tEND AS datumdokumenta, " + "a.rbrkepu AS rbrkepu, " + "a.iznos, " + "a.storno, " + "a.stornoiznos, " + "X.PDV, " + "(SELECT b.rabatukupno FROM faktura b WHERE a.iddok = b.iddok), " + "(SELECT k.prodvrednost FROM kalkulacija k WHERE k.iddok = a.iddok), " + "(SELECT (p.dbl2-p.dbl1) FROM opstidokument p WHERE p.iddok = a.iddok  ), " + "(SELECT o.iznosbezporeza FROM opstidokument o WHERE o.iddok = a.iddok  ), " + "(SELECT (n.novavrednost - n.staravrednost) FROM nivelacija n WHERE n.iddok = a.iddok  ), " + "a.vrsta, " + "(SELECT c.iznosbezporeza FROM faktura c WHERE a.iddok = c.iddok), " + "a.zaduzenje, " + "a.razduzenje, " + "a.iddok, " + "a.ozndokumenta, " + "a.sfrkomitent, " + "a.opis, " + "X.A1," + "X.A2," + "(SELECT  t.iznosbezporeza FROM konsignacija t WHERE t.iddok = a.iddok ), " + "a.podtip," + "(SELECT o.dbl7 + o.dbl8 FROM opstidokument o WHERE o.iddok = a.original)," + "a.datum, " + "(SELECT k.nabavnavrednost FROM kalkulacija k WHERE k.iddok = a.iddok) " + "FROM dokument a " + "FULL JOIN (SELECT" + "\t\t\t\tt.iddok AS id, " + "\t\t\t\tSUM(CASE  " + " \t\t\t\t\tWHEN t.vrsta = 'PDV' THEN t.iznos " + " \t\t\t\t\tELSE 0 " + " \t\t\t\t\tEND) AS PDV, " + "\t\t\t\tSUM(CASE " + " \t\t\t\t\tWHEN (t.ozntargr='T1' OR t.ozntargr='T2') AND t.vrsta = 'PDV' THEN t.osnovica " + " \t\t\t\t\tELSE 0 " + " \t\t\t\t\tEND) AS A1, " + "\t\t\t\tSUM(CASE " + " \t\t\t\t\tWHEN (t.ozntargr='U1' OR t.ozntargr='U2') AND t.vrsta = 'PDV' THEN t.osnovica " + "\t\t\t\t\tELSE 0  " + "\t\t\t\t\tEND) AS A2 " + "\t\t\tFROM " + "\t\t\t\tdokument a, dtaksa t " + "\t\t\tWHERE " + "\t\t\t\t(a.tip IN (%s) AND a.oznrj = %s AND a.oznogranak = %s) AND a.arhiviran = 1 AND NOT a.rbrdok = -1 " + "\t\t\t\tAND t.iddok = a.iddok AND t.vrsta = 'PDV' " + "\t\t\tGROUP BY " + "\t\t\t\ta.iddok, " + "\t\t\t\tt.iddok)X ON X.ID = A.IDDOK " + "WHERE " + "(a.tip IN (%s) AND a.oznrj = %s AND a.oznogranak = %s) " + "AND a.arhiviran = 1 " + "AND NOT a.rbrdok = -1 " + "AND ( a.kepu is null or NOT a.kepu = -1)) " + "ORDER BY #orderBy)Y #datumskoograniecnje ", dokumenta, oznrj, ogranak, dokumenta, oznrj, ogranak, oznrj, ogranak, oznrj, ogranak, oznrj, ogranak, oznrj, ogranak);
                que = PzDialogKEPKnjiga.this.chkDatum.isSelected() ? que.replace("#datumskoograniecnje", "WHERE Y.datumdokumenta >= '" + PzDialogKEPKnjiga.this.dateOd.getVal() + "' AND Y.datumdokumenta <= '" + PzDialogKEPKnjiga.this.dateDo.getVal() + "'") : que.replace("#datumskoograniecnje", "");
                que = que.replace("#orderBy", PzDialogKEPKnjiga.this.orderBy);
                Query q = PzDialogKEPKnjiga.this.em.createNativeQuery(que);
                q.setHint("eclipselink.cursor.scrollable", (Object)"True");
                return (ScrollableCursor)q.getSingleResult();
            }

            @Override
            protected void done() {
                PzDialogKEPKnjiga.this.layerUI.setLocked(false);
                try {
                    PzDialogKEPKnjiga.this.cursor = (ScrollableCursor)this.get();
                    if (PzDialogKEPKnjiga.this.chckGenerisiRedne.isSelected()) {
                        PzDialogKEPKnjiga.this.tableModel = new PzTableModelKep(PzDialogKEPKnjiga.this.cursor, PzDialogKEPKnjiga.this.ruleK, true);
                    } else {
                        PzDialogKEPKnjiga.this.tableModel = new PzTableModelKep(PzDialogKEPKnjiga.this.cursor, PzDialogKEPKnjiga.this.ruleK, false);
                    }
                    PzDialogKEPKnjiga.this.tblKepu.setModel((TableModel)((Object)PzDialogKEPKnjiga.this.tableModel));
                    PzDialogKEPKnjiga.this.tblKepu.setAutoResizeMode(0);
                    PzDialogKEPKnjiga.this.tblKepu.getColumnModel().getColumn(0).setPreferredWidth(70);
                    PzDialogKEPKnjiga.this.tblKepu.getColumnModel().getColumn(1).setPreferredWidth(100);
                    PzDialogKEPKnjiga.this.tblKepu.getColumnModel().getColumn(2).setPreferredWidth(400);
                    PzDialogKEPKnjiga.this.tblKepu.getColumnModel().getColumn(3).setPreferredWidth(100);
                    PzDialogKEPKnjiga.this.tblKepu.getColumnModel().getColumn(4).setPreferredWidth(100);
                    PzDialogKEPKnjiga.this.tblKepu.hideColumnByName("Uplata");
                    PzDialogKEPKnjiga.this.tblKepu.getColumnModel().getColumn(5).setPreferredWidth(100);
                    PzDialogKEPKnjiga.this.btnBrisanje.setEnabled(true);
                    PzDialogKEPKnjiga.this.btnDodavanje.setEnabled(true);
                    PzDialogKEPKnjiga.this.btnIzmena.setEnabled(true);
                    PzDialogKEPKnjiga.this.btnStampa.setEnabled(true);
                    PzDialogKEPKnjiga.this.btnPrikaziDokument.setEnabled(true);
                    PzDialogKEPKnjiga.this.btnFilter.setEnabled(true);
                    PzDialogKEPKnjiga.this.btnSkoci.setEnabled(true);
                    PzDialogKEPKnjiga.this.refreshSum();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
        };
        this.worker.execute();
        this.filtrirano = false;
        return this.cursor;
    }

    private void refreshSum() {
        BigDecimal zaduzenje = BigDecimal.ZERO;
        BigDecimal razduzenje = BigDecimal.ZERO;
        BigDecimal uplata = BigDecimal.ZERO;
        int i = 0;
        while (i < this.tblKepu.getModel().getRowCount()) {
            zaduzenje = zaduzenje.add((BigDecimal)this.tblKepu.getModel().getValueAt(i, 3));
            razduzenje = razduzenje.add((BigDecimal)this.tblKepu.getModel().getValueAt(i, 4));
            uplata = uplata.add((BigDecimal)this.tblKepu.getModel().getValueAt(i, 5));
            ++i;
        }
        this.dfZaduzenje.setValue((Object)zaduzenje);
        this.dfRazduzenje.setValue((Object)razduzenje);
        this.dfUplata.setValue((Object)uplata);
        this.dfMedjuracunica1.setVal((Object)this.dfZaduzenje.getBigDecimal().subtract(this.dfRazduzenje.getBigDecimal()));
        this.dfMedjuracunica2.setVal((Object)this.dfRazduzenje.getBigDecimal().subtract(this.dfUplata.getBigDecimal()));
        this.lblbrDok.setText(String.valueOf(this.tblKepu.getModel().getRowCount()));
    }

    private void showReport() {
        Firma firma = null;
        String godina = null;
        try {
            firma = PzFirma.getFirma();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Vector<Object> data = new Vector<Object>();
        try {
            godina = PzParameter.getParameterValue((String)"TEKUCA_GODINA");
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        Date datum = null;
        datum = this.chkDatum.isSelected() ? this.dateDo.getVal() : PzDateUtility.getCurrentDate();
        try {
            data.add(firma);
            data.add(this.radnaJedinica);
            data.add(this.radnaJedinica.getOgranak());
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("TEKUCA_GODINA", godina);
        params.put("datum", datum);
        if (this.filtrirano) {
            params.put("FILTRIRANO", "filtrirano");
        }
        PzTableDataSource ds = new PzTableDataSource((PzAbstractTable)this.tblKepu, data);
        try {
            PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)ds, (String)"rs/pezar/reports/compiled/kep.jasper", params, (String)"kepu", (int)PzReportManager.REPORT_TYPE_JASPER);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void thisWindowClosing(WindowEvent evt) {
        if (this.cursor != null) {
            this.cursor.close();
        }
        if (this.em != null) {
            this.em.close();
        }
        super.thisWindowClosing(evt);
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogKEPKnjiga(Boolean.FALSE);
    }

    public PzDialogKEPKnjiga(Boolean initGUI) {
    }

    private void onSlikaDokumentaPressed() {
        if (this.tblKepu.getSelectedRow() == -1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Morate selektovati dokument iz tabele.", "Info", 1);
            return;
        }
        Integer iddok = (Integer)this.tblKepu.getModel().getValueAt(this.tblKepu.convertRowIndexToModel(this.tblKepu.getSelectedRow()), 6);
        PzDokument d = null;
        try {
            d = (PzDokument)PzEntityManager.find(Dokument.class, (Object)iddok);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)d);
    }

    private JLabel getJLabel1() {
        if (this.jLabel1 == null) {
            this.jLabel1 = new JLabel();
            this.jLabel1.setName("jLabel1");
            this.jLabel1.setText("Filter:");
        }
        return this.jLabel1;
    }

    private JLabel getLblFilterIkona() {
        if (this.lblFilterIkona == null) {
            this.lblFilterIkona = new JLabel();
            this.lblFilterIkona.setName("lblFilterIkona");
            this.lblFilterIkona.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/forbidden.png")));
        }
        return this.lblFilterIkona;
    }
}

