/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import rs.pezar.core.PzApplication;
import rs.pezar.core.log.PzLogger;
import rs.pezar.swing.util.PzSwingUtility;

public class CertUtil {
    private static final char[] HEXDIGITS = "0123456789abcdef".toCharArray();

    /*
     * Unable to fully structure code
     */
    public static void installCert(String args, String passPhase) throws Exception {
        if (args == null) {
            return;
        }
        c = args.replace("http://", "").replace("https://", "").split(":");
        host = c[0];
        port = c.length == 1 ? 443 : Integer.parseInt(c[1]);
        p = passPhase == null ? "changeit" : passPhase;
        passphrase = p.toCharArray();
        file = CertUtil.getCertFile();
        PzLogger.getInstance().logInfo("Loading KeyStore " + file.getAbsolutePath() + "...");
        in = new FileInputStream(file);
        ks = KeyStore.getInstance(KeyStore.getDefaultType());
        try {
            ks.load(in, passphrase);
            PzLogger.getInstance().logInfo("Keystore loaded " + file.getAbsolutePath() + "...");
        }
        catch (Exception v0) {
            ks.load(null, passphrase);
        }
        in.close();
        context = SSLContext.getInstance("TLS");
        tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(ks);
        defaultTrustManager = (X509TrustManager)tmf.getTrustManagers()[0];
        tm = new SavingTrustManager(defaultTrustManager);
        context.init(null, new TrustManager[]{tm}, null);
        factory = context.getSocketFactory();
        PzLogger.getInstance().logInfo("Opening connection to " + host + ":" + port + "...");
        socket = (SSLSocket)factory.createSocket(host, port);
        socket.setSoTimeout(10000);
        try {
            System.out.println("Starting SSL handshake...");
            socket.startHandshake();
            socket.close();
            System.out.println();
            PzLogger.getInstance().logInfo("No errors, certificate is already trusted.");
            return;
        }
        catch (SSLException e) {
            PzLogger.getInstance().logInfo("Error. Certificate is not trusted.");
            e.printStackTrace(System.out);
            chain = SavingTrustManager.access$0(tm);
            if (chain == null) {
                throw new CertException("Could not obtain server certificate chain");
            }
            PzLogger.getInstance().logInfo("");
            PzLogger.getInstance().logInfo("Server sent " + chain.length + " certificate(s):");
            PzLogger.getInstance().logInfo("");
            sha1 = MessageDigest.getInstance("SHA1");
            md5 = MessageDigest.getInstance("MD5");
            i = 0;
            ** while (i < chain.length)
        }
lbl-1000:
        // 1 sources

        {
            cert = chain[i];
            PzLogger.getInstance().logInfo(" " + (i + 1) + " Subject " + cert.getSubjectDN());
            PzLogger.getInstance().logInfo("   Issuer  " + cert.getIssuerDN());
            sha1.update(cert.getEncoded());
            PzLogger.getInstance().logInfo("   sha1    " + CertUtil.toHexString(sha1.digest()));
            md5.update(cert.getEncoded());
            PzLogger.getInstance().logInfo("   md5     " + CertUtil.toHexString(md5.digest()));
            PzLogger.getInstance().logInfo("");
            ++i;
            continue;
        }
lbl59:
        // 1 sources

        rez = PzSwingUtility.daNeDijalog(PzApplication.getApplication().getWorkbench().getMainFrame(), "Da biste mogli da koristite servis " + args + ", odre\u0111eni sertifikati moraju biti instalirani na va\u0161em ra\u010dunaru.\nDa li \u017eelite da ih instalirate?", "Instalacija sertifikata", null, true);
        if (rez != 0) {
            return;
        }
        i = 0;
        while (i < chain.length) {
            cert = chain[i];
            alias = String.valueOf(host) + "-" + (i + 1);
            ks.setCertificateEntry(alias, cert);
            out = new FileOutputStream(file);
            ks.store(out, passphrase);
            out.close();
            PzLogger.getInstance().logInfo("");
            PzLogger.getInstance().logInfo(cert.toString());
            PzLogger.getInstance().logInfo("");
            PzLogger.getInstance().logInfo("Added certificate to keystore " + file.getAbsolutePath() + " using alias '" + alias + "'");
            ++i;
        }
    }

    public static File getCertFile() {
        File cacerts;
        File file = cacerts = PzApplication.getApplication() != null ? new File(PzApplication.getApplication().getDataFolder() + File.separator + "cacerts") : new File(String.valueOf(System.getProperty("user.home")) + File.separator + ".pezar" + File.separator + "cacerts");
        if (!cacerts.exists()) {
            try {
                cacerts.createNewFile();
                KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
                ks.load(null);
                FileOutputStream out = new FileOutputStream(cacerts);
                ks.store(out, "changeit".toCharArray());
                ((OutputStream)out).close();
            }
            catch (Exception e) {
                PzLogger.getInstance().logException(e);
            }
        }
        return cacerts;
    }

    private static String toHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 3);
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            int b = byArray[n2];
            sb.append(HEXDIGITS[(b &= 0xFF) >> 4]);
            sb.append(HEXDIGITS[b & 0xF]);
            sb.append(' ');
            ++n2;
        }
        return sb.toString();
    }

    public static class CertException
    extends Exception {
        private static final long serialVersionUID = -3922352779488267804L;

        public CertException() {
        }

        public CertException(String message) {
            super(message);
        }

        public CertException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    private static class SavingTrustManager
    implements X509TrustManager {
        private final X509TrustManager tm;
        private X509Certificate[] chain;

        SavingTrustManager(X509TrustManager tm) {
            this.tm = tm;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.chain = chain;
            this.tm.checkServerTrusted(chain, authType);
        }

        static /* synthetic */ X509Certificate[] access$0(SavingTrustManager savingTrustManager) {
            return savingTrustManager.chain;
        }
    }
}

