/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.swing.util;

import java.awt.Component;
import java.awt.Window;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Date;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.LayerUI;
import rs.pezar.db.PzEntity;
import rs.pezar.swing.PzBusyPainterUI;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.fields.PzFieldImpl;

public class PzSwingUtility {
    public static String format(Object obj) {
        String result;
        String string = result = obj != null ? obj.toString() : "";
        if (obj instanceof Date) {
            String[] seq = obj.toString().split("-");
            result = String.valueOf(seq[2]) + "." + seq[1] + "." + seq[0];
        } else if (obj instanceof Double) {
            DecimalFormat numFormat = new DecimalFormat("###,###.00");
            result = numFormat.format((Double)obj);
        }
        return result;
    }

    public static String getSelectedValue(ButtonGroup group) {
        String result = "";
        Enumeration<AbstractButton> buttons = group.getElements();
        while (buttons.hasMoreElements()) {
            AbstractButton button = buttons.nextElement();
            if (!button.isSelected()) continue;
            result = button.getActionCommand();
            break;
        }
        return result;
    }

    public static void setSelectedValue(String value, ButtonGroup group) {
        Enumeration<AbstractButton> buttons = group.getElements();
        while (buttons.hasMoreElements()) {
            AbstractButton button = buttons.nextElement();
            if (!button.getActionCommand().equals(value)) continue;
            button.setSelected(true);
        }
    }

    public static void setSelectedValue(Object value, JComboBox cb) {
        int i = 0;
        while (i < cb.getItemCount()) {
            if (cb.getItemAt(i) instanceof PzChoice && ((PzChoice)cb.getItemAt(i)).getValue().equals(value)) {
                cb.setSelectedIndex(i);
                break;
            }
            ++i;
        }
    }

    public static void showErrorMessage(Component component, String message) {
        JOptionPane.showMessageDialog(SwingUtilities.getRoot(component), message, "Gre\u0161ka", 0);
    }

    public static void showInformationMessage(Component component, String message) {
        JOptionPane.showMessageDialog(SwingUtilities.getRoot(component), message, "Informacija", 1);
    }

    private static void showDialog(PzDialog dialog, Component parent) {
        if (SwingUtilities.getRoot(parent) instanceof PzDialog) {
            ((PzDialog)SwingUtilities.getRoot(parent)).showDialog(dialog);
        }
    }

    public static PzDialog showDialog(Class dialogClass, Component parent) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor c = dialogClass.getConstructor(PzDialog.class);
        PzDialog dialog = (PzDialog)c.newInstance(parent);
        PzSwingUtility.showDialog(dialog, parent);
        return dialog;
    }

    public static PzDialog showDialog(Class dialogClass, Component parent, boolean closeOnEnter) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor c = dialogClass.getConstructor(PzDialog.class);
        PzDialog dialog = (PzDialog)c.newInstance(parent);
        dialog.setCloseOnEnter(closeOnEnter);
        PzSwingUtility.showDialog(dialog, parent);
        return dialog;
    }

    public static PzDialog showDialog(Class dialogClass, JFrame parent) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor c = dialogClass.getConstructor(JFrame.class);
        PzDialog dialog = (PzDialog)c.newInstance(parent);
        PzSwingUtility.showDialog(dialog, (Component)parent);
        return dialog;
    }

    public static PzDialog showDialog(PzDialog parent, Class dialogClass, boolean arg, Object data1, Object data2) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor c = dialogClass.getConstructor(PzDialog.class, Boolean.TYPE, Object.class, Object.class);
        PzDialog dialog = (PzDialog)c.newInstance(parent, arg, data1, data2);
        dialog.setCloseOnEnter(true);
        PzSwingUtility.showDialog(dialog, (Component)parent);
        return dialog;
    }

    public static PzEntity createEntity(Class entityClass, JPanel panel) {
        PzEntity entity = null;
        try {
            entity = (PzEntity)entityClass.newInstance();
            Field[] fields = entityClass.getDeclaredFields();
            int i = 0;
            while (i < fields.length) {
                Object value = PzSwingUtility.getValueByFieldName(fields[i].getName(), panel);
                if (value != null) {
                    Method method;
                    String firstLetter = fields[i].getName().substring(0, 1);
                    String methodName = "set" + firstLetter.toUpperCase() + fields[i].getName().substring(1);
                    if (value instanceof Double) {
                        method = entityClass.getMethod(methodName, Double.TYPE);
                        method.invoke((Object)entity, (double)((Double)value));
                    } else if (value instanceof Integer) {
                        method = entityClass.getMethod(methodName, Integer.TYPE);
                        method.invoke((Object)entity, (int)((Integer)value));
                    } else {
                        method = entityClass.getMethod(methodName, value.getClass());
                        method.invoke((Object)entity, value);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            entity = null;
        }
        return entity;
    }

    private static Object getValueByFieldName(String fieldName, JPanel panel) {
        Object result = null;
        Vector<Component> pzFields = PzSwingUtility.getAllFields(panel);
        for (Component pzField : pzFields) {
            String name = pzField.getName();
            if (name == null || !pzField.getName().equalsIgnoreCase(fieldName)) continue;
            result = ((PzFieldImpl)pzField).getVal();
            break;
        }
        return result;
    }

    public static Vector<Component> getAllFields(JPanel panel) {
        Vector<Component> v = new Vector<Component>();
        Component[] components = panel.getComponents();
        int i = 0;
        while (i < components.length) {
            if (components[i] instanceof JPanel) {
                v.addAll(PzSwingUtility.getAllFields((JPanel)components[i]));
            } else if (components[i] instanceof PzFieldImpl) {
                v.addElement(components[i]);
            }
            ++i;
        }
        return v;
    }

    public static void fillForm(JPanel panel, PzEntity entity) {
        try {
            Field[] fields = entity.getClass().getDeclaredFields();
            int i = 0;
            while (i < fields.length) {
                String fieldName = fields[i].getName();
                PzFieldImpl field = PzSwingUtility.getFieldByName(fieldName, panel);
                if (field != null) {
                    fields[i].setAccessible(true);
                    field.setVal(fields[i].get(entity));
                    fields[i].setAccessible(false);
                }
                ++i;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static PzFieldImpl getFieldByName(String name, JPanel panel) {
        PzFieldImpl result = null;
        Component[] components = panel.getComponents();
        int i = 0;
        while (i < components.length) {
            if (components[i] instanceof JPanel) {
                result = PzSwingUtility.getFieldByName(name, (JPanel)components[i]);
            } else if (components[i] instanceof PzFieldImpl && components[i].getName() != null && components[i].getName().equals(name)) {
                result = (PzFieldImpl)components[i];
            }
            ++i;
        }
        return result;
    }

    public static int daNeDijalog(Component komponenta, Object poruka, String naslov, Icon ikonica, boolean ne) {
        Object[] options = new Object[]{"Da", "Ne"};
        int rez = JOptionPane.showOptionDialog(komponenta, poruka, naslov, 0, 3, ikonica, options, ne ? options[1] : options[0]);
        return rez;
    }

    public static PzDialog getActiveDialog() {
        Window window = FocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (window instanceof PzDialog) {
            return (PzDialog)window;
        }
        return null;
    }

    public static JXLayer<JComponent> createLayer(JComponent component) {
        PzBusyPainterUI layerUI = new PzBusyPainterUI();
        return new JXLayer((Component)component, (LayerUI)layerUI);
    }
}

