/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.swing.fields;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.MaskFormatter;
import net.sourceforge.jtimepiece.JTimepiece;
import rs.pezar.core.format.PzFormatFactory;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.swing.fields.PzFieldImpl;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzDateUtility;

public class PzDateField
extends PzFieldImpl {
    private static final long serialVersionUID = 2795415680076367360L;
    private java.sql.Date defaultDate;
    private JTimepiece tp;

    public PzDateField() {
        MaskFormatter formatter = null;
        try {
            formatter = new MaskFormatter("##.##.####");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        DefaultFormatterFactory factory = new DefaultFormatterFactory(formatter, formatter, formatter);
        formatter.setAllowsInvalid(false);
        formatter.setCommitsOnValidEdit(false);
        this.setFormatterFactory(factory);
        this.setFocusLostBehavior(3);
        this.setHorizontalAlignment(0);
        this.setVal(PzDateUtility.getCurrentDate());
        this.setDefaultDate(PzDateUtility.getFirstDayOfCurrentYear());
        this.setVerifyInput(true);
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent arg0) {
                if (arg0.getPropertyName().equals("text")) {
                    PzDateField.this.firePropertyChange("val", PzDateField.this.getValStr((String)arg0.getOldValue()), PzDateField.this.getValStr((String)arg0.getNewValue()));
                }
            }
        });
    }

    public java.sql.Date getDefaultDate() {
        return this.defaultDate;
    }

    public void setDefaultDate(java.sql.Date date) {
        this.defaultDate = date;
    }

    public void setDefaultDate(String date) {
        String[] seq = date.split("\\.");
        this.defaultDate = java.sql.Date.valueOf(String.valueOf(seq[2]) + "-" + seq[1] + "-" + seq[0]);
    }

    @Override
    public java.sql.Date getVal() {
        try {
            if (this.getText().equals("  .  .    ")) {
                return PzDateUtility.getFirstDayOfCurrentYear();
            }
            String[] seq = this.getText().split("\\.");
            return java.sql.Date.valueOf(String.valueOf(seq[2]) + "-" + seq[1] + "-" + seq[0]);
        }
        catch (Exception exception) {
            return this.defaultDate;
        }
    }

    private java.sql.Date getValStr(String s) {
        try {
            if (s.equals("  .  .    ")) {
                return PzDateUtility.getFirstDayOfCurrentYear();
            }
            String[] seq = this.getText().split("\\.");
            return java.sql.Date.valueOf(String.valueOf(seq[2]) + "-" + seq[1] + "-" + seq[0]);
        }
        catch (Exception exception) {
            return this.defaultDate;
        }
    }

    public java.sql.Date getVal(String valueIfEmpty) {
        try {
            if (this.getText().equals("  .  .    ")) {
                String[] seq = valueIfEmpty.split("\\.");
                return java.sql.Date.valueOf(String.valueOf(seq[2]) + "-" + seq[1] + "-" + seq[0]);
            }
            return this.getVal();
        }
        catch (Exception exception) {
            return this.defaultDate;
        }
    }

    public Date getDate() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy");
        Date result = null;
        try {
            result = dateFormat.parse((String)this.getValue());
        }
        catch (ParseException parseException) {
            result = this.defaultDate;
        }
        return result;
    }

    @Override
    public void setVal(Object date) {
        if (date == null) {
            this.setValue(null);
        } else if (date instanceof java.sql.Date) {
            String[] seq = date.toString().split("-");
            this.setText(String.valueOf(seq[2]) + "." + seq[1] + "." + seq[0]);
        }
    }

    public void setVal(String date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            dateFormat.parse(date);
            String[] seq = date.split("-");
            this.setText(String.valueOf(seq[2]) + "." + seq[1] + "." + seq[0]);
        }
        catch (ParseException parseException) {
            this.setVal(this.defaultDate);
        }
    }

    @Override
    public boolean isValueValid() {
        if (this.getText().equals("  .  .    ")) {
            return true;
        }
        try {
            SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy");
            df.setLenient(false);
            df.parse(this.getText());
        }
        catch (ParseException parseException) {
            PzSwingUtility.showErrorMessage(this, "Datum nije validan! Molim, unesite validan datum da biste mogli da nastavite.");
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            PzSwingUtility.showErrorMessage(this, "Datum nije validan! Molim, unesite validan datum da biste mogli da nastavite.");
            return false;
        }
        if (this.getLimit() > -1) {
            this.tp = new JTimepiece();
            Date datelimit = this.tp.addDay((Date)PzDateUtility.getCurrentDate(), this.getLimit().intValue());
            if (this.tp.isAfter((Date)this.getVal(), datelimit)) {
                PzSwingUtility.showErrorMessage(this, "Nije vam dozvoljeno da radite sa izabranim datumom jer je u sistemu definisan limit od " + this.getLimit() + " dana.\nNajve\u0107i datum koji mo\u017eete uneti je " + PzFormatFactory.getDateFormat().format(datelimit));
                return false;
            }
        }
        return true;
    }

    public int getYear() {
        try {
            return Integer.parseInt(this.getText().substring(6, 10));
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public int getMonth() {
        try {
            return Integer.parseInt(this.getText().substring(3, 5));
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public int getDay() {
        try {
            return Integer.parseInt(this.getText().substring(0, 2));
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private Integer getLimit() {
        return PzParameter.getInteger("DATUM_LIMIT", new Integer(-1));
    }

    @Override
    protected void setStateOnInit() {
        this.setState(PzFieldIndikator.STATE_VALID);
    }
}

