/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.swing.custom.login.connections;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.custom.login.ConnConfTableModel;
import rs.pezar.swing.custom.login.PzConnection;
import rs.pezar.swing.custom.login.PzDialogConnectionsConfiguration;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzTextField;

public class DodavanjeConnConf
extends PzDialog {
    private static final long serialVersionUID = -4734471008231143192L;
    private JLabel jLabel3;
    private PzButton btnOk;
    private PzTextField tfBaza;
    private PzTextField tfServer;
    private PzTextField tfNaziv;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private PzPanel mainPanel;
    private ConnConfTableModel model = null;
    private boolean update = true;
    private PzFieldIndikator bazaIndikator;
    private PzFieldIndikator serverIndikator;
    private int selectedRow = -1;
    private PzFieldIndikator nazivIndikator;
    private PzDialogConnectionsConfiguration parent;

    public DodavanjeConnConf(ConnConfTableModel model, boolean update, PzConnection conn, PzDialogConnectionsConfiguration parent) {
        this.initGUI();
        this.update = update;
        this.model = model;
        this.parent = parent;
        if (update) {
            this.setTitle("Izmena konfiguracije");
            this.initFields(conn);
        } else {
            this.setTitle("Nova konfiguracija");
            if (conn != null) {
                this.initFields(conn);
            }
        }
    }

    private void initFields(PzConnection conn) {
        this.tfNaziv.setText(conn.getConnectionName());
        this.tfServer.setText(conn.getServer());
        this.tfBaza.setText(conn.getDatabase());
        this.mainPanel.updateAllFieldsState();
    }

    private void initGUI() {
        this.mainPanel = new PzPanel();
        this.mainPanel.setLayout(new BorderLayout());
        try {
            this.setContentPane(this.mainPanel);
            GridBagLayout thisLayout = new GridBagLayout();
            thisLayout.columnWidths = new int[]{100, 87, 96, 20};
            thisLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            thisLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.1};
            thisLayout.rowHeights = new int[]{10, 25, 25, 25, 20};
            this.mainPanel.setLayout(thisLayout);
            this.jLabel1 = new JLabel();
            this.mainPanel.add((Component)this.jLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.jLabel1.setText("Naziv konfiguracije");
            this.jLabel2 = new JLabel();
            this.mainPanel.add((Component)this.jLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.jLabel2.setText("Server");
            this.jLabel3 = new JLabel();
            this.mainPanel.add((Component)this.jLabel3, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.jLabel3.setText("Baza");
            this.tfNaziv = new PzTextField();
            this.mainPanel.add((Component)this.tfNaziv, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.tfNaziv.setVerifyInput(true);
            this.tfServer = new PzTextField();
            this.mainPanel.add((Component)this.tfServer, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.tfServer.setVerifyInput(true);
            this.tfBaza = new PzTextField();
            this.mainPanel.add((Component)this.tfBaza, new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.tfBaza.setVerifyInput(true);
            this.btnOk = new PzButton();
            this.mainPanel.add((Component)this.btnOk, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 11, 0, new Insets(2, 0, 0, 0), 0, 0));
            this.btnOk.setPreferredSize(new Dimension(100, 30));
            this.btnOk.setText("Potvrdi");
            this.btnOk.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/core/resource/img/check.png")));
            this.btnOk.addActionListener(this);
            this.nazivIndikator = new PzFieldIndikator();
            this.mainPanel.add((Component)this.nazivIndikator, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.serverIndikator = new PzFieldIndikator();
            this.mainPanel.add((Component)this.serverIndikator, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.bazaIndikator = new PzFieldIndikator();
            this.mainPanel.add((Component)this.bazaIndikator, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.tfNaziv.setStateIndikator(this.nazivIndikator);
            this.tfServer.setStateIndikator(this.serverIndikator);
            this.tfBaza.setStateIndikator(this.bazaIndikator);
            this.pack();
            this.setResizable(false);
            this.setLocationRelativeTo(this.getParent());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle(this, e);
        }
    }

    public void setSelectedRow(int selectedRow) {
        this.selectedRow = selectedRow;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (!this.mainPanel.validateForm(true)) {
                return;
            }
            PzConnection conn = new PzConnection(this.tfNaziv.getText(), this.tfServer.getText(), this.tfBaza.getText());
            if (this.update) {
                int indeks = this.model.containsElement(conn);
                if (this.selectedRow != indeks && indeks != -1) {
                    JOptionPane.showMessageDialog(null, "Postoji konfiguracija sa unetim nazivom. Morate uneti drugi naziv!", "Gre\u0161ka", 0);
                    return;
                }
                this.model.setElementAt(this.selectedRow, conn);
            } else {
                if (this.model.containsElement(conn) != -1) {
                    JOptionPane.showMessageDialog(null, "Postoji konfiguracija sa unetim nazivom. Morate uneti drugi naziv!", "Gre\u0161ka", 0);
                    return;
                }
                this.model.insertElement(conn);
            }
            this.parent.setElementForSelection(conn);
            this.dispose();
        }
        catch (Exception e1) {
            PzMysqlExceptionHandler.handle(this, e1);
        }
    }

    public static Object getGUIBuilderInstance() {
        return new DodavanjeConnConf(Boolean.FALSE);
    }

    public DodavanjeConnConf(Boolean initGUI) {
    }

    @Override
    protected void thisWindowClosing(WindowEvent evt) {
        this.setVisible(false);
    }
}

