/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.swing.custom;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.table.AbstractTableModel;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzTaksaDokument;
import rs.pezar.db.entity.Tarifnagrupa;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.custom.PzDialogPorez;
import rs.pezar.swing.data.models.PzTableModel;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;

public class PzTablePorez
extends PzTable {
    private static final long serialVersionUID = -2696478378874710857L;
    private Vector<PzTaksaDokument> takse;
    private Class<? extends PzTaksaDokument> type;
    private PzTableModel model;
    private Class<? extends PzDialogPorez> dialogClass;
    private String tip = "";
    private HashMap<String, Object> parameters;

    public void setType(Class<? extends PzTaksaDokument> t) {
        this.type = t;
    }

    public void setDialogClass(Class<? extends PzDialogPorez> c) {
        this.dialogClass = c;
    }

    public PzTablePorez(Class<? extends PzTaksaDokument> type, Class<? extends PzDialogPorez> dialogClass, boolean inicijalizujPoreze) {
        this.type = type;
        this.dialogClass = dialogClass;
        try {
            if (inicijalizujPoreze) {
                if (type != null) {
                    this.init();
                }
            } else {
                this.takse = new Vector();
                this.model = new PzTableModel(this.takse, type);
                this.setModel(this.model);
            }
        }
        catch (Exception exception) {}
    }

    public void setParameters(HashMap<String, Object> parameters) {
        this.parameters = parameters;
    }

    public void init() throws Exception {
        super.initGUI();
        Vector<PzEntity> data = PzEntityManager.select("SELECT t FROM Tarifnagrupa t ORDER BY t.sfrTarGr");
        this.takse = new Vector();
        for (PzEntity entity : data) {
            Tarifnagrupa tg = (Tarifnagrupa)entity;
            PzTaksaDokument td = this.type.newInstance();
            td.setTarifnagrupa(tg);
            td.setId(tg.getOznTarGr(), 0, this.tip);
            td.setVrsta(tg.getVrstatg().getOznVrstaTG());
            this.takse.addElement(td);
        }
        PzTableModel model = new PzTableModel(this.takse, this.type);
        this.setModel(model);
        this.model = model;
        final PzTablePorez instance = this;
        this.getActionMap().put("ENTER", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (PzTablePorez.this.dialogClass != null) {
                        PzDialogPorez dialogTaksa = (PzDialogPorez)PzTablePorez.this.dialogClass.newInstance();
                        dialogTaksa.passParameters(PzTablePorez.this.parameters);
                        dialogTaksa.passSelectedPorez((PzTaksaDokument)PzTablePorez.this.getSelectedEntity());
                        dialogTaksa.setModal(true);
                        dialogTaksa.setLocationRelativeTo((Component)((Object)instance));
                        dialogTaksa.setVisible(true);
                        if (dialogTaksa.userConfirmed()) {
                            dialogTaksa.modifyPorez();
                        }
                        ((AbstractTableModel)instance.getModel()).fireTableRowsUpdated(PzTablePorez.this.getSelectedRow(), PzTablePorez.this.getSelectedRow());
                        PzTablePorez.this.calculateFields();
                    }
                }
                catch (Exception e1) {
                    PzMysqlExceptionHandler.handle(e1);
                }
            }
        });
    }

    public List<? extends PzTaksaDokument> getPorezi() {
        ArrayList<PzTaksaDokument> porezi = new ArrayList<PzTaksaDokument>();
        PzTaksaDokument taksaDokument = null;
        int i = 0;
        while (i < this.takse.size()) {
            taksaDokument = this.takse.get(i);
            if (taksaDokument.getOsnovica() != null && taksaDokument.getOsnovica().doubleValue() != 0.0 || taksaDokument.getIznos() != null && taksaDokument.getIznos().doubleValue() != 0.0) {
                porezi.add(taksaDokument);
            }
            ++i;
        }
        return porezi;
    }

    public void addPorezi(List<? extends PzTaksaDokument> v, boolean sumirajIste) {
        PzTaksaDokument taksaDokument = null;
        int i = 0;
        while (i < v.size()) {
            taksaDokument = v.get(i);
            boolean found = false;
            int j = 0;
            while (j < this.takse.size()) {
                PzTaksaDokument tDoc = this.takse.elementAt(j);
                if (tDoc.getTarifnagrupa().getSfrTarGr().equals(taksaDokument.getTarifnagrupa().getSfrTarGr())) {
                    if (sumirajIste) {
                        this.takse.get(j).setIznos(this.takse.get(j).getIznos().add(taksaDokument.getIznos()));
                        this.takse.get(j).setOsnovica(this.takse.get(j).getOsnovica().add(taksaDokument.getOsnovica()));
                    } else {
                        this.takse.set(j, taksaDokument);
                    }
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                this.takse.add(taksaDokument);
            }
            ++i;
        }
        this.model.fireTableDataChanged();
        this.calculateFields();
    }

    public void setPorezi(List<? extends PzTaksaDokument> v, boolean sumirajIste) {
        this.resetPorezi();
        this.addPorezi(v, sumirajIste);
    }

    public void resetPorezi() {
        for (PzTaksaDokument taksa : this.takse) {
            taksa.setIznos(new BigDecimal("0"));
            taksa.setOsnovica(new BigDecimal("0"));
        }
        this.calculateFields();
    }

    public String getTip() {
        return this.tip;
    }

    public void setTip(String tip) {
        this.tip = tip;
    }

    @Override
    public void clear() {
        this.takse.clear();
        this.model.fireTableDataChanged();
    }
}

