/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.swing.custom;

import com.cloudgarden.layout.AnchorConstraint;
import com.cloudgarden.layout.AnchorLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import rs.pezar.db.PzTaksaDokument;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.custom.PzDialogPorez;
import rs.pezar.swing.fields.PzDoubleField;

public class PzDialogMaloprodajaPorezIznos
extends PzDialogPorez {
    private PzPanelHeader header;
    private PzPanel panel;
    private PzDoubleField tfIznosSaPdv;
    private JLabel jLabel3;
    private PzButton btnOK;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private PzDoubleField iznos;
    private PzDoubleField osnovica;

    public PzDialogMaloprodajaPorezIznos() {
        this.initGUI();
    }

    @Override
    public void passSelectedPorez(PzTaksaDokument porez) throws Exception {
        if (porez.getIznos() == null) {
            return;
        }
        super.passSelectedPorez(porez);
        this.iznos.setVal(porez.getIznos());
        this.osnovica.setVal(porez.getOsnovica());
        this.tfIznosSaPdv.setVal(porez.getIznos().add(porez.getOsnovica()));
    }

    @Override
    public void modifyPorez() {
        this.getSelectedPorez().setIznos(this.iznos.getBigDecimal());
        this.getSelectedPorez().setOsnovica(this.osnovica.getBigDecimal());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.confirmChanges();
    }

    protected void initGUI() {
        try {
            this.setResizable(false);
            this.header = new PzPanelHeader();
            this.header.setTitle("Unos poreza");
            this.getContentPane().add((Component)this.header, "North");
            this.header.setBounds(0, 0, 357, 63);
            this.panel = new PzPanel();
            AnchorLayout panelLayout = new AnchorLayout();
            this.panel.setLayout(panelLayout);
            this.getContentPane().add((Component)this.panel, "Center");
            this.panel.setBounds(0, 60, 357, 205);
            this.tfIznosSaPdv = new PzDoubleField();
            this.panel.add((Component)this.tfIznosSaPdv, new AnchorConstraint(56, 780, 202, 483, 1, 1, 1, 1));
            this.tfIznosSaPdv.setPreferredSize(new Dimension(106, 30));
            this.tfIznosSaPdv.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent evt) {
                    PzDialogMaloprodajaPorezIznos.this.porezKeyPressed(evt);
                }
            });
            this.jLabel3 = new JLabel();
            this.panel.add((Component)this.jLabel3, new AnchorConstraint(56, 483, 197, 186, 1, 1, 1, 1));
            this.jLabel3.setText("Iznos sa PDV-om");
            this.jLabel3.setPreferredSize(new Dimension(106, 29));
            this.btnOK = new PzButton();
            this.panel.add((Component)this.btnOK, new AnchorConstraint(665, 785, 841, 483, 1, 1, 1, 1));
            this.btnOK.setText("Potvrdi");
            this.btnOK.setPreferredSize(new Dimension(108, 36));
            this.btnOK.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/core/resource/img/check.png")));
            this.btnOK.addActionListener(this);
            this.jLabel2 = new JLabel();
            this.panel.add((Component)this.jLabel2, new AnchorConstraint(431, 483, 573, 186, 1, 1, 1, 1));
            this.jLabel2.setText("Iznos:");
            this.jLabel2.setPreferredSize(new Dimension(106, 29));
            this.jLabel1 = new JLabel();
            this.panel.add((Component)this.jLabel1, new AnchorConstraint(256, 483, 397, 186, 1, 1, 1, 1));
            this.jLabel1.setText("Osnovica:");
            this.jLabel1.setPreferredSize(new Dimension(106, 29));
            this.iznos = new PzDoubleField();
            this.panel.add((Component)this.iznos, new AnchorConstraint(436, 785, 582, 483, 1, 1, 1, 1));
            this.iznos.setPreferredSize(new Dimension(108, 30));
            this.osnovica = new PzDoubleField();
            this.panel.add((Component)this.osnovica, new AnchorConstraint(251, 785, 397, 483, 1, 1, 1, 1));
            this.osnovica.setPreferredSize(new Dimension(108, 30));
            this.pack();
            this.setSize(365, 300);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void porezKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.osnovica.setVal(100.0 * this.tfIznosSaPdv.getVal() / (Double.valueOf(this.getSelectedPorez().getTarifnagrupa().getStopa()) + 100.0));
            this.iznos.setVal(this.tfIznosSaPdv.getVal() - this.osnovica.getVal());
            this.btnOK.requestFocus();
        }
    }

    @Override
    protected void thisWindowClosing(WindowEvent evt) {
    }
}

