/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JMenuBar;
import rs.pezar.core.gui.menu.PzMenuPermissions;
import rs.pezar.swing.PzMenu;
import rs.pezar.swing.PzMenuItem;
import rs.pezar.swing.PzWorkbench;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;

public class PzMenuBar
extends JMenuBar
implements ActionListener {
    private static final long serialVersionUID = 1761933058472624534L;
    private List<PzMenu> menus;
    private PzWorkbench workbench;

    public PzMenuBar(PzWorkbench wb) {
        this.workbench = wb;
        this.menus = new Vector<PzMenu>();
    }

    public void addMenu(PzMenu menu) throws Exception {
        if (this.getMenuById(menu.getId()) != null) {
            throw new IllegalArgumentException("Can't insert menu with id " + menu.getId() + ", because menu with the same id already exists.");
        }
        if (menu.getItems() != null && menu.getItems().size() > 0) {
            for (PzMenuItem item : menu.getItems()) {
                item.addActionListener(this);
            }
        }
        this.menus.add(menu);
        this.add(menu);
    }

    public PzMenu getMenuById(String id) {
        PzMenu menu = null;
        for (PzMenu m : this.menus) {
            if (!m.getId().equals(id)) continue;
            menu = m;
            break;
        }
        return menu;
    }

    public void merge(PzMenu menu) throws Exception {
        PzMenu menu1 = this.getMenuById(menu.getId());
        if (menu1 != null) {
            for (PzMenuItem item : menu.getItems()) {
                if (!PzMenuPermissions.itemValidPermission(item)) continue;
                menu1.insert(item, (int)item.getId());
                item.addActionListener(this);
            }
        } else {
            this.addMenu(menu);
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        PzMenuItem item = (PzMenuItem)arg0.getSource();
        if (item.getDialogClass() != null) {
            this.workbench.showDialog(item.getDialogClass(), null);
        } else if (item.getActionClass() != null) {
            try {
                item.getActionClass().newInstance().actionPerformed(null);
            }
            catch (Exception e) {
                PzMysqlExceptionHandler.handle(this, e);
            }
        }
    }
}

