/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.swing;

import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import rs.pezar.swing.PzMenuItem;

public class PzMenu
extends JMenu
implements Comparable {
    private static final long serialVersionUID = 343100527879697593L;
    private ImageIcon icon;
    private String text;
    private String id;
    private Vector<PzMenuItem> items;

    public PzMenu() {
    }

    public Vector<PzMenuItem> getItems() {
        return this.items;
    }

    public PzMenu(Node node, ClassLoader loader) throws DOMException, ClassNotFoundException {
        this();
        Node idNode = node.getAttributes().getNamedItem("id");
        if (node.getAttributes().getNamedItem("icon") != null) {
            this.setIcon(new ImageIcon(loader.getResource(node.getAttributes().getNamedItem("icon").getNodeValue())));
        }
        if (node.getAttributes().getNamedItem("text") != null) {
            this.setText(node.getAttributes().getNamedItem("text").getNodeValue());
        }
        if (idNode != null) {
            this.setId(idNode.getNodeValue());
        }
        if (node.hasChildNodes()) {
            this.items = new Vector();
            PzMenuItem item = null;
            int i = 0;
            while (i < node.getChildNodes().getLength()) {
                item = new PzMenuItem(node.getChildNodes().item(i), loader);
                this.items.addElement(item);
                this.insert(item, i);
                ++i;
            }
        }
    }

    @Override
    public ImageIcon getIcon() {
        return this.icon;
    }

    public void setIcon(ImageIcon icon) {
        super.setIcon(icon);
        this.icon = icon;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setText(String label) {
        this.text = label;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int compareTo(Object arg0) {
        return this.getId().compareTo(((PzMenu)arg0).getId());
    }
}

