/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.swing;

import com.cloudgarden.layout.AnchorConstraint;
import com.cloudgarden.layout.AnchorLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzManageableTable;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzScrollableTableEntity;
import rs.pezar.swing.PzTable;

public class PzGenericTableDialog
extends PzDialog {
    private static final long serialVersionUID = 726551917242014098L;
    private JScrollPane scp;
    private PzButton btnOK;
    private PzPanel pnlContent;
    private PzPanelHeader header;
    private Object source;
    private PzManageableTable table;
    private Class<?> entityClass;
    private int checkBoxColumn;
    private PzEntityFilter filter;
    private static PzEntity selectedEntity;
    private static List<PzEntity> selectedEntities;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzGenericTableDialog inst = new PzGenericTableDialog(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzGenericTableDialog(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public PzGenericTableDialog(PzDialog parent, Object source, Class<?> type, int checkBoxColumn, PzEntityFilter filter) {
        super(parent);
        this.setId(String.valueOf(parent.getClass().getName()) + this.getClass().getName());
        this.source = source;
        this.entityClass = type;
        this.filter = filter;
        this.initGUI();
        this.checkBoxColumn = checkBoxColumn;
        this.instantiateTable();
    }

    private void initGUI() {
        try {
            this.pnlContent = new PzPanel();
            AnchorLayout pnlContentLayout = new AnchorLayout();
            this.pnlContent.setLayout(pnlContentLayout);
            this.getContentPane().add((Component)this.pnlContent, "Center");
            this.btnOK = new PzButton();
            this.pnlContent.add((Component)this.btnOK, new AnchorConstraint(842, 11, 11, 812, 0, 2, 2, 0));
            this.btnOK.setPreferredSize(new Dimension(135, 39));
            this.btnOK.setName("btnOK");
            this.btnOK.setAction(this.getAppActionMap().get((Object)"akcija"));
            this.header = new PzPanelHeader();
            this.header.setName("header");
            this.getContentPane().add((Component)this.header, "North");
            this.setSize(782, 416);
            Application.getInstance().getContext().getResourceMap(this.getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void instantiateTable() {
        if (this.source == null) {
            return;
        }
        if (this.source instanceof List) {
            this.table = new PzTable();
            this.table.setFilter(this.filter);
            this.table.setId(this.entityClass.getName());
            ((PzTable)this.table).setData((List)this.source, this.entityClass);
        } else if (this.source instanceof ScrollableCursor) {
            this.table = new PzScrollableTableEntity(this.entityClass);
            this.table.setFilter(this.filter);
            ((PzScrollableTableEntity)this.table).read((ScrollableCursor)this.source);
        }
        this.table.setEnterAction(new AbstractAction(){
            private static final long serialVersionUID = 833766127922040169L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                selectedEntity = PzGenericTableDialog.this.table.getSelectedEntity();
                selectedEntities = PzGenericTableDialog.this.table.getCheckedEntities();
                PzGenericTableDialog.this.dispose();
            }
        });
        if (this.checkBoxColumn != -1) {
            this.table.setCheckboxColumn(0);
        }
        if (this.table.getRowCount() > 0) {
            this.table.setRowSelectionInterval(0, 0);
            this.table.checkAll();
        }
        this.scp = new JScrollPane();
        this.scp.setViewportView((Component)((Object)this.table));
        this.scp.setPreferredSize(new Dimension(750, 240));
        this.pnlContent.add((Component)this.scp, new AnchorConstraint(12, 12, 62, 12, 2, 2, 2, 2));
    }

    public static PzEntity showDialog(PzDialog parent, Class<?> type, List<?> list, String title, String text, PzEntityFilter filter) {
        PzGenericTableDialog dlg = new PzGenericTableDialog(parent, list, type, -1, filter);
        dlg.setHeaderTitle(title, text);
        dlg.setModal(true);
        dlg.setLocationRelativeTo(parent);
        dlg.setId(type.getName());
        dlg.restoreSize();
        dlg.setVisible(true);
        PzEntity selectedEntity = PzGenericTableDialog.selectedEntity;
        PzGenericTableDialog.selectedEntity = null;
        selectedEntities = null;
        return selectedEntity;
    }

    public static List<PzEntity> showDialog(PzDialog parent, Class<?> type, List<?> list, String title, String text, int checkBoxColumn, PzEntityFilter filter) {
        PzGenericTableDialog dlg = new PzGenericTableDialog(parent, list, type, checkBoxColumn, filter);
        dlg.setHeaderTitle(title, text);
        dlg.setModal(true);
        dlg.setLocationRelativeTo(parent);
        dlg.setId(String.valueOf(type.getName()) + "_checkbox");
        dlg.restoreSize();
        dlg.setVisible(true);
        List<PzEntity> selectedEntities = PzGenericTableDialog.selectedEntities;
        selectedEntity = null;
        PzGenericTableDialog.selectedEntities = null;
        return selectedEntities;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Action
    public void akcija() {
        selectedEntity = this.table.getSelectedEntity();
        selectedEntities = this.table.getCheckedEntities();
        this.dispose();
    }

    private ApplicationActionMap getAppActionMap() {
        return Application.getInstance().getContext().getActionMap((Object)this);
    }

    private void setHeaderTitle(String title, String subtitle) {
        this.header.setTitle(title);
        this.header.setText(subtitle);
    }

    static /* synthetic */ PzEntity access$0() {
        return selectedEntity;
    }

    static /* synthetic */ List access$3() {
        return selectedEntities;
    }
}

