/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import rs.pezar.db.PzEntity;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Stanjeartikal;
import rs.pezar.db.entity.StavkaporudzbinePK;

@Entity
@Table(name="stavkaporudzbine")
public class Stavkaporudzbine
implements Serializable,
PzEntity {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private StavkaporudzbinePK id;
    @Column(nullable=false, precision=20, scale=2)
    private BigDecimal cenaPorucena = new BigDecimal("0.0");
    @Column(precision=20, scale=3)
    private BigDecimal kolKons = new BigDecimal("0.0");
    @Column(nullable=false, precision=20, scale=3)
    private BigDecimal kolPorucena = new BigDecimal("0.0");
    @Transient
    private BigDecimal rabat = new BigDecimal("0.0");
    @Column(length=5)
    private String kons;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="idDok", nullable=false, insertable=false, updatable=false)
    private Faktura faktura;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="oznOgranak", referencedColumnName="OZNOGRANAK"), @JoinColumn(name="oznRj", referencedColumnName="OZNRJ"), @JoinColumn(name="sfrProizvod", referencedColumnName="SFRPROIZVOD")})
    private Stanjeartikal stanjeartikal;

    public StavkaporudzbinePK getId() {
        return this.id;
    }

    public void setId(StavkaporudzbinePK id) {
        this.id = id;
    }

    public BigDecimal getCenaPorucena() {
        return this.cenaPorucena;
    }

    public void setCenaPorucena(BigDecimal cenaporucena) {
        this.cenaPorucena = cenaporucena;
    }

    public BigDecimal getKolKons() {
        return this.kolKons;
    }

    public void setKolKons(BigDecimal kolkons) {
        this.kolKons = kolkons;
    }

    public BigDecimal getRabat() {
        return this.rabat;
    }

    public void setRabat(BigDecimal rabat) {
        this.rabat = rabat;
    }

    public BigDecimal getKolPorucena() {
        return this.kolPorucena;
    }

    public void setKolPorucena(BigDecimal kolporucena) {
        this.kolPorucena = kolporucena;
    }

    public String getKons() {
        return this.kons;
    }

    public void setKons(String kons) {
        this.kons = kons;
    }

    public Faktura getFaktura() {
        return this.faktura;
    }

    public void setFaktura(Faktura faktura) {
        this.faktura = faktura;
    }

    public Stanjeartikal getStanjeartikal() {
        return this.stanjeartikal;
    }

    public void setStanjeartikal(Stanjeartikal stanjeartikal) {
        this.stanjeartikal = stanjeartikal;
    }

    @Override
    public Object[] getValues() {
        int cenaIsta = this.stanjeartikal.getProdCena() == this.cenaPorucena.doubleValue() ? 1 : 0;
        double raspKolMagacin = this.stanjeartikal.getKolicina() - this.stanjeartikal.getAlocKolicina();
        double raspKolUkupno = raspKolMagacin + this.stanjeartikal.getKonsKolicina() - this.stanjeartikal.getKonsAlocirana();
        return new Object[]{new Integer(this.getKolIndikator()), this.getStanjeartikal().getId().getSfrProizvod(), this.getStanjeartikal().getNaziv(), this.getKolPorucena(), raspKolUkupno, raspKolMagacin, new Integer(cenaIsta), this.getCenaPorucena(), this.stanjeartikal.getProdCena(), this.getKons(), this.getKolKons()};
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{"", "\u0160ifra", "Naziv", "<html>Poru\u010dena<br>koli\u010dina</html>", "<html>Ukupna rasp.<br>koli\u010dina</html>", "<html>Koli\u010dina<br>u magacinu</html>", "", "<html>Cena sa<br>porud\u017ebine</html>", "<html>Cena u<br>magacinu</html>", "Kons", "Kol->kons"};
    }

    public int getKolIndikator() {
        double raspKolicina;
        int imaKolicine = -1;
        double d = raspKolicina = this.stanjeartikal.getRaspKolicina() + this.kolPorucena.doubleValue() > 0.0 ? this.stanjeartikal.getRaspKolicina() + this.kolPorucena.doubleValue() : 0.0;
        if (raspKolicina + this.kolKons.doubleValue() - this.kolPorucena.doubleValue() >= 0.0) {
            imaKolicine = 1;
        } else if (raspKolicina + this.stanjeartikal.getKonsKolicina() - this.kolPorucena.doubleValue() >= 0.0) {
            imaKolicine = 0;
        }
        return imaKolicine;
    }
}

