/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import javax.persistence.Embeddable;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.entity.Interniracun;
import rs.pezar.db.entity.Konto;
import rs.pezar.db.entity.KontoPK;
import rs.pezar.db.entity.Stavkasheme;

@Embeddable
public class StavkanzkPK
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String oznKonto;
    private String analitika;
    private Integer idNalog;
    private Integer rBroj;

    public StavkanzkPK() {
    }

    public StavkanzkPK(String oznKonto, String analitika) {
        this.oznKonto = oznKonto;
        this.analitika = analitika;
    }

    public StavkanzkPK(String oznKonto, String analitika, Integer idNalog, Integer rBroj) {
        this.oznKonto = oznKonto;
        this.analitika = analitika;
        this.idNalog = idNalog;
        this.rBroj = rBroj;
    }

    public StavkanzkPK(Stavkasheme stavka, PzDokument dokument) {
        this.oznKonto = stavka.getOznKonto();
        if ("K".equals(stavka.getTipAnalitike()) && dokument.getKomitent() != null) {
            this.analitika = dokument.getKomitent().getSfrKomitent();
        }
        if ("R".equals(stavka.getTipAnalitike())) {
            if ("W".equals(stavka.getIndikator()) && dokument instanceof Interniracun) {
                this.analitika = ((Interniracun)dokument).getIzlaznaRJ().getId().getOznRj();
            } else if ("Q".equals(stavka.getIndikator()) && dokument instanceof Interniracun) {
                this.analitika = ((Interniracun)dokument).getUlaznaRJ().getId().getOznRj();
            } else if (dokument.getRadnajedinica() != null) {
                this.analitika = String.valueOf(PzEntityUtil.strZero(dokument.getRadnajedinica().getId().getOznRj(), 3)) + dokument.getRadnajedinica().getgTip();
                try {
                    KontoPK id = new KontoPK(this.oznKonto, this.analitika);
                    Konto k = (Konto)PzEntityManager.find(Konto.class, id);
                    if (k == null) {
                        k = new Konto(this.oznKonto, this.analitika, "", "");
                        PzEntityManager.insert(k);
                    }
                }
                catch (Exception exception) {}
            } else {
                this.analitika = "";
            }
        } else {
            this.analitika = "";
        }
    }

    public String getOznKonto() {
        return this.oznKonto;
    }

    public void setOznKonto(String oznkonto) {
        this.oznKonto = oznkonto;
    }

    public String getAnalitika() {
        return this.analitika;
    }

    public void setAnalitika(String analitika) {
        this.analitika = analitika;
    }

    public Integer getIdNalog() {
        return this.idNalog;
    }

    public void setIdNalog(Integer idnalog) {
        this.idNalog = idnalog;
    }

    public Integer getrBroj() {
        return this.rBroj;
    }

    public void setrBroj(Integer rBroj) {
        this.rBroj = rBroj;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StavkanzkPK)) {
            return false;
        }
        StavkanzkPK castOther = (StavkanzkPK)other;
        return this.oznKonto.equals(castOther.oznKonto) && this.analitika.equals(castOther.analitika) && this.idNalog.equals(castOther.idNalog) && this.rBroj.equals(castOther.idNalog);
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + this.oznKonto.hashCode();
        hash = hash * 31 + this.analitika.hashCode();
        hash = hash * 31 + this.idNalog.hashCode();
        hash = hash * 31 + this.rBroj.hashCode();
        return hash;
    }
}

