/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.eclipse.persistence.indirection.IndirectList;
import rs.pezar.db.PzADTaksa;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzUslugaDokument;
import rs.pezar.db.entity.Fakturausluga;
import rs.pezar.db.entity.Sfutaksa;
import rs.pezar.db.entity.StavkafaktureuslPK;
import rs.pezar.db.entity.Tarifnagrupa;
import rs.pezar.db.entity.Usluga;

@Entity
@Table(name="StavkaFaktureUsl")
public class Stavkafaktureusl
extends PzUslugaDokument
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private StavkafaktureuslPK id;
    @Column(nullable=false)
    private double cena;
    private BigDecimal kolicina;
    @Column(nullable=false, length=255)
    private String naziv;
    private int sort;
    @OneToMany(mappedBy="stavkafaktureusl", cascade={CascadeType.ALL})
    private List<Sfutaksa> sfutaksas;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="sfrProizvod")
    private Usluga usluga;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="idDok", nullable=false, insertable=false, updatable=false)
    private Fakturausluga fakturausluga;

    @Override
    public StavkafaktureuslPK getId() {
        return this.id;
    }

    public void setId(StavkafaktureuslPK id) {
        this.id = id;
    }

    public String getBliziOpis() {
        return "";
    }

    public void setBliziOpis(String bliziOpis) {
    }

    @Override
    public double getCena() {
        return this.cena;
    }

    @Override
    public void setCena(double cena) {
        this.cena = cena;
    }

    public String getNaziv1() {
        return this.naziv;
    }

    public void setNaziv1(String naziv) {
        this.naziv = naziv;
    }

    public List<Sfutaksa> getSfutaksas() {
        return this.sfutaksas;
    }

    public void setSfutaksas(List<Sfutaksa> sfutaksas) {
        this.sfutaksas = sfutaksas;
    }

    @Override
    public Usluga getUsluga() {
        return this.usluga;
    }

    @Override
    public void setUsluga(Usluga usluga) {
        this.usluga = usluga;
    }

    public Fakturausluga getFakturausluga() {
        return this.fakturausluga;
    }

    public void setFakturausluga(Fakturausluga fakturausluga) {
        this.fakturausluga = fakturausluga;
    }

    @Override
    public double getKolicina() {
        return this.kolicina.doubleValue();
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{"\u0160ifra usluge", "TGR", "Cena", "Naziv usluge"};
    }

    @Override
    public Object[] getValues() {
        return new Object[]{this.getUsluga().getSfrProizvod(), this.getUsluga().getTarifnaGrupa("PDV").getOznTarGr(), this.getCena(), this.getNaziv1()};
    }

    @Override
    public String getNaziv() {
        return this.naziv;
    }

    @Override
    public void setNaziv(String naziv) {
        this.naziv = naziv;
    }

    @Override
    public PzDokument getDokument() {
        return this.getFakturausluga();
    }

    @Override
    public double getProcRabata() {
        return 0.0;
    }

    @Override
    public void setDokument(PzDokument dokument) {
        this.fakturausluga = (Fakturausluga)dokument;
    }

    @Override
    public void addTaksa(Tarifnagrupa tgr) {
        if (this.sfutaksas == null) {
            this.sfutaksas = new IndirectList();
        }
        this.sfutaksas.add(new Sfutaksa(this, tgr));
    }

    @Override
    public void setId(int dokId, int rBroj) {
        this.id = new StavkafaktureuslPK(dokId, rBroj);
    }

    @Override
    public void setKolicina(double kolicina) {
        this.kolicina = new BigDecimal(kolicina).setScale(3, 4);
    }

    @Override
    public void setProcRabata(double procRabata) {
    }

    @Override
    public List<? extends PzADTaksa> getTaksas() {
        return this.sfutaksas;
    }

    @Override
    public double getBrNormaSati() {
        return 0.0;
    }

    @Override
    public void setBrNormaSati(double arg) {
    }

    @Override
    public int getSort() {
        return this.sort;
    }

    @Override
    public void setSort(int sort) {
        this.sort = sort;
    }

    public void setKolicina(BigDecimal kolicina) {
        this.kolicina = kolicina;
    }
}

