/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Version;
import rs.pezar.core.PzApplication;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.PzEntity;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Osobinaartikla;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.StanjePK;

@Entity
@Table(name="Stanje")
public class Stanje
implements Serializable,
PzEntity {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private StanjePK id;
    @Column(nullable=false)
    private double alocKolicina;
    @Column(nullable=false)
    private double cenaNaPS;
    private Date datZadIzlaza;
    private Date datZadUlaza;
    private Date datPop;
    @Column(nullable=false)
    private double kolPop;
    @Column(nullable=false)
    private double kolicina;
    @Column(nullable=false)
    private double kumIzlaza;
    @Column(nullable=false)
    private double kumProdaje;
    @Column(nullable=false)
    private double kumUlaza;
    @Column(nullable=false, length=1)
    private String nivo;
    @Column(nullable=false, length=1)
    private String paleta;
    @Column(nullable=false)
    private double pocStanje;
    @Column(nullable=false)
    private double prodCena;
    @Column(nullable=false)
    private BigDecimal prosNabCena = new BigDecimal("0");
    @Column(nullable=false, length=1)
    private String stalaza;
    @Column(nullable=false)
    private double zadNabCena;
    @Version
    private int version;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="oznOgranak", referencedColumnName="OZNOGRANAK", nullable=false, insertable=false, updatable=false), @JoinColumn(name="oznRj", referencedColumnName="OZNRJ", nullable=false, insertable=false, updatable=false)})
    private Radnajedinica radnajedinica;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="sfrProizvod", nullable=false, insertable=false, updatable=false)
    private Artikal artikal;
    @OneToMany(mappedBy="stanje", fetch=FetchType.LAZY)
    private List<Osobinaartikla> osobinaartiklas;

    public double getRaspolozivaKolicina() {
        return this.kolicina - this.alocKolicina;
    }

    public StanjePK getId() {
        return this.id;
    }

    public void setId(StanjePK id) {
        this.id = id;
    }

    public double getAlocKolicina() {
        return this.alocKolicina;
    }

    public void setAlocKolicina(double alocKolicina) {
        this.alocKolicina = BDConverter.getKolicina(alocKolicina).doubleValue();
    }

    public double getCenaNaPS() {
        return this.cenaNaPS;
    }

    public void setCenaNaPS(double cenaNaPS) {
        this.cenaNaPS = BDConverter.getProdCena(cenaNaPS).doubleValue();
    }

    public Date getDatZadIzlaza() {
        return this.datZadIzlaza;
    }

    public void setDatZadIzlaza(Date datZadIzlaza) {
        this.datZadIzlaza = datZadIzlaza;
    }

    public Date getDatZadUlaza() {
        return this.datZadUlaza;
    }

    public void setDatZadUlaza(Date datZadUlaza) {
        this.datZadUlaza = datZadUlaza;
    }

    public double getKolicina() {
        return this.kolicina;
    }

    public void setKolicina(double kolicina) {
        this.kolicina = BDConverter.getKolicina(kolicina).doubleValue();
    }

    public double getKumIzlaza() {
        return this.kumIzlaza;
    }

    public void setKumIzlaza(double kumIzlaza) {
        this.kumIzlaza = BDConverter.getKolicina(kumIzlaza).doubleValue();
    }

    public double getKumUlaza() {
        return this.kumUlaza;
    }

    public void setKumUlaza(double kumUlaza) {
        this.kumUlaza = BDConverter.getKolicina(kumUlaza).doubleValue();
    }

    public double getKumProdaje() {
        return this.kumProdaje;
    }

    public void setKumProdaje(double kumProdaje) {
        this.kumProdaje = kumProdaje;
    }

    public String getNivo() {
        return this.nivo;
    }

    public void setNivo(String nivo) {
        this.nivo = nivo;
    }

    public String getPaleta() {
        return this.paleta;
    }

    public void setPaleta(String paleta) {
        this.paleta = paleta;
    }

    public double getProdCena() {
        return this.prodCena;
    }

    public void setProdCena(double prodCena) {
        this.prodCena = BDConverter.getProdCena(prodCena).doubleValue();
    }

    public BigDecimal getProsNabCena() {
        return this.prosNabCena;
    }

    public void setProsNabCena(BigDecimal prosNabCena) {
        this.prosNabCena = prosNabCena;
    }

    public String getStalaza() {
        return this.stalaza;
    }

    public void setStalaza(String stalaza) {
        this.stalaza = stalaza;
    }

    public double getZadNabCena() {
        return this.zadNabCena;
    }

    public void setZadNabCena(double zadNabCena) {
        this.zadNabCena = zadNabCena;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getVersion() {
        return this.version;
    }

    public Radnajedinica getRadnajedinica() {
        return this.radnajedinica;
    }

    public void setRadnajedinica(Radnajedinica radnajedinica) {
        this.radnajedinica = radnajedinica;
    }

    public void setArtikal(Artikal artikal) {
        this.artikal = artikal;
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{"RJ", "Koli\u010dina", "Alocirana", "Raspolo\u017eiva", "Prod. cena", "Kum. ulaza", "Kum. izlaza", "Kum. prodaje"};
    }

    @Override
    public Object[] getValues() {
        return new Object[]{"[ " + this.radnajedinica.getId().getOznRj() + " ] " + this.radnajedinica.getNaziv(), this.kolicina, this.alocKolicina, this.kolicina - this.alocKolicina, this.prodCena, this.kumUlaza, this.kumIzlaza, this.kumProdaje};
    }

    public Date getDatPop() {
        return this.datPop;
    }

    public void setDatPop(Date datPop) {
        this.datPop = datPop;
    }

    public double getKolPop() {
        return this.kolPop;
    }

    public void setKolPop(double kolPop) {
        this.kolPop = BDConverter.getKolicina(kolPop).doubleValue();
    }

    public Artikal getArtikal() {
        return this.artikal;
    }

    public List<Osobinaartikla> getOsobinaartiklas() {
        return this.osobinaartiklas;
    }

    public void setOsobinaartiklas(List<Osobinaartikla> osobinaartiklas) {
        this.osobinaartiklas = osobinaartiklas;
    }

    @PrePersist
    @PreUpdate
    public void kolicinaEv() throws Exception {
        Boolean evKolicine = Boolean.FALSE;
        if (PzApplication.getApplication().getSession().getRuntimeStore().get("KOLICINE_U_VRED_PROD") == null) {
            evKolicine = PzParameter.getBoolean("KOLICINE_U_VRED_PROD", Boolean.TRUE);
            PzApplication.getApplication().getSession().getRuntimeStore().put("KOLICINE_U_VRED_PROD", evKolicine);
        } else {
            evKolicine = (Boolean)PzApplication.getApplication().getSession().getRuntimeStore().get("KOLICINE_U_VRED_PROD");
        }
        if (this.getRadnajedinica() != null && "EV".equals(this.getRadnajedinica().getTip()) && !evKolicine.booleanValue()) {
            this.setKolicina(0.0);
            this.setAlocKolicina(0.0);
        } else if (this.getArtikal() != null && this.getArtikal().getTarifnaGrupa("PDV").getOznTarGr().equals("U1")) {
            this.setKolicina(0.0);
            this.setAlocKolicina(0.0);
        }
    }
}

