/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import rs.pezar.db.PzEntity;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Rabatnaskala;

@Entity
@Table(name="RobnaGrupa")
public class Robnagrupa
implements Serializable,
PzEntity {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(unique=true, nullable=false, length=20)
    private String oznRobGr;
    @Column(nullable=false, length=255)
    private String naziv;
    @OneToMany(mappedBy="robnagrupa")
    private List<Artikal> artikals;
    @OneToMany(mappedBy="robnagrupa")
    private List<Rabatnaskala> rabatnaskalas;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="oznNadGrupa", nullable=false)
    private Robnagrupa nadGrupa;
    @OneToMany(mappedBy="nadGrupa")
    private List<Robnagrupa> podGrupe;

    public String getOznRobGr() {
        return this.oznRobGr;
    }

    public void setOznRobGr(String oznRobGr) {
        this.oznRobGr = oznRobGr;
    }

    public String getNaziv() {
        return this.naziv;
    }

    public void setNaziv(String naziv) {
        this.naziv = naziv;
    }

    public List<Artikal> getArtikals() {
        return this.artikals;
    }

    public void setArtikals(List<Artikal> artikals) {
        this.artikals = artikals;
    }

    public List<Rabatnaskala> getRabatnaskalas() {
        return this.rabatnaskalas;
    }

    public void setRabatnaskalas(List<Rabatnaskala> rabatnaskalas) {
        this.rabatnaskalas = rabatnaskalas;
    }

    public Robnagrupa getNadGrupa() {
        return this.nadGrupa;
    }

    public void setNadGrupa(Robnagrupa robnaGrupa) {
        this.nadGrupa = robnaGrupa;
    }

    public List<Robnagrupa> getPodGrupe() {
        return this.podGrupe;
    }

    public void setPodGrupe(List<Robnagrupa> robnaGrupas) {
        this.podGrupe = robnaGrupas;
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{"Oznaka", "Naziv"};
    }

    @Override
    public Object[] getValues() {
        return new Object[]{this.oznRobGr, this.naziv};
    }

    public String toString() {
        return this.naziv;
    }

    public List<String> getRobnaGrupaList() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.getPodGrupe() != null && this.getPodGrupe().size() > 0) {
            for (Robnagrupa rg : this.getPodGrupe()) {
                if (rg.getPodGrupe() != null && rg.getPodGrupe().size() > 0) {
                    list.addAll(rg.getRobnaGrupaList());
                    continue;
                }
                list.add(rg.getOznRobGr());
            }
        } else {
            list.add(this.getOznRobGr());
        }
        return list;
    }

    public String getRobnaGrupaListAsString() {
        List<String> list = this.getRobnaGrupaList();
        String res = "";
        int i = 0;
        while (i < list.size()) {
            res = String.valueOf(res) + (i != 0 ? ", " : "") + "'" + list.get(i) + "'";
            ++i;
        }
        return " ( " + res + " ) ";
    }
}

