/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import javax.persistence.CascadeType;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import rs.pezar.db.PzADTaksa;
import rs.pezar.db.entity.Aftaksa;
import rs.pezar.db.entity.PfrtaksaPK;
import rs.pezar.db.entity.Proizvodfiskalniracun;
import rs.pezar.db.entity.Tarifnagrupa;

@Entity
public class Pfrtaksa
extends PzADTaksa
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private PfrtaksaPK id;
    private String opis;
    private String oznVrstaTG;
    private double stopa;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE})
    @JoinColumns(value={@JoinColumn(name="idDok", referencedColumnName="IDDOK", nullable=false, insertable=false, updatable=false), @JoinColumn(name="rBroj", referencedColumnName="RBROJ", nullable=false, insertable=false, updatable=false), @JoinColumn(name="sfrProizvod", referencedColumnName="SFRPROIZVOD", nullable=false, insertable=false, updatable=false)})
    private Proizvodfiskalniracun proizvodfiskalniracun;

    public Pfrtaksa() {
    }

    public Pfrtaksa(Proizvodfiskalniracun proizvod, Tarifnagrupa tgr) {
        this.id = new PfrtaksaPK(proizvod.getId().getIdDok(), proizvod.getId().getSfrProizvod(), proizvod.getId().getrBroj(), tgr.getOznTarGr());
        this.opis = tgr.getVrstatg().getOpis();
        this.oznVrstaTG = tgr.getVrstatg().getOznVrstaTG();
        this.stopa = tgr.getStopa();
        this.proizvodfiskalniracun = proizvod;
    }

    public Pfrtaksa(int idRacuna, String sfrProizvod, String oznTarGr, int rBroj, double stopa, String oznaka, String opis) {
        PfrtaksaPK id;
        this.id = id = new PfrtaksaPK(idRacuna, sfrProizvod, rBroj, oznTarGr);
        this.stopa = stopa;
        this.oznVrstaTG = oznaka;
        this.opis = opis;
    }

    public Pfrtaksa(Aftaksa afTaksa) {
        this(afTaksa.getId().getIdDok(), afTaksa.getId().getSfrProizvod(), afTaksa.getId().getOznTarGr(), afTaksa.getId().getrBroj(), afTaksa.getStopa(), afTaksa.getOznVrstaTG(), afTaksa.getOpis());
    }

    public Pfrtaksa(Pfrtaksa afTaksa) {
        this(afTaksa.getId().getIdDok(), afTaksa.getId().getSfrProizvod(), afTaksa.getId().getOznTarGr(), afTaksa.getId().getrBroj(), afTaksa.getStopa(), afTaksa.getOznVrstaTG(), afTaksa.getOpis());
    }

    public PfrtaksaPK getId() {
        return this.id;
    }

    public void setId(PfrtaksaPK id) {
        this.id = id;
    }

    @Override
    public String getOpis() {
        return this.opis;
    }

    public void setOpis(String opis) {
        this.opis = opis;
    }

    @Override
    public String getOznVrstaTG() {
        return this.oznVrstaTG;
    }

    public void setOznVrstaTG(String oznvrstatg) {
        this.oznVrstaTG = oznvrstatg;
    }

    @Override
    public double getStopa() {
        return this.stopa;
    }

    public void setStopa(double stopa) {
        this.stopa = stopa;
    }

    public Proizvodfiskalniracun getProizvodfiskalniracun() {
        return this.proizvodfiskalniracun;
    }

    public void setProizvodfiskalniracun(Proizvodfiskalniracun proizvodfiskalniracun) {
        this.proizvodfiskalniracun = proizvodfiskalniracun;
    }

    @Override
    public String getOznTarGr() {
        return this.id.getOznTarGr();
    }

    @Override
    public String[] getColumnNames() {
        return null;
    }

    @Override
    public Object[] getValues() {
        return null;
    }
}

