/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.eclipse.persistence.annotations.PrivateOwned;
import rs.pezar.db.PzArtikalDokument;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.PzTaksaDokument;
import rs.pezar.db.entity.Aodtaksa;
import rs.pezar.db.entity.Artikalopstidokument;
import rs.pezar.db.entity.Dokument;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Obracunkonsignacije;
import rs.pezar.db.entity.Prjmestotroska;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.RadniNalog;
import rs.pezar.db.entity.Taksaopstidokument;
import rs.pezar.db.entity.Tarifnagrupa;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.util.PzDateUtility;

@Entity
@Table(name="OpstiDokument")
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="discriminator", discriminatorType=DiscriminatorType.STRING, length=255)
public class Opstidokument
extends PzDokument
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(unique=true, nullable=false)
    private int idDok;
    @Column(nullable=false)
    private short arhiviran;
    private short cvProdajna;
    private Date datArh;
    private Date datValute;
    @Column(nullable=false)
    private Date datum;
    private BigDecimal iznosBezPoreza = new BigDecimal(0);
    private BigDecimal iznosSaPorezom = new BigDecimal(0);
    @Column(length=255)
    private String oznDokumenta;
    @Column(length=30)
    private String podTip;
    private BigDecimal pdvIznos = new BigDecimal(0);
    @Column(nullable=false)
    private double procRabata;
    @Column(nullable=false)
    private short proknjizen;
    @Column(length=255)
    private String poruka;
    @Column(nullable=false)
    private int rbrDok;
    @Column(nullable=false)
    private int rBroj;
    @Column(nullable=false, length=255)
    private String rjUlaz;
    @Column(nullable=false)
    private int storno;
    private BigDecimal stornoIznos = new BigDecimal(0);
    @Column(nullable=false, length=255)
    private String tip;
    private BigDecimal vrednostRobe = new BigDecimal(0);
    private BigDecimal vrednostUsluga = new BigDecimal(0);
    @Transient
    private String vrstaDok = null;
    @OneToMany(mappedBy="opstidokument", cascade={CascadeType.PERSIST, CascadeType.REMOVE})
    @OrderBy(value="sort ASC")
    private List<Artikalopstidokument> artikalopstidokuments;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="oznOgranak", referencedColumnName="OZNOGRANAK", nullable=false), @JoinColumn(name="oznRj", referencedColumnName="OZNRJ", nullable=false)})
    private Radnajedinica radnajedinica;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="oznPrj", referencedColumnName="OZNPRJ", nullable=false), @JoinColumn(name="oznMTroska", referencedColumnName="OZNMTROSKA", nullable=false)})
    private Prjmestotroska prjmestotroska;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="oznRadniNalog", referencedColumnName="OZNRADNINALOG", nullable=false)})
    private RadniNalog radninalog;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="sfrKomitent", nullable=false)
    private Komitent komitent;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="usernamepoc", nullable=false)
    private Pzuser userPoc;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="usernamekraj", nullable=false)
    private Pzuser userKraj;
    @OneToMany(mappedBy="opstidokument", cascade={CascadeType.ALL})
    @PrivateOwned
    private List<Taksaopstidokument> taksaopstidokuments;
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="idDok", nullable=false, insertable=false, updatable=false)
    private Dokument dokument;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="original")
    private Opstidokument original;
    @OneToMany(mappedBy="original")
    private List<Opstidokument> originals;

    public Artikalopstidokument getArtikal(String sfrA, int idDok) {
        for (Artikalopstidokument af : this.getArtikalopstidokuments()) {
            if (!af.getId().getSfrProizvod().equals(sfrA) || af.getOpstidokument().getIdDok() != idDok) continue;
            return af;
        }
        return null;
    }

    @Override
    public int getIdDok() {
        return this.idDok;
    }

    @Override
    public void setIdDok(int idDok) {
        this.idDok = idDok;
    }

    @Override
    public short getArhiviran() {
        return this.arhiviran;
    }

    @Override
    public void setArhiviran(short arhiviran) {
        this.arhiviran = arhiviran;
    }

    @Override
    public short getCvProdajna() {
        return this.cvProdajna;
    }

    @Override
    public void setCvProdajna(short cvProdajna) {
        this.cvProdajna = cvProdajna;
    }

    @Override
    public Date getDatArh() {
        return this.datArh;
    }

    @Override
    public void setDatArh(Date datArh) {
        this.datArh = datArh;
    }

    @Override
    public Date getDatum() {
        return this.datum;
    }

    @Override
    public void setDatum(Date datum) {
        this.datum = datum;
    }

    @Override
    public Date getDatValute() {
        return this.datValute;
    }

    @Override
    public void setDatValute(Date datValute) {
        this.datValute = datValute;
    }

    public BigDecimal getIznosBezPoreza() {
        return this.iznosBezPoreza;
    }

    public void setIznosBezPoreza(BigDecimal iznosBezPoreza) {
        this.iznosBezPoreza = iznosBezPoreza;
    }

    public BigDecimal getIznosSaPorezom() {
        return this.iznosSaPorezom;
    }

    public void setIznosSaPorezom(BigDecimal iznosSaPorezom) {
        this.iznosSaPorezom = iznosSaPorezom;
    }

    @Override
    public String getOznDokumenta() {
        return this.oznDokumenta;
    }

    @Override
    public void setOznDokumenta(String oznDokumenta) {
        this.oznDokumenta = oznDokumenta;
    }

    @Override
    public String getPodTip() {
        return this.podTip;
    }

    @Override
    public void setPodTip(String podTip) {
        this.podTip = podTip;
    }

    public BigDecimal getPdvIznos() {
        return this.pdvIznos;
    }

    public void setPdvIznos(BigDecimal pdvIznos) {
        this.pdvIznos = pdvIznos;
    }

    public double getProcRabata() {
        return this.procRabata;
    }

    public void setProcRabata(double procRabata) {
        this.procRabata = procRabata;
    }

    @Override
    public short getProknjizen() {
        return this.proknjizen;
    }

    @Override
    public void setProknjizen(short proknjizen) {
        this.proknjizen = proknjizen;
    }

    public String getPoruka() {
        return this.poruka;
    }

    public void setPoruka(String razlogIzrade) {
        this.poruka = razlogIzrade;
    }

    @Override
    public int getRbrDok() {
        return this.rbrDok;
    }

    @Override
    public void setRbrDok(int rbrDok) {
        this.rbrDok = rbrDok;
    }

    @Override
    public int getrBroj() {
        return this.rBroj;
    }

    @Override
    public void setrBroj(int rBroj) {
        this.rBroj = rBroj;
    }

    public String getRjUlaz() {
        return this.rjUlaz;
    }

    public void setRjUlaz(String rjUlaz) {
        this.rjUlaz = rjUlaz;
    }

    @Override
    public int getStorno() {
        return this.storno;
    }

    @Override
    public void setStorno(int storno) {
        this.storno = storno;
    }

    @Override
    public void setStornoIznos(BigDecimal stornoIznos) {
        this.stornoIznos = stornoIznos;
    }

    @Override
    public BigDecimal getStornoIznos() {
        return this.stornoIznos;
    }

    @Override
    public String getTip() {
        return this.tip;
    }

    @Override
    public void setTip(String tip) {
        this.tip = tip;
    }

    @Override
    public BigDecimal getVrednostRobe() {
        return this.vrednostRobe;
    }

    @Override
    public void setVrednostRobe(BigDecimal vrednostRobe) {
        this.vrednostRobe = vrednostRobe;
    }

    @Override
    public BigDecimal getVrednostUsluga() {
        return this.vrednostUsluga;
    }

    @Override
    public void setVrednostUsluga(BigDecimal vrednostUsluga) {
        this.vrednostUsluga = vrednostUsluga;
    }

    @Override
    public String getVrsta() {
        String vrsta;
        String string = vrsta = this.vrstaDok != null ? this.vrstaDok : "N";
        if (this.tip.equals("UVECANJE_LAGERA") || this.tip.equals("PREDAJNICA")) {
            vrsta = "U";
        } else if (this.tip.equals("OTPIS") || this.tip.equals("UMANJENJE_LAGERA") || this.tip.equals("TREBOVANJE") || this.tip.equals("TREBOVANJE_SASTAVNICE") || this.tip.equals(TipDokumentConfig.get().TREBOVANJE_U_GARANTNOM_ROKU)) {
            vrsta = "I";
        } else if (this.tip.equals(TipDokumentConfig.get().PROMENA_STOPE)) {
            vrsta = "L";
        }
        return vrsta;
    }

    @Override
    public void setVrsta(String vrsta) {
        this.vrstaDok = vrsta;
    }

    public List<Artikalopstidokument> getArtikalopstidokuments() {
        return this.artikalopstidokuments;
    }

    public void setArtikalopstidokuments(List<Artikalopstidokument> artikalopstidokuments) {
        this.artikalopstidokuments = artikalopstidokuments;
    }

    @Override
    public Radnajedinica getRadnajedinica() {
        return this.radnajedinica;
    }

    public Prjmestotroska getPrjmestotroska() {
        return this.prjmestotroska;
    }

    public RadniNalog getRadninalog() {
        return this.radninalog;
    }

    public void setRadninalog(RadniNalog radninalog) {
        this.radninalog = radninalog;
    }

    public void setPrjmestotroska(Prjmestotroska prjmestotroska) {
        this.prjmestotroska = prjmestotroska;
    }

    @Override
    public void setRadnajedinica(Radnajedinica radnajedinica) {
        this.radnajedinica = radnajedinica;
    }

    @Override
    public Komitent getKomitent() {
        return this.komitent;
    }

    @Override
    public void setKomitent(Komitent komitent) {
        this.komitent = komitent;
    }

    @Override
    public Pzuser getUserPoc() {
        return this.userPoc;
    }

    @Override
    public void setUserPoc(Pzuser pzuser) {
        this.userPoc = pzuser;
    }

    @Override
    public Pzuser getUserKraj() {
        return this.userKraj;
    }

    @Override
    public void setUserKraj(Pzuser pzuser) {
        this.userKraj = pzuser;
    }

    public void setTaksaopstidokuments(List<Taksaopstidokument> taksaopstidokuments) {
        this.taksaopstidokuments = taksaopstidokuments;
    }

    public List<Taksaopstidokument> getTaksaopstidokuments() {
        return this.taksaopstidokuments;
    }

    @Override
    public Dokument getDokument() {
        return this.dokument;
    }

    @Override
    public void setDokument(Dokument dokument) {
        this.dokument = dokument;
    }

    @Override
    public void adjust() {
        if (this.getArtikalopstidokuments() != null) {
            for (Artikalopstidokument aod : this.getArtikalopstidokuments()) {
                aod.getId().setIdDok(this.getIdDok());
                if (aod.getAodtaksas() == null || aod.getAodtaksas().size() <= 0) continue;
                for (Aodtaksa adt : aod.getAodtaksas()) {
                    adt.getId().setIdDok(this.getIdDok());
                }
            }
        }
        if (this.taksaopstidokuments != null) {
            for (Taksaopstidokument t : this.taksaopstidokuments) {
                t.getId().setIdDok(this.getIdDok());
            }
        }
    }

    @Override
    public void formirajOznaku() {
        String godina = String.valueOf(PzDateUtility.getCurrentYear());
        this.oznDokumenta = String.format("%s-%s/%s", String.valueOf(this.getRadnajedinica().getId().getOznRj()) + this.getRadnajedinica().getgTip(), PzEntityUtil.strZero("" + this.getrBroj(), 5), godina);
    }

    @Override
    public List<? extends PzArtikalDokument> getArtikalDocuments() {
        if (this instanceof Obracunkonsignacije) {
            return ((Obracunkonsignacije)this).getArtikalobracunkonsignacijes();
        }
        return this.getArtikalopstidokuments();
    }

    @Override
    public String[] getDokColumnNames() {
        if (this.tip != null) {
            if (this.tip.equals("OTPIS") || this.tip.equals("UVECANJE_LAGERA") || this.tip.equals("UMANJENJE_LAGERA")) {
                return new String[]{"Dokumenat", "Datum izdavanja", "Iznos", "iddok", "rjulaz"};
            }
            if (this.tip.equals("TRANSFER")) {
                return new String[]{"Dokumenat", "Datum izdavanja", "iddok", "rjulaz"};
            }
            if (this.tip.equals("TREBOVANJE")) {
                return new String[]{"Dokumenat", "Datum", "Iznos", "iddok"};
            }
            return null;
        }
        return null;
    }

    @Override
    public Object[] getDokValues() {
        if (this.tip.equals("OTPIS") || this.tip.equals("UVECANJE_LAGERA") || this.tip.equals("UMANJENJE_LAGERA") || this.tip.equals("TRANSFER") || this.tip.equals("TREBOVANJE")) {
            return new Object[]{this.oznDokumenta, this.datum, this.iznosBezPoreza};
        }
        return null;
    }

    @Override
    public BigDecimal getIznos() {
        return this.iznosSaPorezom;
    }

    @Override
    public Object[] getKValues(byte type) {
        return null;
    }

    @Override
    public String getOpis() {
        return TipDokumentConfig.getNameByValue(this.getTip(), null);
    }

    @Override
    public void setIznos(BigDecimal iznos) {
        this.iznosSaPorezom = iznos;
    }

    @Override
    public void setOpis(String opis) {
    }

    @Override
    public Opstidokument getOriginal() {
        return this.original;
    }

    public void setOriginal(Opstidokument original) {
        this.original = original;
    }

    public List<Opstidokument> getOriginals() {
        return this.originals;
    }

    public void setOriginals(List<Opstidokument> originals) {
        this.originals = originals;
    }

    @Override
    public String[] getColumnNames() {
        if (this.tip.equals("TRANSFER")) {
            return new String[]{"Br. dokumenta", "Datum dok.", "Radna jedinica"};
        }
        if (this.tip.equals("POPIS")) {
            return new String[]{"Br. dokumenta", "Datum dok.", "Radna jedinica", "Iznos popisa", "Vi\u0161ak", "Manjak"};
        }
        if (this.tip.equals("TREBOVANJE")) {
            return new String[]{"Br. dokumenta", "Datum dok.", "Iznos", "Radna jedinica"};
        }
        if (this.tip.equals("TREBOVANJE_SASTAVNICE")) {
            return new String[]{"Br. dokumenta", "Datum dok.", "Iznos", "Prj/mt"};
        }
        if (this.tip.equals(TipDokumentConfig.get().TREBOVANJE_U_GARANTNOM_ROKU)) {
            return new String[]{"Br. dokumenta", "Datum dok.", "Iznos", "Radna jedinica"};
        }
        return new String[]{"Br. dokumenta", "Datum dok.", "Iznos bez poreza", "Iznos sa porezom", "Radna jedinica"};
    }

    @Override
    public Object[] getValues() {
        if (this.tip.equals("TRANSFER")) {
            return new Object[]{this.getrBroj(), this.datum, String.valueOf(this.radnajedinica.getId().getOznRj()) + " - " + this.radnajedinica.getNaziv()};
        }
        if (this.tip.equals("POPIS")) {
            return new Object[]{this.getrBroj(), this.datum, String.valueOf(this.radnajedinica.getId().getOznRj()) + " - " + this.radnajedinica.getNaziv(), this.stornoIznos, this.iznosSaPorezom, this.iznosBezPoreza};
        }
        if (this.tip.equals("TREBOVANJE")) {
            return new Object[]{this.getrBroj(), this.datum, this.iznosBezPoreza, String.valueOf(this.radnajedinica.getId().getOznRj()) + " - " + this.radnajedinica.getNaziv()};
        }
        if (this.tip.equals("TREBOVANJE_SASTAVNICE")) {
            return new Object[]{this.getrBroj(), this.datum, this.iznosBezPoreza, String.valueOf(this.prjmestotroska.getId().getOznPrj()) + "/" + this.prjmestotroska.getId().getOznMTroska() + " - " + this.prjmestotroska.getNaziv()};
        }
        if (this.tip.equals(TipDokumentConfig.get().TREBOVANJE_U_GARANTNOM_ROKU)) {
            return new Object[]{this.getrBroj(), this.datum, this.iznosBezPoreza, String.valueOf(this.radnajedinica.getId().getOznRj()) + " - " + this.radnajedinica.getNaziv()};
        }
        return new Object[]{this.getrBroj(), this.datum, this.iznosBezPoreza, this.iznosSaPorezom, String.valueOf(this.radnajedinica.getId().getOznRj()) + " - " + this.radnajedinica.getNaziv()};
    }

    @Override
    public void setOriginal(PzDokument original) {
        this.original = (Opstidokument)original;
    }

    @Override
    public PzTaksaDokument createEmptyTaksaDokument(String oznTarGr, String tip) {
        return new Taksaopstidokument(this.idDok, oznTarGr, tip);
    }

    @Override
    public void setTaksadokuments(List<? extends PzTaksaDokument> taksaDokuments) {
        this.taksaopstidokuments = taksaDokuments;
    }

    @Override
    public List<? extends PzTaksaDokument> getTaksadokuments() {
        if (this instanceof Obracunkonsignacije) {
            return null;
        }
        return this.taksaopstidokuments;
    }

    public Taksaopstidokument getTaksaopstidokument(String vrsta) {
        Taksaopstidokument taksa = null;
        for (Taksaopstidokument odtaksa : this.taksaopstidokuments) {
            if (!odtaksa.getVrsta().equals(vrsta)) continue;
            taksa = odtaksa;
        }
        return taksa;
    }

    @Override
    public Date getDatPrometa() {
        return this.datum;
    }

    public BigDecimal getIznosSaPorezom(List<Artikalopstidokument> artikli) {
        BigDecimal rez = new BigDecimal(0);
        if (artikli != null) {
            for (Artikalopstidokument af : artikli) {
                rez = rez.add(new BigDecimal(af.getCenaSaPorezom() * af.getKolicina()));
            }
        }
        return rez;
    }

    public BigDecimal getIznosBezPoreza(List<Artikalopstidokument> artikli) {
        BigDecimal rez = new BigDecimal(0);
        if (artikli != null) {
            for (Artikalopstidokument af : artikli) {
                rez = rez.add(new BigDecimal(af.getCenaBezPoreza() * af.getKolicina()));
            }
        }
        return rez;
    }

    @Override
    public void setArtikalDokuments(List<? extends PzArtikalDokument> list) {
        this.artikalopstidokuments = list;
    }

    @Override
    public boolean obracunavaSePorez(Tarifnagrupa tg, String tip) {
        if (tip.equals(TipDokumentConfig.get().PROMENA_STOPE)) {
            return false;
        }
        return !this.getTip().equals("TREBOVANJE");
    }
}

