/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import rs.pezar.db.PzEntity;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Stavkanzk;

@Entity
public class Nzk
implements Serializable,
PzEntity {
    private static final long serialVersionUID = 1L;
    @Id
    private Integer idNalog;
    private Integer arhiviran;
    private Integer brojac;
    private Integer brSheme;
    private Date datum;
    private BigDecimal duguje = new BigDecimal(0);
    private BigDecimal potrazuje = new BigDecimal(0);
    private String opis;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="pzusername")
    private Pzuser pzuser;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="oznOgranak", referencedColumnName="OZNOGRANAK"), @JoinColumn(name="oznRj", referencedColumnName="OZNRJ")})
    private Radnajedinica radnajedinica;
    @OneToMany(mappedBy="nzk", cascade={CascadeType.ALL})
    @OrderBy(value="id.rBroj ASC")
    private List<Stavkanzk> stavkanzks;

    public Integer getIdNalog() {
        return this.idNalog;
    }

    public void setIdNalog(Integer idnalog) {
        this.idNalog = idnalog;
    }

    public Integer getArhiviran() {
        return this.arhiviran;
    }

    public void setArhiviran(Integer arhiviran) {
        this.arhiviran = arhiviran;
    }

    public Integer getBrojac() {
        return this.brojac;
    }

    public void setBrojac(Integer brojac) {
        this.brojac = brojac;
    }

    public Integer getBrSheme() {
        return this.brSheme;
    }

    public void setBrSheme(Integer brsheme) {
        this.brSheme = brsheme;
    }

    public Date getDatum() {
        return this.datum;
    }

    public void setDatum(Date datum) {
        this.datum = datum;
    }

    public BigDecimal getDuguje() {
        return this.duguje;
    }

    public void setDuguje(BigDecimal duguje) {
        this.duguje = duguje;
    }

    public String getOpis() {
        return this.opis;
    }

    public void setOpis(String opis) {
        this.opis = opis;
    }

    public BigDecimal getDugujeSum() {
        BigDecimal duguje = new BigDecimal(0);
        for (Stavkanzk stavka : this.stavkanzks) {
            duguje = duguje.add(stavka.getDuguje());
        }
        this.duguje = duguje;
        return duguje;
    }

    public BigDecimal getPotrazuje() {
        return this.potrazuje;
    }

    public void setPotrazuje(BigDecimal potrazuje) {
        this.potrazuje = potrazuje;
    }

    public BigDecimal getPotrazujeSum() {
        BigDecimal potrazuje = new BigDecimal(0);
        for (Stavkanzk stavka : this.stavkanzks) {
            potrazuje = potrazuje.add(stavka.getPotrazuje());
        }
        this.potrazuje = potrazuje;
        return potrazuje;
    }

    public Pzuser getPzuser() {
        return this.pzuser;
    }

    public void setPzuser(Pzuser pzuser) {
        this.pzuser = pzuser;
    }

    public Radnajedinica getRadnajedinica() {
        return this.radnajedinica;
    }

    public void setRadnajedinica(Radnajedinica radnajedinica) {
        this.radnajedinica = radnajedinica;
    }

    public List<Stavkanzk> getStavkanzks() {
        return this.stavkanzks;
    }

    public void setStavkanzks(List<Stavkanzk> stavkanzks) {
        this.stavkanzks = stavkanzks;
    }

    @Override
    public Object[] getValues() {
        return new Object[]{this.getArhiviran(), this.getIdNalog(), this.getDatum(), this.getOpis()};
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{"", "<html><center>Broj<br/>naloga</center></html>", "<html><center>Datum<br/>naloga</center></html>", "Opis"};
    }
}

