/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import java.sql.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.apache.commons.beanutils.BeanUtils;
import org.eclipse.persistence.annotations.PrivateOwned;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Artikallista;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;

@Entity
@Table(name="lista")
public class Lista
implements Serializable,
PzEntity {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(unique=true, nullable=false)
    @TableGenerator(name="ListaTab", table="ID_GEN", pkColumnName="ID_NAME", valueColumnName="ID_VAL", pkColumnValue="LISTA_ID", initialValue=1, allocationSize=1)
    @GeneratedValue(generator="ListaTab", strategy=GenerationType.TABLE)
    private Integer idLista;
    @Column(nullable=false)
    private Integer arhiviran;
    @Column(nullable=false)
    private Date datum;
    @Column(length=2000)
    private String komentar;
    @Column(nullable=false, length=100)
    private String naslov;
    private int rBroj;
    private int counter;
    @Column(nullable=false, length=30)
    private String tip;
    @OneToMany(mappedBy="lista", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @PrivateOwned
    private List<Artikallista> artikallistas;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="sfrKomitent", nullable=false)
    private Komitent komitent;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE})
    @JoinColumn(name="pzusername", nullable=false, updatable=false)
    private Pzuser pzuser;

    public Integer getIdLista() {
        return this.idLista;
    }

    public void setIdLista(Integer idlista) {
        this.idLista = idlista;
    }

    public Integer getArhiviran() {
        return this.arhiviran;
    }

    public void setArhiviran(Integer arhiviran) {
        this.arhiviran = arhiviran;
    }

    public Date getDatum() {
        return this.datum;
    }

    public void setDatum(Date datum) {
        this.datum = datum;
    }

    public String getKomentar() {
        return this.komentar;
    }

    public void setKomentar(String komentar) {
        this.komentar = komentar;
    }

    public String getNaslov() {
        return this.naslov;
    }

    public void setNaslov(String naslov) {
        this.naslov = naslov;
    }

    public void setrBroj(int rBroj) {
        this.rBroj = rBroj;
    }

    public int getrBroj() {
        return this.rBroj;
    }

    public void setCounter(int counter) {
        this.counter = counter;
    }

    public int getCounter() {
        return this.counter;
    }

    public List<Artikallista> getArtikallistas() {
        return this.artikallistas;
    }

    public void setArtikallistas(List<Artikallista> artikallistas) {
        this.artikallistas = artikallistas;
    }

    public void setKomitent(Komitent komitent) {
        this.komitent = komitent;
    }

    public Komitent getKomitent() {
        return this.komitent;
    }

    public Pzuser getPzuser() {
        return this.pzuser;
    }

    public void setPzuser(Pzuser pzuser) {
        this.pzuser = pzuser;
    }

    @Override
    public Object[] getValues() {
        return new Object[]{this.naslov, this.datum, this.tip, this.komitent != null ? this.komitent.getNaziv() : null};
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{"Naziv liste", "Datum kreiranja", "Tip", "Komitent"};
    }

    public void incCounter() {
        ++this.counter;
    }

    public void setTip(String tip) {
        this.tip = tip;
    }

    public String getTip() {
        return this.tip;
    }

    public Artikallista getArtikal(String sfrA) {
        for (Artikallista aLista : this.artikallistas) {
            if (aLista.getSfrProizvod() == null || !aLista.getSfrProizvod().equals(sfrA)) continue;
            return aLista;
        }
        return null;
    }

    public int getNextRBrojArtikli() {
        int rBroj = 0;
        for (Artikallista aLista : this.getArtikallistas()) {
            if (aLista.getId().getrBroj() <= rBroj) continue;
            rBroj = aLista.getId().getrBroj();
        }
        return rBroj + 1;
    }

    public void kopirajArtikleSaListe(Lista lista, Radnajedinica rj) throws Exception {
        for (Artikallista aLista : lista.getArtikallistas()) {
            Stanje s;
            Artikallista kopija = (Artikallista)BeanUtils.cloneBean((Object)aLista);
            kopija.getId().setrBroj(this.getNextRBrojArtikli());
            kopija.getId().setIdLista(this.idLista);
            if (rj != null && (s = (Stanje)PzEntityManager.find(Stanje.class, new StanjePK(kopija.getSfrProizvod(), rj))) != null) {
                kopija.setPomKolicina(s.getRaspolozivaKolicina());
            }
            this.artikallistas.add(kopija);
            kopija.setLista(this);
        }
    }
}

