/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import rs.pezar.db.PzTaksaDokument;
import rs.pezar.db.entity.Dokument;
import rs.pezar.db.entity.DtaksaPK;
import rs.pezar.db.entity.Tarifnagrupa;

@Entity
@Table(name="DTaksa")
public class Dtaksa
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private DtaksaPK id;
    @Column(nullable=false)
    private BigDecimal iznos = new BigDecimal(0);
    @Column(nullable=false)
    private BigDecimal osnovica = new BigDecimal(0);
    @Column(nullable=false, length=20)
    private String vrsta;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="oznTarGr", nullable=false, insertable=false, updatable=false)
    private Tarifnagrupa tarifnagrupa;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="idDok", nullable=false, insertable=false, updatable=false)
    private Dokument dokument;

    public Dtaksa() {
    }

    public Dtaksa(PzTaksaDokument td, Dokument d) {
        this.dokument = d;
        this.iznos = td.getIznos();
        this.osnovica = td.getOsnovica();
        this.vrsta = td.getVrsta();
        this.tarifnagrupa = td.getTarifnagrupa();
        this.id = new DtaksaPK(td.getTarifnagrupa().getOznTarGr(), d.getIdDok(), td.getTip());
    }

    public void update(PzTaksaDokument td) {
        this.iznos = td.getIznos();
        this.osnovica = td.getOsnovica();
    }

    public DtaksaPK getId() {
        return this.id;
    }

    public void setId(DtaksaPK id) {
        this.id = id;
    }

    public BigDecimal getIznos() {
        return this.iznos;
    }

    public void setIznos(BigDecimal iznos) {
        this.iznos = iznos;
    }

    public BigDecimal getOsnovica() {
        return this.osnovica;
    }

    public void setOsnovica(BigDecimal osnovica) {
        this.osnovica = osnovica;
    }

    public String getVrsta() {
        return this.vrsta;
    }

    public void setVrsta(String vrsta) {
        this.vrsta = vrsta;
    }

    public Tarifnagrupa getTarifnagrupa() {
        return this.tarifnagrupa;
    }

    public void setTarifnagrupa(Tarifnagrupa tarifnagrupa) {
        this.tarifnagrupa = tarifnagrupa;
    }

    public Dokument getDokument() {
        return this.dokument;
    }

    public void setDokument(Dokument dokument) {
        this.dokument = dokument;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.iznos == null ? 0 : this.iznos.hashCode());
        result = 31 * result + (this.osnovica == null ? 0 : this.osnovica.hashCode());
        result = 31 * result + (this.vrsta == null ? 0 : this.vrsta.hashCode());
        return result;
    }
}

