/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.OneToMany;
import org.eclipse.persistence.annotations.PrivateOwned;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.PzArtikalDokument;
import rs.pezar.db.entity.Artikalcarinadokument;
import rs.pezar.db.entity.Opstidokument;
import rs.pezar.db.entity.Tarifnagrupa;

@Entity
@DiscriminatorValue(value="CARINA_PRIJEM")
public class CarinaDokument
extends Opstidokument
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="dbl1")
    private double kurs;
    @Column(name="dbl2")
    private double vrednostD;
    @Column(name="dbl3")
    private double vrednostV;
    @OneToMany(mappedBy="carinadokument", cascade={CascadeType.PERSIST, CascadeType.REMOVE})
    @PrivateOwned
    private List<Artikalcarinadokument> artikalcarinadokuments;

    public List<Artikalcarinadokument> getArtikalcarinadokuments() {
        return this.artikalcarinadokuments;
    }

    public void setArtikalcarinadokuments(List<Artikalcarinadokument> artikalcarinadokuments) {
        this.artikalcarinadokuments = artikalcarinadokuments;
    }

    @Override
    public List<? extends PzArtikalDokument> getArtikalDocuments() {
        return this.getArtikalcarinadokuments();
    }

    public double getKurs() {
        return this.kurs;
    }

    public void setKurs(double kurs) {
        this.kurs = kurs;
    }

    public double getVrednostD() {
        return this.vrednostD;
    }

    public void setVrednostD(double vrednostD) {
        this.vrednostD = vrednostD;
    }

    public double getVrednostV() {
        return this.vrednostV;
    }

    public void setVrednostV(double vrednostV) {
        this.vrednostV = vrednostV;
    }

    @Override
    public BigDecimal getIznos() {
        return BDConverter.getIznos(this.vrednostD);
    }

    @Override
    public String getVrsta() {
        return "U";
    }

    @Override
    public boolean obracunavaSePorez(Tarifnagrupa tg, String tip) {
        return false;
    }

    public BigDecimal getVrednostDinar(List<Artikalcarinadokument> artikli) {
        BigDecimal rez = new BigDecimal(0);
        for (Artikalcarinadokument art : artikli) {
            rez = rez.add(BDConverter.getIznos(art.getCenaD() * art.getKolicina()));
        }
        return rez;
    }

    public BigDecimal getVrednostValuta(List<Artikalcarinadokument> artikli) {
        BigDecimal rez = new BigDecimal(0);
        for (Artikalcarinadokument art : artikli) {
            rez = rez.add(BDConverter.getIznos(art.getCenaV() * art.getKolicina()));
        }
        return rez;
    }

    @Override
    public void adjust() {
        this.setVrednostD(this.getVrednostDinar(this.getArtikalcarinadokuments()).doubleValue());
        this.setVrednostV(this.getVrednostValuta(this.getArtikalcarinadokuments()).doubleValue());
        this.setVrednostRobe(BDConverter.getIznos(this.getVrednostDinar(this.getArtikalcarinadokuments())));
        if (this.getArtikalcarinadokuments() != null) {
            for (Artikalcarinadokument ad : this.getArtikalcarinadokuments()) {
                ad.getId().setIdDok(this.getIdDok());
            }
        }
    }

    @Override
    public void izracunajVrednostRobe() {
    }
}

