/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.eclipse.persistence.indirection.IndirectList;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.PzADTaksa;
import rs.pezar.db.PzArtikalDokument;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.entity.Aktaksa;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.ArtikalkalkulacijaPK;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.db.entity.Tarifnagrupa;
import rs.pezar.db.entity.Usluga;
import rs.pezar.util.PzMathUtility;

@Entity
@Table(name="ArtikalKalkulacija")
public class Artikalkalkulacija
extends PzArtikalDokument
implements Serializable,
Comparable<Artikalkalkulacija> {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private ArtikalkalkulacijaPK id;
    @Column(length=255)
    private String bliziOpis;
    private String dobSifra;
    @Transient
    private String katBroj;
    @Column(nullable=false, length=255)
    private String jm;
    @Column(nullable=false)
    private double kolicina;
    @Column(nullable=false)
    private double fakturnaCena;
    private double nabCena;
    @Column(nullable=false, length=255)
    private String naziv;
    @Column(nullable=false)
    private double procMarze;
    @Column(nullable=false)
    private double procRabata;
    @Column(nullable=false)
    private BigDecimal prodCena = new BigDecimal(0);
    private BigDecimal prosNabCena = new BigDecimal(0);
    private int sort;
    @Column(nullable=false)
    private double zavTroskovi;
    @OneToMany(mappedBy="artikalkalkulacija", cascade={CascadeType.ALL})
    private List<Aktaksa> aktaksas;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="sfrProizvod", nullable=false, insertable=false, updatable=false)
    private Artikal artikal;
    @ManyToOne(cascade={CascadeType.MERGE})
    @JoinColumn(name="idDok", nullable=false, insertable=false, updatable=false)
    private Kalkulacija kalkulacija;

    @Override
    public ArtikalkalkulacijaPK getId() {
        return this.id;
    }

    public void setId(ArtikalkalkulacijaPK id) {
        this.id = id;
    }

    @Override
    public String getBliziOpis() {
        return this.bliziOpis != null ? this.bliziOpis : "";
    }

    @Override
    public void setBliziOpis(String bliziOpis) {
        this.bliziOpis = bliziOpis;
    }

    public String getDobSifra() {
        return this.dobSifra;
    }

    public void setDobSifra(String dobSifra) {
        this.dobSifra = dobSifra;
    }

    public String getKatBroj() {
        return this.katBroj;
    }

    public void setKatBroj(String katBroj) {
        this.katBroj = katBroj;
    }

    @Override
    public String getJm() {
        return this.jm;
    }

    @Override
    public void setJm(String jm) {
        this.jm = jm;
    }

    @Override
    public double getKolicina() {
        return this.kolicina;
    }

    @Override
    public void setKolicina(double kolicina) {
        this.kolicina = kolicina;
    }

    public double getFakturnaCena() {
        return this.fakturnaCena;
    }

    public void setFakturnaCena(double nabCena) {
        this.fakturnaCena = nabCena;
    }

    @Override
    public double getNabCena() {
        return this.nabCena;
    }

    @Override
    public void setNabCena(double nabCena) {
        this.nabCena = nabCena;
    }

    @Override
    public String getNaziv() {
        return this.naziv;
    }

    @Override
    public void setNaziv(String nazivArt) {
        this.naziv = nazivArt;
    }

    public double getProcMarze() {
        return this.procMarze;
    }

    public void setProcMarze(double procMarze) {
        this.procMarze = procMarze;
    }

    @Override
    public double getProcRabata() {
        return this.procRabata;
    }

    @Override
    public void setProcRabata(double procRabata) {
        this.procRabata = procRabata;
    }

    @Override
    public BigDecimal getProdCena() {
        return this.prodCena;
    }

    @Override
    public void setProdCena(BigDecimal prodCena) {
        this.prodCena = prodCena;
    }

    @Override
    public BigDecimal getProsNabCena() {
        return this.prosNabCena;
    }

    @Override
    public void setProsNabCena(BigDecimal prosNabCena) {
        this.prosNabCena = prosNabCena;
    }

    @Override
    public int getSort() {
        return this.sort;
    }

    @Override
    public void setSort(int sort) {
        this.sort = sort;
    }

    public double getZavTroskovi() {
        return this.zavTroskovi;
    }

    public void setZavTroskovi(double zavTroskovi) {
        this.zavTroskovi = zavTroskovi;
    }

    public List<Aktaksa> getAktaksas() {
        return this.aktaksas;
    }

    public void setAktaksas(List<Aktaksa> aktaksas) {
        this.aktaksas = aktaksas;
    }

    @Override
    public Artikal getArtikal() {
        return this.artikal;
    }

    @Override
    public void setArtikal(Artikal artikal) {
        this.artikal = artikal;
    }

    public Kalkulacija getKalkulacija() {
        return this.kalkulacija;
    }

    public void setKalkulacija(Kalkulacija kalkulacija) {
        this.kalkulacija = kalkulacija;
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{"\u0160ifra", "Naziv", "JM", "Koli\u010dina", "Fakturna cena", "% rabata", "Fakturna vrednost", "Prod. cena", "% mar\u017ee", "Cena evro"};
    }

    @Override
    public Object[] getValues() {
        return new Object[]{this.id.getSfrProizvod(), this.naziv, this.jm, this.kolicina, this.fakturnaCena, this.procRabata, this.kolicina * this.fakturnaCena * (1.0 - this.procRabata / 100.0), this.prodCena, this.procMarze, this.getKalkulacija() != null && this.getKalkulacija().getKurs() != 0.0 ? BDConverter.getIznos(this.fakturnaCena / this.getKalkulacija().getKurs()) : null};
    }

    @Override
    public Object[] getKValues() {
        String kalk = new String();
        kalk = String.format("K:%d Rn:%s D:%s", this.kalkulacija.getrBroj(), this.kalkulacija.getOznDokumenta(), this.kalkulacija.getKomitent().getSfrKomitent());
        Object[] objectArray = new Object[15];
        objectArray[0] = this.kalkulacija.getDatFakture();
        objectArray[1] = this.kalkulacija.getKomitent().getSfrKomitent();
        objectArray[2] = this.kalkulacija.getOznDokumenta();
        objectArray[3] = this.kalkulacija.getStorno() != 0 ? "Storno Kalkulacije" : "Kalkulacija";
        objectArray[4] = this.kalkulacija.getrBroj();
        objectArray[5] = this.fakturnaCena;
        objectArray[6] = this.kalkulacija.getStorno() != 0 ? -this.kolicina : this.kolicina;
        objectArray[7] = 0.0;
        objectArray[9] = this.procRabata;
        objectArray[10] = this.kolicina * this.fakturnaCena * (1.0 - this.procRabata / 100.0);
        objectArray[11] = 0.0;
        objectArray[14] = kalk;
        return objectArray;
    }

    public Object[] getIzvodValues() {
        return new Object[]{this.kalkulacija.getDatum(), this.kalkulacija.getRadnajedinica().getId().getOznRj(), this.kalkulacija.getOznDokumenta(), this.kolicina, this.fakturnaCena, this.procRabata, this.nabCena, this.kalkulacija.getKomitent().getSfrKomitent(), this.kalkulacija.getKomitent().getNaziv()};
    }

    @Override
    public double getCena() {
        return this.prodCena.doubleValue();
    }

    @Override
    public String getSifra() {
        return this.id.getSfrProizvod();
    }

    @Override
    public PzDokument getDokument() {
        return this.kalkulacija;
    }

    @Override
    public void setDokument(PzDokument dokument) {
        this.kalkulacija = (Kalkulacija)dokument;
    }

    @Override
    public void addTaksa(Tarifnagrupa tgr) {
        if (this.aktaksas == null) {
            this.aktaksas = new IndirectList();
        }
        this.aktaksas.add(new Aktaksa(this, tgr));
    }

    @Override
    public void setCena(double cena) {
        this.prodCena = PzMathUtility.roundToBigDecimal(cena);
    }

    @Override
    public void setId(int dokId, String artId, int rBroj) {
        this.id = new ArtikalkalkulacijaPK(dokId, artId, rBroj);
    }

    @Override
    public Usluga getUsluga() {
        return null;
    }

    @Override
    public void setUsluga(Usluga usluga) {
    }

    @Override
    public List<? extends PzADTaksa> getTaksas() {
        return this.aktaksas;
    }

    @Override
    public BigDecimal calculateTaksa(String vrsta) {
        if (this.kalkulacija.getKomitent().getDomaciKomitent() == 1) {
            return super.calculateTaksa(vrsta);
        }
        return new BigDecimal(0);
    }

    @Override
    public BigDecimal calculateOsnovica(String vrsta) {
        if (this.kalkulacija.getKomitent().getDomaciKomitent() == 1) {
            return super.calculateOsnovica(vrsta);
        }
        return BDConverter.getIznos(this.kolicina * this.fakturnaCena * (1.0 - this.procRabata / 100.0));
    }

    public void setEko(BigDecimal eko) {
        if (this.getBliziOpis() == null) {
            if (eko.compareTo(BigDecimal.ZERO) == 0) {
                return;
            }
            this.setBliziOpis(String.format("#EKO[%s]", eko.toString()));
        } else if (eko.compareTo(BigDecimal.ZERO) == 0) {
            this.setBliziOpis(this.getBliziOpis().replaceAll("#EKO\\[(\\d+\\.\\d+)\\]", ""));
        } else {
            this.setBliziOpis(String.valueOf(this.getBliziOpis()) + String.format(" #EKO[%s]", eko.toString()));
        }
    }

    public BigDecimal getEko() {
        Matcher m = Pattern.compile("#EKO\\[(\\d+\\.\\d+)\\]").matcher(this.getBliziOpis());
        if (m.find()) {
            return new BigDecimal(m.group(1));
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal calculateZavTrosak() {
        if (this.getKalkulacija() == null || this.getKalkulacija().getRadnajedinica() == null) {
            return new BigDecimal(0);
        }
        BigDecimal netoIznosRobe = this.getKalkulacija().getIznos().subtract(this.getKalkulacija().getPdvIznos()).subtract(this.getKalkulacija().getTrosakBezPdv());
        BigDecimal fakturnaCena = BDConverter.getIznos(this.getFakturnaCena());
        BigDecimal kolicina = BDConverter.getKolicina(this.getKolicina());
        BigDecimal fakturnaVrednost = fakturnaCena.multiply(kolicina);
        BigDecimal procRabata = BDConverter.getProcRabata100(this.getProcRabata());
        BigDecimal rabat = BDConverter.getIznos(fakturnaVrednost.multiply(procRabata));
        BigDecimal nabavnaVrednost = fakturnaVrednost.subtract(rabat);
        double udeoUTroskovima = 0.0;
        if (netoIznosRobe.compareTo(BigDecimal.ZERO) != 0) {
            udeoUTroskovima = nabavnaVrednost.multiply(new BigDecimal("100")).doubleValue() / netoIznosRobe.doubleValue() / 100.0;
        }
        double zTros1 = (this.getKalkulacija().getTrosakBezPdv().doubleValue() + this.getKalkulacija().calculateTroskoviSum().doubleValue()) * udeoUTroskovima;
        BigDecimal zTros = BDConverter.getIznos(zTros1);
        return zTros;
    }

    public BigDecimal calculateNabVrednost() {
        BigDecimal fakVrednost = BDConverter.getKolicina(this.getKolicina()).multiply(BDConverter.getFakturnaCena(this.getFakturnaCena()));
        BigDecimal fakVrednostBezRabata = fakVrednost.subtract(BDConverter.getIznos(fakVrednost.multiply(BDConverter.getProcRabata100(this.getProcRabata()))));
        BigDecimal zavTros = this.calculateZavTrosak();
        BigDecimal ekoTaksa = this.getEko();
        BigDecimal nabVrednost = fakVrednostBezRabata.add(zavTros);
        if (ekoTaksa.compareTo(BigDecimal.ZERO) != 0) {
            nabVrednost = nabVrednost.add(ekoTaksa.multiply(new BigDecimal(this.getKolicina() * this.getArtikal().getTezina())));
        }
        return BDConverter.getIznos(nabVrednost);
    }

    public BigDecimal calculateNabCena() {
        return BDConverter.getNabCena(this.calculateNabVrednost().doubleValue() / this.getKolicina());
    }

    @Override
    public int compareTo(Artikalkalkulacija arg0) {
        return PzEntityUtil.strZero(this.getId().getSfrProizvod(), 15).compareTo(PzEntityUtil.strZero(arg0.getId().getSfrProizvod(), 15));
    }
}

