/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Vector;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.eclipse.persistence.annotations.JoinFetch;
import org.eclipse.persistence.annotations.JoinFetchType;
import org.eclipse.persistence.annotations.PrivateOwned;
import org.eclipse.persistence.indirection.IndirectList;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.PzADTaksa;
import rs.pezar.db.PzArtikalDokument;
import rs.pezar.db.PzDokument;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Aftaksa;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.ArtikalfakturaPK;
import rs.pezar.db.entity.Artikalfakturaparameter;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Stanjeartikal;
import rs.pezar.db.entity.Tarifnagrupa;
import rs.pezar.db.entity.Usluga;

@Entity
@Table(name="ArtikalFaktura")
public class Artikalfaktura
extends PzArtikalDokument
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private ArtikalfakturaPK id;
    @Column(length=255)
    private String bliziOpis;
    @Column(nullable=false)
    private double cena;
    @Column(nullable=false, length=255)
    private String jm;
    @Column(nullable=false)
    private double kolicina;
    private double nabCena;
    @Column(nullable=false, length=255)
    private String naziv;
    @Column(nullable=false, length=255)
    private String dobSifra;
    @Column(nullable=false)
    private double procRabata;
    @Column(nullable=false)
    private double tezina;
    @Column(length=255)
    private String saOtpremnice;
    private BigDecimal prodCena;
    private BigDecimal prosNabCena;
    private int sort;
    private short indk;
    private short indp;
    @Column(length=255)
    private String konsignacija;
    private double kolSaKons;
    @OneToMany(mappedBy="artikalfaktura", cascade={CascadeType.ALL})
    @JoinFetch(value=JoinFetchType.INNER)
    @PrivateOwned
    private List<Aftaksa> aftaksas;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="sfrProizvod", nullable=false, insertable=false, updatable=false)
    private Artikal artikal;
    @ManyToOne(cascade={CascadeType.MERGE})
    @JoinFetch(value=JoinFetchType.INNER)
    @JoinColumn(name="idDok", nullable=false, insertable=false, updatable=false)
    private Faktura faktura;
    @OneToMany(mappedBy="artikalFaktura", cascade={CascadeType.ALL})
    private List<Artikalfakturaparameter> artikalFakturaParameters;

    public Artikalfaktura() {
    }

    public Artikalfaktura(int idDok, String sfrProizvod, int rBroj, String bliziOpis, double cena, String jm, double kolicina, double nabCena, String nazivArt, String pomSifra, double procRabata, double tezina, String saOtpremnice, BigDecimal prosNabCena, BigDecimal prodCena, String konsignacija, double kolSaKons) {
        ArtikalfakturaPK id;
        this.id = id = new ArtikalfakturaPK(idDok, sfrProizvod, rBroj);
        this.bliziOpis = bliziOpis;
        this.cena = cena;
        this.jm = jm;
        this.kolicina = kolicina;
        this.nabCena = nabCena;
        this.naziv = nazivArt;
        this.dobSifra = pomSifra;
        this.procRabata = procRabata;
        this.tezina = tezina;
        this.saOtpremnice = saOtpremnice;
        this.prosNabCena = prosNabCena;
        this.prodCena = prodCena;
        this.konsignacija = konsignacija;
        this.kolSaKons = kolSaKons;
    }

    public Artikalfaktura(Artikalfaktura af) {
        this(af.getId().getIdDok(), af.getId().getSfrProizvod(), af.getId().getrBroj(), af.getBliziOpis(), af.getCena(), af.getJm(), af.getKolicina(), af.getNabCena(), af.getNaziv(), af.getDobSifra(), af.getProcRabata(), af.getTezina(), af.getSaOtpremnice(), af.getProsNabCena(), af.getProdCena(), af.getKonsignacija(), af.getKolSaKons());
        this.artikal = af.getArtikal();
        this.sort = af.getSort();
    }

    @Override
    public ArtikalfakturaPK getId() {
        return this.id;
    }

    public void setId(ArtikalfakturaPK id) {
        this.id = id;
    }

    @Override
    public String getBliziOpis() {
        return this.bliziOpis;
    }

    @Override
    public void setBliziOpis(String bliziOpis) {
        this.bliziOpis = bliziOpis;
    }

    @Override
    public double getCena() {
        return this.cena;
    }

    @Override
    public void setCena(double cena) {
        this.cena = cena;
        this.setProdCena(new BigDecimal(Double.toString(cena)));
    }

    @Override
    public String getJm() {
        return this.jm;
    }

    @Override
    public void setJm(String jm) {
        this.jm = jm;
    }

    @Override
    public double getKolicina() {
        return this.kolicina;
    }

    @Override
    public void setKolicina(double kolicina) {
        this.kolicina = kolicina;
    }

    @Override
    public void setNabCena(double nabCena) {
        this.nabCena = nabCena;
    }

    @Override
    public double getNabCena() {
        return this.nabCena;
    }

    @Override
    public String getNaziv() {
        return this.naziv;
    }

    @Override
    public void setNaziv(String nazivArt) {
        this.naziv = nazivArt;
    }

    public String getDobSifra() {
        return this.dobSifra;
    }

    public void setDobSifra(String pomSifra) {
        this.dobSifra = pomSifra;
    }

    @Override
    public double getProcRabata() {
        return this.procRabata;
    }

    @Override
    public void setProcRabata(double procRabata) {
        this.procRabata = procRabata;
    }

    public short getIndk() {
        return this.indk;
    }

    public void setIndk(short indk) {
        this.indk = indk;
    }

    public short getIndp() {
        return this.indp;
    }

    public void setIndp(short indp) {
        this.indp = indp;
    }

    public double getTezina() {
        return this.tezina;
    }

    public void setTezina(double tezina) {
        this.tezina = tezina;
    }

    public String getSaOtpremnice() {
        return this.saOtpremnice;
    }

    public void setSaOtpremnice(String saOtpremnice) {
        this.saOtpremnice = saOtpremnice;
    }

    @Override
    public BigDecimal getProsNabCena() {
        return this.prosNabCena;
    }

    @Override
    public void setProsNabCena(BigDecimal prosNabCena) {
        this.prosNabCena = prosNabCena;
    }

    @Override
    public int getSort() {
        return this.sort;
    }

    @Override
    public void setSort(int sort) {
        this.sort = sort;
    }

    @Override
    public BigDecimal getProdCena() {
        return this.prodCena;
    }

    @Override
    public void setProdCena(BigDecimal prodCena) {
        this.prodCena = prodCena;
    }

    public String getKonsignacija() {
        return this.konsignacija;
    }

    public void setKonsignacija(String konsignacija) {
        this.konsignacija = konsignacija;
    }

    public double getKolSaKons() {
        return this.kolSaKons;
    }

    public void setKolSaKons(double kolSaKons) {
        this.kolSaKons = kolSaKons;
    }

    public List<Aftaksa> getAftaksas() {
        return this.aftaksas;
    }

    public void setAftaksas(List<Aftaksa> aftaksas) {
        this.aftaksas = aftaksas;
    }

    @Override
    public Artikal getArtikal() {
        return this.artikal;
    }

    @Override
    public void setArtikal(Artikal artikal) {
        this.artikal = artikal;
    }

    public Faktura getFaktura() {
        return this.faktura;
    }

    public void setFaktura(Faktura faktura) {
        this.faktura = faktura;
    }

    public List<Artikalfakturaparameter> getArtikalFakturaParameters() {
        return this.artikalFakturaParameters;
    }

    public void setArtikalFakturaParameters(List<Artikalfakturaparameter> artikalFakturaParameters) {
        this.artikalFakturaParameters = artikalFakturaParameters;
    }

    public void addArtikalFakturaparameter(Artikalfakturaparameter afp) {
        if (this.getArtikalFakturaParameters() == null) {
            this.setArtikalFakturaParameters(new Vector<Artikalfakturaparameter>());
        }
        this.getArtikalFakturaParameters().add(afp);
    }

    @Override
    public String[] getColumnNames() {
        String valuta = PzParameter.getParameterValue("DEF_VALUTA", "EUR");
        if (this.getFaktura().getTip().equals("AVANSNI_RACUN") || this.getFaktura().getTip().equals("PROFAKTURA") && this.faktura.getRadnajedinica().getTip().equals("V") || this.getFaktura().getTip().equals("FAKTURA_TRANZITA")) {
            return new String[]{"\u0160ifra", "Naziv artikla", "Koli\u010dina", "Prodajna cena", "% rabata", "Iznos rabata", valuta, "Kurs"};
        }
        if (this.faktura.getZaOtpremnice() == 1) {
            return new String[]{"Otpremnica", "\u0160ifra artikla", "Naziv artikla", "Koli\u010dina", "Cena", "%rabat", "Iznos rabata"};
        }
        if (this.faktura.getTip().equals("FAKTURA_INTERNI_RACUN")) {
            return new String[]{"\u0160ifra", "Naziv artikla", "JM", "Koli\u010dina", "Cena", "Kons", "Kol - Kons"};
        }
        if (this.faktura.getTip().equals("OTPREMNICA")) {
            return new String[]{"\u0160ifra", "Naziv artikla", "Koli\u010dina", "Prodajna cena", "% rabata", "Iznos rabata", valuta, "Kurs", "Kons", "Kol - Kons"};
        }
        if (this.faktura.getTip().equals("PRENOSNICA_SA_KONSIGNACIJE")) {
            return new String[]{"\u0160ifra", "Naziv artikla", "Koli\u010dina", "Prodajna cena", "% rabata", "Iznos rabata", valuta, "Kurs"};
        }
        if (this.faktura.getTip().equals("SLIKA_MALOPRODAJNOG_RACUNA")) {
            return new String[]{"\u0160ifra", "Naziv artikla", "JM", "Tgr", "Koli\u010dina", "Cena"};
        }
        if (this.faktura.getTip().equals("PROPUSTENA_PRODAJA")) {
            return new String[]{"\u0160ifra", "Naziv artikla", "Koli\u010dina", "Prodajna cena", "Proizvo\u0111a\u010d"};
        }
        if (this.faktura.getRadnajedinica().getTip().equals("V")) {
            return new String[]{"\u0160ifra", "Naziv artikla", "Koli\u010dina", "Prodajna cena", "% rabata", "Iznos rabata", valuta, "Kurs", "Kons", "Kol - Kons", "Proizvo\u0111a\u010d"};
        }
        return new String[]{"\u0160ifra", "Naziv artikla", "Koli\u010dina", "Prodajna cena"};
    }

    @Override
    public Object[] getValues() {
        double cenaKurs = this.cena / this.faktura.getKurs();
        boolean straniKupac = false;
        if (!this.faktura.getTip().equals("SLIKA_MALOPRODAJNOG_RACUNA") && !this.faktura.getTip().equals("FAKTURA_INTERNI_RACUN")) {
            boolean bl = straniKupac = this.faktura.getKomitent().getDomaciKomitent() != 1;
        }
        if (this.faktura.getTip().equals("AVANSNI_RACUN") || this.getFaktura().getTip().equals("PROFAKTURA") && this.faktura.getRadnajedinica().getTip().equals("V") || this.getFaktura().getTip().equals("FAKTURA_TRANZITA")) {
            return new Object[]{this.id.getSfrProizvod(), String.valueOf(this.naziv) + ", " + this.getBliziOpis(), this.kolicina, this.cena, this.procRabata, this.kolicina * this.cena * this.procRabata / 100.0, straniKupac ? Double.valueOf(cenaKurs) : "-", straniKupac ? Double.valueOf(this.faktura.getKurs()) : "-"};
        }
        if (this.faktura.getZaOtpremnice() == 1) {
            return new Object[]{this.saOtpremnice, this.id.getSfrProizvod(), String.valueOf(this.naziv) + ", " + this.getBliziOpis(), this.kolicina, this.cena, this.procRabata, this.kolicina * this.cena * this.procRabata / 100.0};
        }
        if (this.faktura.getTip().equals("FAKTURA_INTERNI_RACUN")) {
            return new Object[]{this.id.getSfrProizvod(), String.valueOf(this.naziv) + ", " + this.getBliziOpis(), this.jm, this.kolicina, this.cena, this.konsignacija, this.kolSaKons};
        }
        if (this.faktura.getTip().equals("OTPREMNICA")) {
            return new Object[]{this.id.getSfrProizvod(), String.valueOf(this.naziv) + ", " + this.getBliziOpis(), this.kolicina, this.cena, this.procRabata, this.kolicina * this.cena * this.procRabata / 100.0, straniKupac ? Double.valueOf(cenaKurs) : "-", straniKupac ? Double.valueOf(this.faktura.getKurs()) : "-", this.konsignacija, this.kolSaKons};
        }
        if (this.faktura.getTip().equals("PRENOSNICA_SA_KONSIGNACIJE")) {
            return new Object[]{this.id.getSfrProizvod(), String.valueOf(this.naziv) + ", " + this.getBliziOpis(), this.kolicina, this.cena, this.procRabata, this.kolicina * this.cena * this.procRabata / 100.0, straniKupac ? Double.valueOf(cenaKurs) : "-", straniKupac ? Double.valueOf(this.faktura.getKurs()) : "-"};
        }
        if (this.faktura.getTip().equals("SLIKA_MALOPRODAJNOG_RACUNA")) {
            return new Object[]{this.id.getSfrProizvod(), this.naziv, this.jm, this.artikal.getTarifnaGrupa("PDV").getOznTarGr(), this.kolicina, this.cena};
        }
        if (this.faktura.getTip().equals("PROPUSTENA_PRODAJA")) {
            return new Object[]{this.id.getSfrProizvod(), String.valueOf(this.naziv) + ", " + this.getBliziOpis(), this.kolicina, this.cena, this.artikal.getProizvodjac() != null ? this.artikal.getProizvodjac().getNaziv() : ""};
        }
        if (this.faktura.getRadnajedinica().getTip().equals("V")) {
            return new Object[]{this.id.getSfrProizvod(), String.valueOf(this.naziv) + ", " + this.getBliziOpis(), this.kolicina, this.cena, this.procRabata, this.kolicina * this.cena * this.procRabata / 100.0, straniKupac ? Double.valueOf(cenaKurs) : "-", straniKupac ? Double.valueOf(this.faktura.getKurs()) : "-", this.konsignacija, this.kolSaKons, this.artikal.getProizvodjac() != null ? this.artikal.getProizvodjac().getNaziv() : ""};
        }
        return new Object[]{this.id.getSfrProizvod(), String.valueOf(this.naziv) + ", " + this.getBliziOpis(), this.kolicina, this.cena};
    }

    @Override
    public Object[] getKValues() {
        double cena = this.getCena();
        double kolicina = this.getKolicina();
        double rabat = this.faktura.getProcRabata();
        double ukupnaVrednost = kolicina * (cena * (1.0 - rabat / 100.0));
        Object[] objectArray = new Object[15];
        objectArray[0] = this.faktura.getDatum();
        objectArray[1] = this.faktura.getKomitent().getSfrKomitent();
        objectArray[2] = this.faktura.getOznDokumenta();
        objectArray[3] = this.faktura.getStorno() != 0 ? "Storno fakture" : "Faktura";
        objectArray[5] = cena;
        objectArray[6] = 0.0;
        objectArray[7] = this.faktura.getStorno() != 0 ? -kolicina : kolicina;
        objectArray[9] = rabat;
        objectArray[10] = 0.0;
        objectArray[11] = ukupnaVrednost;
        objectArray[12] = 0.0;
        objectArray[14] = "";
        return objectArray;
    }

    @Override
    public String getSifra() {
        return this.id.getSfrProizvod();
    }

    @Override
    public PzDokument getDokument() {
        return this.faktura;
    }

    @Override
    public void setDokument(PzDokument dokument) {
        this.faktura = (Faktura)dokument;
    }

    @Override
    public void addTaksa(Tarifnagrupa tgr) {
        if (this.aftaksas == null) {
            this.aftaksas = new IndirectList();
        }
        this.aftaksas.add(new Aftaksa(this, tgr));
    }

    @Override
    public void setId(int dokId, String artId, int rBroj) {
        this.id = new ArtikalfakturaPK(dokId, artId, rBroj);
    }

    @Override
    public Usluga getUsluga() {
        return null;
    }

    @Override
    public void setUsluga(Usluga usluga) {
    }

    @Override
    public List<? extends PzADTaksa> getTaksas() {
        return this.aftaksas;
    }

    public void preuzmiTakse(List<Aftaksa> takse, EntityManager em) {
        for (Aftaksa afT : takse) {
            afT.getId().setIdDok(this.faktura.getIdDok());
            this.aftaksas.add(afT);
            em.persist((Object)afT);
        }
    }

    @Override
    public BigDecimal calculateTaksa(String vrsta) {
        BigDecimal kolicina = BDConverter.getKolicina(this.getKolicina());
        BigDecimal cena = BDConverter.getProdCena(this.getCena());
        BigDecimal vrednost = BDConverter.getIznos(cena.multiply(kolicina));
        BigDecimal procRabata100 = BDConverter.getProcRabata100(this.getProcRabata());
        BigDecimal iznosRabata = BDConverter.getIznos(vrednost.multiply(procRabata100));
        BigDecimal osnovica = BDConverter.getIznos(vrednost.subtract(iznosRabata));
        if (this.getDokument().getRadnajedinica().getgTip().equals("V") || this.getDokument().getRadnajedinica().getgTip().equals("T") || this.getDokument().getRadnajedinica().getgTip().equals("K") || this.getDokument().getRadnajedinica().getgTip().equals("G")) {
            if (vrsta.equals("PDV") && this.getTaksa("AKC") != null) {
                BigDecimal akcizaIznos = BDConverter.getIznos(this.getTaksa("AKC").getStopa());
                BigDecimal akcizaVrednost = BDConverter.getIznos(akcizaIznos.multiply(kolicina));
                osnovica = osnovica.add(akcizaVrednost);
            }
            if (vrsta.equals("AKC")) {
                return BDConverter.getIznos(this.getTaksa(vrsta).getStopa() * kolicina.doubleValue());
            }
            BigDecimal stopaPDV100 = BDConverter.getStopaPDVProc(this.getTaksa(vrsta).getStopa());
            BigDecimal iznosPDVa = BDConverter.getIznos(osnovica.multiply(stopaPDV100));
            return iznosPDVa;
        }
        if (vrsta.equals("AKC")) {
            return BDConverter.getIznos(this.getTaksa(vrsta).getStopa());
        }
        if (this.getDokument().getArhiviran() == 1) {
            return vrednost.subtract(this.calculateOsnovica(vrsta));
        }
        return osnovica.subtract(this.calculateOsnovica(vrsta));
    }

    @Override
    public BigDecimal calculateOsnovica(String vrsta) {
        BigDecimal kolicina = BDConverter.getKolicina(this.getKolicina());
        BigDecimal cena = BDConverter.getProdCena(this.getCena());
        BigDecimal vrednost = BDConverter.getIznos(cena.multiply(kolicina));
        BigDecimal procRabata100 = BDConverter.getProcRabata100(this.getProcRabata());
        BigDecimal iznosRabata = BDConverter.getIznos(vrednost.multiply(procRabata100));
        BigDecimal osnovica = BDConverter.getIznos(vrednost.subtract(iznosRabata));
        if (this.getDokument().getRadnajedinica().getgTip().equals("V") || this.getDokument().getRadnajedinica().getgTip().equals("T") || this.getDokument().getRadnajedinica().getgTip().equals("K") || this.getDokument().getRadnajedinica().getgTip().equals("G")) {
            if (vrsta.equals("PDV") && this.getTaksa("AKC") != null) {
                BigDecimal akcizaIznos = BDConverter.getIznos(this.getTaksa("AKC").getStopa());
                BigDecimal akcizaVrednost = BDConverter.getIznos(akcizaIznos.multiply(kolicina));
                osnovica = osnovica.add(akcizaVrednost);
            }
            return osnovica;
        }
        BigDecimal stopa = BDConverter.getStopaPDV(this.getTaksa(vrsta).getStopa());
        stopa = stopa.add(BDConverter.getIznos(100.0));
        BigDecimal iznosPDV = BDConverter.getIznos(stopa.doubleValue() / 100.0);
        if (this.getDokument().getArhiviran() == 1) {
            return BDConverter.getIznos(vrednost.doubleValue() / iznosPDV.doubleValue());
        }
        return BDConverter.getIznos(osnovica.doubleValue() / iznosPDV.doubleValue());
    }

    public boolean cekPRNCena(double procenatRabata, Stanjeartikal sta) {
        double iznosRabata = this.cena * procenatRabata / 100.0;
        return !(this.cena - iznosRabata < sta.getProsNabCena().doubleValue());
    }

    public BigDecimal naracunajIznosBezRabata() {
        BigDecimal iznosRabata;
        BigDecimal kolicina = BDConverter.getKolicina(this.getKolicina());
        BigDecimal cena = this.faktura.getKomitent() != null && this.faktura.getKomitent().getDomacaValuta() == 0 ? BDConverter.getProdCenaValuta(this.getCena()) : BDConverter.getProdCena(this.getCena());
        BigDecimal vrednost = this.faktura.getKomitent() != null && this.faktura.getKomitent().getDomacaValuta() == 0 ? BDConverter.getIznosValuta(cena.multiply(kolicina)) : BDConverter.getIznos(cena.multiply(kolicina));
        BigDecimal procRabata = BDConverter.getProcRabata100(this.getProcRabata());
        BigDecimal bigDecimal = iznosRabata = this.faktura.getKomitent() != null && this.faktura.getKomitent().getDomacaValuta() == 0 ? BDConverter.getIznosValuta(vrednost.multiply(procRabata)) : BDConverter.getIznos(vrednost.multiply(procRabata));
        if (this.faktura.getArhiviran() == 1 && this.faktura.getRadnajedinica().getgTip().equals("E")) {
            return vrednost;
        }
        return vrednost.subtract(iznosRabata);
    }

    public BigDecimal iznosSaPorezomVeleprodaja() {
        BigDecimal osnovica = this.naracunajIznosBezRabata();
        if (this.getTaksa("AKC") != null) {
            BigDecimal akcizaIznos = this.faktura.getKomitent() != null && this.faktura.getKomitent().getDomacaValuta() == 0 ? BDConverter.getIznosValuta(this.getTaksa("AKC").getStopa()) : BDConverter.getIznos(this.getTaksa("AKC").getStopa());
            BigDecimal akcizaVrednost = this.faktura.getKomitent() != null && this.faktura.getKomitent().getDomacaValuta() == 0 ? BDConverter.getIznosValuta(akcizaIznos.multiply(new BigDecimal(this.kolicina))) : BDConverter.getIznos(akcizaIznos.multiply(new BigDecimal(this.kolicina)));
            osnovica = osnovica.add(akcizaVrednost);
        }
        if (this.getTaksa("PDV").getOznTarGr().startsWith("S")) {
            return osnovica;
        }
        BigDecimal stopaPDV100 = BDConverter.getStopaPDVProc(this.getTaksa("PDV").getStopa());
        BigDecimal iznosPDVa = this.faktura.getKomitent() != null && this.faktura.getKomitent().getDomacaValuta() == 0 ? BDConverter.getIznosValuta(osnovica.multiply(stopaPDV100)) : BDConverter.getIznos(osnovica.multiply(stopaPDV100));
        BigDecimal ukupno = this.faktura.getKomitent() != null && this.faktura.getKomitent().getDomacaValuta() == 0 ? BDConverter.getIznosValuta(osnovica.add(iznosPDVa)) : BDConverter.getIznos(osnovica.add(iznosPDVa));
        return ukupno;
    }

    public BigDecimal iznosBezPorezaMaloprodaja() {
        BigDecimal vrednostBezPDVa;
        BigDecimal osnovica = this.naracunajIznosBezRabata();
        BigDecimal iznosPDV = this.faktura.getKomitent() != null && this.faktura.getKomitent().getDomacaValuta() == 0 ? BDConverter.getIznosValuta((100.0 + this.getTaksa("PDV").getStopa()) / 100.0) : BDConverter.getIznos((100.0 + this.getTaksa("PDV").getStopa()) / 100.0);
        BigDecimal bigDecimal = vrednostBezPDVa = this.faktura.getKomitent() != null && this.faktura.getKomitent().getDomacaValuta() == 0 ? BDConverter.getIznosValuta(osnovica.doubleValue() / iznosPDV.doubleValue()) : BDConverter.getIznos(osnovica.doubleValue() / iznosPDV.doubleValue());
        if (this.getTaksa("AKC") != null) {
            BigDecimal akcizaIznos = this.faktura.getKomitent() != null && this.faktura.getKomitent().getDomacaValuta() == 0 ? BDConverter.getIznosValuta(this.getTaksa("AKC").getStopa()) : BDConverter.getIznos(this.getTaksa("AKC").getStopa());
            BigDecimal akcizaVrednost = this.faktura.getKomitent() != null && this.faktura.getKomitent().getDomacaValuta() == 0 ? BDConverter.getIznosValuta(akcizaIznos.multiply(new BigDecimal(this.kolicina))) : BDConverter.getIznos(akcizaIznos.multiply(new BigDecimal(this.kolicina)));
            vrednostBezPDVa = vrednostBezPDVa.subtract(akcizaVrednost);
        }
        return this.faktura.getKomitent() != null && this.faktura.getKomitent().getDomacaValuta() == 0 ? BDConverter.getIznosValuta(vrednostBezPDVa) : BDConverter.getIznos(vrednostBezPDVa);
    }

    public Artikalfakturaparameter getArtikalfakturaparameter(String name) {
        for (Artikalfakturaparameter afp : this.getArtikalFakturaParameters()) {
            if (afp.getId().getIdDok() != this.getId().getIdDok() || !afp.getId().getName().equals(name) || afp.getId().getrBroj() != this.getId().getrBroj() || !afp.getId().getSfrProizvod().equals(this.getId().getSfrProizvod())) continue;
            return afp;
        }
        return null;
    }

    public double getCenaBezRabata() {
        if (this.procRabata == 0.0) {
            return this.cena;
        }
        return BDConverter.getIznos(new BigDecimal(this.cena).divide(BDConverter.getIznos(1.0 - this.procRabata / 100.0), 2, RoundingMode.HALF_UP)).doubleValue();
    }
}

