/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import rs.pezar.db.PzADTaksa;
import rs.pezar.db.entity.AodtaksaPK;
import rs.pezar.db.entity.Artikalopstidokument;
import rs.pezar.db.entity.Tarifnagrupa;

@Entity
@Table(name="AODTaksa")
public class Aodtaksa
extends PzADTaksa
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private AodtaksaPK id;
    @Column(nullable=false, length=100)
    private String opis;
    @Column(nullable=false, length=20)
    private String oznVrstaTG;
    @Column(nullable=false)
    private double stopa;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="idDok", referencedColumnName="IDDOK", nullable=false, insertable=false, updatable=false), @JoinColumn(name="sfrProizvod", referencedColumnName="SFRPROIZVOD", nullable=false, insertable=false, updatable=false), @JoinColumn(name="rBroj", referencedColumnName="RBROJ", nullable=false, insertable=false, updatable=false)})
    private Artikalopstidokument artikalopstidokument;

    public Aodtaksa() {
    }

    public Aodtaksa(Artikalopstidokument aod, Tarifnagrupa tgr) {
        this.id = new AodtaksaPK(aod.getId().getIdDok(), aod.getId().getSfrProizvod(), tgr.getOznTarGr(), aod.getId().getrBroj());
        this.artikalopstidokument = aod;
        this.opis = tgr.getVrstatg().getOpis();
        this.stopa = tgr.getStopa();
        this.oznVrstaTG = tgr.getVrstatg().getOznVrstaTG();
    }

    public AodtaksaPK getId() {
        return this.id;
    }

    public void setId(AodtaksaPK id) {
        this.id = id;
    }

    @Override
    public String getOpis() {
        return this.opis;
    }

    public void setOpis(String opis) {
        this.opis = opis;
    }

    @Override
    public String getOznVrstaTG() {
        return this.oznVrstaTG;
    }

    public void setOznVrstaTG(String oznaka) {
        this.oznVrstaTG = oznaka;
    }

    @Override
    public double getStopa() {
        return this.stopa;
    }

    public void setStopa(double stopa) {
        this.stopa = stopa;
    }

    public Artikalopstidokument getArtikalopstidokument() {
        return this.artikalopstidokument;
    }

    public void setArtikalopstidokument(Artikalopstidokument artikalopstidokument) {
        this.artikalopstidokument = artikalopstidokument;
    }

    @Override
    public String getOznTarGr() {
        return this.id.getOznTarGr();
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{"Oznaka TG", "Vrsta TG", "Stopa", "Opis"};
    }

    @Override
    public Object[] getValues() {
        return new Object[]{this.id.getOznTarGr(), this.oznVrstaTG, this.stopa, this.opis};
    }
}

