/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import rs.pezar.db.PzADTaksa;
import rs.pezar.db.entity.AirtaksaPK;
import rs.pezar.db.entity.Artikalinterniracun;
import rs.pezar.db.entity.Tarifnagrupa;

@Entity
@Table(name="AIRTaksa")
public class Airtaksa
extends PzADTaksa
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private AirtaksaPK id;
    private String oznVrstaTG;
    private String opis;
    @Column(nullable=false)
    private double stopa;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="sfrProizvod", referencedColumnName="sfrProizvod", nullable=false, insertable=false, updatable=false), @JoinColumn(name="idDok", referencedColumnName="idDok", nullable=false, insertable=false, updatable=false), @JoinColumn(name="rBroj", referencedColumnName="RBROJ", nullable=false, insertable=false, updatable=false)})
    private Artikalinterniracun artikalinterniracun;

    public Airtaksa() {
    }

    public Airtaksa(Artikalinterniracun artikalinterniracun2, Tarifnagrupa tgr) {
        this.id = new AirtaksaPK(artikalinterniracun2.getId().getIdDok(), artikalinterniracun2.getId().getSfrProizvod(), tgr.getOznTarGr(), artikalinterniracun2.getId().getrBroj());
        this.artikalinterniracun = artikalinterniracun2;
        this.opis = tgr.getVrstatg().getOpis();
        this.stopa = tgr.getStopa();
        this.oznVrstaTG = tgr.getVrstatg().getOznVrstaTG();
    }

    public AirtaksaPK getId() {
        return this.id;
    }

    public void setId(AirtaksaPK id) {
        this.id = id;
    }

    @Override
    public String getOznVrstaTG() {
        return this.oznVrstaTG;
    }

    public void setOznVrstaTG(String oznaka) {
        this.oznVrstaTG = oznaka;
    }

    @Override
    public String getOpis() {
        return this.opis;
    }

    public void setOpis(String opis) {
        this.opis = opis;
    }

    @Override
    public double getStopa() {
        return this.stopa;
    }

    public void setStopa(double stopa) {
        this.stopa = stopa;
    }

    public Artikalinterniracun getArtikalinterniracun() {
        return this.artikalinterniracun;
    }

    public void setArtikalinterniracun(Artikalinterniracun artikalinterniracun) {
        this.artikalinterniracun = artikalinterniracun;
    }

    @Override
    public String getOznTarGr() {
        return this.id.getOznTarGr();
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{"Oznaka TG", "Vrsta TG", "Stopa", "Opis"};
    }

    @Override
    public Object[] getValues() {
        return new Object[]{this.id.getOznTarGr(), this.oznVrstaTG, this.stopa, this.opis};
    }
}

