/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db;

import java.math.BigDecimal;
import java.util.List;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.PzADTaksa;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntityExtended;
import rs.pezar.db.entity.Tarifnagrupa;

public abstract class PzProizvodDokument
extends PzEntityExtended {
    public abstract double getKolicina();

    public abstract void setKolicina(double var1);

    public double getProcRabata() {
        return 0.0;
    }

    public void setProcRabata(double procRabata) {
    }

    public abstract double getCena();

    public abstract void setCena(double var1);

    public abstract void addTaksa(Tarifnagrupa var1);

    public abstract List<? extends PzADTaksa> getTaksas();

    public abstract void setNaziv(String var1);

    public abstract String getNaziv();

    public abstract PzDokument getDokument();

    public abstract void setDokument(PzDokument var1);

    public abstract void setSort(int var1);

    public abstract int getSort();

    public String getVrsta() {
        return this.getTaksa("PDV") != null && this.getTaksa("PDV").getOznTarGr().startsWith("U") ? "N" : this.getDokument().getVrsta();
    }

    public BigDecimal calculateTaksa(String vrsta) {
        BigDecimal stopa = BDConverter.getStopaPDV(this.getTaksa(vrsta).getStopa() / 100.0);
        BigDecimal kolicina = BDConverter.getKolicina(this.getKolicina());
        BigDecimal cena = BDConverter.getProdCena(this.getCena());
        PzDokument dokument = this.getDokument();
        if (dokument.getRadnajedinica().getgTip().equals("V") || dokument.getRadnajedinica().getgTip().equals("T") || dokument.getRadnajedinica().getgTip().equals("G")) {
            return BDConverter.getIznos(cena.multiply(kolicina).multiply(stopa));
        }
        return BDConverter.getIznos(BDConverter.getIznos(kolicina.multiply(cena)).multiply(stopa.multiply(new BigDecimal(100))).doubleValue() / new BigDecimal(100).add(stopa.multiply(new BigDecimal(100))).doubleValue());
    }

    public BigDecimal calculateOsnovica(String vrsta) {
        BigDecimal kolicina = BDConverter.getKolicina(this.getKolicina());
        BigDecimal cena = BDConverter.getProdCena(this.getCena());
        if (this.getDokument().getRadnajedinica().getgTip().equals("V") || this.getDokument().getRadnajedinica().getgTip().equals("T") || this.getDokument().getRadnajedinica().getgTip().equals("G")) {
            return BDConverter.getIznos(kolicina.multiply(cena));
        }
        return BDConverter.getIznos(kolicina.multiply(cena));
    }

    public PzADTaksa getTaksa(String vrsta) {
        PzADTaksa result = null;
        if (this.getTaksas() != null) {
            for (PzADTaksa pzADTaksa : this.getTaksas()) {
                if (!pzADTaksa.getOznVrstaTG().equals(vrsta)) continue;
                result = pzADTaksa;
                break;
            }
        }
        return result;
    }
}

