/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.persistence.EmbeddedId;
import javax.persistence.EntityManager;
import javax.persistence.Id;
import javax.persistence.Query;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.persistence.indirection.IndirectList;
import org.eclipse.persistence.queries.ScrollableCursor;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.PzArtikalDokument;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentException;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzProizvodDokument;
import rs.pezar.db.PzTaksaDokument;
import rs.pezar.db.PzUslugaDokument;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.commons.PzUser;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Artikaldokument;
import rs.pezar.db.entity.ArtikaldokumentPK;
import rs.pezar.db.entity.Artikalfaktura;
import rs.pezar.db.entity.Artikalinterniracun;
import rs.pezar.db.entity.Artikalnivelacija;
import rs.pezar.db.entity.Artikalopstidokument;
import rs.pezar.db.entity.Brojacrj;
import rs.pezar.db.entity.BrojacrjPK;
import rs.pezar.db.entity.Dokument;
import rs.pezar.db.entity.Dtaksa;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Id_gen;
import rs.pezar.db.entity.Interniracun;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.db.entity.Nivelacija;
import rs.pezar.db.entity.Opstidokument;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.db.entity.Taksakalkulacija;
import rs.pezar.db.entity.Taksanivelacija;
import rs.pezar.db.entity.Tarifnagrupa;
import rs.pezar.db.entity.Trosak;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.util.PzDateUtility;
import rs.pezar.util.PzMathUtility;

public class PzEntityUtil {
    public static String currentType = null;
    private static String popuna;
    private static Integer duzina;

    public static synchronized String formatirajSifru(String sifra) {
        if (popuna == null) {
            popuna = PzParameter.getParameterValue("POPUNA_SIFRE", "0");
        }
        if (duzina == null) {
            duzina = PzParameter.getInteger("DUZINA_SIFRE", 9);
        }
        return popuna.equals("") ? sifra : StringUtils.leftPad((String)sifra, (int)duzina, (String)popuna);
    }

    public static Object getID(PzEntity entity) {
        Object result = null;
        Class<?> c = entity.getClass();
        try {
            return PzEntityUtil.getID(entity, c);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        System.out.println((Object)result);
        return result;
    }

    private static Object getID(PzEntity entity, Class c) throws IllegalArgumentException, IllegalAccessException {
        Field[] fields = c.getDeclaredFields();
        Object result = null;
        int i = 0;
        while (i < fields.length) {
            if (fields[i].isAnnotationPresent(Id.class) || fields[i].isAnnotationPresent(EmbeddedId.class)) {
                fields[i].setAccessible(true);
                result = fields[i].get(entity);
                fields[i].setAccessible(false);
                break;
            }
            ++i;
        }
        if (result == null && c.getSuperclass() != null) {
            result = PzEntityUtil.getID(entity, c.getSuperclass());
        }
        return result;
    }

    public static HashMap<String, String> getFieldsAndValues(PzEntity entity) {
        HashMap<String, String> result = new HashMap<String, String>();
        Class<?> c = entity.getClass();
        try {
            Field[] fields = c.getDeclaredFields();
            int i = 0;
            while (i < fields.length) {
                fields[i].setAccessible(true);
                Object res = fields[i].get(entity);
                if (!(res == null || res.toString().equals("") || res.toString().equals("0") || res.toString().equals("0.0") || fields[i].getName().equals("serialVersionUID") || fields[i].getName().startsWith("_"))) {
                    result.put(fields[i].getName(), res.toString());
                }
                fields[i].setAccessible(false);
                ++i;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String strZero(String str, int length) {
        String result = str = str != null ? str : "";
        if (str.length() < length) {
            int i = 0;
            while (i < length - str.length()) {
                result = "0" + result;
                ++i;
            }
        }
        return result;
    }

    public static Nivelacija createNivelacija(PzDokument dokument, boolean naUkupnuKolicinu, boolean novaCenaNaDokumentu, EntityManager em) throws Exception {
        return PzEntityUtil.createNivelacija(dokument, naUkupnuKolicinu, novaCenaNaDokumentu, em, false);
    }

    /*
     * WARNING - void declaration
     */
    public static Nivelacija createNivelacija(PzDokument dokument, boolean naUkupnuKolicinu, boolean novaCenaNaDokumentu, EntityManager em, boolean izlaznaRj) throws Exception {
        void var17_18;
        boolean interniRacun = false;
        if (dokument == null || dokument.getTip().equals("NIVELACIJA") || dokument.getArtikalDocuments() == null || dokument.getArtikalDocuments().size() == 0) {
            return null;
        }
        Radnajedinica rj = null;
        if (dokument instanceof Interniracun) {
            interniRacun = true;
            rj = dokument.getTip().equals("ZADUZENJE_NASE_KONSIGNACIJE") || izlaznaRj ? ((Interniracun)dokument).getIzlaznaRJ() : ((Interniracun)dokument).getUlaznaRJ();
        } else {
            rj = dokument.getRadnajedinica();
        }
        IndirectList artikalnivelacijas = new IndirectList();
        BigDecimal novaVrednost = new BigDecimal("0");
        BigDecimal staraVrednost = new BigDecimal("0");
        int rBroj = 0;
        for (PzArtikalDokument pzArtikalDokument : dokument.getArtikalDocuments()) {
            double staraCena;
            double novaCena;
            Stanje stanje = (Stanje)em.find(Stanje.class, (Object)new StanjePK(pzArtikalDokument.getId().getSfrProizvod(), rj));
            if (stanje == null || pzArtikalDokument.getTaksa("PDV").getOznTarGr().startsWith("U")) continue;
            double kolicina = naUkupnuKolicinu ? stanje.getKolicina() : pzArtikalDokument.getKolicina();
            if (novaCenaNaDokumentu) {
                novaCena = interniRacun ? pzArtikalDokument.getCena(izlaznaRj) : pzArtikalDokument.getCena();
                staraCena = stanje.getProdCena();
            } else {
                novaCena = stanje.getProdCena();
                staraCena = interniRacun ? pzArtikalDokument.getCena(izlaznaRj) : pzArtikalDokument.getCena();
            }
            Artikalnivelacija an = null;
            if (stanje == null || novaCena == staraCena || !(stanje.getKolicina() > 0.0 || rj != null && rj.getTip().equals("EV")) && naUkupnuKolicinu || !(kolicina > 0.0)) continue;
            an = new Artikalnivelacija();
            Artikal art = pzArtikalDokument.getArtikal();
            an.setId(0, art.getSfrProizvod(), ++rBroj);
            an.setNaziv(art.getNaziv());
            an.setBliziOpis(art.getBliziOpis());
            an.setJm(art.getJedMere());
            an.setArtikal(art);
            for (Tarifnagrupa tgr : art.getTarifnagrupas()) {
                an.addTaksa(tgr);
            }
            an.setCenaNova(novaCena);
            an.setCenaStara(staraCena);
            an.setKolicina(kolicina);
            BigDecimal nv = BDConverter.getIznos(BDConverter.getProdCena(an.getCenaNova()).multiply(BDConverter.getKolicina(an.getKolicina())));
            BigDecimal sv = BDConverter.getIznos(BDConverter.getProdCena(an.getCenaStara()).multiply(BDConverter.getKolicina(an.getKolicina())));
            an.setVrednost(nv.subtract(sv));
            artikalnivelacijas.add((Object)an);
            novaVrednost = novaVrednost.add(nv);
            staraVrednost = staraVrednost.add(sv);
        }
        Object var17_16 = null;
        if (artikalnivelacijas.size() != 0) {
            Nivelacija nivelacija = new Nivelacija();
            nivelacija.setPoruka("Nivelacija automatski generisana uz dokument (ID: " + dokument.getIdDok() + ")");
            nivelacija.setPodok(dokument.getIdDok());
            nivelacija.setTip(TipDokumentConfig.get().NIVELACIJA);
            nivelacija.setPodTip(TipDokumentConfig.get().PODTIP_NIVELACIJA_STANDARDNA);
            nivelacija.setUserPoc(PzUser.getUser());
            nivelacija.setUserKraj(PzUser.getUser());
            nivelacija.setRadnajedinica(rj);
            nivelacija.setDatum(dokument.getDatum());
            nivelacija.setDatArh(new Date(new java.util.Date().getTime()));
            if (dokument.getRadnajedinica().getNacinVodjenja().equals("PRODAJNA")) {
                nivelacija.setCvProdajna((short)1);
            }
            nivelacija.setArtikalnivelacijas((List<Artikalnivelacija>)artikalnivelacijas);
            nivelacija.setNovaVrednost(novaVrednost);
            nivelacija.setStaraVrednost(staraVrednost);
            for (Artikalnivelacija an : nivelacija.getArtikalnivelacijas()) {
                an.setDokument(nivelacija);
            }
        }
        return var17_18;
    }

    public static Nivelacija createNivelacijaTransfer(Opstidokument dokument, EntityManager em) throws Exception {
        if (dokument == null || dokument.getTip().equals("NIVELACIJA") || dokument.getArtikalDocuments() == null || dokument.getArtikalDocuments().size() == 0) {
            return null;
        }
        Radnajedinica rj = dokument.getRadnajedinica();
        IndirectList artikalnivelacijas = new IndirectList();
        BigDecimal novaVrednost = new BigDecimal("0");
        BigDecimal staraVrednost = new BigDecimal("0");
        int rBroj = 0;
        for (Artikalopstidokument a : dokument.getArtikalopstidokuments()) {
            if (a.getArtikalopstidokument() == null) continue;
            Stanje stanje = (Stanje)em.find(Stanje.class, (Object)new StanjePK(a.getArtikalopstidokument().getId().getSfrProizvod(), rj));
            Stanje stanjeSa = (Stanje)em.find(Stanje.class, (Object)new StanjePK(a.getId().getSfrProizvod(), rj));
            if (stanje == null) continue;
            double kolicina = a.getKolicina();
            double novaCena = a.getArtikalopstidokument().getCenaSaPorezom();
            double staraCena = stanjeSa.getProdCena();
            Artikalnivelacija an = null;
            if (stanje == null || novaCena == staraCena || !(stanje.getKolicina() > 0.0) || !(kolicina > 0.0)) continue;
            an = new Artikalnivelacija();
            Artikal art = a.getArtikal();
            an.setId(0, art.getSfrProizvod(), ++rBroj);
            an.setNaziv(art.getNaziv());
            an.setBliziOpis(art.getBliziOpis());
            an.setJm(art.getJedMere());
            an.setArtikal(art);
            for (Tarifnagrupa tgr : art.getTarifnagrupas()) {
                an.addTaksa(tgr);
            }
            an.setCenaNova(novaCena);
            an.setCenaStara(staraCena);
            an.setKolicina(kolicina);
            BigDecimal nv = BDConverter.getIznos(BDConverter.getProdCena(an.getCenaNova()).multiply(BDConverter.getKolicina(an.getKolicina())));
            BigDecimal sv = BDConverter.getIznos(BDConverter.getProdCena(an.getCenaStara()).multiply(BDConverter.getKolicina(an.getKolicina())));
            an.setVrednost(nv.subtract(sv));
            artikalnivelacijas.add((Object)an);
            novaVrednost = novaVrednost.add(nv);
            staraVrednost = staraVrednost.add(sv);
        }
        Nivelacija nivel = null;
        if (artikalnivelacijas.size() != 0) {
            nivel = new Nivelacija();
            nivel.setTip(TipDokumentConfig.get().NIVELACIJA);
            nivel.setPodTip(TipDokumentConfig.get().PODTIP_NIVELACIJA_STANDARDNA);
            nivel.setUserPoc(PzUser.getUser());
            nivel.setUserKraj(PzUser.getUser());
            nivel.setRadnajedinica(rj);
            nivel.setDatum(dokument.getDatum());
            nivel.setDatArh(new Date(new java.util.Date().getTime()));
            if (dokument.getRadnajedinica().getNacinVodjenja().equals("PRODAJNA")) {
                nivel.setCvProdajna((short)1);
            }
            nivel.setArtikalnivelacijas((List<Artikalnivelacija>)artikalnivelacijas);
            nivel.setNovaVrednost(novaVrednost);
            nivel.setStaraVrednost(staraVrednost);
            for (Artikalnivelacija an : nivel.getArtikalnivelacijas()) {
                an.setDokument(nivel);
            }
        }
        return nivel;
    }

    public static Nivelacija createNivelacija(PzDokument dokument, ScrollableCursor cursor, boolean naUkupnuKolicinu, boolean novaCenaNaDokumentu, EntityManager em) throws Exception {
        double staraCena;
        double novaCena;
        double kolicina;
        if (dokument == null || dokument.getTip().equals("NIVELACIJA") || cursor == null || cursor.size() == 0) {
            return null;
        }
        Radnajedinica rj = null;
        rj = dokument instanceof Interniracun ? (dokument.getTip().equals("ZADUZENJE_NASE_KONSIGNACIJE") ? ((Interniracun)dokument).getIzlaznaRJ() : ((Interniracun)dokument).getUlaznaRJ()) : dokument.getRadnajedinica();
        BigDecimal novaVrednost = new BigDecimal("0");
        boolean trebaKreiratiNivelaciju = false;
        int rBroj = 0;
        Query q = null;
        while (cursor.hasNext()) {
            Object[] artikalDokument = (Object[])cursor.next();
            q = em.createQuery("SELECT s.id.sfrProizvod, s.kolicina, s.prodCena FROM Stanje s where s.radnajedinica=:rj and s.id.sfrProizvod=:sifra");
            q.setParameter("rj", (Object)dokument.getRadnajedinica());
            q.setParameter("sifra", artikalDokument[0]);
            Vector v = (Vector)q.getResultList();
            if (v == null || v.size() == 0) continue;
            Object[] stanje = (Object[])v.iterator().next();
            kolicina = naUkupnuKolicinu ? ((Double)stanje[1]).doubleValue() : ((Double)artikalDokument[1]).doubleValue();
            if (novaCenaNaDokumentu) {
                novaCena = (Double)artikalDokument[2];
                staraCena = (Double)stanje[2];
            } else {
                novaCena = (Double)stanje[2];
                staraCena = (Double)artikalDokument[2];
            }
            if (stanje == null || novaCena == staraCena || !((Double)stanje[1] > 0.0) || !(kolicina > 0.0)) continue;
            trebaKreiratiNivelaciju = true;
            break;
        }
        Nivelacija nivel = null;
        if (trebaKreiratiNivelaciju) {
            Brojacrj brKepu;
            Brojacrj brDok;
            Brojacrj brojac;
            nivel = new Nivelacija();
            nivel.setTip(TipDokumentConfig.get().NIVELACIJA);
            nivel.setPodTip(TipDokumentConfig.get().PODTIP_NIVELACIJA_STANDARDNA);
            nivel.setUserPoc(PzUser.getUser());
            nivel.setUserKraj(PzUser.getUser());
            nivel.setRadnajedinica(rj);
            nivel.setDatum(dokument.getDatum());
            nivel.setDatArh(new Date(new java.util.Date().getTime()));
            if (dokument.getRadnajedinica().getNacinVodjenja().equals("PRODAJNA")) {
                nivel.setCvProdajna((short)1);
            }
            if ((brojac = (Brojacrj)em.find(Brojacrj.class, (Object)new BrojacrjPK(nivel.getRadnajedinica().getId(), nivel.getTip(), nivel.getArhiviran()))) == null) {
                brojac = new Brojacrj();
                BrojacrjPK pk = new BrojacrjPK();
                pk.setArhiviran(nivel.getArhiviran());
                pk.setOznOgranak(nivel.getRadnajedinica().getId().getOznOgranak());
                pk.setOznRj(nivel.getRadnajedinica().getId().getOznRj());
                pk.setTip(nivel.getTip());
                brojac.setId(pk);
                brojac.setRadnajedinica(nivel.getRadnajedinica());
                brojac.setRBroj(0);
            }
            if ((brDok = (Brojacrj)em.find(Brojacrj.class, (Object)new BrojacrjPK(nivel.getRadnajedinica().getId(), "DOKUMENT", nivel.getArhiviran()))) == null) {
                brDok = new Brojacrj();
                BrojacrjPK pk = new BrojacrjPK();
                pk.setArhiviran(nivel.getArhiviran());
                pk.setOznOgranak(nivel.getRadnajedinica().getId().getOznOgranak());
                pk.setOznRj(nivel.getRadnajedinica().getId().getOznRj());
                pk.setTip("DOKUMENT");
                brDok.setId(pk);
                brDok.setRadnajedinica(nivel.getRadnajedinica());
                brDok.setRBroj(0);
            }
            if ((brKepu = (Brojacrj)em.find(Brojacrj.class, (Object)new BrojacrjPK(nivel.getRadnajedinica().getId(), "KEPU", nivel.getArhiviran()))) == null) {
                brKepu = new Brojacrj();
                BrojacrjPK pk = new BrojacrjPK();
                pk.setArhiviran(nivel.getArhiviran());
                pk.setOznOgranak(nivel.getRadnajedinica().getId().getOznOgranak());
                pk.setOznRj(nivel.getRadnajedinica().getId().getOznRj());
                pk.setTip("KEPU");
                brKepu.setId(pk);
                brKepu.setRadnajedinica(nivel.getRadnajedinica());
                brKepu.setRBroj(0);
            }
            if (nivel.getIdDok() == 0) {
                Id_gen dokId = (Id_gen)em.find(Id_gen.class, (Object)"DOKUMENT_ID");
                if (dokId == null) {
                    dokId = new Id_gen();
                    dokId.setIdName("DOKUMENT_ID");
                    dokId.setIdVal(1);
                }
                dokId.setIdVal(dokId.getIdVal() + 1);
                em.merge((Object)dokId);
                nivel.setIdDok(dokId.getIdVal());
            }
            nivel.adjust();
            brojac.setRBroj(brojac.getRBroj() + 1);
            brDok.setRBroj(brDok.getRBroj() + 1);
            brKepu.setRBroj(brKepu.getRBroj() + 1);
            nivel.setrBroj(brojac.getRBroj());
            nivel.setRbrDok(brDok.getRBroj());
            nivel.setArhiviran((short)1);
            nivel.setDatArh(PzDateUtility.getCurrentDate());
            nivel.formirajOznaku();
            nivel.setRadnajedinica(dokument.getRadnajedinica());
            nivel.setUserPoc(dokument.getUserPoc());
            nivel.setUserKraj(dokument.getUserKraj());
            Dokument dok = new Dokument(nivel, true);
            nivel.setDokument(dok);
            em.merge((Object)brojac);
            em.merge((Object)brDok);
            em.merge((Object)brKepu);
            em.persist((Object)dok);
            em.persist((Object)nivel);
            String query = "SELECT s.id.sfrProizvod, s.kolicina, s.prodCena FROM Stanje s where s.radnajedinica=:rj";
            q = em.createQuery(query);
            q.setParameter("rj", (Object)dokument.getRadnajedinica());
            Vector v = (Vector)q.getResultList();
            cursor.absolute(0);
            while (cursor.hasNext()) {
                Object[] artikalDokument = (Object[])cursor.next();
                if (v == null || v.size() == 0) continue;
                Object[] stanje = PzEntityUtil.pronadjiUVektoru(v, (String)artikalDokument[0]);
                kolicina = naUkupnuKolicinu ? (stanje != null ? (Double)stanje[1] : 0.0) : (Double)artikalDokument[1];
                if (novaCenaNaDokumentu) {
                    novaCena = (Double)artikalDokument[2];
                    staraCena = stanje != null ? (Double)stanje[2] : 0.0;
                } else {
                    novaCena = stanje != null ? (Double)stanje[2] : 0.0;
                    staraCena = (Double)artikalDokument[2];
                }
                Artikalnivelacija an = null;
                if (stanje == null || novaCena == staraCena || !((Double)stanje[1] > 0.0) || !(kolicina > 0.0)) continue;
                an = new Artikalnivelacija();
                an.setId(nivel.getIdDok(), (String)artikalDokument[0], ++rBroj);
                an.setNaziv((String)artikalDokument[3]);
                an.setBliziOpis((String)artikalDokument[4]);
                an.setJm((String)artikalDokument[5]);
                an.setCenaNova(novaCena);
                an.setCenaStara(staraCena);
                an.setKolicina(kolicina);
                BigDecimal nv = PzMathUtility.roundToBigDecimal(an.getCenaNova() * an.getKolicina());
                BigDecimal sv = PzMathUtility.roundToBigDecimal(an.getCenaStara() * an.getKolicina());
                an.setVrednost(nv.subtract(sv));
                em.persist((Object)an);
                Artikaldokument artDok = new Artikaldokument();
                artDok.setId(new ArtikaldokumentPK(nivel.getIdDok(), an.getId().getSfrProizvod(), an.getId().getrBroj()));
                artDok.setVrsta("L");
                artDok.setCena(an.getCena());
                artDok.setNaziv(an.getNaziv());
                artDok.setBliziOpis(an.getBliziOpis());
                artDok.setKolicina(an.getKolicina());
                artDok.setProcRabata(an.getProcRabata());
                artDok.setJm(an.getJm());
                artDok.setVrednost(an.getVrednost());
                em.persist((Object)artDok);
                novaVrednost = novaVrednost.add(PzMathUtility.roundToBigDecimal(an.getCenaNova()).multiply(new BigDecimal(an.getKolicina())));
            }
            nivel.setNovaVrednost(novaVrednost);
            query = "INSERT INTO ANTaksa (oznTarGr, idDok, sfrProizvod, rBroj, oznVrstaTG, stopa, opis) (SELECT tga.oznTarGr, :idDok, tga.sfrProizvod, an.rBroj, tg.oznVrstaTg, tg.stopa, '' FROM TGArtikal tga, ArtikalNivelacija an, TarifnaGrupa tg WHERE an.idDok=:idDok AND tga.sfrProizvod = an.sfrProizvod AND tg.oznTarGr = tga.oznTarGr)";
            query = query.replaceAll(":idDok", "" + nivel.getIdDok());
            q = em.createNativeQuery(query);
            q.executeUpdate();
            query = "INSERT INTO ADTaksa (oznTarGr, idDok, sfrProizvod, rBroj, oznVrstaTG, stopa, opis) " + "(SELECT at.oznTarGr, at.idDok, at.sfrProizvod, at.rBroj, at.oznVrstaTG, at.stopa, at.opis FROM ANTaksa at WHERE at.idDok=:idDok)".replace(":idDok", String.valueOf(nivel.getIdDok()));
            query = query.replaceAll(":idDok", "" + nivel.getIdDok());
            q = em.createNativeQuery(query);
            q.executeUpdate();
            q = em.createQuery("SELECT DISTINCT t.id.oznTarGr, t.oznVrstaTG FROM Antaksa t WHERE t.id.idDok=" + nivel.getIdDok());
            List tarGrupe = q.getResultList();
            for (Object[] tgr : tarGrupe) {
                Tarifnagrupa tGrupa = (Tarifnagrupa)em.find(Tarifnagrupa.class, tgr[0]);
                q = em.createQuery("SELECT a.kolicina, a.cenaStara, a.cenaNova, t.stopa FROM Artikalnivelacija a JOIN a.antaksas t WHERE t.id.oznTarGr='" + tgr[0] + "' AND t.id.idDok=" + nivel.getIdDok());
                List values = q.getResultList();
                String tip = nivel.getRadnajedinica().getgTip().equals("V") || nivel.getRadnajedinica().getgTip().equals("T") ? PzTaksaDokument.TIP_IZRACUNATI : PzTaksaDokument.TIP_UKALKULISANI;
                Taksanivelacija tn = new Taksanivelacija(nivel.getIdDok(), tip, (String)tgr[0]);
                BigDecimal osnovicaNova = new BigDecimal(0.0);
                BigDecimal osnovicaStara = new BigDecimal(0.0);
                BigDecimal iznosNovi = new BigDecimal(0.0);
                BigDecimal iznosStari = new BigDecimal(0.0);
                for (Object[] value : values) {
                    osnovicaStara = osnovicaStara.add(PzEntityUtil.calculateOsnovica((Double)value[0], (Double)value[1], (Double)value[3], nivel));
                    iznosStari = iznosStari.add(PzEntityUtil.calculateTaksa((Double)value[0], (Double)value[1], (Double)value[3], nivel));
                    osnovicaNova = osnovicaNova.add(PzEntityUtil.calculateOsnovica((Double)value[0], (Double)value[2], (Double)value[3], nivel));
                    iznosNovi = iznosNovi.add(PzEntityUtil.calculateTaksa((Double)value[0], (Double)value[2], (Double)value[3], nivel));
                }
                if (tn.getTip().equals(PzTaksaDokument.TIP_IZRACUNATI)) {
                    tn.setOsnovica(osnovicaNova.subtract(osnovicaStara));
                    tn.setIznos(tn.getOsnovica().multiply(BDConverter.getStopaPDVProc(tGrupa.getStopa())));
                } else {
                    tn.setOsnovica(osnovicaNova.subtract(osnovicaStara));
                    tn.setIznos(iznosNovi.subtract(iznosStari));
                }
                tn.setNivelacija(nivel);
                tn.setTarifnagrupa(tGrupa);
                tn.setVrsta((String)tgr[1]);
                em.persist((Object)tn);
                Dtaksa dt = new Dtaksa(tn, nivel.getDokument());
                em.persist((Object)dt);
                if (nivel.getTaksanivelacijas() == null) {
                    nivel.setTaksanivelacijas(new Vector<Taksanivelacija>());
                }
                nivel.getTaksanivelacijas().add(tn);
            }
        }
        return nivel;
    }

    private static BigDecimal calculateOsnovica(double kolicina, double cena, double stopa, Nivelacija n) {
        BigDecimal kolicinaBD = BDConverter.getKolicina(kolicina);
        BigDecimal cenaBD = BDConverter.getProdCena(cena);
        if (n.getRadnajedinica().getgTip().equals("V") || n.getRadnajedinica().getgTip().equals("T")) {
            return BDConverter.getIznos(kolicinaBD.multiply(cenaBD));
        }
        return BDConverter.getIznos(kolicinaBD.multiply(cenaBD));
    }

    private static BigDecimal calculateTaksa(double kolicina, double cena, double stopa, Nivelacija n) {
        BigDecimal kolicinaBD = BDConverter.getKolicina(kolicina);
        BigDecimal cenaBD = BDConverter.getProdCena(cena);
        BigDecimal stopaBD = BDConverter.getStopaPDVProc(stopa);
        BDConverter.getIznos(kolicina * cena);
        if (n.getRadnajedinica().getgTip().equals("V") || n.getRadnajedinica().getgTip().equals("T")) {
            return BDConverter.getIznos(cenaBD.multiply(kolicinaBD).multiply(stopaBD));
        }
        return BDConverter.getIznos(kolicinaBD.multiply(cenaBD).multiply(stopaBD.multiply(new BigDecimal(100))).doubleValue() / new BigDecimal(100).add(stopaBD.multiply(new BigDecimal(100))).doubleValue());
    }

    private static Object[] pronadjiUVektoru(Vector<Object[]> vektor, String sifra) {
        Iterator<Object[]> cur = vektor.iterator();
        boolean found = false;
        while (cur.hasNext() && !found) {
            Object[] obj = cur.next();
            String sifraKursor = (String)obj[0];
            if (!sifraKursor.equals(sifra)) continue;
            found = true;
            return obj;
        }
        return null;
    }

    public static PzDokument createStorno(PzDokument original) throws Exception {
        EntityManager em = PzEntityManager.getEm();
        PzDokument storno = null;
        storno = PzEntityUtil.createStorno(original, em);
        em.close();
        return storno;
    }

    public static PzDokument createStorno(PzDokument original, EntityManager em) throws PzDokumentException, IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        if (original.getIznos().equals(original.getStornoIznos())) {
            throw new PzDokumentException(PzDokumentException.EXCEPTION_STORNIRAN, "Dokument je ve\u0107 u potpunosti storniran! Dalji rad nemogu\u0107!");
        }
        String className = original.getClass().getSimpleName();
        PzDokument temp = (PzDokument)em.find(original.getClass(), (Object)original.getIdDok());
        em.detach((Object)temp);
        PzDokument kopija = (PzDokument)BeanUtils.cloneBean((Object)temp);
        Query q = em.createQuery("SELECT d FROM " + className + " d WHERE d.arhiviran=1 and d.storno=1 AND d.original.idDok = " + kopija.getIdDok());
        Vector stornoDokumenti = (Vector)q.getResultList();
        if (stornoDokumenti != null && stornoDokumenti.size() > 0) {
            for (PzDokument stornoDok : stornoDokumenti) {
                Iterator<? extends PzArtikalDokument> i = stornoDok.getArtikalDocuments().iterator();
                while (i.hasNext()) {
                    PzEntityUtil.umanjiKolicinu(kopija, i.next());
                }
            }
            for (PzDokument dok : stornoDokumenti) {
                Iterator<? extends PzTaksaDokument> td = dok.getTaksadokuments().iterator();
                while (td.hasNext()) {
                    PzEntityUtil.umanjiPorez(kopija, td.next());
                }
            }
            if (className.equalsIgnoreCase("kalkulacija")) {
                Vector stornoKalk = stornoDokumenti;
                for (Kalkulacija k : stornoKalk) {
                    ((Kalkulacija)kopija).setTrosakBezPdv(((Kalkulacija)kopija).getTrosakBezPdv().subtract(k.getTrosakBezPdv()));
                    for (Trosak trosakPomocni : k.getTrosaks()) {
                        PzEntityUtil.umanjiTrosak(kopija, trosakPomocni);
                        if (trosakPomocni.getTaksakalkulacijas() == null) continue;
                        Iterator<Taksakalkulacija> tt = trosakPomocni.getTaksakalkulacijas().iterator();
                        while (tt.hasNext()) {
                            PzEntityUtil.umanjiTaksaTrosak(kopija, tt.next());
                        }
                    }
                }
            }
        }
        kopija.setProknjizen((short)0);
        return kopija;
    }

    public static Object izracunajTakse(Vector original, Vector stornoDokumenti) {
        return null;
    }

    private static void umanjiKolicinu(PzDokument original, PzArtikalDokument next) {
        for (PzArtikalDokument pzArtikalDokument : original.getArtikalDocuments()) {
            BigDecimal nextKolicina;
            if (!pzArtikalDokument.getId().getSfrProizvod().equals(next.getId().getSfrProizvod()) || pzArtikalDokument.getId().getrBroj() != next.getId().getrBroj()) continue;
            BigDecimal artDokKolicina = BDConverter.getKolicina(pzArtikalDokument.getKolicina());
            BigDecimal razlika = artDokKolicina.subtract(nextKolicina = BDConverter.getKolicina(next.getKolicina()));
            if (razlika.equals(new BigDecimal("0.00"))) {
                original.getArtikalDocuments().remove(pzArtikalDokument);
                break;
            }
            pzArtikalDokument.setKolicina(razlika.doubleValue());
            break;
        }
    }

    private static void umanjiPorez(PzDokument original, PzTaksaDokument next) {
        for (PzTaksaDokument pzTaksaDokument : original.getTaksadokuments()) {
            if (!pzTaksaDokument.getTarifnagrupa().equals(next.getTarifnagrupa())) continue;
            if (pzTaksaDokument.getIznos().subtract(next.getIznos()).equals(new BigDecimal("0"))) {
                original.getTaksadokuments().remove(pzTaksaDokument);
                break;
            }
            pzTaksaDokument.setOsnovica(pzTaksaDokument.getOsnovica().subtract(next.getOsnovica()));
            pzTaksaDokument.setIznos(pzTaksaDokument.getIznos().subtract(next.getIznos()));
        }
    }

    private static void umanjiTrosak(PzDokument original, Trosak next) {
        for (Trosak trosak : ((Kalkulacija)original).getTrosaks()) {
            if (!trosak.getOznDokumenta().equals(next.getOznDokumenta()) || !trosak.getPodTip().equals(next.getPodTip())) continue;
            if (trosak.getBezPrava().subtract(next.getBezPrava()).doubleValue() == 0.0 && trosak.getOslobodjeno().subtract(next.getOslobodjeno()).doubleValue() == 0.0 && trosak.getOsnovica().subtract(next.getOsnovica()).doubleValue() == 0.0) {
                ((Kalkulacija)original).getTrosaks().remove(trosak);
                break;
            }
            trosak.setBezPrava(trosak.getBezPrava().subtract(next.getBezPrava()));
            trosak.setOslobodjeno(trosak.getOslobodjeno().subtract(next.getOslobodjeno()));
            trosak.setOsnovica(trosak.getOsnovica().subtract(next.getOsnovica()));
        }
    }

    private static void umanjiTaksaTrosak(PzDokument original, Taksakalkulacija next) {
        Taksakalkulacija tt = next;
        for (Trosak trOriginal : ((Kalkulacija)original).getTrosaks()) {
            if (trOriginal.getTaksakalkulacijas() == null) continue;
            for (Taksakalkulacija ttPomocni : trOriginal.getTaksakalkulacijas()) {
                if (!ttPomocni.getKalkulacija().getOznDokumenta().equals(tt.getKalkulacija().getOznDokumenta()) || !ttPomocni.getKalkulacija().getPodTip().equals(tt.getKalkulacija().getPodTip()) || ttPomocni.getTarifnagrupa() != tt.getTarifnagrupa()) continue;
                ttPomocni.setOsnovica(ttPomocni.getOsnovica().subtract(tt.getOsnovica()));
                ttPomocni.setIznos(ttPomocni.getIznos().subtract(tt.getIznos()));
            }
        }
    }

    public static void addTaksaDokuments(PzDokument dok, String vrsta) {
        if (dok.getArtikalDocuments() != null && dok.getArtikalDocuments().size() > 0) {
            for (PzArtikalDokument pzArtikalDokument : dok.getArtikalDocuments()) {
                PzEntityUtil.addTaksa(pzArtikalDokument, dok, dok.getRadnajedinica(), vrsta);
            }
        }
        if (dok.getUslugaDocuments() != null && dok.getUslugaDocuments().size() > 0) {
            for (PzUslugaDokument pzUslugaDokument : dok.getUslugaDocuments()) {
                PzEntityUtil.addTaksa(pzUslugaDokument, dok, dok.getRadnajedinica(), vrsta);
            }
        }
    }

    public static void addTaksaInterniracuns(Interniracun dok) {
        for (Artikalinterniracun ai : dok.getArtikalinterniracuns()) {
            dok.setVrsta("I");
            PzEntityUtil.addTaksa(ai, dok, dok.getIzlaznaRJ(), "PDV");
            dok.setVrsta("U");
            PzEntityUtil.addTaksa(ai, dok, dok.getUlaznaRJ(), "PDV");
        }
        dok.setVrsta("N");
    }

    private static synchronized void addTaksa(PzProizvodDokument ad, PzDokument dok, Radnajedinica rj, String vrsta) {
        if (dok.getTaksadokuments() == null) {
            return;
        }
        boolean found = false;
        Tarifnagrupa tg = null;
        try {
            if (ad.getTaksa(vrsta) == null) {
                return;
            }
            tg = (Tarifnagrupa)PzEntityManager.find(Tarifnagrupa.class, ad.getTaksa(vrsta).getOznTarGr());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        for (PzTaksaDokument pzTaksaDokument : dok.getTaksadokuments()) {
            if (!pzTaksaDokument.getTarifnagrupa().getOznTarGr().equals(tg.getOznTarGr()) || !rj.getId().getOznRj().equals(pzTaksaDokument.getIndikator())) continue;
            if ((rj.getgTip().equals("V") || rj.getgTip().equals("T") || rj.getgTip().equals("K") || rj.getgTip().equals("G") || rj.getgTip().equals("S")) && (pzTaksaDokument.getTip().equals(PzTaksaDokument.TIP_IZRACUNATI) || pzTaksaDokument.getTip().equals("I") || pzTaksaDokument.getTip().equals("U"))) {
                pzTaksaDokument.setIznos(BDConverter.getIznos(pzTaksaDokument.getIznos().add(ad.calculateTaksa(vrsta))));
                if (dok.getTip().equals("PRIMO_PREDAJNICA") && dok.getVrsta().equals("I")) {
                    pzTaksaDokument.setTip("I");
                } else if (dok.getTip().equals("PRIMO_PREDAJNICA") && dok.getVrsta().equals("U")) {
                    pzTaksaDokument.setTip("U");
                } else {
                    pzTaksaDokument.setTip(PzTaksaDokument.TIP_IZRACUNATI);
                }
                pzTaksaDokument.setOsnovica(BDConverter.getIznos(pzTaksaDokument.getOsnovica().add(ad.calculateOsnovica(vrsta))));
                found = true;
                continue;
            }
            if (!rj.getgTip().equals("E") || !pzTaksaDokument.getTip().equals(PzTaksaDokument.TIP_UKALKULISANI) && !pzTaksaDokument.getTip().equals("I") && !pzTaksaDokument.getTip().equals("U")) continue;
            pzTaksaDokument.setIznos(BDConverter.getIznos(pzTaksaDokument.getIznos().add(ad.calculateTaksa(vrsta))));
            if (dok.getTip().equals("PRIMO_PREDAJNICA") && dok.getVrsta().equals("I")) {
                pzTaksaDokument.setTip("I");
            } else if (dok.getTip().equals("PRIMO_PREDAJNICA") && dok.getVrsta().equals("U")) {
                pzTaksaDokument.setTip("U");
            } else {
                pzTaksaDokument.setTip(PzTaksaDokument.TIP_UKALKULISANI);
            }
            pzTaksaDokument.setOsnovica(BDConverter.getIznos(pzTaksaDokument.getOsnovica().add(ad.calculateOsnovica(vrsta))));
            found = true;
        }
        if (!found) {
            PzTaksaDokument pzTaksaDokument = dok.createEmptyTaksaDokument(tg.getOznTarGr(), null);
            pzTaksaDokument.setVrsta(vrsta);
            pzTaksaDokument.setTarifnagrupa(tg);
            if (ad instanceof PzArtikalDokument) {
                if (rj.getgTip().equals("V") || rj.getgTip().equals("T") || rj.getgTip().equals("K") || rj.getgTip().equals("G") || rj.getgTip().equals("S")) {
                    pzTaksaDokument.setIznos(ad.calculateTaksa(vrsta));
                    pzTaksaDokument.setOsnovica(ad.calculateOsnovica(vrsta));
                    if (dok.getTip().equals("PRIMO_PREDAJNICA") && dok.getVrsta().equals("I")) {
                        pzTaksaDokument.setTip("I");
                    } else if (dok.getTip().equals("PRIMO_PREDAJNICA") && dok.getVrsta().equals("U")) {
                        pzTaksaDokument.setTip("U");
                    } else {
                        pzTaksaDokument.setTip(PzTaksaDokument.TIP_IZRACUNATI);
                    }
                } else {
                    pzTaksaDokument.setIznos(BDConverter.getIznos(ad.calculateTaksa(vrsta)));
                    pzTaksaDokument.setOsnovica(ad.calculateOsnovica(vrsta));
                    if (dok.getTip().equals("PRIMO_PREDAJNICA") && dok.getVrsta().equals("I")) {
                        pzTaksaDokument.setTip("I");
                    } else if (dok.getTip().equals("PRIMO_PREDAJNICA") && dok.getVrsta().equals("U")) {
                        pzTaksaDokument.setTip("U");
                    } else {
                        pzTaksaDokument.setTip(PzTaksaDokument.TIP_UKALKULISANI);
                    }
                }
            } else {
                pzTaksaDokument.setIznos(ad.calculateTaksa(vrsta));
                pzTaksaDokument.setOsnovica(ad.calculateOsnovica(vrsta));
                pzTaksaDokument.setTip(PzTaksaDokument.TIP_IZRACUNATI);
            }
            if (dok.obracunavaSePorez(pzTaksaDokument.getTarifnagrupa(), pzTaksaDokument.getTip())) {
                dok.getTaksadokuments().add(pzTaksaDokument);
            }
            pzTaksaDokument.setIndikator(rj.getId().getOznRj());
        }
    }

    public static void osveziPRNC(PzDokument dokument, EntityManager em) {
        if (dokument instanceof Interniracun) {
            PzEntityUtil.osveziPRNCInterniRacun((Interniracun)dokument, em);
        } else {
            if (dokument.getRadnajedinica() == null || !"V".equals(dokument.getRadnajedinica().getgTip()) && !"S".equals(dokument.getRadnajedinica().getgTip())) {
                return;
            }
            if (dokument.getArtikalDocuments() != null && dokument.getArtikalDocuments().size() > 0) {
                String sifre = "";
                int i = 0;
                while (i < dokument.getArtikalDocuments().size()) {
                    sifre = String.valueOf(sifre) + (i == 0 ? "" : ",") + "'" + dokument.getArtikalDocuments().get(i).getId().getSfrProizvod() + "'";
                    ++i;
                }
                sifre = "(" + sifre + ")";
                Query q = em.createQuery("SELECT s.id.sfrProizvod, s.prosNabCena FROM Stanje s WHERE s.id.sfrProizvod IN " + sifre + " AND s.radnajedinica=:rj");
                q.setParameter("rj", (Object)dokument.getRadnajedinica());
                List res = q.getResultList();
                for (PzArtikalDokument pzArtikalDokument : dokument.getArtikalDocuments()) {
                    for (Object[] row : res) {
                        if (!pzArtikalDokument.getId().getSfrProizvod().equals(row[0])) continue;
                        pzArtikalDokument.setProsNabCena((BigDecimal)row[1]);
                    }
                }
            }
        }
    }

    private static void osveziPRNCInterniRacun(Interniracun dokument, EntityManager em) {
        if (!dokument.getUlaznaRJ().getgTip().equals("V") && !dokument.getIzlaznaRJ().getgTip().equals("V")) {
            return;
        }
        if (dokument.getArtikalinterniracuns() != null && dokument.getArtikalinterniracuns().size() > 0) {
            String sifre = "";
            int i = 0;
            while (i < dokument.getArtikalinterniracuns().size()) {
                sifre = String.valueOf(sifre) + (i == 0 ? "" : ",") + "'" + dokument.getArtikalinterniracuns().get(i).getId().getSfrProizvod() + "'";
                ++i;
            }
            sifre = "(" + sifre + ")";
            if (dokument.getUlaznaRJ().getgTip().equals("V")) {
                PzEntityUtil.osveziPRNCInterniRacun(sifre, dokument.getUlaznaRJ(), dokument.getArtikalinterniracuns(), "ulaz", em);
            }
            if (dokument.getIzlaznaRJ().getgTip().equals("V")) {
                PzEntityUtil.osveziPRNCInterniRacun(sifre, dokument.getIzlaznaRJ(), dokument.getArtikalinterniracuns(), "izlaz", em);
            }
        }
    }

    private static void osveziPRNCInterniRacun(String sifre, Radnajedinica rj, List<Artikalinterniracun> artikaldokuments, String ulazIzlaz, EntityManager em) {
        Query q = em.createQuery("SELECT s.id.sfrProizvod, s.prosNabCena FROM Stanje s WHERE s.id.sfrProizvod IN " + sifre + " AND s.radnajedinica=:rj");
        q.setParameter("rj", (Object)rj);
        List res = q.getResultList();
        for (Artikalinterniracun a : artikaldokuments) {
            for (Object[] row : res) {
                if (!a.getId().getSfrProizvod().equals(row[0])) continue;
                if (ulazIzlaz.equals("ulaz")) {
                    a.setUlProsNabCena((BigDecimal)row[1]);
                    continue;
                }
                a.setIzlProsNabCena((BigDecimal)row[1]);
            }
        }
    }

    public static Interniracun createInterniNalog(Faktura f, Radnajedinica ulaznaRJ, EntityManager em) throws Exception {
        Radnajedinica izlaznaRJ = f.getRadnajedinica();
        Interniracun interniNalog = new Interniracun();
        interniNalog.setIdDok(0);
        interniNalog.setStorno(0);
        interniNalog.setArhiviran((short)0);
        interniNalog.setTip("INTERNI_NALOG");
        interniNalog.setIzlaznaRJ(izlaznaRJ);
        interniNalog.setUlaznaRJ(ulaznaRJ);
        interniNalog.setDatum(PzDateUtility.getCurrentDate());
        interniNalog.setDatArh(PzDateUtility.getCurrentDate());
        interniNalog.setProknjizen((short)0);
        interniNalog.setProcRabata(0.0);
        interniNalog.setVredNaIzlazu(new BigDecimal("0.00"));
        interniNalog.setVredNaUlazu(new BigDecimal("0.00"));
        interniNalog.setPdvIznos(new BigDecimal("0.00"));
        interniNalog.setRjIzlaz(izlaznaRJ.getPunNaziv());
        interniNalog.setRjUlaz(ulaznaRJ.getPunNaziv());
        interniNalog.setCvProdajna((short)(PzParameter.getBoolean("C_V_PRODAJNA", true) != false ? 1 : 0));
        interniNalog.setArtikalinterniracuns(new Vector<Artikalinterniracun>());
        for (Artikalfaktura af : f.getArtikalfakturas()) {
            Stanje stanjeIzlaz = null;
            Stanje stanjeUlaz = null;
            Artikalinterniracun air = new Artikalinterniracun();
            air = new Artikalinterniracun();
            air.init(af.getArtikal(), (PzDokument)interniNalog);
            air.setKolicina(af.getKolicina());
            double ulaznaCena = af.getCena();
            double iznosRabata = af.getCena() * af.getProcRabata() / 100.0;
            System.out.println(String.valueOf(af.getId().getSfrProizvod()) + "************************S T O P A " + af.getTaksa("PDV").getStopa());
            double iznosPDVa = (ulaznaCena -= iznosRabata) * af.getTaksa("PDV").getStopa() / 100.0;
            air.setUlCena(ulaznaCena += iznosPDVa);
            af.setCena(ulaznaCena);
            af.setProcRabata(0.0);
            air.setProcRabata(0.0);
            air.setProcMarze(0.0);
            air.setInterniracun(interniNalog);
            air.setDokument(interniNalog);
            StanjePK stanjeIzlazpk = new StanjePK(air.getId().getSfrProizvod(), interniNalog.getIzlaznaRJ());
            stanjeIzlaz = (Stanje)em.find(Stanje.class, (Object)stanjeIzlazpk);
            stanjeIzlaz.setAlocKolicina(stanjeIzlaz.getAlocKolicina() - air.getKolicina());
            stanjeIzlaz.setKolicina(stanjeIzlaz.getKolicina() - air.getKolicina());
            stanjeIzlaz.setDatZadIzlaza(interniNalog.getDatum());
            stanjeIzlaz.setKumIzlaza(stanjeIzlaz.getKumIzlaza() + air.getKolicina());
            if (interniNalog.getCvProdajna() == 0) {
                air.setIzlCena(stanjeIzlaz.getProsNabCena().doubleValue());
            } else {
                air.setIzlCena(stanjeIzlaz.getProdCena());
            }
            air.setIzlProdCena(BDConverter.getProdCena(stanjeIzlaz.getProdCena()));
            air.setCvProdajnaIznos(stanjeIzlaz.getProdCena());
            air.setIzlProsNabCena(stanjeIzlaz.getProsNabCena());
            air.setUlProdCena(BDConverter.getProdCena(air.getUlCena()));
            StanjePK stanjeUlazpk = new StanjePK(air.getId().getSfrProizvod(), interniNalog.getUlaznaRJ());
            stanjeUlaz = (Stanje)em.find(Stanje.class, (Object)stanjeUlazpk);
            if (stanjeUlaz == null) {
                stanjeUlaz = new Stanje();
                stanjeUlaz.setId(stanjeUlazpk);
                stanjeUlaz.setAlocKolicina(air.getKolicina());
                stanjeUlaz.setKolicina(air.getKolicina());
                stanjeUlaz.setZadNabCena(air.getIzlCena());
                stanjeUlaz.setProdCena(air.getUlCena());
                stanjeUlaz.setDatZadUlaza(interniNalog.getDatum());
                stanjeUlaz.setKumUlaza(air.getKolicina());
                em.persist((Object)stanjeUlaz);
            } else {
                stanjeUlaz.setKolicina(stanjeUlaz.getKolicina() + air.getKolicina());
                stanjeUlaz.setZadNabCena(air.getIzlCena());
                stanjeUlaz.setProdCena(air.getUlCena());
                stanjeUlaz.setDatZadUlaza(interniNalog.getDatum());
                stanjeUlaz.setKumUlaza(stanjeUlaz.getKumUlaza() + air.getKolicina());
                stanjeUlaz.setAlocKolicina(stanjeUlaz.getAlocKolicina() + air.getKolicina());
            }
            interniNalog.setVredNaIzlazu(interniNalog.getVredNaIzlazu().add(BDConverter.getIznos(air.getKolicina() * air.getIzlCena())));
            interniNalog.setVredNaUlazu(interniNalog.getVredNaUlazu().add(BDConverter.getIznos(air.getKolicina() * air.getUlCena())));
            interniNalog.setCvProdajnaUkupno(interniNalog.getCvProdajnaUkupno().add(BDConverter.getIznos(air.getKolicina() * air.getCvProdajnaIznos())));
            interniNalog.getArtikalinterniracuns().add(air);
        }
        return interniNalog;
    }

    public static Dokument createDokumentGreska(Dokument dok) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        Dokument gdok = null;
        gdok = (Dokument)BeanUtils.cloneBean((Object)dok);
        gdok.setOpis("Greska u knjizenju. Tip: " + gdok.getTip());
        gdok.setTip(TipDokumentConfig.get().DOKUMENT_GRESKA);
        gdok.setArtikaldokuments(null);
        gdok.setOpstidokument(null);
        gdok.setDtaksas(null);
        gdok.setIznos(new BigDecimal(0));
        gdok.setRadnajedinica(null);
        gdok.setKalkulacija(null);
        gdok.setFaktura(null);
        gdok.setFakturausluga(null);
        gdok.setInterniracun(null);
        gdok.setInterniracun1(null);
        gdok.setNivelacija(null);
        gdok.setKonsignacija(null);
        gdok.setStavkanzks(null);
        gdok.setDokument(null);
        gdok.setOriginal(null);
        gdok.setUslugadokuments(null);
        return gdok;
    }
}

