/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.PzArtikalDokument;
import rs.pezar.db.PzEntityExtended;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.PzTaksaDokument;
import rs.pezar.db.PzUslugaDokument;
import rs.pezar.db.commons.PzIdGen;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Dokument;
import rs.pezar.db.entity.DokumentLog;
import rs.pezar.db.entity.Interniracun;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Tarifnagrupa;
import rs.pezar.util.PzDateUtility;

public abstract class PzDokument
extends PzEntityExtended
implements Serializable,
Comparable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private boolean novi = true;
    public static final String[] kColNames = new String[]{"Datum", "Opis", "Broj Fakture", "Duguje", "Potrazuje", "Saldo", "Datum Valute", "Nalog za knji\u017eenje"};

    public abstract String[] getDokColumnNames();

    public abstract Object[] getDokValues();

    public abstract short getCvProdajna();

    public abstract void setCvProdajna(short var1);

    public abstract String getTip();

    public abstract void setTip(String var1);

    public abstract Radnajedinica getRadnajedinica();

    public abstract void setRadnajedinica(Radnajedinica var1);

    public abstract void setrBroj(int var1);

    public abstract int getrBroj();

    public abstract void setRbrDok(int var1);

    public abstract int getRbrDok();

    public abstract Date getDatum();

    public abstract void setDatum(Date var1);

    public abstract void setDatValute(Date var1);

    public abstract Date getDatValute();

    public abstract Date getDatArh();

    public abstract void setDatArh(Date var1);

    public abstract Date getDatPrometa();

    public abstract short getArhiviran();

    public abstract void setArhiviran(short var1);

    public abstract short getProknjizen();

    public abstract void setProknjizen(short var1);

    public abstract void setOznDokumenta(String var1);

    public abstract String getOznDokumenta();

    public abstract BigDecimal getIznos();

    public abstract void setIznos(BigDecimal var1);

    public abstract Komitent getKomitent();

    public abstract void setKomitent(Komitent var1);

    public abstract Pzuser getUserKraj();

    public abstract void setUserKraj(Pzuser var1);

    public abstract Pzuser getUserPoc();

    public abstract void setUserPoc(Pzuser var1);

    public abstract Object[] getKValues(byte var1);

    public abstract void setIdDok(int var1);

    public abstract int getIdDok();

    public abstract List<? extends PzTaksaDokument> getTaksadokuments();

    public abstract String getPodTip();

    public abstract void setPodTip(String var1);

    public abstract void setTaksadokuments(List<? extends PzTaksaDokument> var1);

    public BigDecimal getVrednostRobe() {
        return null;
    }

    public BigDecimal getVrednostUsluga() {
        return null;
    }

    public void setVrednostRobe(BigDecimal vrednost) {
    }

    public void setVrednostUsluga(BigDecimal vrednost) {
    }

    public Date getDatumKnjizenja() {
        return this.getDatum();
    }

    public int compareTo(Object arg1) {
        int result = 0;
        int test = -56;
        test = this.getRbrDok();
        result = test > ((PzDokument)arg1).getRbrDok() ? -1 : (test < ((PzDokument)arg1).getRbrDok() ? 1 : 0);
        return result;
    }

    public abstract void formirajOznaku();

    public abstract void setStorno(int var1);

    public abstract int getStorno();

    public abstract String getOpis();

    public abstract void setOpis(String var1);

    public abstract Dokument getDokument();

    public abstract void adjust() throws Exception;

    public abstract void setDokument(Dokument var1);

    public abstract List<? extends PzArtikalDokument> getArtikalDocuments();

    public abstract void setArtikalDokuments(List<? extends PzArtikalDokument> var1);

    public List<? extends PzUslugaDokument> getUslugaDocuments() {
        return null;
    }

    public void updateDokument(boolean azuriranjeStavki) {
        if (this instanceof Interniracun) {
            ((Interniracun)this).setVrsta("U");
            ((Interniracun)this).setIdDok(((Interniracun)this).getDokument2().getIdDok());
            ((Interniracun)this).getDokument2().update(this, azuriranjeStavki);
            ((Interniracun)this).setVrsta("I");
            ((Interniracun)this).setIdDok(((Interniracun)this).getDokument1().getIdDok());
            ((Interniracun)this).setPodTip("IZLAZ");
        }
        this.getDokument().update(this, azuriranjeStavki);
    }

    public int getNextRBrojArtikli() {
        int rBroj = 0;
        for (PzArtikalDokument pzArtikalDokument : this.getArtikalDocuments()) {
            if (pzArtikalDokument.getId().getrBroj() <= rBroj) continue;
            rBroj = pzArtikalDokument.getId().getrBroj();
        }
        return rBroj + 1;
    }

    public boolean artikalExists(String sfrProizvod) {
        boolean found = false;
        if (this.getArtikalDocuments() != null) {
            for (PzArtikalDokument pzArtikalDokument : this.getArtikalDocuments()) {
                if (!pzArtikalDokument.getId().getSfrProizvod().equals(sfrProizvod)) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    public int getNextRBrojUsluge() {
        int rBroj = 0;
        if (this.getUslugaDocuments() != null) {
            for (PzUslugaDokument pzUslugaDokument : this.getUslugaDocuments()) {
                if (pzUslugaDokument.getId().getrBroj() <= rBroj) continue;
                rBroj = pzUslugaDokument.getId().getrBroj();
            }
        }
        return rBroj + 1;
    }

    public boolean taksaExists(String oznTarGr, String vrsta, String tip) {
        boolean found = false;
        if (this.getTaksadokuments() != null) {
            for (PzTaksaDokument pzTaksaDokument : this.getTaksadokuments()) {
                if (!pzTaksaDokument.getTarifnagrupa().getOznTarGr().equals(oznTarGr) || !pzTaksaDokument.getTip().equals(tip)) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    public PzTaksaDokument getTaksa(String oznTarGr, String vrsta, String tip) {
        PzTaksaDokument td = null;
        if (this.getTaksadokuments() != null) {
            for (PzTaksaDokument pzTaksaDokument : this.getTaksadokuments()) {
                if (!pzTaksaDokument.getTarifnagrupa().getOznTarGr().equals(oznTarGr) || !pzTaksaDokument.getTip().equals(tip)) continue;
                td = pzTaksaDokument;
                break;
            }
        }
        return td;
    }

    public DokumentLog createLog(int vrsta, String opis, Pzuser user, EntityManager em) {
        DokumentLog dlog = new DokumentLog();
        if (PzParameter.getBoolean("LOG", Boolean.TRUE).booleanValue()) {
            dlog.setIdLog(PzIdGen.getNextId("DOKUMENT_LOG", 1).getIdVal());
        }
        dlog.setVrsta(vrsta);
        dlog.setDokument(this.getDokument());
        dlog.setVreme(PzDateUtility.getServerTime(em));
        dlog.setPzuser(user);
        dlog.setOpis(opis != null ? opis : "");
        if (PzParameter.getBoolean("LOG", Boolean.TRUE).booleanValue()) {
            if (!(this instanceof Dokument) && this.getDokument().getLogs() == null) {
                this.getDokument().setLogs(new Vector<DokumentLog>());
            }
            if (this instanceof Dokument && ((Dokument)this).getLogs() == null) {
                ((Dokument)this).setLogs(new Vector<DokumentLog>());
            }
            if (this instanceof Dokument) {
                ((Dokument)this).getLogs().add(dlog);
                dlog.setDokument((Dokument)this);
            } else {
                this.getDokument().getLogs().add(dlog);
            }
        }
        return dlog;
    }

    public abstract void setVrsta(String var1);

    public abstract String getVrsta();

    public abstract BigDecimal getStornoIznos();

    public abstract void setStornoIznos(BigDecimal var1);

    public void setOriginal(PzDokument original) {
    }

    public PzDokument getOriginal() {
        return null;
    }

    public abstract PzTaksaDokument createEmptyTaksaDokument(String var1, String var2);

    public void addTaksas() {
        if (this.getTaksadokuments() == null) {
            this.setTaksadokuments(new Vector());
        }
        if (this instanceof Interniracun) {
            PzEntityUtil.addTaksaInterniracuns((Interniracun)this);
        } else {
            PzEntityUtil.addTaksaDokuments(this, "PDV");
        }
    }

    public boolean obracunavaSePorez(Tarifnagrupa tg, String tip) {
        return "PDV".equals(tg.getVrstatg().getOznVrstaTG());
    }

    public void izracunajVrednostRobe() {
        if (this.getArtikalDocuments() != null && this.getArtikalDocuments().size() > 0) {
            BigDecimal vrednostR = new BigDecimal(0);
            BigDecimal vrednostU = new BigDecimal(0);
            for (PzArtikalDokument pzArtikalDokument : this.getArtikalDocuments()) {
                BigDecimal kolicina;
                if (pzArtikalDokument.getTaksa("PDV") != null && !pzArtikalDokument.getTaksa("PDV").getOznTarGr().startsWith("U")) {
                    BigDecimal prnc;
                    kolicina = BDConverter.getKolicina(pzArtikalDokument.getKolicina());
                    BigDecimal prodCena = pzArtikalDokument.getProdCena();
                    BigDecimal bigDecimal = prnc = pzArtikalDokument.getProsNabCena() != null ? pzArtikalDokument.getProsNabCena() : BigDecimal.ZERO;
                    if (this.getCvProdajna() == 1) {
                        vrednostR = vrednostR.add(BDConverter.getIznos(prodCena.multiply(kolicina)));
                        continue;
                    }
                    vrednostR = vrednostR.add(prnc.multiply(kolicina));
                    continue;
                }
                kolicina = BDConverter.getKolicina(pzArtikalDokument.getKolicina());
                BigDecimal cena = BDConverter.getDefaultBigDecimal(pzArtikalDokument.getCena());
                vrednostU = vrednostU.add(cena.multiply(kolicina));
            }
            this.setVrednostRobe(BDConverter.getIznos(vrednostR));
            this.setVrednostUsluga(BDConverter.getIznos(vrednostU));
        }
    }

    public void setNovi(boolean novi) {
        this.novi = novi;
    }

    public boolean getNovi() {
        return this.novi;
    }
}

