/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.core.gui.menu.supervisor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import javax.persistence.EntityManager;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.apache.commons.beanutils.BeanUtils;
import org.jdesktop.application.Application;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzBrojacRj;
import rs.pezar.db.entity.Artikaldokument;
import rs.pezar.db.entity.Dokument;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Interniracun;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.db.entity.Trosak;
import rs.pezar.exceptions.PzInfoException;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzCheckbox;
import rs.pezar.swing.PzComboBox;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzRadioGroup;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzField;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzGradient;
import rs.pezar.swing.util.PzSwingUtility;

public class PzDialogBrisanjeDokumenta
extends PzDialog {
    private static final String LAKO_BRISANJE = "Lako brisanje";
    private static final String POTPUNO_BRISANJE = "Potpuno brisanje";
    private static final String NE_MENJATI = "Ne menjati";
    private static final String UMANJITI = "Umanjiti";
    private static final String UVECATI = "Uve\u0107ati";
    private JLabel labelRJ;
    private JLabel labelOznaka;
    private PzDateField datum;
    private PzTextField radnaJedinicaNaziv;
    private PzTextField radnaJedinica;
    private PzTextField komitentNaziv;
    private JList listASP;
    private DefaultListModel listModel = new DefaultListModel();
    private PzDateField datumArhiviranja;
    private PzCheckbox checkGreskaDok;
    private PzComboBox comboBrojaci;
    private PzComboBox comboAlociraneKolicine;
    private PzComboBox comboKolicine;
    private JLabel labelBrojaci;
    private JLabel labelAlociraneKolicine;
    private JLabel labelKolicine;
    private PzRadioGroup<String> radioGroupVrstaBrisanja;
    private PzPanel panelOpcije;
    private PzTextField podtipDokumenta;
    private PzTextField tipDokumenta;
    private PzTextField oznaka;
    private PzNumericOnlyTextField komitent;
    private PzDoubleField iznos;
    private PzNumericOnlyTextField brojDokumenta;
    private JLabel labelDatArhiviranja;
    private PzPanel mainPanel;
    private JLabel labelIznos;
    private JLabel labelPodtip;
    private JLabel labelTip;
    private JLabel labelDatum;
    private JLabel labelKomitent;
    private JLabel labelBrojDokumenta;
    private PzPanel panelDokument;
    private JSeparator separator;
    private static PzButton btnOK;
    private PzPanelHeader header;
    private Dokument dokument = null;

    public PzDialogBrisanjeDokumenta(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setTitle("Brisanje dokumenta");
            this.mainPanel = new PzPanel();
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            mainPanelLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0};
            mainPanelLayout.rowHeights = new int[]{7, 7, 7, 7};
            mainPanelLayout.columnWeights = new double[]{0.1};
            mainPanelLayout.columnWidths = new int[]{7};
            this.mainPanel.setLayout(mainPanelLayout);
            this.header = new PzPanelHeader();
            this.mainPanel.add((Component)this.header, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.header.setTitle("Brisanje dokumenta");
            this.header.setOpaque(false);
            this.panelDokument = new PzPanel();
            this.mainPanel.add((Component)this.panelDokument, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
            this.panelDokument.setOpaque(false);
            GridBagLayout panelDokumentLayout = new GridBagLayout();
            panelDokumentLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            panelDokumentLayout.rowHeights = new int[]{25, 10, 25, 25, 25, 25, 25, 25, 20, 25, 25};
            panelDokumentLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            panelDokumentLayout.columnWidths = new int[]{120, 100, 150, 7};
            this.panelDokument.setLayout(panelDokumentLayout);
            this.panelDokument.setBorder(BorderFactory.createTitledBorder(null, "Dokument za brisanje", 4, 0, new Font("Segoe UI", 1, 12), new Color(0, 0, 250)));
            this.labelBrojDokumenta = new JLabel();
            this.panelDokument.add((Component)this.labelBrojDokumenta, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.labelBrojDokumenta.setText("Broj dokumenta");
            this.brojDokumenta = new PzNumericOnlyTextField();
            this.brojDokumenta.setMaxLength(9);
            this.panelDokument.add((Component)this.brojDokumenta, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 1, 0), 0, 0));
            this.brojDokumenta.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    PzField field = (PzField)((Object)arg0);
                    if (PzDialogBrisanjeDokumenta.this.brojDokumenta.getText().equals("")) {
                        field.setState(PzFieldIndikator.STATE_INVALID);
                        return false;
                    }
                    return true;
                }
            });
            this.brojDokumenta.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent evt) {
                    if (evt.getKeyCode() == 10) {
                        PzDialogBrisanjeDokumenta.this.brojDokumentaKeyPressed(evt);
                    }
                }
            });
            this.separator = new JSeparator();
            this.panelDokument.add((Component)this.separator, new GridBagConstraints(0, 1, 4, 1, 0.0, 0.0, 10, 2, new Insets(0, 10, 0, 10), 0, 0));
            this.labelKomitent = new JLabel();
            this.panelDokument.add((Component)this.labelKomitent, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.labelKomitent.setText("Komitent");
            this.komitent = new PzNumericOnlyTextField();
            this.panelDokument.add((Component)this.komitent, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 1, 0), 0, 0));
            this.komitent.setHorizontalAlignment(2);
            this.komitent.setFocusable(false);
            this.komitentNaziv = new PzTextField();
            this.panelDokument.add((Component)this.komitentNaziv, new GridBagConstraints(2, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 1, 10), 0, 0));
            this.komitentNaziv.setFocusable(false);
            this.komitentNaziv.setEditable(false);
            this.labelRJ = new JLabel();
            this.panelDokument.add((Component)this.labelRJ, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.labelRJ.setText("Radna jedinica");
            this.radnaJedinica = new PzTextField();
            this.panelDokument.add((Component)this.radnaJedinica, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 1, 0), 0, 0));
            this.radnaJedinica.setFocusable(false);
            this.radnaJedinicaNaziv = new PzTextField();
            this.panelDokument.add((Component)this.radnaJedinicaNaziv, new GridBagConstraints(2, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 1, 10), 0, 0));
            this.radnaJedinicaNaziv.setFocusable(false);
            this.radnaJedinicaNaziv.setEditable(false);
            this.labelOznaka = new JLabel();
            this.panelDokument.add((Component)this.labelOznaka, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.labelOznaka.setText("Oznaka dokumenta");
            this.oznaka = new PzTextField();
            this.panelDokument.add((Component)this.oznaka, new GridBagConstraints(1, 4, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.oznaka.setFocusable(false);
            this.labelTip = new JLabel();
            this.panelDokument.add((Component)this.labelTip, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.labelTip.setText("Tip dokumenta");
            this.tipDokumenta = new PzTextField();
            this.tipDokumenta.setFocusable(false);
            this.panelDokument.add((Component)this.tipDokumenta, new GridBagConstraints(1, 5, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.labelPodtip = new JLabel();
            this.panelDokument.add((Component)this.labelPodtip, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.labelPodtip.setText("Podtip dokumenta");
            this.podtipDokumenta = new PzTextField();
            this.podtipDokumenta.setFocusable(false);
            this.panelDokument.add((Component)this.podtipDokumenta, new GridBagConstraints(1, 6, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.labelDatum = new JLabel();
            this.panelDokument.add((Component)this.labelDatum, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.labelDatum.setText("Datum dokumenta");
            this.datum = new PzDateField();
            this.datum.setText("");
            this.datum.setFocusable(false);
            this.panelDokument.add((Component)this.datum, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.labelDatArhiviranja = new JLabel();
            this.panelDokument.add((Component)this.labelDatArhiviranja, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.labelDatArhiviranja.setText("Datum arhiviranja");
            this.datumArhiviranja = new PzDateField();
            this.datumArhiviranja.setText("");
            this.datumArhiviranja.setFocusable(false);
            this.panelDokument.add((Component)this.datumArhiviranja, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.labelIznos = new JLabel();
            this.panelDokument.add((Component)this.labelIznos, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.labelIznos.setText("Iznos dokumenta");
            this.iznos = new PzDoubleField();
            this.iznos.setFocusable(false);
            this.panelDokument.add((Component)this.iznos, new GridBagConstraints(1, 9, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.listASP = new JList(this.listModel);
            this.panelDokument.add((Component)this.listASP, new GridBagConstraints(1, 10, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 1, 0, 0), 0, 0));
            this.listASP.setFocusable(false);
            this.listASP.setOpaque(false);
            this.listASP.setEnabled(false);
            this.panelOpcije = new PzPanel();
            GridBagLayout panelOpcijeLayout = new GridBagLayout();
            this.panelOpcije.setOpaque(false);
            this.panelOpcije.setBorder(BorderFactory.createTitledBorder(null, "Opcije za brisanje", 4, 0, new Font("Segoe UI", 1, 12), new Color(0, 0, 250)));
            this.mainPanel.add((Component)this.panelOpcije, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            panelOpcijeLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.1, 0.1};
            panelOpcijeLayout.rowHeights = new int[]{25, 25, 25, 25, 20};
            panelOpcijeLayout.columnWeights = new double[]{0.0, 0.0, 0.1, 0.1};
            panelOpcijeLayout.columnWidths = new int[]{120, 100, 7, 7};
            this.panelOpcije.setLayout(panelOpcijeLayout);
            this.radioGroupVrstaBrisanja = new PzRadioGroup<String>(new String[]{LAKO_BRISANJE, POTPUNO_BRISANJE});
            this.radioGroupVrstaBrisanja.setOpaque(false);
            BoxLayout vrstaBrisanjaLayout = new BoxLayout(this.radioGroupVrstaBrisanja, 0);
            this.radioGroupVrstaBrisanja.setLayout(vrstaBrisanjaLayout);
            this.panelOpcije.add(this.radioGroupVrstaBrisanja, new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.radioGroupVrstaBrisanja.setSelectedValue(LAKO_BRISANJE);
            this.labelKolicine = new JLabel();
            this.panelOpcije.add((Component)this.labelKolicine, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 25, 0, 0), 0, 0));
            this.labelKolicine.setText("Koli\u010dine");
            this.labelAlociraneKolicine = new JLabel();
            this.panelOpcije.add((Component)this.labelAlociraneKolicine, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 25, 0, 0), 0, 0));
            this.labelAlociraneKolicine.setText("Alocirane koli\u010dine");
            this.labelBrojaci = new JLabel();
            this.panelOpcije.add((Component)this.labelBrojaci, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 25, 0, 0), 0, 0));
            this.labelBrojaci.setText("Broja\u010di");
            DefaultComboBoxModel<String> comboKolicineModel = new DefaultComboBoxModel<String>(new String[]{NE_MENJATI, UMANJITI, UVECATI});
            this.comboKolicine = new PzComboBox();
            this.panelOpcije.add((Component)this.comboKolicine, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.comboKolicine.setModel(comboKolicineModel);
            DefaultComboBoxModel<String> pzComboBox1Model = new DefaultComboBoxModel<String>(new String[]{NE_MENJATI, UMANJITI, UVECATI});
            this.comboAlociraneKolicine = new PzComboBox();
            this.panelOpcije.add((Component)this.comboAlociraneKolicine, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.comboAlociraneKolicine.setModel(pzComboBox1Model);
            DefaultComboBoxModel<String> pzComboBox2Model = new DefaultComboBoxModel<String>(new String[]{NE_MENJATI, UMANJITI});
            this.comboBrojaci = new PzComboBox();
            this.panelOpcije.add((Component)this.comboBrojaci, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.comboBrojaci.setModel(pzComboBox2Model);
            this.checkGreskaDok = new PzCheckbox();
            this.panelOpcije.add((Component)this.checkGreskaDok, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, -3, 0, 0), 0, 0));
            this.checkGreskaDok.setText("Snimanje GRE\u0160KA dokumenta");
            this.checkGreskaDok.setOpaque(false);
            btnOK = new PzButton();
            this.mainPanel.add((Component)btnOK, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            btnOK.setText("Potvrdi");
            btnOK.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/core/resource/img/check.png")));
            btnOK.setActionCommand("update");
            btnOK.setFont(new Font("Tahoma", 1, 12));
            btnOK.setPreferredSize(new Dimension(120, 30));
            btnOK.addActionListener(this);
            this.setPreferredSize(new Dimension(600, 600));
            this.setResizable(false);
            Application.getInstance().getContext().getResourceMap(this.getClass()).injectComponents((Component)this.getContentPane());
            this.pack();
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle(this, e);
        }
    }

    protected void brojDokumentaKeyPressed(KeyEvent evt) {
        block12: {
            EntityManager em = PzEntityManager.getEm();
            try {
                try {
                    this.dokument = (Dokument)em.find(Dokument.class, (Object)this.brojDokumenta.getIntVal());
                    if (this.dokument != null) {
                        if (this.dokument.getKomitent() != null) {
                            this.komitent.setVal(this.dokument.getKomitent().getSfrKomitent());
                            this.komitentNaziv.setVal(this.dokument.getKomitent().getNaziv());
                        }
                        if (this.dokument.getRadnajedinica() != null) {
                            this.radnaJedinica.setVal(this.dokument.getRadnajedinica().getId().getOznRj());
                            this.radnaJedinicaNaziv.setVal(this.dokument.getRadnajedinica().getNaziv());
                        }
                        this.oznaka.setVal(this.dokument.getOznDokumenta());
                        this.tipDokumenta.setVal(this.dokument.getTip());
                        this.podtipDokumenta.setVal(this.dokument.getPodTip());
                        this.datum.setVal(this.dokument.getDatum());
                        this.datumArhiviranja.setVal(this.dokument.getDatArh());
                        this.iznos.setVal(this.dokument.getIznos());
                        this.listModel.removeAllElements();
                        if (this.dokument.getArhiviran() == 1) {
                            this.listModel.addElement("Arhiviran");
                        }
                        if (this.dokument.getStornoIznos().doubleValue() > 0.0) {
                            this.listModel.addElement("Storniran");
                        }
                        if (this.dokument.getStorno() == 1) {
                            this.listModel.addElement("Storno");
                        }
                        if (this.dokument.getProknjizen() == 1) {
                            this.listModel.addElement("Proknji\u017een");
                        }
                        break block12;
                    }
                    this.komitent.setText("");
                    this.komitentNaziv.setText("");
                    this.radnaJedinica.setText("");
                    this.radnaJedinicaNaziv.setText("");
                    this.oznaka.setText("");
                    this.tipDokumenta.setText("");
                    this.podtipDokumenta.setText("");
                    this.datum.setText("");
                    this.datumArhiviranja.setText("");
                    this.iznos.setVal(0);
                    this.listModel.removeAllElements();
                    JOptionPane.showMessageDialog(this.panelDokument, "Ne postoji dokument sa brojem: " + this.brojDokumenta.getIntVal(), "Pretraga", 1);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PzDialogBrisanjeDokumenta.this.brojDokumenta.requestFocus();
                        }
                    });
                }
                catch (Exception ex) {
                    PzMysqlExceptionHandler.handle(this, ex);
                    em.close();
                }
            }
            finally {
                em.close();
            }
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        block42: {
            if (this.dokument == null) break block42;
            em = PzEntityManager.getEm();
            try {
                block43: {
                    rez = PzSwingUtility.daNeDijalog(this.panelDokument, "Da li ste sigurni da \u017eelite da obri\u0161ete odabrani dokument?", "Brisanje dokumenta", null, false);
                    if (rez != 0) break block42;
                    dokumentiZaGresku = new ArrayList<Dokument>();
                    snimanjeGreskaDokumenta = this.checkGreskaDok.isSelected();
                    em.getTransaction().begin();
                    this.dokument = (Dokument)em.find(Dokument.class, (Object)this.dokument.getIdDok());
                    kolicine = 0;
                    alociraneKolicine = 0;
                    kolicineSel = this.comboKolicine.getSelectedItem().toString();
                    if (kolicineSel.equals("Umanjiti")) {
                        kolicine = -1;
                    } else if (kolicineSel.equals("Uve\u0107ati")) {
                        kolicine = 1;
                    }
                    alociraneKolicineSel = this.comboAlociraneKolicine.getSelectedItem().toString();
                    if (alociraneKolicineSel.equals("Umanjiti")) {
                        alociraneKolicine = -1;
                    } else if (alociraneKolicineSel.equals("Uve\u0107ati")) {
                        alociraneKolicine = 1;
                    }
                    this.updateStanje(kolicine, alociraneKolicine, em);
                    if (this.comboBrojaci.getSelectedItem().equals("Umanjiti")) {
                        brojacRBroj = PzBrojacRj.getRBroj(this.dokument, em);
                        if (brojacRBroj.getRBroj() != this.dokument.getrBroj()) {
                            throw new PzInfoException("Razlikuju se rBroj broja\u010di u bazi i na dokumentu!");
                        }
                        if (this.dokument.getRbrKepu() != 0) {
                            brojacRbrKepu = PzBrojacRj.getRbrKepu(this.dokument, em);
                            if (brojacRbrKepu.getRBroj() != this.dokument.getRbrKepu()) {
                                throw new PzInfoException("Razlikuju se rbrKepu broja\u010di u bazi i na dokumentu!");
                            }
                            brojacRbrKepu.setRBroj(brojacRbrKepu.getRBroj() - 1);
                        }
                        if ((brojacRbrDok = PzBrojacRj.getRbrDok(this.dokument, em)).getRBroj() != this.dokument.getRbrDok()) {
                            throw new PzInfoException("Razlikuju se rbrDok broja\u010di u bazi i na dokumentu!");
                        }
                        c = TipDokumentConfig.getClassByValue(this.dokument.getTip());
                        d = (PzDokument)em.find(c, (Object)this.dokument.getIdDok());
                        if (d instanceof Interniracun) {
                            ir = (Interniracun)d;
                            brojacRbrKepuIR = PzBrojacRj.getRbrKepu(ir.getDokument2(), em);
                            if (brojacRbrKepuIR.getRBroj() != ir.getDokument2().getRbrKepu()) {
                                throw new PzInfoException("Razlikuju se rbrKepu broja\u010di u bazi i na dokumentu2 internog ra\u010duna!");
                            }
                            brojacRbrKepuIR.setRBroj(brojacRbrKepuIR.getRBroj() - 1);
                        }
                        if (this.dokument.getTip().equals("FISKALNI_IZVESTAJ") && (brojDokFiskIzv = this.dokument.getOriginals().size()) > 0) {
                            postojiJednakBrojac = false;
                            for (Dokument fiskDok : this.dokument.getOriginals()) {
                                if (PzBrojacRj.getRbrKepu(fiskDok, em).getRBroj() != fiskDok.getRbrKepu()) continue;
                                postojiJednakBrojac = true;
                                break;
                            }
                            if (postojiJednakBrojac) {
                                brojacRbrKepuDokumentiFiskIzv = PzBrojacRj.getRbrKepu(this.dokument.getOriginals().get(0), em);
                                brojacRbrKepuDokumentiFiskIzv.setRBroj(brojacRbrKepuDokumentiFiskIzv.getRBroj() - brojDokFiskIzv);
                            } else {
                                throw new PzInfoException("Razlikuju se rbrKepu broja\u010di u bazi i svih dokumenata fiskalnog izve\u0161taja!");
                            }
                        }
                        brojacRBroj.setRBroj(brojacRBroj.getRBroj() - 1);
                        brojacRbrDok.setRBroj(brojacRbrDok.getRBroj() - 1);
                    }
                    c = TipDokumentConfig.getClassByValue(this.dokument.getTip());
                    d = (PzDokument)em.find(c, (Object)this.dokument.getIdDok());
                    if (!this.radioGroupVrstaBrisanja.getSelectedValue().equals("Lako brisanje")) break block43;
                    this.dokument.setArhiviran((short)-1);
                    d.setArhiviran((short)-1);
                    if (d instanceof Interniracun) {
                        ((Interniracun)d).getDokument2().setArhiviran((short)-1);
                    }
                    if (this.dokument.getTip().equals("FISKALNI_IZVESTAJ")) {
                        for (Dokument fiskDok : this.dokument.getOriginals()) {
                            fiskDok.setArhiviran((short)-1);
                        }
                    }
                    if (this.dokument.getTip().equals("KALKULACIJA")) {
                        kalk = (Kalkulacija)d;
                        for (Trosak t : kalk.getTrosaks()) {
                            t.setArhiviran((short)-1);
                            t.getDokument().setArhiviran((short)-1);
                        }
                    }
                    ** GOTO lbl104
                }
                if (this.dokument.getTip().equals("FAKTURA") || this.dokument.getTip().equals("OTPREMNICA")) {
                    f = (Faktura)d;
                    if (f.getZaOtpremnice() == 1) {
                        rz = PzSwingUtility.daNeDijalog(this.panelDokument, "Preko odabrane fakture su fakturisane otpremnice!\nBrisanjem ovog dokumenta otpremnice postaju nefakturisane, nastavak?", "Brisanje fakture za otpremnice", null, false);
                        if (rz != 0) {
                            return;
                        }
                        for (Faktura otpremnica : em.createQuery("select f from Faktura f where f.fakturaBean.idDok = " + this.dokument.getIdDok()).getResultList()) {
                            otpremnica.setFakturaBean(null);
                        }
                    } else if (f.getFakturaBean() != null && (rz = PzSwingUtility.daNeDijalog(this.panelDokument, "Odabrana otpremnica je fakturisana!\nPotencijalni problem u slu\u010daju vra\u0107anja u pripremu fakture preko koje je fakturisana!\nNastavak?", "Brisanje fakturisane otpremnice", null, false)) != 0) {
                        return;
                    }
                }
                try {
                    if (this.dokument.getTip().equals("FISKALNI_IZVESTAJ") && snimanjeGreskaDokumenta) {
                        dokumentiZaGresku = em.createQuery("select d from Dokument d where d.original.idDok = " + this.dokument.getIdDok()).getResultList();
                        em.createQuery("delete from Dokument d where d.original.idDok = " + this.dokument.getIdDok()).executeUpdate();
                    }
                    if (this.dokument.getTip().equals("KALKULACIJA") && snimanjeGreskaDokumenta) {
                        kalk = (Kalkulacija)d;
                        for (Trosak trosak : kalk.getTrosaks()) {
                            dokumentiZaGresku.add(trosak.getDokument());
                        }
                    }
                    if (d instanceof Interniracun) {
                        dokumentiZaGresku.add(((Interniracun)d).getDokument2());
                    }
                    em.remove((Object)this.dokument);
                    em.flush();
lbl104:
                    // 2 sources

                    if (snimanjeGreskaDokumenta) {
                        greskaDok = this.createDokumentGreska(this.dokument);
                        em.persist((Object)greskaDok);
                        for (PzDokument povezaniDokument : dokumentiZaGresku) {
                            dokk = povezaniDokument instanceof Dokument != false ? (Dokument)povezaniDokument : povezaniDokument.getDokument();
                            greskaDok = this.createDokumentGreska(dokk);
                            em.persist((Object)greskaDok);
                        }
                    }
                    em.getTransaction().commit();
                    this.dispose();
                }
                catch (Exception ex) {
                    PzMysqlExceptionHandler.handle(this, ex);
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                }
            }
            finally {
                em.close();
            }
        }
    }

    private void updateStanje(int kolicine, int alociraneKolicine, EntityManager em) throws Exception {
        if ((kolicine != 0 || alociraneKolicine != 0) && this.dokument.getRadnajedinica() == null) {
            throw new PzInfoException("Nije mogu\u0107e menjati koli\u010dine ukoliko dokument nema radnu jedinicu!");
        }
        if (kolicine != 0 || alociraneKolicine != 0) {
            for (Artikaldokument ad : this.dokument.getArtikaldokuments()) {
                Stanje stanje = (Stanje)em.find(Stanje.class, (Object)new StanjePK(ad.getId().getSfrProizvod(), this.dokument.getRadnajedinica()));
                if (stanje == null) continue;
                if (kolicine == 1) {
                    stanje.setKolicina(stanje.getKolicina() + ad.getKolicina());
                } else if (kolicine == -1) {
                    stanje.setKolicina(stanje.getKolicina() - ad.getKolicina());
                }
                if (alociraneKolicine == 1) {
                    stanje.setAlocKolicina(stanje.getAlocKolicina() + ad.getKolicina());
                    continue;
                }
                if (alociraneKolicine != -1) continue;
                stanje.setAlocKolicina(stanje.getAlocKolicina() - ad.getKolicina());
            }
        }
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogBrisanjeDokumenta(Boolean.FALSE);
    }

    public PzDialogBrisanjeDokumenta(Boolean initGUI) {
    }

    @Override
    public boolean shouldBeShown() {
        this.mainPanel.setPaintGradient(true);
        this.mainPanel.setGradient(PzGradient.DEFAULT_GRADIENT);
        this.getSession().putParameter("gradient", PzGradient.DEFAULT_GRADIENT);
        return true;
    }

    private Dokument createDokumentGreska(Dokument dok) throws Exception {
        Dokument gdok = null;
        gdok = (Dokument)BeanUtils.cloneBean((Object)dok);
        gdok.setOpis("Greska u knjizenju. Tip: " + gdok.getTip());
        gdok.setTip(TipDokumentConfig.get().DOKUMENT_GRESKA);
        gdok.setArtikaldokuments(null);
        gdok.setOpstidokument(null);
        gdok.setDtaksas(null);
        gdok.setIznos(new BigDecimal(0));
        gdok.setRadnajedinica(null);
        gdok.setKalkulacija(null);
        gdok.setFaktura(null);
        gdok.setFakturausluga(null);
        gdok.setInterniracun(null);
        gdok.setInterniracun1(null);
        gdok.setNivelacija(null);
        gdok.setKonsignacija(null);
        gdok.setStavkanzks(null);
        gdok.setDokument(null);
        gdok.setOriginal(null);
        gdok.setUslugadokuments(null);
        gdok.setTrosak(null);
        return gdok;
    }
}

