/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.core.gui.menu.definicijeKorisnika;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.SwingUtilities;
import org.jdesktop.application.Application;
import rs.pezar.core.PzApplication;
import rs.pezar.db.PzEntity;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzButtonPanel;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogInsert;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;

public class DefinicijeKorisnika
extends PzDialogInsert {
    private JLabel lblUsername;
    private JLabel lblPassword;
    private PzTextField txtPrivilegija;
    private PzTextField txtPrezime;
    private PzTextField txtIme;
    private JLabel lblPassword2;
    private JPasswordField txtPassword2;
    private JPasswordField txtPassword1;
    private PzNumericOnlyTextField magacin;
    private JLabel lblMagacin;
    private PzPanel panelCenter;
    private PzTextField txtUsername;
    private PzButton btnOK;
    private PzButtonPanel pzButtonPanel;
    private JLabel lblIme;
    private JLabel lblPrezime;
    private JLabel lblLevel;
    private PzPanelHeader header;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                DefinicijeKorisnika inst = new DefinicijeKorisnika(frame);
                inst.setVisible(true);
            }
        });
    }

    public DefinicijeKorisnika(PzDialog dialog, boolean izmena, Object data1, Object data2) {
        super(dialog, izmena, (PzTable)((Object)data1), data2);
    }

    public DefinicijeKorisnika(PzDialog dialog) {
        super(dialog);
        this.initGUI();
    }

    public DefinicijeKorisnika(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    @Override
    protected void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.header = new PzPanelHeader();
            this.header.setIcon(this.getHeaderIcon());
            this.header.setTitle(this.getHeaderTitle());
            this.getContentPane().add((Component)this.header, "North");
            this.panelCenter = new PzPanel();
            GridBagLayout panelCenterLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.panelCenter, "Center");
            panelCenterLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            panelCenterLayout.rowHeights = new int[]{25, 25, 25, 25, 25, 25, 25};
            panelCenterLayout.columnWeights = new double[]{0.0, 0.1, 0.1};
            panelCenterLayout.columnWidths = new int[]{172, 7, 7};
            this.panelCenter.setLayout(panelCenterLayout);
            this.lblUsername = new JLabel();
            this.panelCenter.add((Component)this.lblUsername, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 2), 0, 0));
            this.lblUsername.setText("Korisni\u010dko ime:");
            this.lblPassword = new JLabel();
            this.panelCenter.add((Component)this.lblPassword, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 2), 0, 0));
            this.lblPassword.setName("lblPassword");
            this.lblIme = new JLabel();
            this.panelCenter.add((Component)this.lblIme, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 2), 0, 0));
            this.lblIme.setText("Ime:");
            this.lblPrezime = new JLabel();
            this.panelCenter.add((Component)this.lblPrezime, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 2), 0, 0));
            this.lblPrezime.setText("Prezime:");
            this.lblLevel = new JLabel();
            this.panelCenter.add((Component)this.lblLevel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 2), 0, 0));
            this.lblLevel.setText("Level:");
            this.txtUsername = new PzTextField();
            this.panelCenter.add((Component)this.txtUsername, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.txtUsername.setPKField(Pzuser.class, null);
            this.txtPassword1 = new JPasswordField();
            this.panelCenter.add((Component)this.txtPassword1, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.txtPassword1.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10 && DefinicijeKorisnika.this.txtPassword1.getPassword().length > 0) {
                        DefinicijeKorisnika.this.txtPassword2.requestFocus();
                    }
                }
            });
            this.txtPassword2 = new JPasswordField();
            this.panelCenter.add((Component)this.txtPassword2, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.txtPassword2.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        if (DefinicijeKorisnika.this.getPasswordText(DefinicijeKorisnika.this.txtPassword1).equals(DefinicijeKorisnika.this.getPasswordText(DefinicijeKorisnika.this.txtPassword2))) {
                            DefinicijeKorisnika.this.txtIme.requestFocus();
                        } else {
                            PzSwingUtility.showErrorMessage(null, "Lozinke se ne poklapaju!");
                        }
                    }
                }
            });
            this.lblPassword2 = new JLabel();
            this.panelCenter.add((Component)this.lblPassword2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 2), 0, 0));
            this.lblPassword2.setName("lblPassword2");
            this.txtIme = new PzTextField();
            this.panelCenter.add((Component)this.txtIme, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.txtPrezime = new PzTextField();
            this.panelCenter.add((Component)this.txtPrezime, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.txtPrivilegija = new PzTextField();
            this.panelCenter.add((Component)this.txtPrivilegija, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.lblMagacin = new JLabel();
            this.panelCenter.add((Component)this.lblMagacin, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 2), 0, 0));
            this.lblMagacin.setName("lblMagacin");
            this.magacin = new PzNumericOnlyTextField();
            this.panelCenter.add((Component)this.magacin, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.setTitle("Izmena korisnika");
            this.pzButtonPanel = new PzButtonPanel();
            this.getContentPane().add((Component)this.pzButtonPanel, "South");
            this.btnOK = new PzButton();
            this.pzButtonPanel.add(this.btnOK);
            this.btnOK.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/core/resource/img/check.png")));
            this.btnOK.setText("Potvrdi");
            this.btnOK.addActionListener(this);
            this.pack();
            this.setSize(454, 348);
            Application.getInstance().getContext().getResourceMap(this.getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        Pzuser user = new Pzuser();
        user.setPzusername(this.txtUsername.getVal());
        user.setPassword(new String(this.txtPassword1.getPassword()));
        user.setPrivilegije(this.txtPrivilegija.getVal());
        user.setOznMagacin(this.magacin.getVal().equals("") ? null : this.magacin.getVal());
        if (!this.getPasswordText(this.txtPassword1).equals(this.getPasswordText(this.txtPassword2))) {
            PzSwingUtility.showErrorMessage(this, "Lozinke se ne poklapaju!");
            this.txtPassword2.requestFocus();
            return;
        }
        if (actionCommand.equalsIgnoreCase("Izmeni")) {
            this.getTable().updateSelectedEntity((PzEntity)user, true);
        } else {
            this.getTable().insert((PzEntity)user, true);
        }
        PzApplication.getApplication().getSession().setLoggedUser(user);
        this.dispose();
    }

    public static Object getGUIBuilderInstance() {
        return new DefinicijeKorisnika(Boolean.FALSE);
    }

    public DefinicijeKorisnika(Boolean initGUI) {
    }

    @Override
    protected void onInsert() {
        this.setTitle("Dodavanje korisnika");
        this.btnOK.setActionCommand("Dodaj");
    }

    @Override
    protected void onUpdate() {
        this.setTitle("Izmena korisnika");
        this.btnOK.setActionCommand("Izmeni");
        Pzuser user = (Pzuser)this.getTable().getSelectedEntity();
        this.txtUsername.setVal(user.getPzusername());
        this.txtUsername.setEnabled(false);
        this.txtPassword1.setText(user.getPassword());
        this.txtPassword2.setText(user.getPassword());
        this.txtIme.setVal(user.getIme());
        this.txtPrezime.setVal(user.getPrezime());
        this.txtPrivilegija.setVal(user.getPrivilegije());
        this.magacin.setVal(user.getOznMagacin());
    }

    @Override
    public void setEntity(PzEntity entity, Component component) {
    }

    @Override
    protected void setHeaderOnInsert() {
        this.setHeaderTitle("Dodavanje korisnika");
        this.setHeaderIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/core/resource/img/businessman_new.png")));
    }

    @Override
    protected void setHeaderOnUpdate() {
        this.setHeaderTitle("Izmena korisnika");
        this.setHeaderIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/core/resource/img/businessman_edit.png")));
    }

    private String getPasswordText(JPasswordField pass) {
        String rez = null;
        int i = 0;
        while (i < pass.getPassword().length) {
            rez = String.valueOf(rez) + pass.getPassword()[i];
            ++i;
        }
        return rez;
    }
}

