/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.core;

import java.io.File;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import rs.pezar.core.log.PzLogger;

public class PzUserSettings {
    private PropertiesConfiguration settings;
    private String path;

    public void initializeProperties(File dataFolder) {
        this.path = String.valueOf(dataFolder.getPath()) + File.separator + "pezar.properties";
        try {
            this.settings = new PropertiesConfiguration(new File(this.path));
        }
        catch (ConfigurationException e) {
            PzLogger.getInstance().logException(e);
        }
    }

    public Object getProperty(String name) {
        return this.settings.getProperty(name);
    }

    public String getString(String name) {
        return this.settings.getString(name);
    }

    public int getInt(String name) {
        return this.settings.getInt(name);
    }

    public boolean getBoolean(String name) {
        return this.settings.getBoolean(name);
    }

    public double getDouble(String name) {
        return this.settings.getDouble(name);
    }

    public synchronized void setProperty(String name, Object value) {
        this.settings.setProperty(name, value);
        try {
            this.settings.save();
        }
        catch (ConfigurationException e) {
            PzLogger.getInstance().logException(e);
        }
    }
}

