/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application.utils;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jdesktop.application.utils.PlatformType;

public final class AppHelper {
    private static PlatformType activePlatformType = null;

    private AppHelper() {
    }

    public static PlatformType getPlatform() {
        if (activePlatformType != null) {
            return activePlatformType;
        }
        activePlatformType = PlatformType.DEFAULT;
        PrivilegedAction<String> doGetOSName = new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("os.name");
            }
        };
        String osName = AccessController.doPrivileged(doGetOSName);
        if (osName != null) {
            osName = osName.toLowerCase();
            PlatformType[] platformTypeArray = PlatformType.values();
            int n = platformTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                PlatformType platformType = platformTypeArray[n2];
                String[] stringArray = platformType.getPatterns();
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String pattern = stringArray[n4];
                    if (osName.startsWith(pattern)) {
                        activePlatformType = platformType;
                        return activePlatformType;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        activePlatformType = PlatformType.DEFAULT;
        return activePlatformType;
    }
}

