/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import rs.pezar.core.format.BDConverter;
import rs.pezar.core.transformation.DefaultDokumentTransformer;
import rs.pezar.core.transformation.TransformationException;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Artikalinterniracun;
import rs.pezar.db.entity.Artikallista;
import rs.pezar.db.entity.Interniracun;
import rs.pezar.db.entity.Lista;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.msg.msg.MsgProtocol;
import rs.pezar.service.msg.chat.textComponent.notification.NotificationText;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.util.PzDateUtility;
import rs.pezar.util.PzMathUtility;

public class PzInterniNalogUtil {
    public static final String PARAMETER_RJ_IZLAZ = "IZLAZNA_RJ";
    public static final String PARAMETER_RJ_ULAZ = "ULAZNA_RJ";
    public static final String PARAMETER_TIP = "TIP_DOKUMENTA";
    private static final String PARAMETER_MARZA = "MARZA";

    public static PzDokument toInterniRacun(Lista l, HashMap<String, Object> parameters, EntityManager em) throws Exception {
        Radnajedinica rjIzlaz = (Radnajedinica)parameters.get(PARAMETER_RJ_IZLAZ);
        Radnajedinica rjUlaz = (Radnajedinica)parameters.get(PARAMETER_RJ_ULAZ);
        DefaultDokumentTransformer ddt = new DefaultDokumentTransformer(Interniracun.class, Artikalinterniracun.class);
        Interniracun interninalog = (Interniracun)ddt.toDokument(l, parameters, em);
        interninalog.setTip((String)parameters.get(PARAMETER_TIP));
        interninalog.setIzlaznaRJ(rjIzlaz);
        interninalog.setRjIzlaz(rjIzlaz.getPunNaziv());
        interninalog.setUlaznaRJ(rjUlaz);
        interninalog.setRjUlaz(rjUlaz.getPunNaziv());
        interninalog.setStorno(0);
        interninalog.setArhiviran((short)0);
        interninalog.setDatum(PzDateUtility.getCurrentDate());
        interninalog.setProknjizen((short)0);
        interninalog.setProcRabata(0.0);
        interninalog.setVredNaIzlazu(new BigDecimal("0.00"));
        interninalog.setVredNaUlazu(new BigDecimal("0.00"));
        interninalog.setPdvIznos(new BigDecimal("0.00"));
        List<Object[]> stanjaIzlaz = PzInterniNalogUtil.getStanja(rjIzlaz, l, em);
        List<Object[]> stanjaUlaz = PzInterniNalogUtil.getStanja(rjUlaz, l, em);
        for (Artikalinterniracun artikal : interninalog.getArtikalinterniracuns()) {
            if (interninalog.getCountArtikal(artikal.getId().getSfrProizvod()) > 1) {
                throw new TransformationException("Gre\u0161ka! Artikal " + artikal.getId().getSfrProizvod() + " se nalazi u listi dva ili vi\u0161e puta");
            }
            if (!PzInterniNalogUtil.updateStanjeInsert(interninalog, artikal, PzInterniNalogUtil.findKolicina(l, artikal.getId().getSfrProizvod()), em)) continue;
            artikal.setKolicina(PzInterniNalogUtil.findKolicina(l, artikal.getId().getSfrProizvod()));
            if (parameters.get(PARAMETER_TIP).equals("INTERNI_NALOG") || parameters.get(PARAMETER_TIP).equals("PRIMO_PREDAJNICA")) {
                if (interninalog.getIzlaznaRJ().getgTip().equals("V") && PzParameter.getParameterValue((String)"C_V_PRODAJNA").equals("false")) {
                    artikal.setIzlCena(((BigDecimal)PzInterniNalogUtil.findValue(stanjaIzlaz, artikal.getId().getSfrProizvod(), 3)).doubleValue());
                    artikal.setIzlProdCena(BDConverter.getProdCena((double)artikal.getIzlCena()));
                } else {
                    artikal.setIzlCena(((Double)PzInterniNalogUtil.findValue(stanjaIzlaz, artikal.getId().getSfrProizvod(), 4)).doubleValue());
                    artikal.setIzlProdCena(BDConverter.getProdCena((double)artikal.getIzlCena()));
                }
            } else {
                artikal.setIzlCena(((Double)PzInterniNalogUtil.findValue(stanjaIzlaz, artikal.getId().getSfrProizvod(), 4)).doubleValue());
            }
            Double ulazCena = 0.0;
            if ((Double)PzInterniNalogUtil.findValue(stanjaUlaz, artikal.getId().getSfrProizvod(), 4) == null) {
                BigDecimal izlaznaCena = (BigDecimal)PzInterniNalogUtil.findValue(stanjaIzlaz, artikal.getId().getSfrProizvod(), 3);
                Artikal art = (Artikal)PzEntityManager.find(Artikal.class, (Object)artikal.getId().getSfrProizvod());
                Double stopaPDV = art.getTarifnaGrupa("PDV").getStopa();
                if (parameters.get(PARAMETER_TIP).equals("INTERNI_NALOG")) {
                    ulazCena = PzMathUtility.round((double)(izlaznaCena.doubleValue() * (stopaPDV + 100.0) / 100.0));
                    if ((Double)parameters.get(PARAMETER_MARZA) == 0.0) {
                        artikal.setUlCena(ulazCena.doubleValue());
                    } else {
                        artikal.setUlCena(ulazCena * ((Double)parameters.get(PARAMETER_MARZA) + 100.0) / 100.0);
                    }
                } else if (parameters.get(PARAMETER_TIP).equals("PRIMO_PREDAJNICA")) {
                    if (interninalog.getIzlaznaRJ().getgTip().equals("V") && PzParameter.getParameterValue((String)"C_V_PRODAJNA").equals("false")) {
                        artikal.setUlCena(((BigDecimal)PzInterniNalogUtil.findValue(stanjaIzlaz, artikal.getId().getSfrProizvod(), 3)).doubleValue());
                    } else {
                        artikal.setUlCena(((Double)PzInterniNalogUtil.findValue(stanjaIzlaz, artikal.getId().getSfrProizvod(), 4)).doubleValue());
                    }
                } else {
                    ulazCena = PzMathUtility.round((double)(izlaznaCena.doubleValue() * (stopaPDV - 100.0) / 100.0));
                    artikal.setUlCena(ulazCena.doubleValue());
                }
            } else {
                ulazCena = (Double)PzInterniNalogUtil.findValue(stanjaUlaz, artikal.getId().getSfrProizvod(), 4);
                if (parameters.get(PARAMETER_TIP).equals("INTERNI_NALOG")) {
                    if ((Double)parameters.get(PARAMETER_MARZA) == 0.0) {
                        artikal.setUlCena(ulazCena.doubleValue());
                        artikal.setUlProdCena(BDConverter.getProdCena((double)artikal.getUlCena()));
                    } else {
                        artikal.setUlCena(ulazCena * ((Double)parameters.get(PARAMETER_MARZA) + 100.0) / 100.0);
                        artikal.setUlProdCena(BDConverter.getProdCena((double)artikal.getUlCena()));
                    }
                }
                if (parameters.get(PARAMETER_TIP).equals("PRIMO_PREDAJNICA")) {
                    if (interninalog.getIzlaznaRJ().getgTip().equals("V") && PzParameter.getParameterValue((String)"C_V_PRODAJNA").equals("false")) {
                        artikal.setUlCena(((BigDecimal)PzInterniNalogUtil.findValue(stanjaIzlaz, artikal.getId().getSfrProizvod(), 3)).doubleValue());
                    } else {
                        artikal.setUlCena(((Double)PzInterniNalogUtil.findValue(stanjaIzlaz, artikal.getId().getSfrProizvod(), 4)).doubleValue());
                    }
                } else {
                    artikal.setUlCena(ulazCena.doubleValue());
                    artikal.setUlProdCena(BDConverter.getProdCena((double)artikal.getUlCena()));
                }
            }
            artikal.setProcRabata(0.0);
            artikal.setProcMarze(0.0);
            if (parameters.get(PARAMETER_TIP).equals("INTERNI_NALOG")) {
                artikal.setProcMarze(((Double)parameters.get(PARAMETER_MARZA)).doubleValue());
                artikal.setCvProdajnaIznos(((Double)PzInterniNalogUtil.findValue(stanjaIzlaz, artikal.getId().getSfrProizvod(), 4)).doubleValue());
            } else if (parameters.get(PARAMETER_TIP).equals("PRIMO_PREDAJNICA")) {
                artikal.setCvProdajnaIznos(((Double)PzInterniNalogUtil.findValue(stanjaIzlaz, artikal.getId().getSfrProizvod(), 4)).doubleValue());
            } else {
                artikal.setCvProdajnaIznos(ulazCena.doubleValue());
            }
            artikal.setInterniracun(interninalog);
            interninalog.setVredNaIzlazu(interninalog.getVredNaIzlazu().add(PzMathUtility.roundToBigDecimal((double)(artikal.getKolicina() * artikal.getIzlCena()))));
            interninalog.setVredNaUlazu(interninalog.getVredNaUlazu().add(PzMathUtility.roundToBigDecimal((double)(artikal.getKolicina() * artikal.getUlCena()))));
        }
        return interninalog;
    }

    private static List<Object[]> getStanja(Radnajedinica rj, Lista l, EntityManager em) {
        Query q = em.createQuery("SELECT s.id.sfrProizvod, s.kolicina, s.alocKolicina, s.prosNabCena, s.prodCena FROM Stanje s WHERE s.radnajedinica=:rj AND s.id.sfrProizvod IN (SELECT al.sfrProizvod FROM Artikallista al WHERE al.id.idLista=:idLista)");
        q.setParameter("rj", (Object)rj);
        q.setParameter("idLista", (Object)l.getIdLista());
        return q.getResultList();
    }

    private static Object findValue(List<Object[]> stanja, String sfrProizvod, int i) {
        Object res = null;
        for (Object[] stanje : stanja) {
            if (!stanje[0].equals(sfrProizvod)) continue;
            res = stanje[i];
            break;
        }
        return res;
    }

    private static double findKolicina(Lista l, String sfrProizvod) {
        double res = 0.0;
        for (Artikallista al : l.getArtikallistas()) {
            if (!al.getSfrProizvod().equals(sfrProizvod)) continue;
            res = al.getKolicina();
            break;
        }
        return res;
    }

    public static boolean updateStanjeInsert(Interniracun interninalog, Artikalinterniracun artikal, double kolicina, EntityManager em) throws Exception {
        Stanje stanjeIzlaz = (Stanje)PzEntityManager.find(Stanje.class, (Object)new StanjePK(artikal.getId().getSfrProizvod(), interninalog.getIzlaznaRJ()));
        if (stanjeIzlaz == null) {
            throw new TransformationException("Gre\u0161ka! Artikal " + artikal.getId().getSfrProizvod() + " nema stanje u izlaznom magacinu. RAD NEMOGU\u0106");
        }
        if (kolicina <= 0.0) {
            throw new TransformationException("Gre\u0161ka! Koli\u010dina za prenos mora biti ve\u0107a od 0.0");
        }
        if (stanjeIzlaz.getKolicina() - stanjeIzlaz.getKolicina() < kolicina && interninalog.getIzlaznaRJ().getNacinVodjenja().equals("ZABRANJEN")) {
            throw new TransformationException("Gre\u0161ka! Nedovoljna koli\u010dina. ZABRANJEN ulazak u minus.");
        }
        if (interninalog.getIzlaznaRJ().getgTip().equals("V") && PzParameter.getParameterValue((String)"C_V_PRODAJNA").equals("false")) {
            Double pomIzlaznaCena = stanjeIzlaz.getProsNabCena().doubleValue();
            if (pomIzlaznaCena == 0.0) {
                throw new TransformationException("Gre\u0161ka! Artikal " + artikal.getId().getSfrProizvod() + " NEMA FORMIRANU prose\u010dno nabavnu cenu u izlaznom magacinu.");
            }
        } else {
            Double pomIzlaznaCena = stanjeIzlaz.getProdCena();
            if (pomIzlaznaCena == 0.0) {
                throw new TransformationException("Gre\u0161ka! Artikal " + artikal.getId().getSfrProizvod() + " NEMA FORMIRANU cenu u izlaznom magacinu. RAD NEMOGU\u0106");
            }
        }
        stanjeIzlaz.setAlocKolicina(stanjeIzlaz.getAlocKolicina() + kolicina);
        return true;
    }

    public static void sendMessage(Pzuser user, String poruka) {
        try {
            String text = NotificationText.codeNotification((String)poruka);
            String queueName = MsgProtocol.getQueueNameFromUserName((String)user.getPzusername(), (String)user.getIme(), (String)user.getPrezime());
            if (MsgProtocol.getInstance() != null) {
                MsgProtocol.getInstance().sendChatTextMessageToQueue(queueName, text);
            }
        }
        catch (JMSException e) {
            PzMysqlExceptionHandler.handle((Throwable)e);
        }
    }

    public static void sendNotification(Pzuser user, String poruka) {
        try {
            String queueName = MsgProtocol.getQueueNameFromUserName((String)user.getPzusername(), (String)user.getIme(), (String)user.getPrezime());
            if (MsgProtocol.getInstance() != null) {
                MsgProtocol.getInstance().sendActionMessageToDestination((Destination)MsgProtocol.getInstance().createDestinationFromQueueName(queueName), "ID:3;CORNER:DD;MESSAGE:" + poruka);
            }
        }
        catch (JMSException e) {
            PzMysqlExceptionHandler.handle((Throwable)e);
        }
    }
}

