/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.interniprenos.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.persistence.EntityManager;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import rs.pezar.db.PZDBF;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Artikalinterniracun;
import rs.pezar.db.entity.Interniracun;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.interniprenos.PzExtensionLoader;
import rs.pezar.interniprenos.gui.PzDialogKonsignacijaPovratnicaIzrada;
import rs.pezar.swing.PzComponentGroup;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.util.PzSwingUtility;

public class PzDialogDokumentiKonsignacijaPovratnica
extends PzDialog {
    private static final long serialVersionUID = 1L;
    private JToolBar toolbar;
    private PzToolBarIcon icnBrisanjeKonsPovratnica;
    private PzToolBarIcon icnIzmenaKonsPovratnica;
    private PzToolBarIcon icnDodavanjeKonsPovratnica;
    private JScrollPane scrollPane;
    private PzTable table;
    private PzPanel mainPanel;
    private PzComponentGroup kIcnGroup;
    private PzComponentGroup fIcnGroup;
    private Interniracun konsignacijaBrisanje;
    private Stanje stanje;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brDok = new JLabel();

    public PzDialogDokumentiKonsignacijaPovratnica(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public PzDialogDokumentiKonsignacijaPovratnica(JFrame frame, String parameter) {
        super(frame);
        this.initGUI();
        if (parameter.equalsIgnoreCase("Interniracun")) {
            this.fIcnGroup.hideAll();
        } else {
            parameter.equalsIgnoreCase("");
        }
        this.table = new PzTable((List)PZDBF.getDokumenti((Pzuser)PzExtensionLoader.getLoggedUser(), (String)parameter, (int)0, (int)0, (String)"POVRATNICA_SA_NASE_KONS"), Interniracun.class);
        this.table.setEnterAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PzDialogDokumentiKonsignacijaPovratnica.this.table.getSelectedRow() == -1) {
                    return;
                }
                PzDialogDokumentiKonsignacijaPovratnica.this.showDialog(PzDialogKonsignacijaPovratnicaIzrada.class, true, PzDialogDokumentiKonsignacijaPovratnica.this.table, PzDialogDokumentiKonsignacijaPovratnica.this.table.getSelectedEntity());
            }
        });
        this.scrollPane.setViewportView((Component)this.table);
        this.refresh();
    }

    private void refresh() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PzDialogDokumentiKonsignacijaPovratnica.this.brDok.setText(Integer.toString(PzDialogDokumentiKonsignacijaPovratnica.this.table.getDataSize()));
            }
        });
    }

    private void initGUI() {
        try {
            this.mainPanel = new PzPanel();
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            mainPanelLayout.rowWeights = new double[]{0.0, 0.1, 0.1, 0.1};
            mainPanelLayout.rowHeights = new int[]{98, 7, 7, 7};
            mainPanelLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            mainPanelLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.scrollPane = new JScrollPane();
            this.mainPanel.add((Component)this.scrollPane, (Object)new GridBagConstraints(0, 1, 4, 3, 0.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
            this.toolbar = new JToolBar();
            this.mainPanel.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            this.toolbar.setLayout(toolbarLayout);
            toolbarLayout.setAlignment(0);
            this.kIcnGroup = new PzComponentGroup();
            this.fIcnGroup = new PzComponentGroup();
            this.toolbar.setOpaque(false);
            this.icnDodavanjeKonsPovratnica = new PzToolBarIcon();
            this.kIcnGroup.add((Component)this.icnDodavanjeKonsPovratnica);
            this.toolbar.add((Component)this.icnDodavanjeKonsPovratnica);
            this.icnDodavanjeKonsPovratnica.setText("Nova povratnica|sa konsignacije|(Insert)");
            this.icnDodavanjeKonsPovratnica.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/interniprenos/resource/img/document_add.png")));
            this.icnDodavanjeKonsPovratnica.addActionListener((ActionListener)((Object)this));
            this.icnDodavanjeKonsPovratnica.setActionCommand("insert_zaduzenje");
            this.icnDodavanjeKonsPovratnica.setShortcut("insert");
            this.icnIzmenaKonsPovratnica = new PzToolBarIcon();
            this.kIcnGroup.add((Component)this.icnIzmenaKonsPovratnica);
            this.toolbar.add((Component)this.icnIzmenaKonsPovratnica);
            this.icnIzmenaKonsPovratnica.setText("Izmena povratnice|sa konsignacije|(F3)");
            this.icnIzmenaKonsPovratnica.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/interniprenos/resource/img/document_edit.png")));
            this.icnIzmenaKonsPovratnica.setActionCommand("update_zaduzenje");
            this.icnIzmenaKonsPovratnica.addActionListener((ActionListener)((Object)this));
            this.icnIzmenaKonsPovratnica.setShortcut("f3");
            this.icnBrisanjeKonsPovratnica = new PzToolBarIcon();
            this.kIcnGroup.add((Component)this.icnBrisanjeKonsPovratnica);
            this.toolbar.add((Component)this.icnBrisanjeKonsPovratnica);
            this.icnBrisanjeKonsPovratnica.setText("Brisanje povratnice|sa konsignacije|(Delete)");
            this.icnBrisanjeKonsPovratnica.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/interniprenos/resource/img/document_delete.png")));
            this.icnBrisanjeKonsPovratnica.addActionListener((ActionListener)((Object)this));
            this.icnBrisanjeKonsPovratnica.setActionCommand("delete_zaduzenje");
            this.icnBrisanjeKonsPovratnica.setShortcut("delete");
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText("  Broj dokumenata");
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.setSize(1000, 600);
            this.setMinimumSize(new Dimension(800, 600));
            this.setTitle("Povratnice sa konsignacije u pripremi");
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = ((PzToolBarIcon)e.getSource()).getActionCommand();
        boolean izmena = false;
        if (!actionCommand.equals("insert_zaduzenje")) {
            if (actionCommand.equals("update_zaduzenje")) {
                if (this.table.getSelectedRow() == -1) {
                    return;
                }
                izmena = true;
            } else if (actionCommand.equals("delete_zaduzenje")) {
                EntityManager em = PzEntityManager.getEm();
                this.konsignacijaBrisanje = (Interniracun)this.table.getSelectedEntity();
                if (this.konsignacijaBrisanje == null) {
                    return;
                }
                int rez = PzSwingUtility.daNeDijalog((Component)SwingUtilities.getRoot(null), (Object)"Da li ste sigurni?", (String)"Brisanje", null, (boolean)false);
                if (rez != 0) {
                    return;
                }
                try {
                    em.getTransaction().begin();
                    for (Artikalinterniracun aintrac : this.konsignacijaBrisanje.getArtikalinterniracuns()) {
                        this.stanje = (Stanje)em.find(Stanje.class, (Object)new StanjePK(aintrac.getId().getSfrProizvod(), this.konsignacijaBrisanje.getIzlaznaRJ()));
                        if (PzParameter.getParameterValue((String)"INT_NAL_FORM_ALOC").equals("true")) {
                            this.stanje.setAlocKolicina(this.stanje.getAlocKolicina() - aintrac.getKolicina());
                        }
                        em.merge((Object)this.stanje);
                    }
                    em.remove(em.find(Interniracun.class, (Object)this.konsignacijaBrisanje.getIdDok()));
                    em.getTransaction().commit();
                    this.table.removeSelectedEntity(false, false);
                    this.refresh();
                    return;
                }
                catch (Exception e1) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                }
                finally {
                    em.close();
                }
            }
        }
        this.showDialog(PzDialogKonsignacijaPovratnicaIzrada.class, izmena, this.table, null);
        this.table.refreshData();
        this.refresh();
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogDokumentiKonsignacijaPovratnica(Boolean.FALSE);
    }

    public PzDialogDokumentiKonsignacijaPovratnica(Boolean initGUI) {
    }

    public void finish() {
        this.table.removeSelectedEntity(false, false);
    }

    public boolean shouldBeShown() {
        this.mainPanel.setPaintGradient(true);
        return true;
    }
}

