/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.interniprenos.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.persistence.EntityManager;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import rs.pezar.db.PZDBF;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Artikalinterniracun;
import rs.pezar.db.entity.Interniracun;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.interniprenos.PzExtensionLoader;
import rs.pezar.interniprenos.gui.PzDialogInterniNalog;
import rs.pezar.interniprenos.gui.interniNalog.PosaljiDrugomUSERu;
import rs.pezar.interniprenos.gui.interniNalog.UzmiOdDrugogUSERa;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzComponentGroup;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.util.PzSwingUtility;

public class PzDialogDokumenti
extends PzDialog {
    private static final long serialVersionUID = 1L;
    protected static Interniracun selected;
    private JToolBar toolbar;
    private PzToolBarIcon icnBrisanjeInternogNaloga;
    private PzToolBarIcon icnIzmenaInternogNaloga;
    private PzToolBarIcon icnDodovanjeInternogNaloga;
    private PzToolBarIcon icnIzmenaUlazneRJ;
    private JScrollPane scrollPane;
    private PzTable table;
    private PzPanel mainPanel;
    private PzComponentGroup kIcnGroup;
    private PzComponentGroup fIcnGroup;
    private Interniracun intnalogBrisanje;
    private Stanje stanje;
    private String parameter;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brDok = new JLabel();
    private PzToolBarIcon btnUzmiOdDrugogUsera;
    private PzToolBarIcon btnPosaljiDrugomUseru;

    public PzDialogDokumenti(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public PzDialogDokumenti(JFrame frame, String parameter) {
        super(frame);
        this.parameter = parameter;
        this.initGUI();
        this.postInit();
    }

    public PzDialogDokumenti(PzDialog parent, String parameter) {
        super(parent);
        this.parameter = parameter;
        this.initGUI();
        this.postInit();
    }

    private void postInit() {
        if (this.parameter.equalsIgnoreCase("Interniracun")) {
            this.fIcnGroup.hideAll();
        } else {
            this.parameter.equalsIgnoreCase("");
        }
        this.initializeTable();
    }

    public void initializeTable() {
        this.table = new PzTable((List)PZDBF.getDokumenti((Pzuser)PzExtensionLoader.getLoggedUser(), (String)this.parameter, (int)0, (int)0, (String)"INTERNI_NALOG"), Interniracun.class);
        this.table.setEnterAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PzDialogDokumenti.this.table.getSelectedRow() != -1) {
                    PzDialogDokumenti.this.showDialog(PzDialogInterniNalog.class, true, PzDialogDokumenti.this.table, PzDialogDokumenti.this.table.getSelectedEntity());
                }
            }
        });
        this.scrollPane.setViewportView((Component)this.table);
        this.refresh();
    }

    private void refresh() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PzDialogDokumenti.this.brDok.setText(Integer.toString(PzDialogDokumenti.this.table.getDataSize()));
            }
        });
    }

    private void initGUI() {
        try {
            this.mainPanel = new PzPanel();
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            mainPanelLayout.rowWeights = new double[]{0.0, 0.1, 0.1, 0.1};
            mainPanelLayout.rowHeights = new int[]{104, 7, 7, 7};
            mainPanelLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            mainPanelLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.scrollPane = new JScrollPane();
            this.mainPanel.add((Component)this.scrollPane, (Object)new GridBagConstraints(0, 1, 4, 3, 0.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
            this.toolbar = new JToolBar();
            this.mainPanel.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            this.toolbar.setLayout(toolbarLayout);
            toolbarLayout.setAlignment(0);
            this.kIcnGroup = new PzComponentGroup();
            this.fIcnGroup = new PzComponentGroup();
            this.toolbar.setOpaque(false);
            this.icnDodovanjeInternogNaloga = new PzToolBarIcon();
            this.kIcnGroup.add((Component)this.icnDodovanjeInternogNaloga);
            this.toolbar.add((Component)this.icnDodovanjeInternogNaloga);
            this.icnDodovanjeInternogNaloga.setText("Novi|interni nalog|(Insert)");
            this.icnDodovanjeInternogNaloga.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/interniprenos/resource/img/document_add.png")));
            this.icnDodovanjeInternogNaloga.addActionListener((ActionListener)((Object)this));
            this.icnDodovanjeInternogNaloga.setActionCommand("insert_interninalog");
            this.icnDodovanjeInternogNaloga.setShortcut("insert");
            this.icnIzmenaInternogNaloga = new PzToolBarIcon();
            this.kIcnGroup.add((Component)this.icnIzmenaInternogNaloga);
            this.toolbar.add((Component)this.icnIzmenaInternogNaloga);
            this.icnIzmenaInternogNaloga.setText("Izmena|internog naloga|(F3)");
            this.icnIzmenaInternogNaloga.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/interniprenos/resource/img/document_edit.png")));
            this.icnIzmenaInternogNaloga.setActionCommand("update_interninalog");
            this.icnIzmenaInternogNaloga.addActionListener((ActionListener)((Object)this));
            this.icnIzmenaInternogNaloga.setShortcut("f3");
            this.icnBrisanjeInternogNaloga = new PzToolBarIcon();
            this.kIcnGroup.add((Component)this.icnBrisanjeInternogNaloga);
            this.toolbar.add((Component)this.icnBrisanjeInternogNaloga);
            this.icnBrisanjeInternogNaloga.setText("Brisanje|internog naloga|(Delete)");
            this.icnBrisanjeInternogNaloga.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/interniprenos/resource/img/document_delete.png")));
            this.icnBrisanjeInternogNaloga.addActionListener((ActionListener)((Object)this));
            this.icnBrisanjeInternogNaloga.setActionCommand("delete_interninalog");
            this.icnBrisanjeInternogNaloga.setShortcut("delete");
            this.icnIzmenaUlazneRJ = new PzToolBarIcon();
            this.kIcnGroup.add((Component)this.icnIzmenaUlazneRJ);
            this.toolbar.add((Component)this.icnIzmenaUlazneRJ);
            this.icnIzmenaUlazneRJ.setText("Izmena|ulazne RJ|(F2)");
            this.icnIzmenaUlazneRJ.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/interniprenos/resource/img/document_edit.png")));
            this.icnIzmenaUlazneRJ.addActionListener((ActionListener)((Object)this));
            this.icnIzmenaUlazneRJ.setActionCommand("izmena_rj");
            this.icnIzmenaUlazneRJ.setShortcut("f2");
            this.btnUzmiOdDrugogUsera = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnUzmiOdDrugogUsera);
            this.btnUzmiOdDrugogUsera.setText("Preuzimanje|od drugog|korisnika (Alt+F5)");
            this.btnUzmiOdDrugogUsera.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/interniprenos/resource/img/user_back.png")));
            this.btnUzmiOdDrugogUsera.setActionCommand("UzmiOdDrugogUsera");
            this.btnUzmiOdDrugogUsera.addActionListener((ActionListener)((Object)this));
            this.btnUzmiOdDrugogUsera.setShortcut("ALT+F5");
            this.btnPosaljiDrugomUseru = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnPosaljiDrugomUseru);
            this.btnPosaljiDrugomUseru.setText("Slanje|drugom korisniku|(Alt+F6)");
            this.btnPosaljiDrugomUseru.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/interniprenos/resource/img/user_send.png")));
            this.btnPosaljiDrugomUseru.setActionCommand("PosaljiDrugomUseru");
            this.btnPosaljiDrugomUseru.addActionListener((ActionListener)((Object)this));
            this.btnPosaljiDrugomUseru.setShortcut("ALT+F6");
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText("  Broj dokumenata");
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.setSize(1000, 600);
            this.setMinimumSize(new Dimension(800, 600));
            this.setTitle("Interni nalozi u pripremi");
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = ((PzToolBarIcon)e.getSource()).getActionCommand();
        boolean izmena = false;
        if (!actionCommand.equals("insert_interninalog")) {
            if (actionCommand.equals("update_interninalog")) {
                if (this.table.getSelectedRow() == -1) {
                    return;
                }
                izmena = true;
            } else {
                if (actionCommand.equalsIgnoreCase("PosaljiDrugomUseru")) {
                    if (this.table.getSelectedRow() != -1) {
                        this.getSession().putParameter("racun", (Object)this.table.getSelectedEntity());
                    }
                    this.showDialog(PosaljiDrugomUSERu.class);
                    return;
                }
                if (actionCommand.equalsIgnoreCase("UzmiOdDrugogUsera")) {
                    this.showDialog(UzmiOdDrugogUSERa.class);
                    return;
                }
                if (actionCommand.equals("delete_interninalog")) {
                    int rez;
                    EntityManager em = PzEntityManager.getEm();
                    this.intnalogBrisanje = (Interniracun)this.table.getSelectedEntity();
                    if (this.intnalogBrisanje == null) {
                        return;
                    }
                    if (this.intnalogBrisanje.getArhiviran() == 1) {
                        PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Ne mozete obrisati arhivirani nalog");
                    }
                    if ((rez = PzSwingUtility.daNeDijalog((Component)SwingUtilities.getRoot(null), (Object)"Da li ste sigurni?", (String)"Brisanje", null, (boolean)false)) != 0) {
                        return;
                    }
                    try {
                        em.getTransaction().begin();
                        for (Artikalinterniracun aintrac : this.intnalogBrisanje.getArtikalinterniracuns()) {
                            this.stanje = (Stanje)em.find(Stanje.class, (Object)new StanjePK(aintrac.getId().getSfrProizvod(), this.intnalogBrisanje.getIzlaznaRJ()));
                            if (PzParameter.getParameterValue((String)"INT_NAL_FORM_ALOC").equals("true")) {
                                this.stanje.setAlocKolicina(this.stanje.getAlocKolicina() - aintrac.getKolicina());
                            }
                            em.merge((Object)this.stanje);
                        }
                        em.remove(em.find(Interniracun.class, (Object)this.intnalogBrisanje.getIdDok()));
                        em.getTransaction().commit();
                        this.table.removeSelectedEntity(false, false);
                        this.refresh();
                        return;
                    }
                    catch (Exception e1) {
                        if (em.getTransaction().isActive()) {
                            em.getTransaction().rollback();
                        }
                        PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                    }
                    finally {
                        em.close();
                    }
                } else if (actionCommand.equals("izmena_rj")) {
                    if (this.table.getSelectedRow() == -1) {
                        return;
                    }
                    Interniracun intnalog = (Interniracun)this.table.getSelectedEntity();
                    if (intnalog == null) {
                        return;
                    }
                    Radnajedinica izlaznaRJ = intnalog.getIzlaznaRJ();
                    Radnajedinica ulaznaRJ = PzDialogRJ.getRJ((PzDialog)this, (String[])new String[]{"EL", "EV", "ET", "ELK", "EP", "EW", "ELR"});
                    if (ulaznaRJ != null) {
                        if (izlaznaRJ.getgTip().equals("G") && !ulaznaRJ.getpTip().equals("P") && !ulaznaRJ.getpTip().equals("W")) {
                            JOptionPane.showMessageDialog(SwingUtilities.getRoot((Component)((Object)this)), "Prodavnica ulaza nije prodavnica SOPSTVENIH PROIZVODA!", "Obave\u0161tenje", 1);
                            return;
                        }
                        if (izlaznaRJ.getgTip().equals("V") && (ulaznaRJ.getpTip().equals("P") || ulaznaRJ.getpTip().equals("W") || ulaznaRJ.getpTip().equals("T"))) {
                            JOptionPane.showMessageDialog(SwingUtilities.getRoot((Component)((Object)this)), "Prodavnica ulaza nije prodavnica TRGOVA\u010cKE ROBE!", "Obave\u0161tenje", 1);
                            return;
                        }
                        if (izlaznaRJ.getgTip().equals("T") && !ulaznaRJ.getpTip().equals("T")) {
                            JOptionPane.showMessageDialog(SwingUtilities.getRoot((Component)((Object)this)), "Prodavnica ulaza nije KONSIGNACIONA prodavnica!", "Obave\u0161tenje", 1);
                            return;
                        }
                        intnalog.setUlaznaRJ(ulaznaRJ);
                        intnalog.setRjUlaz(ulaznaRJ.getPunNaziv());
                        this.table.updateSelectedEntity((PzEntity)intnalog, true);
                        return;
                    }
                    return;
                }
            }
        }
        this.showDialog(PzDialogInterniNalog.class, izmena, this.table, null);
        this.table.refreshData();
        this.refresh();
    }

    public void refreshTable() {
        this.table.refreshData();
        this.refresh();
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogDokumenti(Boolean.FALSE);
    }

    public PzDialogDokumenti(Boolean initGUI) {
    }

    public void finish() {
        this.table.removeSelectedEntity(false, false);
    }

    public static Interniracun getInterniRacunUPripermi(PzDialog parent, String parameter) {
        PzDialogDokumenti dlg = new PzDialogDokumenti(parent, parameter);
        if (!dlg.shouldBeShown()) {
            return null;
        }
        dlg.table.setEnterAction(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                selected = (Interniracun)PzDialogDokumenti.this.table.getSelectedEntity();
                PzDialogDokumenti.this.dispose();
            }
        });
        dlg.restoreSize();
        dlg.setModal(true);
        dlg.setVisible(true);
        Interniracun res = selected;
        selected = null;
        return res;
    }

    public boolean shouldBeShown() {
        this.mainPanel.setPaintGradient(true);
        return true;
    }
}

