/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.efaktura;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.DeliveryType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.InvoiceLineType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.ItemType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PeriodType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PriceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.TaxSubtotalType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.TaxTotalType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.BaseQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.DescriptionCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.InvoicedQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.LineExtensionAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.PriceAmountType;
import oasis.names.specification.ubl.schema.xsd.invoice_21.InvoiceType;
import rs.pezar.db.PzTaksaDokument;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Uplata;
import rs.pezar.efaktura.EFakturaExporter;
import rs.pezar.globals.TipDokumentConfig;

public class EAvansniRacunExporter
extends EFakturaExporter {
    private static final String ADVANCE_TYPE_CODE = "386";
    private Faktura f;

    public EAvansniRacunExporter(Faktura f) {
        super(f);
        this.f = f;
    }

    @Override
    public InvoiceType build() throws Exception {
        InvoiceType i = super.build();
        return i;
    }

    @Override
    protected String getInvoiceTypeCode() {
        return ADVANCE_TYPE_CODE;
    }

    @Override
    protected PeriodType invoicePeriod() {
        PeriodType period = new PeriodType();
        period.addDescriptionCode(new DescriptionCodeType("432"));
        return period;
    }

    @Override
    protected DeliveryType delivery() {
        return null;
    }

    @Override
    protected List<Uplata> advanceList() throws Exception {
        return new ArrayList<Uplata>();
    }

    @Override
    protected List<InvoiceLineType> lines() {
        if (TipDokumentConfig.get().PODTIP_AVANSNI_IZNOS.equals(this.f.getPodTip())) {
            TaxTotalType t = this.taxTotal();
            ArrayList<InvoiceLineType> lines = new ArrayList<InvoiceLineType>();
            int count = 0;
            if (this.taksaDokuments().size() == 0) {
                for (TaxSubtotalType s : t.getTaxSubtotal()) {
                    String dPart = "";
                    InvoiceLineType line = this.invoiceLine(++count, s, dPart);
                    lines.add(line);
                }
            } else {
                for (PzTaksaDokument td : this.taksaDokuments()) {
                    TaxSubtotalType s = this.taxSubTotal(td);
                    String dPart = td.getTarifnagrupa().getOznTarGr().startsWith("U") ? "za usluge" : "za robu";
                    InvoiceLineType line = this.invoiceLine(++count, s, dPart);
                    lines.add(line);
                }
            }
            return lines;
        }
        return super.lines();
    }

    private InvoiceLineType invoiceLine(int count, TaxSubtotalType s, String dPart) {
        String descFormat = "Avans %s (PDV %s%%)";
        InvoiceLineType line = new InvoiceLineType();
        line.setID("" + count);
        InvoicedQuantityType q = new InvoicedQuantityType(BigDecimal.ONE);
        q.setUnitCode("H87");
        line.setInvoicedQuantity(q);
        LineExtensionAmountType ea = new LineExtensionAmountType(s.getTaxableAmountValue());
        ea.setCurrencyID("RSD");
        line.setLineExtensionAmount(ea);
        TaxTotalType tt = new TaxTotalType();
        tt.setTaxAmount(s.getTaxAmount());
        tt.addTaxSubtotal(s);
        line.addTaxTotal(tt);
        ItemType i = new ItemType();
        String name = String.format(descFormat, dPart, s.getTaxCategory().getPercentValue().toString());
        i.setName(name);
        i.addClassifiedTaxCategory(this.taxCategory(s.getTaxCategory().getIDValue(), "VAT", s.getTaxCategory().getPercentValue()));
        PriceType p = new PriceType();
        PriceAmountType pa = new PriceAmountType();
        pa.setCurrencyID("RSD");
        pa.setValue(s.getTaxableAmountValue());
        p.setPriceAmount(pa);
        BaseQuantityType bq = new BaseQuantityType();
        bq.setUnitCode("H87");
        bq.setValue(this.decimal(1.0, 3));
        p.setBaseQuantity(bq);
        line.setPrice(p);
        line.setItem(i);
        return line;
    }

    private List<TaxSubtotalType> taxSubTotals() {
        List<PzTaksaDokument> taksaDokuments = this.taksaDokuments();
        if (taksaDokuments.size() > 0) {
            ArrayList<TaxSubtotalType> taxSubtotals = new ArrayList<TaxSubtotalType>();
            for (PzTaksaDokument taksaDokument : taksaDokuments) {
                taxSubtotals.add(this.taxSubTotal(taksaDokument));
            }
            return taxSubtotals;
        }
        return this.taxTotal().getTaxSubtotal();
    }

    @Override
    protected LineExtensionAmountType lineExtensionAmount() {
        BigDecimal trosak = this.trosak();
        trosak = trosak != null ? trosak : BigDecimal.ZERO;
        return new LineExtensionAmountType(this.taxableAmount().subtract(trosak));
    }
}

