/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.konsignacije.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import net.sf.jasperreports.engine.JRDataSource;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Artikalfaktura;
import rs.pezar.db.entity.ArtikalfakturaPK;
import rs.pezar.db.entity.Artikalkonsignacija;
import rs.pezar.db.entity.Artikalobracunkonsignacije;
import rs.pezar.db.entity.Artikalopstidokument;
import rs.pezar.db.entity.ArtikalopstidokumentPK;
import rs.pezar.db.entity.Brojacrj;
import rs.pezar.db.entity.Obracunkonsignacije;
import rs.pezar.db.entity.Opstidokument;
import rs.pezar.db.entity.Proizvodfiskalniracun;
import rs.pezar.db.entity.ProizvodfiskalniracunPK;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Stanje;
import rs.pezar.konsignacije.gui.PzDialogDokumentiObracun;
import rs.pezar.konsignacije.gui.PzDialogIzborProvizijeZaStorno;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.engine.standard.PzBeanDataSourceAdapter;
import rs.pezar.reports.engine.standard.PzDataSourceAdapter;
import rs.pezar.reports.engine.standard.PzDataSourceExtended;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogInsert;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.util.PzGradient;
import rs.pezar.util.PzDateUtility;
import rs.pezar.util.PzMathUtility;

public class PzDialogStornoObracuna
extends PzDialogInsert {
    private PzPanel pzPanelN;
    private JScrollPane jScrollPane;
    private PzToolBarIcon icnArhiva;
    private PzToolBarIcon icnSelektiranje;
    private PzToolBarIcon icnIzmena;
    private PzDoubleField iznosField;
    private JLabel jLabel2;
    private PzDoubleField provizijaField;
    private PzDoubleField zaPlacanjeField;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private PzPanel pzPanelC;
    private JToolBar jToolBar;
    private PzTable tableInterni;
    private Obracunkonsignacije original;
    private Obracunkonsignacije stornirani;
    private PzPanel mainPanel;
    private boolean izmena;
    private PzToolBarIcon icnProbnoListanje;
    private Radnajedinica ulaznaRJ;
    private PzTable table;
    private Stanje stanjeIzlaz;
    private List<Artikalkonsignacija> artkonsigs;
    private PzDialogDokumentiObracun parent;
    private Brojacrj brojac;
    private double iznosProvizije;
    private double opstiProcenatProvizije;
    private PzStatusBar statusBar;
    private JLabel jlStatusBar = new JLabel();
    private JLabel brDok = new JLabel();

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogStornoObracuna inst = new PzDialogStornoObracuna(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogStornoObracuna(JFrame frame) {
        super(frame);
    }

    public PzDialogStornoObracuna(PzDialog dialog) {
        super(dialog);
        this.original = (Obracunkonsignacije)this.getSession().getParameter("original");
        this.stornirani = (Obracunkonsignacije)this.getSession().getParameter("storno");
        this.initGUI();
        this.paintPanel();
    }

    private void paintPanel() {
        this.mainPanel.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.mainPanel.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.mainPanel.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    protected void initGUI() {
        try {
            if (this.izmena) {
                this.setTitle("PREDLOG STORNA OBRA\u010cUNA ZA PRODATU ROBU SA KONSIGNACIJE " + this.original.getRadnajedinica().getId().getOznRj() + "(" + this.original.getRadnajedinica().getgTip() + ") " + this.original.getRadnajedinica().getNaziv());
            }
            this.mainPanel = new PzPanel();
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            mainPanelLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.1, 0.1};
            mainPanelLayout.rowHeights = new int[]{116, 62, 114, 7, 7};
            mainPanelLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1, 0.1};
            mainPanelLayout.columnWidths = new int[]{7, 7, 7, 7, 7};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.pzPanelC = new PzPanel();
            this.mainPanel.add((Component)this.pzPanelC, (Object)new GridBagConstraints(0, 2, 5, 3, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            GridBagLayout pzPanelCLayout = new GridBagLayout();
            pzPanelCLayout.rowWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            pzPanelCLayout.rowHeights = new int[]{7, 7, 7, 7};
            pzPanelCLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            pzPanelCLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.pzPanelC.setLayout((LayoutManager)pzPanelCLayout);
            this.pzPanelC.setOpaque(false);
            this.jScrollPane = new JScrollPane();
            this.pzPanelC.add((Component)this.jScrollPane, (Object)new GridBagConstraints(0, 0, 4, 4, 0.0, 0.0, 10, 1, new Insets(0, 10, 10, 10), 0, 0));
            this.pzPanelN = new PzPanel();
            this.mainPanel.add((Component)this.pzPanelN, (Object)new GridBagConstraints(0, 1, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            GridBagLayout pzPanelNLayout = new GridBagLayout();
            pzPanelNLayout.rowWeights = new double[]{14.0, 14.0, 14.0};
            pzPanelNLayout.rowHeights = new int[]{7, 7, 7};
            pzPanelNLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pzPanelNLayout.columnWidths = new int[]{130, 100, 16, 77, 100, 8, 100, 100, 20};
            this.pzPanelN.setLayout((LayoutManager)pzPanelNLayout);
            this.pzPanelN.setOpaque(false);
            this.jLabel1 = new JLabel();
            this.pzPanelN.add((Component)this.jLabel1, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 10), 0, 0));
            this.jLabel1.setText("    Op\u0161ti procenat provizije:   " + this.opstiProcenatProvizije);
            this.jToolBar = new JToolBar();
            this.mainPanel.add((Component)this.jToolBar, (Object)new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            this.jToolBar.setLayout(toolbarLayout);
            toolbarLayout.setAlignment(0);
            this.jToolBar.setOpaque(false);
            this.icnSelektiranje = new PzToolBarIcon();
            this.jToolBar.add((Component)this.icnSelektiranje);
            this.icnSelektiranje.setText("Selektiranje|(F2)");
            this.icnSelektiranje.setPreferredSize(new Dimension(90, 90));
            this.icnSelektiranje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/konsignacije/resource/img/product_add.png")));
            this.icnSelektiranje.setActionCommand("Selektiranje");
            this.icnSelektiranje.addActionListener((ActionListener)((Object)this));
            this.icnSelektiranje.setShortcut("f2");
            this.icnArhiva = new PzToolBarIcon();
            this.jToolBar.add((Component)this.icnArhiva);
            this.icnArhiva.setText("Arhiva|(ctrl+W)");
            this.icnArhiva.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/konsignacije/resource/img/address_book.png")));
            this.icnArhiva.setPreferredSize(new Dimension(90, 90));
            this.icnArhiva.setActionCommand("Arhiviranje");
            this.icnArhiva.addActionListener((ActionListener)((Object)this));
            this.icnArhiva.setShortcut("ctrl+w");
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText("  Broj dokumenata ");
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.pack();
            this.setMinimumSize(new Dimension(900, 700));
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        block14: {
            EntityManager em = PzEntityManager.getEm();
            try {
                String actionCommand = ((PzButton)e.getSource()).getActionCommand();
                if (actionCommand.equals("Selektiranje")) {
                    if (this.table.getSelectedRow() == -1) {
                        JOptionPane.showMessageDialog(SwingUtilities.getRoot((Component)((Object)this)), "Niste odabrali stavku.", "Obavestenje", 1);
                        return;
                    }
                    this.table.switchIt();
                    break block14;
                }
                if (!actionCommand.equals("Arhiviranje")) break block14;
                Vector artikli = (Vector)this.table.getCheckedEntities();
                if (artikli.size() == 0) {
                    JOptionPane.showMessageDialog(SwingUtilities.getRoot((Component)((Object)this)), "Nije bilo selektiranih slogova za obradu.", "Obavestenje", 1);
                    return;
                }
                try {
                    if (this.original.getRadnajedinica().getgTip().equals("T") || this.original.getRadnajedinica().getgTip().equals("V")) {
                        this.arhivirajVeleprodaja();
                    } else if (this.original.getRadnajedinica().getgTip().equals("E")) {
                        this.arhivirajMaloprodaja();
                    }
                }
                catch (Exception e1) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                }
            }
            finally {
                em.close();
            }
        }
    }

    protected void onInsert() {
    }

    protected void onUpdate() {
    }

    public boolean shouldBeShown() {
        if (this.izmena) {
            return true;
        }
        boolean result = false;
        Double procProvizije = PzDialogIzborProvizijeZaStorno.getIzbor((PzDialog)this);
        if (procProvizije != null) {
            this.ulaznaRJ = this.original.getRadnajedinica();
            result = true;
            this.setTitle("STORNO OBRA\u010cUNA ZA PRODATU ROBU SA KONSIGNACIJE " + this.ulaznaRJ.getId().getOznRj() + "(" + this.ulaznaRJ.getgTip() + ") " + this.ulaznaRJ.getNaziv());
            this.opstiProcenatProvizije = procProvizije;
            this.jLabel1.setText("    Op\u0161ti procenat provizije:   " + this.opstiProcenatProvizije);
            try {
                for (Artikalobracunkonsignacije artob : this.stornirani.getArtikalobracunkonsignacijes()) {
                    artob.setProvizija(this.opstiProcenatProvizije);
                }
                this.kreirajTabelu();
            }
            catch (Exception e) {
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            }
        }
        return result;
    }

    public void setEntity(PzEntity entity, Component component) {
    }

    protected void setHeaderOnInsert() {
    }

    protected void setHeaderOnUpdate() {
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogStornoObracuna(Boolean.FALSE);
    }

    public PzDialogStornoObracuna(Boolean initGUI) {
    }

    public void finish() {
        this.parent.finish();
        this.dispose();
    }

    private void kreirajTabelu() {
        this.table = new PzTable(this.stornirani.getArtikalobracunkonsignacijes(), Artikalobracunkonsignacije.class);
        this.table.setCheckboxColumn(0);
        this.jScrollPane.setViewportView((Component)this.table);
        this.brDok.setText(String.valueOf(this.table.getRowCount()));
    }

    private void arhivirajVeleprodaja() {
        try {
            EntityManager em1 = PzEntityManager.getEm();
            em1.getTransaction().begin();
            Vector artikli = (Vector)this.table.getCheckedEntities();
            this.stornirani.setArtikalobracunkonsignacijes(new Vector());
            BigDecimal ukupnaVr = new BigDecimal(0);
            BigDecimal ukupnoPr = new BigDecimal(0);
            for (Artikalobracunkonsignacije aob : artikli) {
                aob.setProvizija(this.opstiProcenatProvizije);
                aob.setObracunkonsignacije(this.stornirani);
                this.stornirani.getArtikalobracunkonsignacijes().add(aob);
                ukupnaVr = ukupnaVr.add(PzMathUtility.roundToBigDecimal((double)(aob.getKolicina() * aob.getCena())));
                ukupnoPr = ukupnoPr.add(PzMathUtility.roundToBigDecimal((double)(aob.getKolicina() * aob.getCena() * aob.getProvizija() / 100.0)));
                Artikalobracunkonsignacije aobr = (Artikalobracunkonsignacije)PzEntityManager.find(Artikalobracunkonsignacije.class, (Object)new ArtikalopstidokumentPK(this.original.getIdDok(), aob.getId().getSfrProizvod(), aob.getId().getrBroj()), (EntityManager)em1);
                aobr.setStorniranaStavka(1);
                em1.merge((Object)aobr);
                Artikalfaktura af = (Artikalfaktura)PzEntityManager.find(Artikalfaktura.class, (Object)new ArtikalfakturaPK(aob.getIdDokumenta(), aob.getId().getSfrProizvod(), aob.getrBrojUKljucu()), (EntityManager)em1);
                af.setIndk((short)0);
                em1.merge((Object)af);
            }
            this.stornirani.setIznos(ukupnaVr);
            this.stornirani.setProvizija(ukupnoPr);
            this.stornirani.setZaPlacanje(ukupnaVr.subtract(ukupnoPr));
            this.stornirani.setArhiviran((short)1);
            this.stornirani.setDatArh(new Date(new java.util.Date().getTime()));
            this.stornirani.setOriginal((Opstidokument)this.original);
            PzDokumentManager.getInstance().arhivirajStorno((PzDokument)this.stornirani, PzEntityManager.KOLICINE_NEPROMENJENE, PzEntityManager.KOLICINA_UKUPNA, true, null, em1);
            em1.getTransaction().commit();
            em1.close();
            Vector<Object> lista = new Vector<Object>();
            lista.add(PzFirma.getFirma());
            lista.add(this.stornirani);
            lista.add(this.ulaznaRJ);
            String putanjaReporta = "rs/pezar/reports/compiled/obracun_kons_nasasifra.jasper";
            PzDataSourceExtended ds = new PzDataSourceExtended(lista, this.stornirani.getArtikalobracunkonsignacijes());
            ds.setAdapter((PzDataSourceAdapter)new PzBeanDataSourceAdapter());
            String title = "STORNO OBRA\u010cUNA broj " + PzEntityUtil.strZero((String)this.original.getRadnajedinica().getId().getOznRj(), (int)3) + "-" + PzEntityUtil.strZero((String)("" + this.original.getrBroj()), (int)5) + "/" + PzDateUtility.getCurrentYear();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("title", title);
            PzReportManager.createAndShowReport((PzDialog)this.parent, (JRDataSource)ds, (String)putanjaReporta, params, (String)"Storno obra\u010duna konsignacije");
            this.dispose();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void arhivirajMaloprodaja() {
        try {
            EntityManager em1 = PzEntityManager.getEm();
            em1.getTransaction().begin();
            Vector artikli = (Vector)this.table.getCheckedEntities();
            this.stornirani.setArtikalobracunkonsignacijes(new Vector());
            BigDecimal ukupnaVr = new BigDecimal(0);
            BigDecimal ukupnoPr = new BigDecimal(0);
            for (Artikalobracunkonsignacije aob : artikli) {
                aob.setProvizija(this.opstiProcenatProvizije);
                aob.setObracunkonsignacije(this.stornirani);
                this.stornirani.getArtikalobracunkonsignacijes().add(aob);
                ukupnaVr = ukupnaVr.add(PzMathUtility.roundToBigDecimal((double)(aob.getKolicina() * aob.getCena())));
                ukupnoPr = ukupnoPr.add(PzMathUtility.roundToBigDecimal((double)(aob.getKolicina() * aob.getCena() * aob.getProvizija() / 100.0)));
                Artikalobracunkonsignacije aobr = (Artikalobracunkonsignacije)PzEntityManager.find(Artikalobracunkonsignacije.class, (Object)new ArtikalopstidokumentPK(this.original.getIdDok(), aob.getId().getSfrProizvod(), aob.getId().getrBroj()), (EntityManager)em1);
                aobr.setStorniranaStavka(1);
                em1.merge((Object)aobr);
                if (aob.getVrstaDokSaKogSuPreuzeteStavke() == 1) {
                    Artikalfaktura af = (Artikalfaktura)PzEntityManager.find(Artikalfaktura.class, (Object)new ArtikalfakturaPK(aob.getIdDokumenta(), aob.getId().getSfrProizvod(), aob.getrBrojUKljucu()), (EntityManager)em1);
                    af.setIndk((short)0);
                    em1.merge((Object)af);
                    continue;
                }
                if (aob.getVrstaDokSaKogSuPreuzeteStavke() == 2) {
                    Proizvodfiskalniracun pfr = (Proizvodfiskalniracun)PzEntityManager.find(Proizvodfiskalniracun.class, (Object)new ProizvodfiskalniracunPK(aob.getIdDokumenta(), aob.getId().getSfrProizvod(), aob.getrBrojUKljucu()), (EntityManager)em1);
                    pfr.setIndk((short)0);
                    em1.merge((Object)pfr);
                    continue;
                }
                if (aob.getVrstaDokSaKogSuPreuzeteStavke() != 3) continue;
                Artikalopstidokument aod = (Artikalopstidokument)PzEntityManager.find(Artikalopstidokument.class, (Object)new ArtikalopstidokumentPK(aob.getIdDokumenta(), aob.getId().getSfrProizvod(), aob.getrBrojUKljucu()), (EntityManager)em1);
                aod.setIndk(0);
                em1.merge((Object)aod);
            }
            this.stornirani.setIznos(ukupnaVr);
            this.stornirani.setProvizija(ukupnoPr);
            this.stornirani.setZaPlacanje(ukupnaVr.subtract(ukupnoPr));
            this.stornirani.setArhiviran((short)1);
            this.stornirani.setDatArh(new Date(new java.util.Date().getTime()));
            this.stornirani.setOriginal((Opstidokument)this.original);
            PzDokumentManager.getInstance().arhivirajStorno((PzDokument)this.stornirani, PzEntityManager.KOLICINE_NEPROMENJENE, PzEntityManager.KOLICINA_UKUPNA, true, null, em1);
            em1.getTransaction().commit();
            em1.close();
            Vector<Object> lista = new Vector<Object>();
            lista.add(PzFirma.getFirma());
            lista.add(this.stornirani);
            lista.add(this.ulaznaRJ);
            String putanjaReporta = "rs/pezar/reports/compiled/obracun_kons_nasasifra.jasper";
            PzDataSourceExtended ds = new PzDataSourceExtended(lista, this.stornirani.getArtikalobracunkonsignacijes());
            ds.setAdapter((PzDataSourceAdapter)new PzBeanDataSourceAdapter());
            String title = "STORNO OBRA\u010cUNA broj " + PzEntityUtil.strZero((String)this.original.getRadnajedinica().getId().getOznRj(), (int)3) + "-" + PzEntityUtil.strZero((String)("" + this.original.getrBroj()), (int)5) + "/" + PzDateUtility.getCurrentYear();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("title", title);
            PzReportManager.createAndShowReport((PzDialog)this.parent, (JRDataSource)ds, (String)putanjaReporta, params, (String)"Storno obra\u010duna konsignacije");
            this.dispose();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

