/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.korisnici.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.persistence.EntityManager;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.border.Border;
import rs.pezar.core.PzApplication;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Email;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.db.entity.Telefon;
import rs.pezar.korisnici.PzUserException;
import rs.pezar.korisnici.PzUserUtil;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzComboBox;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;

public class PzDialogIzmenaPodatakaKorisnika
extends PzDialog {
    private PzPanel mainPanel;
    private PzButton btnPotvrdi;
    private PzComboBox cbPol;
    private PzTextField tfMail;
    private JLabel lblMail;
    private PzTextField tfTelefon;
    private JLabel lblTelefon;
    private PzTextField tfIzdao;
    private JLabel lblIzdao;
    private JLabel lblPol;
    private JLabel lblJmbg;
    private PzTextField tfJmbg;
    private JLabel lblBracniStatus;
    private PzTextField tfBrojLK;
    private JLabel lblBrojLK;
    private PzTextField tfPostanskiBroj;
    private JLabel lblPostanskiBroj;
    private PzTextField tfMesto;
    private JLabel lblMesto;
    private PzTextField tfAdresa;
    private JLabel lblAdresa;
    private PzComboBox cbBracniStatus;
    private PzDateField tfDatum;
    private JLabel lblDatum;
    private PzTextField tfPrezime;
    private JLabel lblPrezime;
    private PzTextField tfIme;
    private JLabel lblIme;
    private PzPanel pnlPoslovniPodaci;
    private PzPanel pnlLicniPodaci;
    private PzPanelHeader header;
    private Pzuser user;

    public PzDialogIzmenaPodatakaKorisnika(JFrame frame) {
        super(frame);
        this.initGUI();
        this.postInit();
    }

    private void postInit() {
        try {
            int i;
            Pzuser u = PzApplication.getApplication().getSession().getLoggedUser();
            this.user = (Pzuser)PzEntityManager.find(Pzuser.class, (Object)u.getPzusername());
            this.tfIme.setVal((Object)this.user.getPzuserInfo().getIme());
            this.tfPrezime.setVal((Object)this.user.getPzuserInfo().getPrezime());
            this.cbBracniStatus.setSelectedIndex(this.user.getPzuserInfo().getbStatus().intValue());
            this.tfJmbg.setVal((Object)this.user.getPzuserInfo().getJmbg());
            this.tfDatum.setVal((Object)this.user.getPzuserInfo().getDatRodj());
            this.cbPol.setSelectedIndex(this.user.getPzuserInfo().getPol().intValue());
            this.tfAdresa.setVal((Object)this.user.getPzuserInfo().getAdresa());
            this.tfMesto.setVal((Object)this.user.getPzuserInfo().getMesto());
            this.tfPostanskiBroj.setVal((Object)this.user.getPzuserInfo().getPostBroj());
            this.tfBrojLK.setVal((Object)this.user.getPzuserInfo().getBrlk());
            this.tfIzdao.setVal((Object)this.user.getPzuserInfo().getLkIzdao());
            if (this.user.getTelefons() != null && this.user.getTelefons().size() != 0) {
                List telefon = this.user.getTelefons();
                i = 0;
                while (i < telefon.size()) {
                    if (telefon.get(i) != null && ((Telefon)telefon.get(i)).getTipTelefona().getIdTipTelefona() == 1) {
                        this.tfTelefon.setVal((Object)((Telefon)telefon.get(i)).getBrojTelefona());
                    }
                    ++i;
                }
            }
            if (this.user.getEmails() != null && this.user.getEmails().size() != 0) {
                List email = this.user.getEmails();
                i = 0;
                while (i < email.size()) {
                    if (email.get(i) != null && ((Email)email.get(i)).getTipEmaila().getIdTipEmaila() == 1) {
                        this.tfMail.setVal((Object)((Email)email.get(i)).getAdresa());
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void initGUI() {
        try {
            BorderLayout bLayout = new BorderLayout();
            this.setLayout(bLayout);
            this.mainPanel = new PzPanel();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            this.mainPanel.setPaintGradient(true);
            GridBagLayout mainPanelLayout = new GridBagLayout();
            mainPanelLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0};
            mainPanelLayout.rowHeights = new int[]{7, 78, 168, 7};
            mainPanelLayout.columnWeights = new double[]{0.0, 0.1};
            mainPanelLayout.columnWidths = new int[]{313, 7};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.header = new PzPanelHeader();
            this.mainPanel.add((Component)this.header, (Object)new GridBagConstraints(-1, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.header.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/korisnici/resource/img/businessman_edit.png")));
            this.header.setTitle("Izmana podataka korisnika");
            this.pnlLicniPodaci = new PzPanel();
            GridBagLayout pnlLicniPodaciLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.pnlLicniPodaci, (Object)new GridBagConstraints(0, 1, 1, 2, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 5), 0, 0));
            this.pnlLicniPodaci.setBorder((Border)BorderFactory.createTitledBorder("Li\u010dni podaci"));
            pnlLicniPodaciLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            pnlLicniPodaciLayout.rowHeights = new int[]{7, 7, 26, 22, 20, 26, 20, 20, 20, 20, 20};
            pnlLicniPodaciLayout.columnWeights = new double[]{0.0, 0.1};
            pnlLicniPodaciLayout.columnWidths = new int[]{91, 7};
            this.pnlLicniPodaci.setLayout((LayoutManager)pnlLicniPodaciLayout);
            this.lblIme = new JLabel();
            this.pnlLicniPodaci.add((Component)this.lblIme, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 3, 0), 0, 0));
            this.lblIme.setText("Ime:");
            this.tfIme = new PzTextField();
            this.pnlLicniPodaci.add((Component)this.tfIme, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 20), 0, 0));
            this.lblPrezime = new JLabel();
            this.pnlLicniPodaci.add((Component)this.lblPrezime, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 3, 0), 0, 0));
            this.lblPrezime.setText("Prezime:");
            this.tfPrezime = new PzTextField();
            this.pnlLicniPodaci.add((Component)this.tfPrezime, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 20), 0, 0));
            this.cbPol = new PzComboBox();
            this.pnlLicniPodaci.add((Component)this.cbPol, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 20), 0, 0));
            this.cbPol.addItem((Object)"Mu\u0161ki");
            this.cbPol.addItem((Object)"\u017denksi");
            this.lblPol = new JLabel();
            this.pnlLicniPodaci.add((Component)this.lblPol, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 3, 0), 0, 0));
            this.lblPol.setText("Pol:");
            this.lblJmbg = new JLabel();
            this.pnlLicniPodaci.add((Component)this.lblJmbg, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 3, 0), 0, 0));
            this.lblJmbg.setText("JMBG:");
            this.tfJmbg = new PzTextField();
            this.pnlLicniPodaci.add((Component)this.tfJmbg, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 20), 0, 0));
            this.lblDatum = new JLabel();
            this.pnlLicniPodaci.add((Component)this.lblDatum, (Object)new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 3, 0), 0, 0));
            this.lblDatum.setText("Datum ro\u0111enja:");
            this.tfDatum = new PzDateField();
            this.pnlLicniPodaci.add((Component)this.tfDatum, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 20), 0, 0));
            this.lblBracniStatus = new JLabel();
            this.pnlLicniPodaci.add((Component)this.lblBracniStatus, (Object)new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 3, 0), 0, 0));
            this.lblBracniStatus.setText("Bra\u010dni status:");
            this.cbBracniStatus = new PzComboBox();
            this.pnlLicniPodaci.add((Component)this.cbBracniStatus, (Object)new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 20), 0, 0));
            if (this.cbPol.getSelectedItem().equals("Mu\u0161ki")) {
                this.cbBracniStatus.addItem((Object)"Neo\u017eenjen");
                this.cbBracniStatus.addItem((Object)"O\u017eenjen");
            } else {
                this.cbBracniStatus.addItem((Object)"Neudata");
                this.cbBracniStatus.addItem((Object)"Udata");
            }
            this.lblAdresa = new JLabel();
            this.pnlLicniPodaci.add((Component)this.lblAdresa, (Object)new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 3, 0), 0, 0));
            this.lblAdresa.setText("Adresa:");
            this.tfAdresa = new PzTextField();
            this.pnlLicniPodaci.add((Component)this.tfAdresa, (Object)new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 20), 0, 0));
            this.lblMesto = new JLabel();
            this.pnlLicniPodaci.add((Component)this.lblMesto, (Object)new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 3, 0), 0, 0));
            this.lblMesto.setText("Mesto:");
            this.tfMesto = new PzTextField();
            this.pnlLicniPodaci.add((Component)this.tfMesto, (Object)new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 20), 0, 0));
            this.lblPostanskiBroj = new JLabel();
            this.pnlLicniPodaci.add((Component)this.lblPostanskiBroj, (Object)new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 3, 0), 0, 0));
            this.lblPostanskiBroj.setText("Po\u0161tanski broj:");
            this.tfPostanskiBroj = new PzTextField();
            this.pnlLicniPodaci.add((Component)this.tfPostanskiBroj, (Object)new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 20), 0, 0));
            this.lblBrojLK = new JLabel();
            this.pnlLicniPodaci.add((Component)this.lblBrojLK, (Object)new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 3, 0), 0, 0));
            this.lblBrojLK.setText("Broj LK:");
            this.tfBrojLK = new PzTextField();
            this.pnlLicniPodaci.add((Component)this.tfBrojLK, (Object)new GridBagConstraints(1, 9, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 20), 0, 0));
            this.lblIzdao = new JLabel();
            this.pnlLicniPodaci.add((Component)this.lblIzdao, (Object)new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 3, 0), 0, 0));
            this.lblIzdao.setText("LK izdao:");
            this.tfIzdao = new PzTextField();
            this.pnlLicniPodaci.add((Component)this.tfIzdao, (Object)new GridBagConstraints(1, 10, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 20), 0, 0));
            this.pnlPoslovniPodaci = new PzPanel();
            GridBagLayout pnlPoslovniPodaciLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.pnlPoslovniPodaci, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 10), 0, 0));
            this.pnlPoslovniPodaci.setBorder((Border)BorderFactory.createTitledBorder("Poslovni podaci"));
            pnlPoslovniPodaciLayout.rowWeights = new double[]{0.0, 0.0};
            pnlPoslovniPodaciLayout.rowHeights = new int[]{7, 7};
            pnlPoslovniPodaciLayout.columnWeights = new double[]{0.0, 0.1};
            pnlPoslovniPodaciLayout.columnWidths = new int[]{92, 7};
            this.pnlPoslovniPodaci.setLayout((LayoutManager)pnlPoslovniPodaciLayout);
            this.lblTelefon = new JLabel();
            this.pnlPoslovniPodaci.add((Component)this.lblTelefon, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 3, 0), 0, 0));
            this.lblTelefon.setText("Telefon:");
            this.tfTelefon = new PzTextField();
            this.pnlPoslovniPodaci.add((Component)this.tfTelefon, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 20), 0, 0));
            this.lblMail = new JLabel();
            this.pnlPoslovniPodaci.add((Component)this.lblMail, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 3, 0), 0, 0));
            this.lblMail.setText("Email:");
            this.tfMail = new PzTextField();
            this.pnlPoslovniPodaci.add((Component)this.tfMail, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 20), 0, 0));
            this.btnPotvrdi = new PzButton();
            this.mainPanel.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 0, new Insets(20, 0, 20, 0), 0, 0));
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/korisnici/resource/img/check.png")));
            this.btnPotvrdi.setActionCommand("potvrdi");
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.pack();
            this.setResizable(false);
            this.setRestorable(false);
            this.setSize(639, 519);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        EntityManager em = PzEntityManager.getEm();
        try {
            try {
                if (actionCommand.equals("potvrdi")) {
                    Pzuser pzUser = (Pzuser)em.find(Pzuser.class, (Object)this.user.getPzusername());
                    em.getTransaction().begin();
                    pzUser.getPzuserInfo().setIme(this.tfIme.getVal());
                    pzUser.getPzuserInfo().setPrezime(this.tfPrezime.getVal());
                    pzUser.getPzuserInfo().setPol(Integer.valueOf(this.cbPol.getSelectedIndex()));
                    pzUser.getPzuserInfo().setJmbg(this.tfJmbg.getVal());
                    pzUser.getPzuserInfo().setDatRodj(this.tfDatum.getVal());
                    pzUser.getPzuserInfo().setbStatus(Integer.valueOf(this.cbBracniStatus.getSelectedIndex()));
                    pzUser.getPzuserInfo().setAdresa(this.tfAdresa.getVal());
                    pzUser.getPzuserInfo().setMesto(this.tfMesto.getVal());
                    pzUser.getPzuserInfo().setPostBroj(this.tfPostanskiBroj.getVal());
                    pzUser.getPzuserInfo().setBrlk(this.tfBrojLK.getVal());
                    pzUser.getPzuserInfo().setLkIzdao(this.tfIzdao.getVal());
                    this.createNewBusinessEmail(pzUser, em);
                    this.createNewBusinessTelefon(pzUser, em);
                    em.getTransaction().commit();
                    this.dispose();
                }
            }
            catch (Exception e1) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                if (e1 instanceof PzUserException) {
                    PzSwingUtility.showErrorMessage((Component)((Object)this), (String)e1.getMessage());
                } else {
                    PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                }
                em.close();
            }
        }
        finally {
            em.close();
        }
    }

    private void createNewBusinessEmail(Pzuser user, EntityManager em) throws PzUserException {
        if (!this.tfMail.getVal().equals("")) {
            PzUserUtil.addEmail(this.tfMail.getVal(), user, 1, "POSLOVNI EMAIL", em);
        } else {
            PzUserUtil.removeEmail(user, 1, em);
        }
    }

    private void createNewBusinessTelefon(Pzuser user, EntityManager em) throws PzUserException {
        if (!this.tfTelefon.getVal().equals("")) {
            PzUserUtil.addTelefon(this.tfTelefon.getVal(), user, 1, "POSLOVNI TELEFON", em);
        } else {
            PzUserUtil.removeTelefon(user, 1, em);
        }
    }
}

