/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.korisnici.gui;

import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CGrid;
import bibliothek.gui.dock.common.DefaultSingleCDockable;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.util.ComponentWindowProvider;
import bibliothek.gui.dock.util.WindowProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.persistence.EntityManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.jdesktop.application.Application;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.korisnici.PzUserException;
import rs.pezar.korisnici.gui.PzPanelDozvoleGrupe;
import rs.pezar.korisnici.gui.PzPanelPodaciGrupe;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzButtonPanel;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.util.PzSwingUtility;

public class PzDialogGrupeKorisnika
extends PzDialog {
    private PzButtonPanel btnPanel;
    private PzButton btnCancel;
    private PzButton btnOK;
    private PzPanel pnlMain;
    private boolean update;
    private Pzuser group;
    private PzPanelPodaciGrupe podaciOGrupi;
    private PzPanelDozvoleGrupe dozvoleGrupe;
    private CControl control;
    private DefaultSingleCDockable dockPodaciOGrupi;
    private DefaultSingleCDockable dockDozvoleGrupe;
    private CGrid grid;
    private PzTable table;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogGrupeKorisnika inst = new PzDialogGrupeKorisnika(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogGrupeKorisnika(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public PzDialogGrupeKorisnika(PzDialog dialog) {
        super(dialog);
        this.update = (Boolean)this.getSession().getParameter("update");
        this.table = (PzTable)this.getSession().getParameter("table");
        if (this.update) {
            this.group = (Pzuser)this.getSession().getParameter("userGroup");
        }
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setTitle("Grupe korisnika");
            this.pnlMain = new PzPanel();
            BorderLayout pnlMainLayout = new BorderLayout();
            this.getContentPane().add((Component)this.pnlMain, "Center");
            this.pnlMain.setLayout((LayoutManager)pnlMainLayout);
            this.btnPanel = new PzButtonPanel();
            this.getContentPane().add((Component)this.btnPanel, "South");
            this.btnPanel.setPreferredSize(new Dimension(489, 44));
            this.btnOK = new PzButton();
            this.btnPanel.add((Component)this.btnOK);
            this.btnOK.setName("btnOK");
            this.btnOK.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/korisnici/resource/img/check.png")));
            this.btnOK.addActionListener((ActionListener)((Object)this));
            this.btnOK.setActionCommand("ok");
            this.btnCancel = new PzButton();
            this.btnPanel.add((Component)this.btnCancel);
            this.btnCancel.setName("btnCancel");
            this.btnCancel.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/korisnici/resource/img/x.png")));
            this.btnCancel.addActionListener((ActionListener)((Object)this));
            this.btnCancel.setActionCommand("cancel");
            this.setSize(505, 412);
            this.initPanels();
            this.startupDockFrames();
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String ac = button.getActionCommand();
        if (ac.equals("cancel")) {
            this.dispose();
        } else if (ac.equals("ok")) {
            if (this.podaciOGrupi.getNazivGrupe().equals("")) {
                PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Morate popuniti sva polja na panelu Podaci grupe.");
                return;
            }
            this.snimi();
            this.dispose();
        }
    }

    void initPanels() {
        this.podaciOGrupi = new PzPanelPodaciGrupe();
        this.dozvoleGrupe = new PzPanelDozvoleGrupe();
        if (this.update) {
            this.podaciOGrupi.setUser(this.group);
            this.dozvoleGrupe.setUser(this.group);
        }
    }

    void startupDockFrames() {
        ComponentWindowProvider provider = new ComponentWindowProvider((Component)this.pnlMain);
        this.control = new CControl((WindowProvider)provider);
        this.control.setTheme("eclipse");
        this.pnlMain.add((Component)this.control.getContentArea());
        this.dockPodaciOGrupi = this.podaciOGrupi.getDockable();
        this.dockDozvoleGrupe = this.dozvoleGrupe.getDockable();
        this.grid = new CGrid(this.control);
        this.grid.add(0.0, 0.0, 1.0, 1.0, new CDockable[]{this.dockPodaciOGrupi});
        this.grid.add(0.0, 0.0, 1.0, 1.0, new CDockable[]{this.dockDozvoleGrupe});
        this.control.getContentArea().deploy(this.grid);
        this.dockPodaciOGrupi.toFront();
    }

    private void snimi() {
        EntityManager em = PzEntityManager.getEm();
        try {
            try {
                this.group = this.group == null ? this.createUser() : (Pzuser)em.find(Pzuser.class, (Object)this.group.getPzusername());
                em.getTransaction().begin();
                this.podaciOGrupi.saveData(this.group, this.update, em);
                this.dozvoleGrupe.saveData(this.group, this.update, em);
                if (!this.update) {
                    em.persist((Object)this.group);
                }
                em.getTransaction().commit();
                if (!this.update) {
                    this.table.insert((PzEntity)this.group, false);
                } else {
                    this.table.updateSelectedEntity((PzEntity)this.group, false);
                }
                this.dispose();
            }
            catch (Exception e) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                if (e instanceof PzUserException) {
                    PzSwingUtility.showErrorMessage((Component)((Object)this), (String)e.getMessage());
                } else {
                    PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
                }
                em.close();
            }
        }
        finally {
            em.close();
        }
    }

    private Pzuser createUser() {
        Pzuser user = new Pzuser();
        user.setDozvolas(new ArrayList());
        return user;
    }
}

