/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.webservice.client.nbs.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.io.FileNotFoundException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.LayerUI;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTitledPanel;
import rs.pezar.core.PzApplication;
import rs.pezar.core.format.PzFormatFactory;
import rs.pezar.swing.PzBusyPainterUI;
import rs.pezar.swing.PzExceptionPanel;
import rs.pezar.swing.PzPanel;
import rs.pezar.util.PzDateUtility;
import rs.pezar.webservice.client.nbs.NBS;
import rs.pezar.webservice.client.nbs.jaxb.exchangeRateDataSet.ExchangeRateDataSet;

public class PnlKursnaLista
extends JXTitledPanel {
    private static final long serialVersionUID = -504871399794511530L;
    private JXTable table;
    private JLabel lblNaDan;
    private PzPanel pnlContent;
    private JLabel lblIcon;
    private JButton btnOsvezi;
    private GridBagConstraints gbc_scrollPane;
    private JScrollPane scrollPane;
    private PzExceptionPanel errorPane;
    private JXLayer<PzPanel> layer;
    private PzBusyPainterUI layerUI;
    private boolean firstTime = true;

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().add((Component)((Object)new PnlKursnaLista()));
        frame.setDefaultCloseOperation(2);
        frame.pack();
        frame.setVisible(true);
    }

    public PnlKursnaLista() {
        this.setPaintBorderInsets(false);
        this.setTitleFont(new Font("Tahoma", 1, 16));
        this.setTitle("Kursna lista NBS");
        this.initGUI();
        this.paintGradient();
    }

    private void paintGradient() {
        this.pnlContent.setPaintGradient(true);
        this.pnlContent.setGradient(Color.GRAY, Color.WHITE, PzPanel.GRADIENT_SOUTH_NORTH);
    }

    private void initGUI() {
        try {
            this.setPreferredSize(new Dimension(198, 300));
            this.pnlContent = new PzPanel();
            this.pnlContent.setBorder((Border)new EmptyBorder(0, 5, 2, 5));
            this.setContentContainer((Container)this.getLayer(this.pnlContent));
            GridBagLayout gridBagLayout = new GridBagLayout();
            gridBagLayout.columnWidths = new int[1];
            int[] nArray = new int[4];
            nArray[2] = 21;
            gridBagLayout.rowHeights = nArray;
            gridBagLayout.columnWeights = new double[]{1.0};
            gridBagLayout.rowWeights = new double[]{0.0, 1.0, 0.0, Double.MIN_VALUE};
            this.pnlContent.setLayout((LayoutManager)gridBagLayout);
            this.lblNaDan = new JLabel("na dan ");
            this.lblNaDan.setFont(new Font("SansSerif", 0, 10));
            GridBagConstraints gbc_lblNaDan = new GridBagConstraints();
            gbc_lblNaDan.anchor = 17;
            gbc_lblNaDan.insets = new Insets(0, 0, 5, 0);
            gbc_lblNaDan.gridx = 0;
            gbc_lblNaDan.gridy = 0;
            this.pnlContent.add((Component)this.lblNaDan, (Object)gbc_lblNaDan);
            this.scrollPane = new JScrollPane();
            this.scrollPane.setVisible(false);
            this.gbc_scrollPane = new GridBagConstraints();
            this.gbc_scrollPane.insets = new Insets(0, 0, 2, 0);
            this.gbc_scrollPane.fill = 1;
            this.gbc_scrollPane.gridx = 0;
            this.gbc_scrollPane.gridy = 1;
            this.pnlContent.add((Component)this.scrollPane, (Object)this.gbc_scrollPane);
            this.table = new JXTable();
            this.table.setShowVerticalLines(false);
            this.table.getTableHeader().setFont(new Font("SansSerif", 1, 13));
            this.scrollPane.setViewportView((Component)this.table);
            this.btnOsvezi = new JButton("Osve\u017ei");
            this.btnOsvezi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    PzApplication.getApplication().getPropManager().clear("kursnalista.sav");
                    PnlKursnaLista.this.initData();
                }
            });
            this.btnOsvezi.setIcon(new ImageIcon(PnlKursnaLista.class.getResource("/rs/pezar/webservice/client/nbs/resource/img/refresh.png")));
            GridBagConstraints gbc_btnNewButton = new GridBagConstraints();
            gbc_btnNewButton.gridx = 0;
            gbc_btnNewButton.gridy = 2;
            this.pnlContent.add((Component)this.btnOsvezi, (Object)gbc_btnNewButton);
            this.lblIcon = new JLabel();
            this.lblIcon.setIcon(new ImageIcon(PnlKursnaLista.class.getResource("/rs/pezar/webservice/client/nbs/resource/img/nbs_32.png")));
            this.setRightDecoration(this.lblIcon);
            this.errorPane = new PzExceptionPanel("", null);
            this.errorPane.setVisible(false);
            this.pnlContent.add((Component)this.errorPane, (Object)this.gbc_scrollPane);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initData() {
        this.layerUI.setLocked(true);
        SwingWorker<List<ExchangeRateDataSet.ExchangeRate>, Object> worker = new SwingWorker<List<ExchangeRateDataSet.ExchangeRate>, Object>(){

            @Override
            protected List<ExchangeRateDataSet.ExchangeRate> doInBackground() throws Exception {
                HashMap<String, List> map;
                List list = null;
                try {
                    map = (HashMap<String, List>)PzApplication.getApplication().getPropManager().loadBufferedObject("kursnalista.sav", ExchangeRateDataSet.ExchangeRate.class.getClassLoader());
                    list = (List)map.get(PzFormatFactory.getDateFormat().format(PzDateUtility.getCurrentDate()));
                }
                catch (FileNotFoundException fileNotFoundException) {}
                if (list == null) {
                    list = NBS.getKursnaLista(PzDateUtility.getCurrentDate());
                    map = new HashMap<String, List>();
                    map.put(PzFormatFactory.getDateFormat().format(PzDateUtility.getCurrentDate()), list);
                    PzApplication.getApplication().getPropManager().saveObject(map, "kursnalista.sav");
                }
                return list;
            }

            @Override
            protected void done() {
                try {
                    try {
                        List kurs = (List)this.get();
                        DefaultTableModel model = new DefaultTableModel();
                        Object[][] data = new Object[kurs.size()][2];
                        int i = 0;
                        for (ExchangeRateDataSet.ExchangeRate k : kurs) {
                            data[i] = new Object[]{k.getCurrencyCodeAlfaChar(), k.getUnit(), k.getMiddleRate()};
                            ++i;
                        }
                        model.setDataVector(data, new String[]{"Valuta", "Jedinica", "<html>Srednji<br/>kurs<html>"});
                        PnlKursnaLista.this.table.setModel((TableModel)model);
                        DefaultTableCellRenderer renderer0 = new DefaultTableCellRenderer();
                        renderer0.setHorizontalAlignment(0);
                        PnlKursnaLista.this.table.getColumnModel().getColumn(0).setCellRenderer(renderer0);
                        DefaultTableCellRenderer renderer1 = new DefaultTableCellRenderer();
                        renderer1.setHorizontalAlignment(0);
                        PnlKursnaLista.this.table.getColumnModel().getColumn(1).setCellRenderer(renderer1);
                        DefaultTableCellRenderer renderer2 = new DefaultTableCellRenderer();
                        renderer2.setHorizontalAlignment(4);
                        PnlKursnaLista.this.table.getColumnModel().getColumn(2).setCellRenderer(renderer2);
                        final List kursref = kurs;
                        if (PnlKursnaLista.this.firstTime) {
                            PnlKursnaLista.this.table.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

                                @Override
                                public void mouseMoved(MouseEvent e) {
                                    Point p = e.getPoint();
                                    int row = PnlKursnaLista.this.table.rowAtPoint(p);
                                    int column = 0;
                                    if (row >= PnlKursnaLista.this.table.getRowCount() || row < 0) {
                                        return;
                                    }
                                    PnlKursnaLista.this.table.setToolTipText(PnlKursnaLista.this.getToolTip(kursref, (String)PnlKursnaLista.this.table.getValueAt(row, column)));
                                }
                            });
                            PnlKursnaLista.this.firstTime = false;
                        }
                        PnlKursnaLista.this.errorPane.setVisible(false);
                        PnlKursnaLista.this.scrollPane.setVisible(true);
                        PnlKursnaLista.this.lblNaDan.setText("na dan " + new SimpleDateFormat("dd.MM.yyyy").format(PzDateUtility.getCurrentDate()));
                    }
                    catch (Exception e) {
                        PnlKursnaLista.this.errorPane.setMessage("Gre\u0161ka prilikom preuzimanja kursa iz sistema NBS.");
                        PnlKursnaLista.this.errorPane.setThrowable((Throwable)e);
                        PnlKursnaLista.this.scrollPane.setVisible(false);
                        PnlKursnaLista.this.errorPane.setVisible(true);
                        PnlKursnaLista.this.layerUI.setLocked(false);
                    }
                }
                finally {
                    PnlKursnaLista.this.layerUI.setLocked(false);
                }
            }
        };
        worker.execute();
    }

    public JXLayer<PzPanel> getLayer(PzPanel pnl) {
        if (this.layerUI == null) {
            this.layerUI = new PzBusyPainterUI();
            this.layer = new JXLayer((Component)pnl, (LayerUI)this.layerUI);
        }
        return this.layer;
    }

    private String getToolTip(List<ExchangeRateDataSet.ExchangeRate> kurs, String ozn) {
        String res = null;
        Iterator<ExchangeRateDataSet.ExchangeRate> iterator = kurs.iterator();
        while (iterator.hasNext() && res == null) {
            ExchangeRateDataSet.ExchangeRate k = iterator.next();
            if (!k.getCurrencyCodeAlfaChar().equals(ozn)) continue;
            res = k.getCurrencyNameSerLat();
        }
        return res;
    }
}

