/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.proizvodnja.gui.sastavnice;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.math.BigDecimal;
import javax.persistence.EntityManager;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.jdesktop.application.Application;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Artikalgarnitura;
import rs.pezar.db.entity.Artikalinterniracun;
import rs.pezar.db.entity.Interniracun;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.proizvodnja.gui.PzDialogSastavnicaDostavnica;
import rs.pezar.proizvodnja.gui.dostavnica.Arhiviranje;
import rs.pezar.proizvodnja.gui.dostavnica.Dodavanje;
import rs.pezar.proizvodnja.gui.sastavnice.DodavanjeKomponente;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.util.PzGradient;

public class SastavSklopa
extends PzDialog {
    private static final String SASTAVNICA = "sastavnica";
    private static final long serialVersionUID = 2020718806330562548L;
    private JToolBar toolbar;
    private PzToolBarIcon icnDodavanje;
    private PzDoubleField dfIzlaz;
    private PzDoubleField dfUlaz;
    private JLabel lblUlaz;
    private JLabel lblIzlz;
    private PzTable tabelaArtikli;
    private JScrollPane scrollPane;
    private PzPanel pnlGlavni;
    private PzToolBarIcon icnBrisi;
    private Artikal sklop;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brDok = new JLabel();
    private PzToolBarIcon icnIzmena;
    private PzToolBarIcon icnArhiva;
    private PzToolBarIcon icnBrisiSve;
    private final String paremeter = (String)this.getSession().getParameter("parameter");
    private Interniracun dostavnica;

    public SastavSklopa(PzDialog dialog) {
        super(dialog);
        if (this.paremeter.equals(SASTAVNICA)) {
            this.sklop = (Artikal)this.getSession().getParameter("artikal");
        } else {
            this.dostavnica = (Interniracun)this.getSession().getParameter("dostavnica");
        }
        this.initGUI();
        this.postInit();
        this.paintPanel();
    }

    private void paintPanel() {
        this.pnlGlavni.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.pnlGlavni.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.pnlGlavni.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    private void postInit() {
        if (this.paremeter.equals(SASTAVNICA)) {
            this.tabelaArtikli.setData(this.sklop.getDeloviGarniture(), Artikalgarnitura.class);
            this.setTitle("NORMATIV ZA IZGRADNJU GOTOVOG PROIZVODA [" + this.sklop.getSfrProizvod() + " ] " + this.sklop.getNaziv());
            this.icnArhiva.setVisible(false);
        } else {
            this.tabelaArtikli.setData(this.dostavnica.getArtikalinterniracuns(), Artikalinterniracun.class);
            this.setTitle("DOSTAVNICA iz magacina " + this.dostavnica.getIzlaznaRJ().getPunNaziv() + " u magacin " + this.dostavnica.getUlaznaRJ().getPunNaziv());
            this.lblIzlz = new JLabel();
            this.pnlGlavni.add((Component)this.lblIzlz, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 5, 0), 0, 0));
            this.lblIzlz.setText("Izlazna vrednost:");
            this.dfIzlaz = this.tabelaArtikli.createExpresionField("$6$");
            this.pnlGlavni.add((Component)this.dfIzlaz, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.dfIzlaz.setFocusable(false);
            this.dfIzlaz.setEnabled(false);
            this.lblUlaz = new JLabel();
            this.pnlGlavni.add((Component)this.lblUlaz, (Object)new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 5, 0), 0, 0));
            this.lblUlaz.setText("Ulazna vrednost:");
            this.dfUlaz = this.tabelaArtikli.createExpresionField("$7$");
            this.pnlGlavni.add((Component)this.dfUlaz, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.dfUlaz.setFocusable(false);
            this.dfUlaz.setEnabled(false);
        }
        this.refresh();
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.pnlGlavni = new PzPanel();
            GridBagLayout pnlGlavniLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            pnlGlavniLayout.rowWeights = new double[]{0.0, 0.1, 0.1, 0.0, 0.0};
            pnlGlavniLayout.rowHeights = new int[]{100, 7, 7, 20, 7};
            pnlGlavniLayout.columnWeights = new double[]{0.0, 0.0, 0.1, 0.1};
            pnlGlavniLayout.columnWidths = new int[]{108, 140, 7, 7};
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout);
            this.scrollPane = new JScrollPane();
            this.pnlGlavni.add((Component)this.scrollPane, (Object)new GridBagConstraints(0, 1, 4, 2, 0.0, 0.0, 10, 1, new Insets(0, 10, 10, 10), 0, 0));
            this.tabelaArtikli = new PzTable();
            this.scrollPane.setViewportView((Component)this.tabelaArtikli);
            this.tabelaArtikli.setEnterAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SastavSklopa.this.icnDodavanje.doClick();
                }
            });
            this.toolbar = new JToolBar();
            this.pnlGlavni.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.toolbar.setLayout(toolbarLayout);
            this.toolbar.setOpaque(false);
            this.icnDodavanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnDodavanje);
            this.icnDodavanje.setText("Dodavanje|(INS)");
            this.icnDodavanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/product_add.png")));
            this.icnDodavanje.setActionCommand("dodavanje");
            this.icnDodavanje.addActionListener((ActionListener)((Object)this));
            this.icnDodavanje.setShortcut("INSERT");
            this.icnIzmena = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnIzmena);
            this.icnIzmena.setText("Izmena|(F3)");
            this.icnIzmena.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/product_edit.png")));
            this.icnIzmena.setActionCommand("izmena");
            this.icnIzmena.addActionListener((ActionListener)((Object)this));
            this.icnIzmena.setShortcut("F3");
            this.icnBrisi = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnBrisi);
            this.icnBrisi.setText("Brisanje|(Del)");
            this.icnBrisi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/product_delete.png")));
            this.icnBrisi.setActionCommand("brisanje");
            this.icnBrisi.addActionListener((ActionListener)((Object)this));
            this.icnBrisi.setShortcut("Delete");
            this.icnArhiva = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnArhiva);
            this.icnArhiva.setText("Arhiviranje|(CTRL+W)");
            this.icnArhiva.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/printer_preferences.png")));
            this.icnArhiva.setActionCommand("arhiva");
            this.icnArhiva.addActionListener((ActionListener)((Object)this));
            this.icnArhiva.setShortcut("CTRL+W");
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText("  Broj artikala");
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.pack();
            this.setSize(688, 557);
            this.setMinimumSize(new Dimension(688, 557));
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        EntityManager em = PzEntityManager.getEm();
        try {
            try {
                this.getSession().putParameter("tabela", (Object)this.tabelaArtikli);
                if (actionCommand.equals("dodavanje")) {
                    if (this.paremeter.equals(SASTAVNICA)) {
                        this.getSession().putParameter("artikal", (Object)this.sklop);
                        this.getSession().putParameter("update", (Object)false);
                        this.showDialog(DodavanjeKomponente.class);
                    } else {
                        this.getSession().putParameter("dostavnica", (Object)this.dostavnica);
                        this.getSession().putParameter("update", (Object)false);
                        this.showDialog(Dodavanje.class);
                    }
                    this.refresh();
                } else if (actionCommand.equals("izmena")) {
                    if (this.tabelaArtikli.getRowCount() != 0) {
                        if (this.paremeter.equals(SASTAVNICA)) {
                            this.getSession().putParameter("artikal", (Object)this.sklop);
                            this.getSession().putParameter("update", (Object)true);
                            this.showDialog(DodavanjeKomponente.class);
                        } else {
                            this.getSession().putParameter("dostavnica", (Object)this.dostavnica);
                            this.getSession().putParameter("update", (Object)true);
                            this.showDialog(Dodavanje.class);
                        }
                        this.refresh();
                    }
                } else if (actionCommand.equals("brisanje")) {
                    if (this.tabelaArtikli.getRowCount() != 0) {
                        em.getTransaction().begin();
                        if (!this.paremeter.equals(SASTAVNICA)) {
                            Artikalinterniracun art = (Artikalinterniracun)this.tabelaArtikli.getSelectedEntity();
                            Interniracun racun = (Interniracun)em.find(Interniracun.class, (Object)this.dostavnica.getIdDok());
                            racun.setVredNaIzlazu(this.dostavnica.getVredNaIzlazu().subtract(new BigDecimal(art.getKolicina() * art.getIzlCena())));
                            racun.setVredNaUlazu(this.dostavnica.getVredNaUlazu().subtract(new BigDecimal(art.getKolicina() * art.getUlCena())));
                            Stanje stanjeIzlaz = (Stanje)em.find(Stanje.class, (Object)new StanjePK(art.getId().getSfrProizvod(), this.dostavnica.getIzlaznaRJ()));
                            if (PzParameter.getParameterValue((String)"INT_NAL_FORM_ALOC").equals("true")) {
                                stanjeIzlaz.setAlocKolicina(stanjeIzlaz.getAlocKolicina() - art.getKolicina());
                            }
                            this.dostavnica = racun;
                        }
                        this.tabelaArtikli.removeSelectedEntity(true, em);
                        em.getTransaction().commit();
                        this.tabelaArtikli.commitRemove();
                        this.refresh();
                    }
                } else if (actionCommand.equals("arhiva") && this.tabelaArtikli.getRowCount() != 0) {
                    this.getSession().putParameter("dostavnica", (Object)this.dostavnica);
                    this.showDialog(Arhiviranje.class);
                }
            }
            catch (Exception e1) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                em.close();
            }
        }
        finally {
            em.close();
        }
    }

    private void refresh() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SastavSklopa.this.brDok.setText(String.valueOf(SastavSklopa.this.tabelaArtikli.getRowCount()));
                if (!SastavSklopa.this.paremeter.equals(SastavSklopa.SASTAVNICA)) {
                    SastavSklopa.this.tabelaArtikli.calculateFields();
                }
            }
        });
    }

    protected void thisWindowClosing(WindowEvent evt) {
        ((PzDialogSastavnicaDostavnica)((Object)this.getParent())).initializeTable();
        super.thisWindowClosing(evt);
    }
}

