/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.proizvodnja.gui.gradjevinarstvo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import rs.pezar.db.PzEntity;
import rs.pezar.db.entity.RadniNalog;
import rs.pezar.proizvodnja.gui.gradjevinarstvo.IzmenaRadnogNaloga;
import rs.pezar.proizvodnja.gui.gradjevinarstvo.PzDialogIzradaRadnogNaloga;
import rs.pezar.proizvodnja.gui.radniNalozi.RadniNalogRenderer;
import rs.pezar.proizvodnja.util.ProizvodnjaGradientUtil;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.util.PzSwingUtility;

public class PzDialogRadNalGradjevinarstvo
extends PzDialog {
    private static final long serialVersionUID = -7745443644331406254L;
    private PzPanel panel;
    private JToolBar toolbar;
    private PzToolBarIcon icnDodavanje;
    private PzToolBarIcon icnIzmena;
    private PzToolBarIcon icnPromjenaStatusa;
    private PzToolBarIcon icnUlaz;
    private PzTable table;
    private JScrollPane scrollPane;
    PzPanel mainPanel;
    private RadniNalogRenderer r = new RadniNalogRenderer();

    public PzDialogRadNalGradjevinarstvo(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public PzDialogRadNalGradjevinarstvo(PzDialog dialog) {
        super(dialog);
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.mainPanel = new PzPanel();
            this.mainPanel.setLayout((LayoutManager)new BorderLayout());
            this.getContentPane().add((Component)this.mainPanel, "Center");
            this.toolbar = new JToolBar();
            this.toolbar.setOpaque(false);
            this.toolbar.setFloatable(false);
            FlowLayout toolbarLayout = new FlowLayout();
            this.toolbar.setLayout(toolbarLayout);
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.mainPanel.add((Component)this.toolbar, (Object)"North");
            this.icnDodavanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnDodavanje);
            this.icnDodavanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/radniNalog_add.png")));
            this.icnDodavanje.setText("Dodavanje|(Ins)");
            this.icnDodavanje.setActionCommand("Dodavanje");
            this.icnDodavanje.addActionListener((ActionListener)((Object)this));
            this.icnDodavanje.setShortcut("INSERT");
            this.icnIzmena = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnIzmena);
            this.icnIzmena.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/radniNalog_edit.png")));
            this.icnIzmena.setText("Izmena|(F3)");
            this.icnIzmena.setActionCommand("Izmena");
            this.icnIzmena.addActionListener((ActionListener)((Object)this));
            this.icnIzmena.setShortcut("F3");
            this.icnUlaz = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnUlaz);
            this.icnUlaz.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/radniNalog.png")));
            this.icnUlaz.setText("Ulaz u|radni nalog|(Enter)");
            this.icnUlaz.setActionCommand("ulaz");
            this.icnUlaz.addActionListener((ActionListener)((Object)this));
            this.icnUlaz.setShortcut("ENTER");
            this.icnPromjenaStatusa = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnPromjenaStatusa);
            this.icnPromjenaStatusa.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/radniNalog.png")));
            this.icnPromjenaStatusa.setText("Promena|statusa|(F2)");
            this.icnPromjenaStatusa.setActionCommand("promena");
            this.icnPromjenaStatusa.addActionListener((ActionListener)((Object)this));
            this.icnPromjenaStatusa.setShortcut("F2");
            this.setTitle("Radni nalozi");
            this.panel = new PzPanel();
            this.panel.setOpaque(false);
            GridBagLayout jPanel1Layout = new GridBagLayout();
            this.mainPanel.add((Component)this.panel, (Object)"Center");
            this.panel.setPreferredSize(new Dimension(592, 272));
            jPanel1Layout.rowWeights = new double[]{0.1};
            jPanel1Layout.rowHeights = new int[]{7};
            jPanel1Layout.columnWeights = new double[]{0.1};
            jPanel1Layout.columnWidths = new int[]{7};
            this.panel.setLayout((LayoutManager)jPanel1Layout);
            this.scrollPane = new JScrollPane();
            this.panel.add((Component)this.scrollPane, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
            this.scrollPane.setBackground(new Color(211, 242, 210));
            this.table = new PzTable(RadniNalog.class);
            this.scrollPane.setViewportView((Component)this.table);
            this.table.setEnterAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PzDialogRadNalGradjevinarstvo.this.icnUlaz.doClick();
                }
            });
            this.adjustColumn0();
            this.setMinimumSize(new Dimension(500, 400));
            this.pack();
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent arg0) {
        boolean izmena = false;
        PzToolBarIcon icon = (PzToolBarIcon)arg0.getSource();
        String actionCommand = icon.getActionCommand();
        if (actionCommand.equalsIgnoreCase("Dodavanje")) {
            this.getSession().putParameter("update", (Object)izmena);
            this.getSession().putParameter("tabela", (Object)this.table);
            this.showDialog(IzmenaRadnogNaloga.class);
        } else if (actionCommand.equalsIgnoreCase("Izmena")) {
            izmena = true;
            this.getSession().putParameter("update", (Object)izmena);
            this.getSession().putParameter("tabela", (Object)this.table);
            this.showDialog(IzmenaRadnogNaloga.class);
        } else if (actionCommand.equalsIgnoreCase("ulaz")) {
            if (this.table.getSelectedRow() != -1) {
                if (((RadniNalog)this.table.getSelectedEntity()).getStatus() == 2) {
                    PzSwingUtility.showErrorMessage((Component)SwingUtilities.getRoot((Component)((Object)this)), (String)"Radni nalog je otkazan.");
                    return;
                }
                this.getSession().putParameter("tabela", (Object)this.table);
                this.getSession().putParameter("radninalog", (Object)this.table.getSelectedEntity());
                this.showDialog(PzDialogIzradaRadnogNaloga.class);
            }
        } else if (actionCommand.equalsIgnoreCase("promena") && this.table.getSelectedRow() != -1) {
            RadniNalog rn = (RadniNalog)this.table.getSelectedEntity();
            if (rn.getStatus() == 0) {
                int rez = JOptionPane.showConfirmDialog(SwingUtilities.getRoot((Component)((Object)this)), "Dozvoljena promena statusa iz \"nezavrsen\" u \"otkazan\" ?", "Informacija", 0);
                if (rez == 0) {
                    rn.setStatus((short)2);
                    this.table.updateSelectedEntity((PzEntity)rn, true);
                }
            } else if (rn.getStatus() == 2) {
                int rez = JOptionPane.showConfirmDialog(SwingUtilities.getRoot((Component)((Object)this)), "Dozvoljena promena statusa iz \"otkazan\" u \"nezavrsen\" ?", "Informacija", 0);
                if (rez == 0) {
                    rn.setStatus((short)0);
                    this.table.updateSelectedEntity((PzEntity)rn, true);
                }
            } else if (rn.getStatus() == 1) {
                return;
            }
        }
    }

    public boolean shouldBeShown() {
        this.mainPanel.setPaintGradient(true);
        this.mainPanel.setGradient(ProizvodnjaGradientUtil.GRADJEVINARSTVO_GRADIENT);
        this.getSession().putParameter("gradient", (Object)ProizvodnjaGradientUtil.GRADJEVINARSTVO_GRADIENT);
        return true;
    }

    private void adjustColumn0() {
        if (this.table.convertColumnIndexToView(0) != -1 && this.table.getColumn(0).getCellRenderer() != this.r) {
            this.table.getColumn(0).setMinWidth(20);
            this.table.getColumn(0).setMaxWidth(20);
            this.table.getColumn(0).setPreferredWidth(20);
            this.table.getColumn(0).setCellRenderer(this.r);
        }
    }
}

